/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.concurrency;

import java.awt.EventQueue;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.concurrency.ThreadContext;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Attachment;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import org.jetbrains.kotlin.com.intellij.util.ui.EDT;

public final class ThreadingAssertions {
    private ThreadingAssertions() {
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(ThreadingAssertions.class);
        if (logger == null) {
            ThreadingAssertions.$$$reportNull$$$0(0);
        }
        return logger;
    }

    public static void assertEventDispatchThread() {
        if (!EDT.isCurrentThreadEdt()) {
            ThreadingAssertions.throwThreadAccessException("Access is allowed from Event Dispatch Thread (EDT) only");
        }
    }

    public static void assertBackgroundThread() {
        if (EDT.isCurrentThreadEdt()) {
            ThreadingAssertions.throwThreadAccessException("Access from Event Dispatch Thread (EDT) is not allowed");
        }
    }

    private static void trySoftAssertReadAccessWhenLocksAreForbidden() {
        String advice = ThreadingAssertions.getStringDetail(Application::isLockingProhibited);
        if (advice != null) {
            ThreadingAssertions.getLogger().error(ThreadingAssertions.createLockingForbiddenException("This thread requested read access, but it does not have permission to use locks.\n" + advice));
        }
    }

    @ApiStatus.Obsolete
    public static void softAssertReadAccess() {
        if (!ThreadingAssertions.isFlagSet(Application::isReadAccessAllowed)) {
            ThreadingAssertions.getLogger().error(ThreadingAssertions.createThreadAccessException("Read access is allowed from inside read-action only (see Application.runReadAction())"));
        } else {
            ThreadingAssertions.trySoftAssertReadAccessWhenLocksAreForbidden();
        }
    }

    public static void assertWriteAccess() {
        if (!ThreadingAssertions.isFlagSet(Application::isWriteAccessAllowed)) {
            ThreadingAssertions.throwThreadAccessException("Write access is allowed inside write-action only (see Application.runWriteAction())");
        } else {
            ThreadingAssertions.trySoftAssertWriteAccessWhenLocksAreForbidden();
        }
    }

    private static void trySoftAssertWriteAccessWhenLocksAreForbidden() {
        String advice = ThreadingAssertions.getStringDetail(Application::isLockingProhibited);
        if (advice != null) {
            ThreadingAssertions.getLogger().error(ThreadingAssertions.createLockingForbiddenException("This thread requested write access, but it does not have permission to use locks.\n" + advice));
        }
    }

    private static void throwThreadAccessException(@NotNull @NonNls String message2) {
        if (message2 == null) {
            ThreadingAssertions.$$$reportNull$$$0(1);
        }
        throw ThreadingAssertions.createThreadAccessException(message2);
    }

    @NotNull
    private static RuntimeExceptionWithAttachments createThreadAccessException(@NonNls @NotNull String message2) {
        if (message2 == null) {
            ThreadingAssertions.$$$reportNull$$$0(2);
        }
        boolean skipReadAction = EDT.isCurrentThreadEdt() && ThreadContext.currentThreadContextOrNull() != null;
        return new RuntimeExceptionWithAttachments(message2 + "; If you access or modify model on EDT consider wrapping your code in WriteIntentReadAction " + (skipReadAction ? "" : " or ReadAction") + "; see " + "https://jb.gg/ij-platform-threading" + " for details\n" + ThreadingAssertions.getThreadDetails(), new Attachment[0]);
    }

    @NotNull
    private static RuntimeExceptionWithAttachments createLockingForbiddenException(@NonNls @NotNull String advice) {
        if (advice == null) {
            ThreadingAssertions.$$$reportNull$$$0(3);
        }
        return new RuntimeExceptionWithAttachments(advice + "\nSee " + "https://jb.gg/ij-platform-threading" + " for details\n" + ThreadingAssertions.getThreadDetails(), new Attachment[0]);
    }

    @NotNull
    private static String getThreadDetails() {
        Thread current = Thread.currentThread();
        Thread edt = EDT.getEventDispatchThreadOrNull();
        String string = "Current thread: " + ThreadingAssertions.describe(current) + " (EventQueue.isDispatchThread()=" + EventQueue.isDispatchThread() + ")\nSystemEventQueueThread: " + (edt == current ? "(same)" : ThreadingAssertions.describe(edt));
        if (string == null) {
            ThreadingAssertions.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private static String describe(@Nullable Thread o) {
        String string = o == null ? "null" : o + " " + System.identityHashCode(o);
        if (string == null) {
            ThreadingAssertions.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static boolean isFlagSet(@NotNull Function<Application, Boolean> getter2) {
        Application app;
        if (getter2 == null) {
            ThreadingAssertions.$$$reportNull$$$0(6);
        }
        return (app = ApplicationManager.getApplication()) != null && getter2.apply(app) != false;
    }

    private static String getStringDetail(@NotNull Function<Application, String> getter2) {
        Application app;
        if (getter2 == null) {
            ThreadingAssertions.$$$reportNull$$$0(7);
        }
        return (app = ApplicationManager.getApplication()) != null ? getter2.apply(app) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/concurrency/ThreadingAssertions";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "advice";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/concurrency/ThreadingAssertions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadDetails";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "describe";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "throwThreadAccessException";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createThreadAccessException";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createLockingForbiddenException";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isFlagSet";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getStringDetail";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

