/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;
import org.jetbrains.kotlin.com.intellij.util.io.FilePageCacheLockFree;
import org.jetbrains.kotlin.com.intellij.util.io.PageCacheUtils;
import org.jetbrains.kotlin.com.intellij.util.io.StorageLockContext;
import org.jetbrains.kotlin.com.intellij.util.io.pagecache.PagedStorage;
import org.jetbrains.kotlin.com.intellij.util.io.pagecache.impl.PagesTable;

@ApiStatus.Internal
public final class PagedFileStorageWithRWLockedPageContent
implements PagedStorage {
    private static final Logger LOG = Logger.getInstance(PagedFileStorageWithRWLockedPageContent.class);
    public static final int DEFAULT_PAGE_SIZE = PageCacheUtils.DEFAULT_PAGE_SIZE;
    private static final StorageLockContext DEFAULT_LOCK_CONTEXT = new StorageLockContext(false);
    public static final ThreadLocal<StorageLockContext> THREAD_LOCAL_STORAGE_LOCK_CONTEXT = new ThreadLocal();
    private static final int MAX_ATTEMPTS_TO_ACQUIRE_PAGE = SystemProperties.getIntProperty("vfs.lock-free-impl.max-attempts-to-acquire-page", 10000);
    @NotNull
    private final Path file;
    private final boolean readOnly;
    private final int pageSize;
    private final boolean nativeBytesOrder;
    @NotNull
    private final FilePageCacheLockFree pageCache;
    private final PagesTable pages;
    private volatile Future<?> closingInProgress;
    private final AtomicInteger dirtyPagesCount;
    private final AtomicLong actualSize;
    private static final byte[] ZEROES = new byte[8192];

    @NotNull
    public Path getFile() {
        Path path = this.file;
        if (path == null) {
            PagedFileStorageWithRWLockedPageContent.$$$reportNull$$$0(11);
        }
        return path;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isNativeBytesOrder() {
        return this.nativeBytesOrder;
    }

    @Override
    public boolean isDirty() {
        return this.dirtyPagesCount.get() > 0;
    }

    public boolean isClosed() {
        return this.closingInProgress != null;
    }

    @Override
    public void force() throws IOException {
        if (this.isDirty()) {
            this.pages.flushAll();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        this.pageCache.tryToReclaimAll(this.pages);
        Future<?> future = this.closeAsync();
        try {
            future.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException("Can't close storage for " + this.file, cause);
        }
        catch (InterruptedException e) {
            InterruptedIOException ioEx = new InterruptedIOException("Closing storage for " + this.file + " was interrupted");
            ioEx.addSuppressed(e);
            throw ioEx;
        }
    }

    public synchronized Future<?> closeAsync() {
        if (!this.isClosed()) {
            CompletableFuture<Object> closingProgress = new CompletableFuture<Object>();
            this.closingInProgress = closingProgress;
            this.pageCache.enqueueStoragePagesClosing(this, closingProgress);
        }
        return this.closingInProgress;
    }

    public String toString() {
        return "PagedFileStorage[" + this.file + "]{size: " + this.actualSize.get() + ", dirtyPages: " + this.dirtyPagesCount.get() + "}{pageSize: " + this.pageSize + ", " + (this.isClosed() ? "closed " : "") + (this.isReadOnly() ? "readOnly " : "") + (this.isNativeBytesOrder() ? "nativeByteOrder" : "") + "}";
    }

    PagesTable pages() {
        return this.pages;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 13: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 13: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageLockContext";
                break;
            }
            case 11: 
            case 13: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/io/PagedFileStorageWithRWLockedPageContent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pageToLoad";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bufferToSave";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pageBuffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/PagedFileStorageWithRWLockedPageContent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "pageByOffset";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findOutAppropriateContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createWithDefaults";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 13: 
            case 19: 
            case 20: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "putBuffer";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "executeOp";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "executeIdempotentOp";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadPageData";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "flushPage";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fillWithZeroes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 13: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

