/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.zip.CRC32;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.util.ConcurrencyUtil;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.IndexStorageUtil;
import org.jetbrains.kotlin.com.intellij.util.io.CorruptionException;
import org.jetbrains.kotlin.com.intellij.util.io.DataExternalizer;
import org.jetbrains.kotlin.com.intellij.util.io.DataOutputStream;
import org.jetbrains.kotlin.com.intellij.util.io.EnumeratorIntegerDescriptor;
import org.jetbrains.kotlin.com.intellij.util.io.KeyDescriptor;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentMapWal;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentMapWalPlayer;
import org.jetbrains.kotlin.com.intellij.util.io.UnsyncByteArrayOutputStream;
import org.jetbrains.kotlin.com.intellij.util.io.WalEvent;
import org.jetbrains.kotlin.com.intellij.util.io.WalRecord;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntSet;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000j\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a(\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0012\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0017\u001a2\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0019\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0017H\u0007\u001aJ\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u001e0\u001c\"\u0004\b\u0000\u0010\u001d\"\u0004\b\u0001\u0010\u001e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u00172\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001e0!\u001aB\u0010\"\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u001e0#\"\u0004\b\u0000\u0010\u001d\"\u0004\b\u0001\u0010\u001e2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u00172\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001e0!\u001a:\u0010$\u001a\u0004\u0018\u00010\u0015\"\u0004\b\u0000\u0010\u001d\"\u0004\b\u0001\u0010\u001e2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u00172\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001e0!H\u0002\u001a)\u0010%\u001a\u0002H\u001e\"\u0004\b\u0000\u0010\u001e2\u0006\u0010&\u001a\u00020'2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001e0!H\u0002\u00a2\u0006\u0002\u0010(\u001a)\u0010)\u001a\u00020'\"\u0004\b\u0000\u0010\u001e2\u0006\u0010*\u001a\u0002H\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001e0!H\u0002\u00a2\u0006\u0002\u0010+\u001a]\u0010,\u001a\u0002H-\"\u0004\b\u0000\u0010\u001d\"\u0004\b\u0001\u0010\u001e\"\u0004\b\u0002\u0010-2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u00172\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001e0!2\u0018\u0010.\u001a\u0014\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u0002H-0/H\u0002\u00a2\u0006\u0002\u00100\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\"\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00061"}, d2={"VERSION", "", "checksumGen", "Lkotlin/Function0;", "Ljava/util/zip/CRC32;", "debugWalRecords", "", "getDebugWalRecords", "()Z", "setDebugWalRecords", "(Z)V", "log", "Lorg/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger;", "integerExternalizer", "Lorg/jetbrains/kotlin/com/intellij/util/io/EnumeratorIntegerDescriptor;", "getIntegerExternalizer", "()Lcom/intellij/util/io/EnumeratorIntegerDescriptor;", "restoreMemoryEnumeratorFromWal", "", "Data", "walFile", "Ljava/nio/file/Path;", "dataDescriptor", "Lorg/jetbrains/kotlin/com/intellij/util/io/KeyDescriptor;", "restorePersistentEnumeratorFromWal", "Lorg/jetbrains/kotlin/com/intellij/util/io/PersistentEnumerator;", "outputMapFile", "restorePersistentMapFromWal", "Lorg/jetbrains/kotlin/com/intellij/util/io/PersistentMap;", "K", "V", "keyDescriptor", "valueExternalizer", "Lorg/jetbrains/kotlin/com/intellij/util/io/DataExternalizer;", "restoreHashMapFromWal", "", "tryCompact", "readData", "array", "", "([BLcom/intellij/util/io/DataExternalizer;)Ljava/lang/Object;", "writeData", "value", "(Ljava/lang/Object;Lcom/intellij/util/io/DataExternalizer;)[B", "restoreFromWal", "R", "accumulator", "Lorg/jetbrains/kotlin/com/intellij/util/io/Accumulator;", "(Ljava/nio/file/Path;Lcom/intellij/util/io/KeyDescriptor;Lcom/intellij/util/io/DataExternalizer;Lcom/intellij/util/io/Accumulator;)Ljava/lang/Object;", "intellij.platform.util"})
@SourceDebugExtension(value={"SMAP\nwriteAheadLog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 writeAheadLog.kt\ncom/intellij/util/io/WriteAheadLogKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,517:1\n1#2:518\n1328#3,3:519\n15#4:522\n*S KotlinDebug\n*F\n+ 1 writeAheadLog.kt\ncom/intellij/util/io/WriteAheadLogKt\n*L\n329#1:519,3\n44#1:522\n*E\n"})
public final class WriteAheadLogKt {
    @NotNull
    private static final Function0<CRC32> checksumGen = WriteAheadLogKt::checksumGen$lambda$0;
    private static volatile boolean debugWalRecords;
    @NotNull
    private static final Logger log;

    public static final boolean getDebugWalRecords() {
        return debugWalRecords;
    }

    private static final EnumeratorIntegerDescriptor getIntegerExternalizer() {
        EnumeratorIntegerDescriptor enumeratorIntegerDescriptor = EnumeratorIntegerDescriptor.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)enumeratorIntegerDescriptor, (String)"INSTANCE");
        return enumeratorIntegerDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final <K, V> Path tryCompact(Path walFile, KeyDescriptor<K> keyDescriptor, DataExternalizer<V> valueExternalizer) {
        boolean bl;
        WalEvent walEvent;
        if (!Files.exists(walFile, new LinkOption[0])) {
            return null;
        }
        Map<Object, IntLinkedOpenHashSet> map = IndexStorageUtil.createKeyDescriptorHashedMap(keyDescriptor);
        Intrinsics.checkNotNullExpressionValue(map, (String)"createKeyDescriptorHashedMap(...)");
        Map<Object, IntLinkedOpenHashSet> keyToLastEvent = map;
        Closeable closeable = new PersistentMapWalPlayer<K, V>(keyDescriptor, valueExternalizer, walFile);
        Object object = null;
        try {
            PersistentMapWalPlayer it = (PersistentMapWalPlayer)closeable;
            boolean bl2 = false;
            int eventCount = 0;
            for (WalEvent walEvent2 : it.readWal()) {
                Serializable serializable;
                walEvent = walEvent2;
                if (walEvent instanceof WalEvent.AppendEvent) {
                    serializable = ((IntSet)keyToLastEvent.computeIfAbsent(((WalEvent.AppendEvent)walEvent2).getKey(), WriteAheadLogKt::tryCompact$lambda$4$lambda$1)).add(eventCount);
                } else if (walEvent instanceof WalEvent.PutEvent) {
                    void set;
                    IntLinkedOpenHashSet intLinkedOpenHashSet;
                    IntLinkedOpenHashSet intLinkedOpenHashSet2 = intLinkedOpenHashSet = new IntLinkedOpenHashSet();
                    Object k = ((WalEvent.PutEvent)walEvent2).getKey();
                    Map<Object, IntLinkedOpenHashSet> map2 = keyToLastEvent;
                    boolean bl3 = false;
                    set.add(eventCount);
                    Unit unit = Unit.INSTANCE;
                    serializable = map2.put(k, intLinkedOpenHashSet);
                } else if (walEvent instanceof WalEvent.RemoveEvent) {
                    serializable = keyToLastEvent.put(((WalEvent.RemoveEvent)walEvent2).getKey(), new IntLinkedOpenHashSet());
                } else {
                    if (walEvent instanceof WalEvent.CorruptionEvent) {
                        throw new CorruptionException("wal has been corrupted");
                    }
                    throw new NoWhenBranchMatchedException();
                }
                ((IntSet)keyToLastEvent.computeIfAbsent(walEvent2.getKey(), WriteAheadLogKt::tryCompact$lambda$4$lambda$3)).add(eventCount);
                ++eventCount;
            }
            bl = keyToLastEvent.size() * 2 < eventCount;
        }
        catch (Throwable bl2) {
            object = bl2;
            throw bl2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        boolean shouldCompact = bl;
        if (!shouldCompact) {
            return null;
        }
        Path compactedWalFile = walFile.resolveSibling(walFile.getFileName() + "_compacted");
        object = new PersistentMapWalPlayer<K, V>(keyDescriptor, valueExternalizer, walFile);
        Throwable throwable = null;
        try {
            PersistentMapWalPlayer walPlayer = (PersistentMapWalPlayer)object;
            boolean bl4 = false;
            boolean bl5 = walPlayer.getUseCompression$intellij_platform_util();
            Intrinsics.checkNotNull((Object)compactedWalFile);
            ExecutorService executorService = ConcurrencyUtil.newSameThreadExecutorService();
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSameThreadExecutorService(...)");
            Closeable closeable2 = new PersistentMapWal(keyDescriptor, valueExternalizer, bl5, compactedWalFile, executorService, false, 32, null);
            Throwable throwable2 = null;
            try {
                PersistentMapWal compactedWal = (PersistentMapWal)closeable2;
                boolean bl6 = false;
                Sequence $this$forEachIndexed$iv = walPlayer.readWal();
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    IntSet events;
                    void walEvent3;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    WalEvent walEvent4 = (WalEvent)item$iv;
                    int index = n;
                    boolean bl7 = false;
                    Object key = walEvent3.getKey();
                    if ((IntSet)keyToLastEvent.get(key) == null) {
                        throw new IOException("No events found for key =  " + key);
                    }
                    if (!events.contains(index)) continue;
                    void var25_38 = walEvent3;
                    if (var25_38 instanceof WalEvent.AppendEvent) {
                        compactedWal.appendData(key, arg_0 -> WriteAheadLogKt.tryCompact$lambda$8$lambda$7$lambda$6$lambda$5((WalEvent)walEvent3, arg_0));
                        continue;
                    }
                    if (var25_38 instanceof WalEvent.PutEvent) {
                        compactedWal.put(key, ((WalEvent.PutEvent)walEvent3).getValue());
                        continue;
                    }
                    if (var25_38 instanceof WalEvent.RemoveEvent) continue;
                    if (var25_38 instanceof WalEvent.CorruptionEvent) {
                        throw new CorruptionException("wal has been corrupted");
                    }
                    throw new NoWhenBranchMatchedException();
                }
                walEvent = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return compactedWalFile;
    }

    private static final <V> V readData(byte[] array, DataExternalizer<V> valueExternalizer) {
        return valueExternalizer.read(new DataInputStream(new ByteArrayInputStream(array)));
    }

    private static final <V> byte[] writeData(V value2, DataExternalizer<V> valueExternalizer) {
        UnsyncByteArrayOutputStream baos = new UnsyncByteArrayOutputStream();
        valueExternalizer.save(new DataOutputStream(baos), value2);
        byte[] byArray = baos.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    private static final CRC32 checksumGen$lambda$0() {
        return new CRC32();
    }

    private static final IntLinkedOpenHashSet tryCompact$lambda$4$lambda$1(Object it) {
        return new IntLinkedOpenHashSet();
    }

    private static final IntLinkedOpenHashSet tryCompact$lambda$4$lambda$3(Object it) {
        return new IntLinkedOpenHashSet();
    }

    private static final void tryCompact$lambda$8$lambda$7$lambda$6$lambda$5(WalEvent $walEvent, DataOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.write(((WalEvent.AppendEvent)$walEvent).getData());
    }

    public static final /* synthetic */ EnumeratorIntegerDescriptor access$getIntegerExternalizer() {
        return WriteAheadLogKt.getIntegerExternalizer();
    }

    public static final /* synthetic */ Path access$tryCompact(Path walFile, KeyDescriptor keyDescriptor, DataExternalizer valueExternalizer) {
        return WriteAheadLogKt.tryCompact(walFile, keyDescriptor, valueExternalizer);
    }

    public static final /* synthetic */ byte[] access$writeData(Object value2, DataExternalizer valueExternalizer) {
        return WriteAheadLogKt.writeData(value2, valueExternalizer);
    }

    public static final /* synthetic */ Function0 access$getChecksumGen$p() {
        return checksumGen;
    }

    public static final /* synthetic */ Object access$readData(byte[] array, DataExternalizer valueExternalizer) {
        return WriteAheadLogKt.readData(array, valueExternalizer);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WalRecord.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }
}

