/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io.zip;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.io.zip.JBZipExtraField;
import org.jetbrains.kotlin.com.intellij.util.io.zip.ZipShort;

class UnrecognizedExtraField
implements JBZipExtraField {
    @NotNull
    private final ZipShort myHeaderId;
    private byte[] myLocalData;
    private byte[] myCentralData;

    UnrecognizedExtraField(@NotNull ZipShort headerId) {
        if (headerId == null) {
            UnrecognizedExtraField.$$$reportNull$$$0(0);
        }
        this.myHeaderId = headerId;
    }

    @Override
    @NotNull
    public ZipShort getHeaderId() {
        ZipShort zipShort = this.myHeaderId;
        if (zipShort == null) {
            UnrecognizedExtraField.$$$reportNull$$$0(1);
        }
        return zipShort;
    }

    public void setLocalFileDataData(byte[] data) {
        this.myLocalData = ArrayUtil.copyOf(data);
    }

    @Override
    @NotNull
    public ZipShort getLocalFileDataLength() {
        return new ZipShort(this.myLocalData != null ? this.myLocalData.length : 0);
    }

    @Override
    public byte @NotNull [] getLocalFileDataData() {
        byte[] byArray = ArrayUtil.copyOf(this.myLocalData);
        if (byArray == null) {
            UnrecognizedExtraField.$$$reportNull$$$0(2);
        }
        return byArray;
    }

    public void setCentralDirectoryData(byte[] data) {
        this.myCentralData = ArrayUtil.copyOf(data);
    }

    @Override
    @NotNull
    public ZipShort getCentralDirectoryLength() {
        if (this.myCentralData != null) {
            return new ZipShort(this.myCentralData.length);
        }
        ZipShort zipShort = this.getLocalFileDataLength();
        if (zipShort == null) {
            UnrecognizedExtraField.$$$reportNull$$$0(3);
        }
        return zipShort;
    }

    @Override
    public byte @NotNull [] getCentralDirectoryData() {
        if (this.myCentralData != null) {
            byte[] byArray = ArrayUtil.copyOf(this.myCentralData);
            if (byArray == null) {
                UnrecognizedExtraField.$$$reportNull$$$0(4);
            }
            return byArray;
        }
        byte[] byArray = this.getLocalFileDataData();
        if (byArray == null) {
            UnrecognizedExtraField.$$$reportNull$$$0(5);
        }
        return byArray;
    }

    @Override
    public void parseFromCentralDirectoryData(byte @NotNull [] data, int offset, int length) {
        if (data == null) {
            UnrecognizedExtraField.$$$reportNull$$$0(7);
        }
        byte[] tmp = Arrays.copyOfRange(data, offset, offset + length);
        this.setCentralDirectoryData(tmp);
        if (this.myLocalData == null) {
            this.setLocalFileDataData(tmp);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/io/zip/UnrecognizedExtraField";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/zip/UnrecognizedExtraField";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalFileDataData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCentralDirectoryLength";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCentralDirectoryData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseFromLocalFileData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseFromCentralDirectoryData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

