/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.messages.impl;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.messages.Topic;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.MessageBusImpl;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J+\u0010\u000e\u001a\u00020\u000f\"\b\b\u0000\u0010\u0010*\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00122\u0006\u0010\u0013\u001a\u0002H\u0010\u00a2\u0006\u0002\u0010\u0014J$\u0010\u0015\u001a\u00020\u000f2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0000\u0012\u00020\t0\u0017H\u0016J\u001a\u0010\u0018\u001a\u00020\u000f2\u0010\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b0\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u000fH$J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R<\u0010\u0006\u001a.\u0012*\u0012(\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0014\u0012\u000e\b\u0001\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\b0\b0\u00078\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\r\u0082\u0001\u0002\u001f \u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/com/intellij/util/messages/impl/BaseBusConnection;", "Lorg/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusImpl$MessageHandlerHolder;", "bus", "Lorg/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusImpl;", "<init>", "(Lcom/intellij/util/messages/impl/MessageBusImpl;)V", "subscriptions", "Ljava/util/concurrent/atomic/AtomicReference;", "", "", "kotlin.jvm.PlatformType", "isDisposed", "", "()Z", "subscribe", "", "L", "topic", "Lorg/jetbrains/kotlin/com/intellij/util/messages/Topic;", "handler", "(Lcom/intellij/util/messages/Topic;Ljava/lang/Object;)V", "collectHandlers", "result", "", "disconnectIfNeeded", "predicate", "Ljava/util/function/Predicate;", "Ljava/lang/Class;", "disconnect", "toString", "", "Lorg/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusConnectionImpl;", "Lorg/jetbrains/kotlin/com/intellij/util/messages/impl/SimpleMessageBusConnectionImpl;", "intellij.platform.core"})
@SourceDebugExtension(value={"SMAP\nBaseBusConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseBusConnection.kt\ncom/intellij/util/messages/impl/BaseBusConnection\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,89:1\n37#2:90\n36#2,3:91\n*S KotlinDebug\n*F\n+ 1 BaseBusConnection.kt\ncom/intellij/util/messages/impl/BaseBusConnection\n*L\n80#1:90\n80#1:91,3\n*E\n"})
public abstract class BaseBusConnection
implements MessageBusImpl.MessageHandlerHolder {
    @JvmField
    @Nullable
    public MessageBusImpl bus;
    @JvmField
    @NotNull
    protected final AtomicReference<Object[]> subscriptions;

    private BaseBusConnection(MessageBusImpl bus) {
        this.bus = bus;
        this.subscriptions = new AtomicReference<Object[]>(ArrayUtilRt.EMPTY_OBJECT_ARRAY);
    }

    @Override
    public boolean isDisposed() {
        return this.bus == null;
    }

    public final <L> void subscribe(@NotNull Topic<L> topic, @NotNull L handler2) {
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        Object[] list = null;
        Object[] newList = null;
        do {
            if ((list = this.subscriptions.get()).length == 0) {
                Object[] objectArray = new Object[]{topic, handler2};
                newList = objectArray;
                continue;
            }
            int size = list.length;
            newList = Arrays.copyOf(list, size + 2);
            newList[size] = topic;
            newList[size + 1] = handler2;
        } while (!this.subscriptions.compareAndSet(list, newList));
        MessageBusImpl messageBusImpl = this.bus;
        Intrinsics.checkNotNull((Object)messageBusImpl);
        messageBusImpl.notifyOnSubscription$intellij_platform_core(topic);
    }

    @Override
    public void collectHandlers(@NotNull Topic<?> topic, @NotNull List<? super Object> result2) {
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        Object[] list = this.subscriptions.get();
        int n = list.length;
        for (int i = 0; i < n; i += 2) {
            if (list[i] != topic) continue;
            Object object = list[i + 1];
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            result2.add(object);
        }
    }

    @NotNull
    public String toString() {
        String string = Arrays.toString(this.subscriptions.get());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public /* synthetic */ BaseBusConnection(MessageBusImpl bus, DefaultConstructorMarker $constructor_marker) {
        this(bus);
    }
}

