/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.config.MavenComparableVersion;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.rendering.ContextIndependentParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRendererKt;
import org.jetbrains.kotlin.diagnostics.rendering.RenderingContext;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00150\u00140\u0013\"\u0004\b\u0000\u0010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0013H\u0007J(\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00150\u00140\u0005\"\u0004\b\u0000\u0010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0005H\u0007J\u009b\u0001\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00190\u0005\"\u0004\b\u0000\u0010\u001a\"\u0004\b\u0001\u0010\u00192\u0006\u0010\u001b\u001a\u00020\u00072\u0016\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u0002H\u001a0\u001dj\b\u0012\u0004\u0012\u0002H\u001a`\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u00132!\u0010 \u001a\u001d\u0012\b\u0012\u00060\"j\u0002`#\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u00020$0!\u00a2\u0006\u0002\b%2\u0018\u0010&\u001a\u0014\u0012\u0004\u0012\u0002H\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001a0\u00140'2\u0014\b\u0002\u0010(\u001a\u000e\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u00020\u00070'H\u0007R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/CommonRenderers;", "", "<init>", "()V", "EMPTY", "Lorg/jetbrains/kotlin/diagnostics/rendering/ContextIndependentParameterRenderer;", "STRING", "", "NAME", "Lorg/jetbrains/kotlin/name/Name;", "MAVEN_VERSION", "Lorg/jetbrains/kotlin/config/MavenComparableVersion;", "THROWABLE", "", "RENDER_POSITION_VARIANCE", "Lorg/jetbrains/kotlin/types/Variance;", "CLASS_KIND", "Lorg/jetbrains/kotlin/descriptors/ClassKind;", "commaSeparated", "Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticParameterRenderer;", "", "T", "itemRenderer", "onNextLines", "renderConflictingSignatureData", "Data", "Declaration", "signatureKind", "sortUsing", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "declarationRenderer", "renderSignature", "Lkotlin/Function2;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "", "Lkotlin/ExtensionFunctionType;", "declarations", "Lkotlin/Function1;", "declarationKind", "frontend.common-psi"})
public final class CommonRenderers {
    @NotNull
    public static final CommonRenderers INSTANCE = new CommonRenderers();
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<Object> EMPTY = DiagnosticParameterRendererKt.Renderer(CommonRenderers::EMPTY$lambda$0);
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<String> STRING = DiagnosticParameterRendererKt.Renderer(CommonRenderers::STRING$lambda$0);
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<Name> NAME = DiagnosticParameterRendererKt.Renderer(CommonRenderers::NAME$lambda$0);
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<MavenComparableVersion> MAVEN_VERSION = DiagnosticParameterRendererKt.Renderer(CommonRenderers::MAVEN_VERSION$lambda$0);
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<Throwable> THROWABLE = DiagnosticParameterRendererKt.Renderer(CommonRenderers::THROWABLE$lambda$0);
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<Variance> RENDER_POSITION_VARIANCE = DiagnosticParameterRendererKt.Renderer(CommonRenderers::RENDER_POSITION_VARIANCE$lambda$0);
    @JvmField
    @NotNull
    public static final ContextIndependentParameterRenderer<ClassKind> CLASS_KIND = DiagnosticParameterRendererKt.Renderer(CommonRenderers::CLASS_KIND$lambda$0);

    private CommonRenderers() {
    }

    @JvmStatic
    @NotNull
    public static final <T> DiagnosticParameterRenderer<Collection<? extends T>> commaSeparated(@NotNull DiagnosticParameterRenderer<? super T> itemRenderer) {
        Intrinsics.checkNotNullParameter(itemRenderer, (String)"itemRenderer");
        return DiagnosticParameterRendererKt.ContextDependentRenderer((arg_0, arg_1) -> CommonRenderers.commaSeparated$lambda$0(itemRenderer, arg_0, arg_1));
    }

    @JvmStatic
    @NotNull
    public static final <T> ContextIndependentParameterRenderer<Collection<? extends T>> onNextLines(@NotNull ContextIndependentParameterRenderer<? super T> itemRenderer) {
        Intrinsics.checkNotNullParameter(itemRenderer, (String)"itemRenderer");
        return DiagnosticParameterRendererKt.Renderer(arg_0 -> CommonRenderers.onNextLines$lambda$0(itemRenderer, arg_0));
    }

    @JvmStatic
    @NotNull
    public static final <Declaration, Data> ContextIndependentParameterRenderer<Data> renderConflictingSignatureData(@NotNull String signatureKind, @NotNull Comparator<Declaration> sortUsing, @NotNull DiagnosticParameterRenderer<? super Declaration> declarationRenderer, @NotNull Function2<? super StringBuilder, ? super Data, Unit> renderSignature, @NotNull Function1<? super Data, ? extends Collection<? extends Declaration>> declarations2, @NotNull Function1<? super Data, String> declarationKind) {
        Intrinsics.checkNotNullParameter((Object)signatureKind, (String)"signatureKind");
        Intrinsics.checkNotNullParameter(sortUsing, (String)"sortUsing");
        Intrinsics.checkNotNullParameter(declarationRenderer, (String)"declarationRenderer");
        Intrinsics.checkNotNullParameter(renderSignature, (String)"renderSignature");
        Intrinsics.checkNotNullParameter(declarations2, (String)"declarations");
        Intrinsics.checkNotNullParameter(declarationKind, (String)"declarationKind");
        return DiagnosticParameterRendererKt.Renderer(arg_0 -> CommonRenderers.renderConflictingSignatureData$lambda$1(declarations2, sortUsing, declarationKind, signatureKind, renderSignature, declarationRenderer, arg_0));
    }

    public static /* synthetic */ ContextIndependentParameterRenderer renderConflictingSignatureData$default(String string, Comparator comparator, DiagnosticParameterRenderer diagnosticParameterRenderer, Function2 function2, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 0x20) != 0) {
            function12 = CommonRenderers::renderConflictingSignatureData$lambda$0;
        }
        return CommonRenderers.renderConflictingSignatureData(string, comparator, diagnosticParameterRenderer, function2, function1, function12);
    }

    private static final String EMPTY$lambda$0(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "";
    }

    private static final String STRING$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final String NAME$lambda$0(Name it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return string;
    }

    private static final String MAVEN_VERSION$lambda$0(MavenComparableVersion it) {
        Object object = it;
        if (object == null || (object = ((MavenComparableVersion)object).toString()) == null) {
            object = "initial version";
        }
        return object;
    }

    private static final String THROWABLE$lambda$0(Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        StringWriter writer = new StringWriter();
        it.printStackTrace(new PrintWriter(writer));
        String string = StringUtil.first(writer.toString(), 2048, true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"first(...)");
        return string;
    }

    private static final String RENDER_POSITION_VARIANCE$lambda$0(Variance variance) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)variance), (String)"variance");
        switch (WhenMappings.$EnumSwitchMapping$0[variance.ordinal()]) {
            case 1: {
                string = "invariant";
                break;
            }
            case 2: {
                string = "in";
                break;
            }
            case 3: {
                string = "out";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private static final String CLASS_KIND$lambda$0(ClassKind classKind) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)classKind), (String)"classKind");
        switch (WhenMappings.$EnumSwitchMapping$1[classKind.ordinal()]) {
            case 1: {
                string = "class";
                break;
            }
            case 2: {
                string = "interface";
                break;
            }
            case 3: {
                string = "enum class";
                break;
            }
            case 4: {
                string = "enum entry";
                break;
            }
            case 5: {
                string = "annotation class";
                break;
            }
            case 6: {
                string = "object";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private static final String commaSeparated$lambda$0(DiagnosticParameterRenderer $itemRenderer, Collection collection, RenderingContext context2) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        StringBuilder $this$commaSeparated_u24lambda_u240_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Iterator iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            Object next = iterator2.next();
            $this$commaSeparated_u24lambda_u240_u240.append($itemRenderer.render(next, context2));
            if (!iterator2.hasNext()) continue;
            $this$commaSeparated_u24lambda_u240_u240.append(", ");
        }
        return stringBuilder.toString();
    }

    private static final String onNextLines$lambda$0(ContextIndependentParameterRenderer $itemRenderer, Collection elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        return CollectionsKt.joinToString$default((Iterable)elements, (CharSequence)"\n", (CharSequence)"\n", null, (int)0, null, (Function1)new Function1<T, String>($itemRenderer){

            public final String invoke(T p0) {
                return ((ContextIndependentParameterRenderer)this.receiver).render(p0);
            }
        }, (int)28, null);
    }

    private static final String renderConflictingSignatureData$lambda$0(Object it) {
        return "declarations";
    }

    private static final Unit renderConflictingSignatureData$lambda$1$0$0(DiagnosticParameterRenderer $declarationRenderer, RenderingContext.Impl $renderingContext, StringBuilder $this$joinToWithBuffer, Object descriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$joinToWithBuffer, (String)"$this$joinToWithBuffer");
        $this$joinToWithBuffer.append("    ");
        $this$joinToWithBuffer.append($declarationRenderer.render(descriptor, $renderingContext));
        return Unit.INSTANCE;
    }

    private static final String renderConflictingSignatureData$lambda$1(Function1 $declarations, Comparator $sortUsing, Function1 $declarationKind, String $signatureKind, Function2 $renderSignature, DiagnosticParameterRenderer $declarationRenderer, Object data) {
        StringBuilder stringBuilder;
        List sortedDeclarations = CollectionsKt.sortedWith((Iterable)((Iterable)$declarations.invoke(data)), (Comparator)$sortUsing);
        RenderingContext.Impl renderingContext = new RenderingContext.Impl(sortedDeclarations);
        StringBuilder $this$renderConflictingSignatureData_u24lambda_u241_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$renderConflictingSignatureData_u24lambda_u241_u240.append("The following ");
        $this$renderConflictingSignatureData_u24lambda_u241_u240.append((String)$declarationKind.invoke(data));
        $this$renderConflictingSignatureData_u24lambda_u241_u240.append(" have the same ");
        $this$renderConflictingSignatureData_u24lambda_u241_u240.append($signatureKind);
        $this$renderConflictingSignatureData_u24lambda_u241_u240.append(" signature (");
        $renderSignature.invoke((Object)$this$renderConflictingSignatureData_u24lambda_u241_u240, data);
        $this$renderConflictingSignatureData_u24lambda_u241_u240.append("):").append('\n');
        AddToStdlibKt.joinToWithBuffer$default(sortedDeclarations, $this$renderConflictingSignatureData_u24lambda_u241_u240, "\n", null, null, 0, null, (arg_0, arg_1) -> CommonRenderers.renderConflictingSignatureData$lambda$1$0$0($declarationRenderer, renderingContext, arg_0, arg_1), 60, null);
        return stringBuilder.toString();
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Variance.values().length];
            try {
                nArray[Variance.INVARIANT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Variance.IN_VARIANCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Variance.OUT_VARIANCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.INTERFACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_CLASS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_ENTRY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ANNOTATION_CLASS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.OBJECT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

