/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.RelationToType;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory4;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.FirVisibilityHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.PermissivenessForExposedVisibility;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameterKind;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.extensions.FirScriptResolutionHacksComponent;
import org.jetbrains.kotlin.fir.extensions.FirScriptResolutionHacksComponentKt;
import org.jetbrains.kotlin.fir.resolve.ContainingClassUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirLocalPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001;B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ-\u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000fH\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0010J-\u0010\u0011\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000fH\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0010J5\u0010\u0012\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0016J-\u0010\u0017\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0018H\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0019J-\u0010\u001a\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u001bH\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001cJ-\u0010\u001d\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u001eH\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001fJ1\u0010 \u001a\u00020\u0007*\u00020!2\u0006\u0010\"\u001a\u00020\u0015H\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010#J9\u0010$\u001a\u00020\u00072\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010'\u001a\u0004\u0018\u00010(H\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010)JA\u0010*\u001a\u0004\u0018\u00010+*\u00020,2\u0006\u0010-\u001a\u00020\u00152\b\b\u0002\u0010.\u001a\u00020/2\u000e\b\u0002\u00100\u001a\b\u0012\u0004\u0012\u00020,01H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u00102J4\u00103\u001a\u00020+2\n\u00104\u001a\u0006\u0012\u0002\b\u0003052\u0006\u00106\u001a\u00020\u00152\u0006\u00107\u001a\u00020\u00152\u0006\u00108\u001a\u00020/2\u0006\u00109\u001a\u00020:H\u0002\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "checkClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;)V", "checkSupertypes", "checkParameterBounds", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameterRefsOwner;", "visibility", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameterRefsOwner;Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;)V", "checkTypeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;)V", "checkFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirFunction;)V", "checkProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)V", "checkExposure", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "declarationVisibility", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;)V", "checkMemberReceiver", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "memberDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/types/FirTypeRef;Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;)V", "findVisibilityExposure", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker$SymbolWithRelation;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "base", "ignoreInternalExposure", "", "visitedTypes", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;ZLjava/util/Set;)Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker$SymbolWithRelation;", "symbolWithRelation", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "symbolVisibility", "baseVisibility", "fromTypeArgument", "permissiveness", "Lorg/jetbrains/kotlin/fir/analysis/checkers/PermissivenessForExposedVisibility;", "SymbolWithRelation", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirExposedVisibilityDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExposedVisibilityDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,357:1\n29#2:358\n29#2:359\n29#2:360\n29#2:361\n57#2:362\n29#2:363\n29#2:364\n29#2:365\n49#3:366\n49#3:367\n48#3:369\n48#3:370\n48#3:371\n1#4:368\n*S KotlinDebug\n*F\n+ 1 FirExposedVisibilityDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker\n*L\n60#1:358\n65#1:359\n125#1:360\n140#1:361\n141#1:362\n174#1:363\n213#1:364\n228#1:365\n252#1:366\n253#1:367\n306#1:369\n310#1:370\n313#1:371\n*E\n"})
public final class FirExposedVisibilityDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirExposedVisibilityDeclarationChecker INSTANCE = new FirExposedVisibilityDeclarationChecker();

    private FirExposedVisibilityDeclarationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        FirDeclaration firDeclaration = declaration;
        if (firDeclaration instanceof FirAnonymousFunction) {
            return;
        }
        if (firDeclaration instanceof FirTypeAlias) {
            this.checkTypeAlias(reporter, context2, (FirTypeAlias)declaration);
        } else if (firDeclaration instanceof FirProperty) {
            this.checkProperty(reporter, context2, (FirProperty)declaration);
        } else if (firDeclaration instanceof FirFunction) {
            this.checkFunction(reporter, context2, (FirFunction)declaration);
        } else if (firDeclaration instanceof FirRegularClass) {
            this.checkClass(reporter, context2, (FirRegularClass)declaration);
        }
    }

    private final void checkClass(DiagnosticReporter reporter, CheckerContext context2, FirRegularClass declaration) {
        this.checkSupertypes(reporter, context2, declaration);
        FirTypeParameterRefsOwner firTypeParameterRefsOwner = declaration;
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        this.checkParameterBounds(reporter, context2, firTypeParameterRefsOwner, (EffectiveVisibility)object);
    }

    private final void checkSupertypes(DiagnosticReporter reporter, CheckerContext context2, FirRegularClass declaration) {
        Object classVisibility;
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)(classVisibility = object), (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        List<FirTypeRef> supertypes = declaration.getSuperTypeRefs();
        boolean isInterface = declaration.getClassKind() == ClassKind.INTERFACE;
        for (FirTypeRef supertypeRef : supertypes) {
            SymbolWithRelation symbolWithRelation;
            FirRegularClassSymbol classSymbol;
            boolean superIsInterface;
            ConeKotlinType supertype;
            KtSourceElement ktSourceElement = supertypeRef.getSource();
            if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.EnumSuperTypeRef.INSTANCE) || ToSymbolUtilsKt.toRegularClassSymbol((SessionHolder)context2, supertype = FirTypeUtilsKt.getConeType(supertypeRef)) == null || (superIsInterface = classSymbol.getClassKind() == ClassKind.INTERFACE) != isInterface || (symbolWithRelation = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, context2, supertype, (EffectiveVisibility)classVisibility, false, null, 12, null)) == null) continue;
            KtDiagnosticFactory4<EffectiveVisibility, FirClassLikeSymbol<?>, RelationToType, EffectiveVisibility> ktDiagnosticFactory4 = isInterface ? FirErrors.INSTANCE.getEXPOSED_SUPER_INTERFACE() : FirErrors.INSTANCE.getEXPOSED_SUPER_CLASS();
            KtSourceElement ktSourceElement2 = supertypeRef.getSource();
            if (ktSourceElement2 == null) {
                ktSourceElement2 = declaration.getSource();
            }
            symbolWithRelation.report(context2, reporter, ktDiagnosticFactory4, ktSourceElement2);
        }
    }

    private final void checkParameterBounds(DiagnosticReporter reporter, CheckerContext context2, FirTypeParameterRefsOwner declaration, EffectiveVisibility visibility) {
        if (Intrinsics.areEqual((Object)visibility, (Object)EffectiveVisibility.Local.INSTANCE) || declaration instanceof FirConstructor) {
            return;
        }
        KtDiagnosticFactory4<EffectiveVisibility, FirClassLikeSymbol<?>, RelationToType, EffectiveVisibility> diagnosticForNonInternalBounds = FirExposedVisibilityDeclarationChecker.checkParameterBounds$getDiagnosticByFeature(context2, declaration, LanguageFeature.ReportExposedTypeForMoreCasesOfTypeParameterBounds);
        KtDiagnosticFactory4<EffectiveVisibility, FirClassLikeSymbol<?>, RelationToType, EffectiveVisibility> diagnosticForInternalBounds = FirExposedVisibilityDeclarationChecker.checkParameterBounds$getDiagnosticByFeature(context2, declaration, LanguageFeature.ReportExposedTypeForInternalTypeParameterBounds);
        for (FirTypeParameterRef parameter : declaration.getTypeParameters()) {
            for (FirResolvedTypeRef bound : parameter.getSymbol().getResolvedBounds()) {
                SymbolWithRelation symbolWithRelation = FirExposedVisibilityDeclarationChecker.checkParameterBounds$findVisibilityExposure(bound, context2, visibility, true);
                if (symbolWithRelation == null || (symbolWithRelation = TuplesKt.to((Object)symbolWithRelation, diagnosticForNonInternalBounds)) == null) {
                    SymbolWithRelation symbolWithRelation2 = FirExposedVisibilityDeclarationChecker.checkParameterBounds$findVisibilityExposure(bound, context2, visibility, false);
                    if (symbolWithRelation2 == null) continue;
                    symbolWithRelation = TuplesKt.to((Object)symbolWithRelation2, diagnosticForInternalBounds);
                }
                SymbolWithRelation symbolWithRelation3 = symbolWithRelation;
                SymbolWithRelation symbolWithRelation4 = (SymbolWithRelation)symbolWithRelation3.component1();
                KtDiagnosticFactory4 diagnostic = (KtDiagnosticFactory4)symbolWithRelation3.component2();
                symbolWithRelation4.report(context2, reporter, diagnostic, bound.getSource());
            }
        }
    }

    private final void checkTypeAlias(DiagnosticReporter reporter, CheckerContext context2, FirTypeAlias declaration) {
        block2: {
            SymbolWithRelation symbolWithRelation;
            Object typeAliasVisibility;
            ConeClassLikeType expandedType2 = FirDeclarationUtilKt.getExpandedConeType(declaration);
            FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
            boolean $i$f$getEffectiveVisibility = false;
            FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
            Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
            if (object == null || (object = object.getEffectiveVisibility()) == null) {
                object = EffectiveVisibility.Local.INSTANCE;
            }
            if (Intrinsics.areEqual((Object)(typeAliasVisibility = object), (Object)EffectiveVisibility.Local.INSTANCE)) {
                return;
            }
            this.checkParameterBounds(reporter, context2, declaration, (EffectiveVisibility)typeAliasVisibility);
            if (expandedType2 == null || (symbolWithRelation = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, context2, expandedType2, (EffectiveVisibility)typeAliasVisibility, false, null, 12, null)) == null) break block2;
            symbolWithRelation.report(context2, reporter, FirErrors.INSTANCE.getEXPOSED_TYPEALIAS_EXPANDED_TYPE(), declaration.getSource());
        }
    }

    private final void checkFunction(DiagnosticReporter reporter, CheckerContext context2, FirFunction declaration) {
        boolean isNonLocal;
        Object functionVisibility;
        KtSourceElement ktSourceElement = declaration.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        Intrinsics.checkNotNull((Object)declaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration");
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = functionVisibility = (EffectiveVisibility)EffectiveVisibility.Local.INSTANCE;
        }
        if (declaration instanceof FirConstructor) {
            FirMemberDeclaration $this$isFromSealedClass$iv = declaration;
            boolean $i$f$isFromSealedClass = false;
            if ($this$isFromSealedClass$iv.getStatus().isFromSealedClass()) {
                functionVisibility = EffectiveVisibility.PrivateInClass.INSTANCE;
            }
        }
        boolean bl = isNonLocal = !Intrinsics.areEqual((Object)functionVisibility, (Object)EffectiveVisibility.Local.INSTANCE);
        if (!(declaration instanceof FirPropertyAccessor)) {
            SymbolWithRelation symbolWithRelation;
            if (isNonLocal && !(declaration instanceof FirConstructor) && (symbolWithRelation = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, context2, FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef()), (EffectiveVisibility)functionVisibility, false, null, 12, null)) != null) {
                symbolWithRelation.report(context2, reporter, FirErrors.INSTANCE.getEXPOSED_FUNCTION_RETURN_TYPE(), declaration.getSource());
            }
            for (FirValueParameter valueParameter2 : declaration.getValueParameters()) {
                this.checkExposure(reporter, context2, valueParameter2, (EffectiveVisibility)functionVisibility);
            }
            for (FirValueParameter valueParameter2 : declaration.getContextParameters()) {
                this.checkExposure(reporter, context2, valueParameter2, (EffectiveVisibility)functionVisibility);
            }
        }
        if (isNonLocal) {
            FirReceiverParameter firReceiverParameter = declaration.getReceiverParameter();
            this.checkMemberReceiver(reporter, context2, firReceiverParameter != null ? firReceiverParameter.getTypeRef() : null, declaration instanceof FirCallableDeclaration ? (FirCallableDeclaration)declaration : null);
        }
        this.checkParameterBounds(reporter, context2, declaration, (EffectiveVisibility)functionVisibility);
    }

    private final void checkProperty(DiagnosticReporter reporter, CheckerContext context2, FirProperty declaration) {
        Object object;
        Object propertyVisibility;
        block10: {
            block9: {
                if (Intrinsics.areEqual((Object)DeclarationAttributesKt.getFromPrimaryConstructor(declaration), (Object)true)) {
                    return;
                }
                if (declaration.getSymbol() instanceof FirLocalPropertySymbol) {
                    return;
                }
                KtSourceElement ktSourceElement = declaration.getSource();
                if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.EnumGeneratedDeclaration.INSTANCE)) {
                    return;
                }
                FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
                boolean $i$f$getEffectiveVisibility = false;
                FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
                Object object2 = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
                if (object2 == null || (object2 = object2.getEffectiveVisibility()) == null) {
                    object2 = EffectiveVisibility.Local.INSTANCE;
                }
                if (Intrinsics.areEqual((Object)(propertyVisibility = object2), (Object)EffectiveVisibility.Local.INSTANCE) || Intrinsics.areEqual((Object)declaration.getOrigin(), (Object)FirDeclarationOrigin.ScriptCustomization.ResultProperty.INSTANCE)) break block9;
                if (!Intrinsics.areEqual((Object)DeclarationAttributesKt.isScriptTopLevelDeclaration(declaration), (Object)true)) break block10;
                FirScriptResolutionHacksComponent firScriptResolutionHacksComponent = FirScriptResolutionHacksComponentKt.getScriptResolutionHacksComponent(context2.getSession());
                boolean bl = firScriptResolutionHacksComponent != null ? firScriptResolutionHacksComponent.getSkipTowerDataCleanupForTopLevelInitializers() : false;
                if (!bl) break block10;
            }
            return;
        }
        if ((object = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, context2, FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef()), (EffectiveVisibility)propertyVisibility, false, null, 12, null)) != null) {
            ((SymbolWithRelation)object).report(context2, reporter, FirErrors.INSTANCE.getEXPOSED_PROPERTY_TYPE(), declaration.getSource());
        }
        FirReceiverParameter firReceiverParameter = declaration.getReceiverParameter();
        this.checkMemberReceiver(reporter, context2, firReceiverParameter != null ? firReceiverParameter.getTypeRef() : null, declaration);
        this.checkParameterBounds(reporter, context2, declaration, (EffectiveVisibility)propertyVisibility);
        for (FirValueParameter parameter : declaration.getContextParameters()) {
            this.checkExposure(reporter, context2, parameter, (EffectiveVisibility)propertyVisibility);
        }
    }

    private final void checkExposure(DiagnosticReporter reporter, CheckerContext context2, FirValueParameter $this$checkExposure, EffectiveVisibility declarationVisibility) {
        Object propertyVisibility;
        SymbolWithRelation symbolWithRelation;
        if (!Intrinsics.areEqual((Object)declarationVisibility, (Object)EffectiveVisibility.Local.INSTANCE) && (symbolWithRelation = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, context2, FirTypeUtilsKt.getConeType($this$checkExposure.getReturnTypeRef()), declarationVisibility, false, null, 12, null)) != null) {
            SymbolWithRelation it = symbolWithRelation;
            boolean bl = false;
            it.report(context2, reporter, $this$checkExposure.getValueParameterKind() == FirValueParameterKind.LegacyContextReceiver ? FirErrors.INSTANCE.getEXPOSED_RECEIVER_TYPE() : FirErrors.INSTANCE.getEXPOSED_PARAMETER_TYPE(), $this$checkExposure.getSource());
            return;
        }
        FirProperty firProperty = ClassMembersKt.getCorrespondingProperty($this$checkExposure);
        if (firProperty == null) {
            return;
        }
        FirProperty property2 = firProperty;
        if (property2.getSymbol() instanceof FirLocalPropertySymbol) {
            return;
        }
        FirMemberDeclaration $this$effectiveVisibility$iv = property2;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)(propertyVisibility = object), (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        SymbolWithRelation symbolWithRelation2 = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, context2, FirTypeUtilsKt.getConeType(property2.getReturnTypeRef()), (EffectiveVisibility)propertyVisibility, false, null, 12, null);
        if (symbolWithRelation2 != null) {
            symbolWithRelation2.report(context2, reporter, FirErrors.INSTANCE.getEXPOSED_PROPERTY_TYPE_IN_CONSTRUCTOR_ERROR(), $this$checkExposure.getSource());
        }
    }

    private final void checkMemberReceiver(DiagnosticReporter reporter, CheckerContext context2, FirTypeRef typeRef, FirCallableDeclaration memberDeclaration) {
        Object memberVisibility;
        if (typeRef == null || memberDeclaration == null) {
            return;
        }
        ConeKotlinType receiverParameterType = FirTypeUtilsKt.getConeType(typeRef);
        FirMemberDeclaration $this$effectiveVisibility$iv = memberDeclaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)(memberVisibility = object), (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        SymbolWithRelation symbolWithRelation = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, context2, receiverParameterType, (EffectiveVisibility)memberVisibility, false, null, 12, null);
        if (symbolWithRelation != null) {
            symbolWithRelation.report(context2, reporter, FirErrors.INSTANCE.getEXPOSED_RECEIVER_TYPE(), typeRef.getSource());
        }
    }

    private final SymbolWithRelation findVisibilityExposure(CheckerContext context2, ConeKotlinType $this$findVisibilityExposure, EffectiveVisibility base, boolean ignoreInternalExposure, Set<ConeKotlinType> visitedTypes) {
        EffectiveVisibility effectiveVisibility;
        EffectiveVisibility effectiveVisibility2;
        boolean $i$f$getEffectiveVisibility;
        FirClassLikeSymbol<?> $this$effectiveVisibility$iv;
        Object object;
        ConeClassLikeType coneClassLikeType;
        if (!visitedTypes.add($this$findVisibilityExposure)) {
            return null;
        }
        ConeKotlinType coneKotlinType = $this$findVisibilityExposure;
        if (coneKotlinType instanceof ConeClassLikeType) {
            coneClassLikeType = (ConeClassLikeType)$this$findVisibilityExposure;
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            object = ((ConeFlexibleType)$this$findVisibilityExposure).getLowerBound();
            coneClassLikeType = object instanceof ConeClassLikeType ? (ConeClassLikeType)object : null;
            if (coneClassLikeType == null) {
                return null;
            }
        } else {
            return null;
        }
        ConeClassLikeType type = coneClassLikeType;
        FirClassLikeSymbol<?> firClassLikeSymbol = ToSymbolUtilsKt.toSymbol((SessionHolder)context2, TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, type).getLookupTag());
        if (firClassLikeSymbol == null) {
            return null;
        }
        FirClassLikeSymbol<?> classSymbol = firClassLikeSymbol;
        object = classSymbol;
        if (object instanceof FirRegularClassSymbol) {
            $this$effectiveVisibility$iv = classSymbol;
            $i$f$getEffectiveVisibility = false;
            effectiveVisibility2 = $this$effectiveVisibility$iv.getResolvedStatus().getEffectiveVisibility();
        } else if (object instanceof FirTypeAliasSymbol) {
            $this$effectiveVisibility$iv = classSymbol;
            $i$f$getEffectiveVisibility = false;
            effectiveVisibility2 = $this$effectiveVisibility$iv.getResolvedStatus().getEffectiveVisibility();
        } else {
            effectiveVisibility2 = effectiveVisibility = null;
        }
        if (ignoreInternalExposure && Intrinsics.areEqual((Object)effectiveVisibility, (Object)EffectiveVisibility.Internal.INSTANCE)) {
            return null;
        }
        if (effectiveVisibility != null) {
            PermissivenessForExposedVisibility permissiveness = FirVisibilityHelpersKt.relationForExposedVisibility(context2, effectiveVisibility, base);
            switch (WhenMappings.$EnumSwitchMapping$0[permissiveness.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    return this.symbolWithRelation(classSymbol, effectiveVisibility, base, visitedTypes.size() > 1, permissiveness);
                }
                case 4: 
                case 5: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        object = type.getTypeArguments();
        int n = ((ConeTypeProjection[])object).length;
        for (int i = 0; i < n; ++i) {
            Object it;
            Object object2;
            int index = i;
            ConeTypeProjection it2 = object[i];
            ConeTypeProjection coneTypeProjection = it2;
            if (coneTypeProjection instanceof ConeClassLikeType) {
                object2 = this.findVisibilityExposure(context2, (ConeKotlinType)it2, base, ignoreInternalExposure, visitedTypes);
                if (object2 == null) continue;
                it = object2;
                boolean bl = false;
                return it;
            }
            if (coneTypeProjection instanceof ConeKotlinTypeProjection) {
                object2 = this.findVisibilityExposure(context2, ((ConeKotlinTypeProjection)it2).getType(), base, ignoreInternalExposure, visitedTypes);
                if (object2 == null) continue;
                it = object2;
                boolean bl = false;
                return it;
            }
            if (coneTypeProjection instanceof ConeStarProjection) {
                Object object3;
                block22: {
                    Object object4;
                    List<FirResolvedTypeRef> list;
                    FirTypeParameterSymbol firTypeParameterSymbol;
                    List<FirTypeParameterSymbol> list2;
                    object2 = ToSymbolUtilsKt.toRegularClassSymbol((SessionHolder)context2, type);
                    if (object2 == null || (list2 = ((FirClassLikeSymbol)object2).getTypeParameterSymbols()) == null || (firTypeParameterSymbol = (FirTypeParameterSymbol)CollectionsKt.getOrNull(list2, (int)index)) == null || (list = firTypeParameterSymbol.getResolvedBounds()) == null) continue;
                    for (Object it3 : (Iterable)list) {
                        boolean bl = false;
                        if ((it3 = INSTANCE.findVisibilityExposure(context2, ((FirResolvedTypeRef)it3).getConeType(), base, ignoreInternalExposure, visitedTypes)) == null) continue;
                        object4 = it3;
                        break block22;
                    }
                    object4 = object3 = null;
                }
                if (object3 == null) continue;
                Object it4 = object3;
                boolean bl = false;
                return it4;
            }
            throw new NoWhenBranchMatchedException();
        }
        return null;
    }

    static /* synthetic */ SymbolWithRelation findVisibilityExposure$default(FirExposedVisibilityDeclarationChecker firExposedVisibilityDeclarationChecker, CheckerContext checkerContext, ConeKotlinType coneKotlinType, EffectiveVisibility effectiveVisibility, boolean bl, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            set = new LinkedHashSet();
        }
        return firExposedVisibilityDeclarationChecker.findVisibilityExposure(checkerContext, coneKotlinType, effectiveVisibility, bl, set);
    }

    private final SymbolWithRelation symbolWithRelation(FirClassLikeSymbol<?> symbol, EffectiveVisibility symbolVisibility, EffectiveVisibility baseVisibility, boolean fromTypeArgument, PermissivenessForExposedVisibility permissiveness) {
        Visibility visibility = symbolVisibility.toVisibility();
        FirClassLikeSymbol<?> $this$visibility$iv = symbol;
        boolean $i$f$getVisibility = false;
        Visibility lowestVisibility = $this$visibility$iv.getRawStatus().getVisibility();
        FirClassLikeSymbol<?> lowestRepresentative = symbol;
        FirClassLikeSymbol<?> currentSymbol = ContainingClassUtilsKt.getContainingClassSymbol((FirBasedSymbol)symbol);
        while (currentSymbol != null && !Intrinsics.areEqual((Object)lowestVisibility, (Object)visibility)) {
            Visibility visibility2;
            FirClassLikeSymbol<?> $this$visibility$iv2 = currentSymbol;
            boolean $i$f$getVisibility2 = false;
            Integer compareResult = $this$visibility$iv2.getRawStatus().getVisibility().compareTo(lowestVisibility);
            if (compareResult != null && compareResult < 0) {
                lowestRepresentative = currentSymbol;
                $this$visibility$iv2 = currentSymbol;
                $i$f$getVisibility2 = false;
                visibility2 = $this$visibility$iv2.getRawStatus().getVisibility();
            } else {
                visibility2 = lowestVisibility;
            }
            lowestVisibility = visibility2;
            currentSymbol = ContainingClassUtilsKt.getContainingClassSymbol((FirBasedSymbol)currentSymbol);
        }
        RelationToType defaultRelation = fromTypeArgument ? RelationToType.ARGUMENT : RelationToType.CONSTRUCTOR;
        return new SymbolWithRelation(lowestRepresentative, symbolVisibility, lowestRepresentative != symbol ? defaultRelation.containerRelation() : defaultRelation, permissiveness, baseVisibility);
    }

    private static final KtDiagnosticFactory4<EffectiveVisibility, FirClassLikeSymbol<?>, RelationToType, EffectiveVisibility> checkParameterBounds$getDiagnosticByFeature(CheckerContext $context, FirTypeParameterRefsOwner $declaration, LanguageFeature feature) {
        boolean reportProperError = LanguageVersionUtilsKt.isEnabled($context, feature);
        return reportProperError || $declaration instanceof FirRegularClass ? FirErrors.INSTANCE.getEXPOSED_TYPE_PARAMETER_BOUND() : FirErrors.INSTANCE.getEXPOSED_TYPE_PARAMETER_BOUND_DEPRECATION_WARNING();
    }

    private static final SymbolWithRelation checkParameterBounds$findVisibilityExposure(FirResolvedTypeRef $this$checkParameterBounds_u24findVisibilityExposure, CheckerContext $context, EffectiveVisibility $visibility, boolean ignoreInternalExposure) {
        return FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(INSTANCE, $context, $this$checkParameterBounds_u24findVisibilityExposure.getConeType(), $visibility, ignoreInternalExposure, null, 8, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B3\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJQ\u0010\u0016\u001a\u00020\u00172\"\u0010\u001c\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fR\u00020\u0018R\u00020\u001aj\u0006\u0010\u0019\u001a\u00020\u0018j\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0002\u0010 J\r\u0010!\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003J\t\u0010$\u001a\u00020\tH\u00c6\u0003J\t\u0010%\u001a\u00020\u0005H\u00c6\u0003J?\u0010&\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010*\u001a\u00020+H\u00d6\u0081\u0004J\n\u0010,\u001a\u00020-H\u00d6\u0081\u0004R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker$SymbolWithRelation;", "", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "symbolVisibility", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "relation", "Lorg/jetbrains/kotlin/descriptors/RelationToType;", "permissiveness", "Lorg/jetbrains/kotlin/fir/analysis/checkers/PermissivenessForExposedVisibility;", "baseVisibility", "<init>", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;Lorg/jetbrains/kotlin/descriptors/RelationToType;Lorg/jetbrains/kotlin/fir/analysis/checkers/PermissivenessForExposedVisibility;Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;)V", "getSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "getSymbolVisibility", "()Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "getRelation", "()Lorg/jetbrains/kotlin/descriptors/RelationToType;", "getPermissiveness", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/PermissivenessForExposedVisibility;", "getBaseVisibility", "report", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "c", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "factory", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory4;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory4;Lorg/jetbrains/kotlin/KtSourceElement;)V", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "", "checkers"})
    private static final class SymbolWithRelation {
        @NotNull
        private final FirClassLikeSymbol<?> symbol;
        @NotNull
        private final EffectiveVisibility symbolVisibility;
        @NotNull
        private final RelationToType relation;
        @NotNull
        private final PermissivenessForExposedVisibility permissiveness;
        @NotNull
        private final EffectiveVisibility baseVisibility;

        public SymbolWithRelation(@NotNull FirClassLikeSymbol<?> symbol, @NotNull EffectiveVisibility symbolVisibility, @NotNull RelationToType relation, @NotNull PermissivenessForExposedVisibility permissiveness, @NotNull EffectiveVisibility baseVisibility) {
            Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
            Intrinsics.checkNotNullParameter((Object)symbolVisibility, (String)"symbolVisibility");
            Intrinsics.checkNotNullParameter((Object)((Object)relation), (String)"relation");
            Intrinsics.checkNotNullParameter((Object)((Object)permissiveness), (String)"permissiveness");
            Intrinsics.checkNotNullParameter((Object)baseVisibility, (String)"baseVisibility");
            this.symbol = symbol;
            this.symbolVisibility = symbolVisibility;
            this.relation = relation;
            this.permissiveness = permissiveness;
            this.baseVisibility = baseVisibility;
        }

        @NotNull
        public final FirClassLikeSymbol<?> getSymbol() {
            return this.symbol;
        }

        @NotNull
        public final EffectiveVisibility getSymbolVisibility() {
            return this.symbolVisibility;
        }

        @NotNull
        public final RelationToType getRelation() {
            return this.relation;
        }

        @NotNull
        public final PermissivenessForExposedVisibility getPermissiveness() {
            return this.permissiveness;
        }

        @NotNull
        public final EffectiveVisibility getBaseVisibility() {
            return this.baseVisibility;
        }

        public final void report(@NotNull CheckerContext c, @NotNull DiagnosticReporter reporter, @NotNull KtDiagnosticFactory4<EffectiveVisibility, FirClassLikeSymbol<?>, RelationToType, EffectiveVisibility> factory, @Nullable KtSourceElement source) {
            boolean isPackagePrivateFromInternal;
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter(factory, (String)"factory");
            boolean bl = isPackagePrivateFromInternal = this.permissiveness == PermissivenessForExposedVisibility.PACKAGE_PRIVATE_FROM_INTERNAL;
            if (isPackagePrivateFromInternal && LanguageVersionUtilsKt.isDisabled(c, LanguageFeature.ForbidExposingPackagePrivateInInternal)) {
                return;
            }
            KtDiagnosticReportHelpersKt.reportOn((DiagnosticContext)c, reporter, (AbstractKtSourceElement)source, isPackagePrivateFromInternal ? FirErrors.INSTANCE.getEXPOSED_PACKAGE_PRIVATE_TYPE_FROM_INTERNAL_WARNING() : factory, this.baseVisibility, this.symbol, this.relation, this.symbolVisibility, factory.getDefaultPositioningStrategy());
        }

        @NotNull
        public final FirClassLikeSymbol<?> component1() {
            return this.symbol;
        }

        @NotNull
        public final EffectiveVisibility component2() {
            return this.symbolVisibility;
        }

        @NotNull
        public final RelationToType component3() {
            return this.relation;
        }

        @NotNull
        public final PermissivenessForExposedVisibility component4() {
            return this.permissiveness;
        }

        @NotNull
        public final EffectiveVisibility component5() {
            return this.baseVisibility;
        }

        @NotNull
        public final SymbolWithRelation copy(@NotNull FirClassLikeSymbol<?> symbol, @NotNull EffectiveVisibility symbolVisibility, @NotNull RelationToType relation, @NotNull PermissivenessForExposedVisibility permissiveness, @NotNull EffectiveVisibility baseVisibility) {
            Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
            Intrinsics.checkNotNullParameter((Object)symbolVisibility, (String)"symbolVisibility");
            Intrinsics.checkNotNullParameter((Object)((Object)relation), (String)"relation");
            Intrinsics.checkNotNullParameter((Object)((Object)permissiveness), (String)"permissiveness");
            Intrinsics.checkNotNullParameter((Object)baseVisibility, (String)"baseVisibility");
            return new SymbolWithRelation(symbol, symbolVisibility, relation, permissiveness, baseVisibility);
        }

        public static /* synthetic */ SymbolWithRelation copy$default(SymbolWithRelation symbolWithRelation, FirClassLikeSymbol firClassLikeSymbol, EffectiveVisibility effectiveVisibility, RelationToType relationToType, PermissivenessForExposedVisibility permissivenessForExposedVisibility, EffectiveVisibility effectiveVisibility2, int n, Object object) {
            if ((n & 1) != 0) {
                firClassLikeSymbol = symbolWithRelation.symbol;
            }
            if ((n & 2) != 0) {
                effectiveVisibility = symbolWithRelation.symbolVisibility;
            }
            if ((n & 4) != 0) {
                relationToType = symbolWithRelation.relation;
            }
            if ((n & 8) != 0) {
                permissivenessForExposedVisibility = symbolWithRelation.permissiveness;
            }
            if ((n & 0x10) != 0) {
                effectiveVisibility2 = symbolWithRelation.baseVisibility;
            }
            return symbolWithRelation.copy(firClassLikeSymbol, effectiveVisibility, relationToType, permissivenessForExposedVisibility, effectiveVisibility2);
        }

        @NotNull
        public String toString() {
            return "SymbolWithRelation(symbol=" + this.symbol + ", symbolVisibility=" + this.symbolVisibility + ", relation=" + (Object)((Object)this.relation) + ", permissiveness=" + (Object)((Object)this.permissiveness) + ", baseVisibility=" + this.baseVisibility + ')';
        }

        public int hashCode() {
            int result2 = this.symbol.hashCode();
            result2 = result2 * 31 + this.symbolVisibility.hashCode();
            result2 = result2 * 31 + this.relation.hashCode();
            result2 = result2 * 31 + this.permissiveness.hashCode();
            result2 = result2 * 31 + this.baseVisibility.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SymbolWithRelation)) {
                return false;
            }
            SymbolWithRelation symbolWithRelation = (SymbolWithRelation)other;
            if (!Intrinsics.areEqual(this.symbol, symbolWithRelation.symbol)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.symbolVisibility, (Object)symbolWithRelation.symbolVisibility)) {
                return false;
            }
            if (this.relation != symbolWithRelation.relation) {
                return false;
            }
            if (this.permissiveness != symbolWithRelation.permissiveness) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.baseVisibility, (Object)symbolWithRelation.baseVisibility);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PermissivenessForExposedVisibility.values().length];
            try {
                nArray[PermissivenessForExposedVisibility.LESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissivenessForExposedVisibility.UNKNOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissivenessForExposedVisibility.PACKAGE_PRIVATE_FROM_INTERNAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissivenessForExposedVisibility.SAME.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissivenessForExposedVisibility.MORE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

