/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.CustomAnnotationTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ5\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0012J7\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0010\u001a\u0004\u0018\u00010\u0015H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImplicitReturnTypeAnnotationMissingDependencyChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCallableDeclarationChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;)V", "returnTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/types/FirTypeRef;Lorg/jetbrains/kotlin/KtSourceElement;)V", "it", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "Lorg/jetbrains/kotlin/AbstractKtSourceElement;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;Lorg/jetbrains/kotlin/AbstractKtSourceElement;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirImplicitReturnTypeAnnotationMissingDependencyChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirImplicitReturnTypeAnnotationMissingDependencyChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImplicitReturnTypeAnnotationMissingDependencyChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n1915#2,2:53\n1915#2,2:55\n*S KotlinDebug\n*F\n+ 1 FirImplicitReturnTypeAnnotationMissingDependencyChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImplicitReturnTypeAnnotationMissingDependencyChecker\n*L\n36#1:53,2\n40#1:55,2\n*E\n"})
public final class FirImplicitReturnTypeAnnotationMissingDependencyChecker
extends FirDeclarationChecker<FirCallableDeclaration> {
    @NotNull
    public static final FirImplicitReturnTypeAnnotationMissingDependencyChecker INSTANCE = new FirImplicitReturnTypeAnnotationMissingDependencyChecker();

    private FirImplicitReturnTypeAnnotationMissingDependencyChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirCallableDeclaration declaration) {
        KtSourceElement source;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (DeclarationUtilsKt.isLocalDeclaredInBlock(declaration)) {
            return;
        }
        FirTypeRef returnTypeRef = declaration.getReturnTypeRef();
        KtSourceElement ktSourceElement = source = returnTypeRef.getSource();
        if (!Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.ImplicitTypeRef.INSTANCE)) {
            return;
        }
        this.check(context2, reporter, returnTypeRef, source);
    }

    public final void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirTypeRef returnTypeRef, @Nullable KtSourceElement source) {
        FirAnnotation it;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)returnTypeRef, (String)"returnTypeRef");
        Iterable $this$forEach$iv = returnTypeRef.getAnnotations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (FirAnnotation)element$iv;
            boolean bl = false;
            INSTANCE.check(context2, reporter, it, (AbstractKtSourceElement)source);
        }
        $this$forEach$iv = CustomAnnotationTypeAttributeKt.getTypeAnnotations(FirTypeUtilsKt.getConeType(returnTypeRef));
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (FirAnnotation)element$iv;
            boolean bl = false;
            INSTANCE.check(context2, reporter, it, (AbstractKtSourceElement)source);
        }
    }

    private final void check(CheckerContext context2, DiagnosticReporter reporter, FirAnnotation it, AbstractKtSourceElement source) {
        ConeKotlinType coneType = FirTypeUtilsKt.getConeType(it.getAnnotationTypeRef());
        if (ToSymbolUtilsKt.toSymbol((SessionHolder)context2, coneType) == null) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, source, FirErrors.INSTANCE.getMISSING_DEPENDENCY_IN_INFERRED_TYPE_ANNOTATION(), (Object)coneType, null, 16, null);
        }
    }
}

