/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJA\u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00022\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmExternalDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "checkInternal", "reportSource", "Lorg/jetbrains/kotlin/KtSourceElement;", "modality", "Lorg/jetbrains/kotlin/descriptors/Modality;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/descriptors/Modality;)V", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmExternalDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmExternalDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmExternalDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n*L\n1#1,85:1\n12#2:86\n53#2:87\n12#2:90\n41#2:91\n88#3:88\n34#4:89\n*S KotlinDebug\n*F\n+ 1 FirJvmExternalDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmExternalDeclarationChecker\n*L\n45#1:86\n49#1:87\n71#1:90\n80#1:91\n69#1:88\n69#1:89\n*E\n"})
public final class FirJvmExternalDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJvmExternalDeclarationChecker INSTANCE = new FirJvmExternalDeclarationChecker();

    private FirJvmExternalDeclarationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration instanceof FirPropertyAccessor) {
            return;
        }
        this.checkInternal(context2, reporter, declaration, null, null);
    }

    private final void checkInternal(CheckerContext context2, DiagnosticReporter reporter, FirDeclaration declaration, KtSourceElement reportSource, Modality modality) {
        FirRegularClassSymbol containingClassSymbol;
        Object externalModifier;
        FirMemberDeclaration it;
        if (!(declaration instanceof FirMemberDeclaration)) {
            return;
        }
        if (declaration instanceof FirProperty) {
            FirPropertyAccessor firPropertyAccessor = ((FirProperty)declaration).getGetter();
            if (firPropertyAccessor != null) {
                it = firPropertyAccessor;
                boolean bl = false;
                FirMemberDeclaration $this$modality$iv = (FirMemberDeclaration)declaration;
                boolean $i$f$getModality = false;
                INSTANCE.checkInternal(context2, reporter, it, ((FirProperty)declaration).getSource(), $this$modality$iv.getStatus().getModality());
            }
        }
        FirMemberDeclaration $this$isExternal$iv = (FirMemberDeclaration)declaration;
        boolean $i$f$isExternal = false;
        if (!$this$isExternal$iv.getStatus().isExternal()) {
            return;
        }
        KtSourceElement ktSourceElement = ((FirMemberDeclaration)declaration).getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source = ktSourceElement;
        if (source.getKind() instanceof KtFakeSourceElementKind) {
            return;
        }
        if (!(declaration instanceof FirFunction)) {
            it = (FirMemberDeclaration)declaration;
            String target = it instanceof FirProperty ? "property" : (it instanceof FirRegularClass ? "class" : "non-function declaration");
            FirElement firElement = declaration;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.EXTERNAL_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"EXTERNAL_KEYWORD");
            Object object = externalModifier = FirKeywordUtilsKt.getModifier(firElement, ktModifierKeywordToken);
            if (object != null) {
                Object it2 = object;
                boolean bl = false;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirModifier)it2).getSource(), FirErrors.INSTANCE.getWRONG_MODIFIER_TARGET(), (Object)((FirModifier)it2).getToken(), (Object)target, null, 32, null);
            }
            return;
        }
        externalModifier = ClassMembersKt.containingClassLookupTag(((FirFunction)declaration).getSymbol());
        FirRegularClassSymbol firRegularClassSymbol = containingClassSymbol = externalModifier != null ? ToSymbolUtilsKt.toRegularClassSymbol((SessionHolder)context2, (ConeClassLikeLookupTag)externalModifier) : null;
        if (containingClassSymbol != null) {
            FirClassSymbol $this$isInterface$iv = containingClassSymbol;
            boolean $i$f$isInterface = false;
            ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
            boolean $i$f$isInterface2 = false;
            boolean bl = $this$isInterface$iv$iv == ClassKind.INTERFACE;
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirFunction)declaration).getSource(), FirJvmErrors.INSTANCE.getEXTERNAL_DECLARATION_IN_INTERFACE(), null, 8, null);
            } else {
                Modality modality2 = modality;
                if (modality2 == null) {
                    FirMemberDeclaration $this$modality$iv = (FirMemberDeclaration)declaration;
                    boolean $i$f$getModality = false;
                    modality2 = $this$modality$iv.getStatus().getModality();
                }
                if (modality2 == Modality.ABSTRACT) {
                    DiagnosticContext diagnosticContext2 = context2;
                    KtSourceElement ktSourceElement2 = reportSource;
                    if (ktSourceElement2 == null) {
                        ktSourceElement2 = ((FirFunction)declaration).getSource();
                    }
                    KtDiagnosticReportHelpersKt.reportOn$default(diagnosticContext2, reporter, (AbstractKtSourceElement)ktSourceElement2, FirJvmErrors.INSTANCE.getEXTERNAL_DECLARATION_CANNOT_BE_ABSTRACT(), null, 8, null);
                }
            }
        }
        if (!(declaration instanceof FirConstructor) && ((FirFunction)declaration).getBody() != null) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirFunction)declaration).getSource(), FirJvmErrors.INSTANCE.getEXTERNAL_DECLARATION_CANNOT_HAVE_BODY(), null, 8, null);
        }
        FirMemberDeclaration $this$isInline$iv = (FirMemberDeclaration)declaration;
        boolean $i$f$isInline = false;
        if ($this$isInline$iv.getStatus().isInline()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirFunction)declaration).getSource(), FirJvmErrors.INSTANCE.getEXTERNAL_DECLARATION_CANNOT_BE_INLINED(), null, 8, null);
        }
    }
}

