/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.java.FirJvmTargetProvider;
import org.jetbrains.kotlin.fir.java.FirJvmTargetProviderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.JvmStandardClassIds;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000fH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmRecordChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;)V", "areRecordsAllowed", "", "Lorg/jetbrains/kotlin/config/JvmTarget;", "enableJvmPreview", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmRecordChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmRecordChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmRecordChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 FirDeclarationUtil.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirDeclarationUtilKt\n*L\n1#1,118:1\n36#2:119\n18#2,2:120\n66#2:122\n77#2:124\n37#3:123\n1915#4,2:125\n1915#4:127\n1916#4:129\n50#5:128\n*S KotlinDebug\n*F\n+ 1 FirJvmRecordChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmRecordChecker\n*L\n59#1:119\n64#1:120,2\n69#1:122\n74#1:124\n69#1:123\n84#1:125,2\n92#1:127\n92#1:129\n100#1:128\n*E\n"})
public final class FirJvmRecordChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirJvmRecordChecker INSTANCE = new FirJvmRecordChecker();

    private FirJvmRecordChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirRegularClass declaration) {
        block17: {
            Modality modality$iv;
            JvmTarget currentJvmTarget;
            Object object;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            FirTypeRef firTypeRef = (FirTypeRef)CollectionsKt.firstOrNull(declaration.getSuperTypeRefs());
            if (firTypeRef != null) {
                FirTypeRef typeRef = firTypeRef;
                boolean bl = false;
                KtSourceElement ktSourceElement = typeRef.getSource();
                if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.RecordSuperTypeRef) && Intrinsics.areEqual((Object)FirHelpersKt.fullyExpandedClassId(FirTypeUtilsKt.getConeType(typeRef), context2.getSession()), (Object)JvmStandardClassIds.Java.INSTANCE.getRecord())) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)typeRef.getSource(), FirJvmErrors.INSTANCE.getILLEGAL_JAVA_LANG_RECORD_SUPERTYPE(), null, 8, null);
                    return;
                }
            }
            if ((object = FirAnnotationUtilsKt.getAnnotationByClassId(declaration, JvmStandardClassIds.JVM_RECORD_ANNOTATION_CLASS_ID, context2.getSession())) == null || (object = ((FirAnnotation)object).getSource()) == null) {
                return;
            }
            Object annotationSource = object;
            FirJvmTargetProvider firJvmTargetProvider = FirJvmTargetProviderKt.getJvmTargetProvider(context2.getSession());
            JvmTarget jvmTarget = currentJvmTarget = firJvmTargetProvider != null ? firJvmTargetProvider.getJvmTarget() : null;
            boolean bl = jvmTarget != null ? !this.areRecordsAllowed(jvmTarget, context2.getLanguageVersionSettings().getFlag(JvmAnalysisFlags.getEnableJvmPreview())) : false;
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration.getSource(), FirJvmErrors.INSTANCE.getJVM_RECORDS_ILLEGAL_BYTECODE_TARGET(), null, 8, null);
                return;
            }
            if (declaration.isLocal()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotationSource, FirJvmErrors.INSTANCE.getLOCAL_JVM_RECORD(), null, 8, null);
                return;
            }
            FirMemberDeclaration $this$isInner$iv = declaration;
            boolean $i$f$isInner = false;
            if ($this$isInner$iv.getStatus().isInner()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration.getSource(), FirJvmErrors.INSTANCE.getINNER_JVM_RECORD(), null, 8, null);
                return;
            }
            FirMemberDeclaration $this$isFinal$iv = declaration;
            boolean $i$f$isFinal = false;
            Modality modality = $this$isFinal$iv.getStatus().getModality();
            if (!(modality == null ? true : (modality$iv = modality) == Modality.FINAL)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration.getSource(), FirJvmErrors.INSTANCE.getNON_FINAL_JVM_RECORD(), null, 8, null);
                return;
            }
            FirClass $this$isEnumClass$iv = declaration;
            boolean $i$f$isEnumClass = false;
            ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
            boolean $i$f$isEnumClass2 = false;
            boolean bl2 = $this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS;
            if (bl2) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration.getSource(), FirJvmErrors.INSTANCE.getENUM_JVM_RECORD(), null, 8, null);
                return;
            }
            FirRegularClass $this$isData$iv = declaration;
            boolean $i$f$isData = false;
            if (!$this$isData$iv.getStatus().isData()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotationSource, FirJvmErrors.INSTANCE.getNON_DATA_CLASS_JVM_RECORD(), null, 8, null);
                return;
            }
            Object object2 = DeclarationUtilsKt.primaryConstructorIfAny(declaration, context2.getSession());
            if (object2 != null && (object2 = ((FirFunctionSymbol)object2).getValueParameterSymbols()) != null) {
                Object params = object2;
                boolean bl3 = false;
                if (params.isEmpty()) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotationSource, FirJvmErrors.INSTANCE.getJVM_RECORD_WITHOUT_PRIMARY_CONSTRUCTOR_PARAMETERS(), null, 8, null);
                    return;
                }
                Iterable $this$forEach$iv = CollectionsKt.dropLast((List)params, (int)1);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FirValueParameterSymbol param = (FirValueParameterSymbol)element$iv;
                    boolean bl4 = false;
                    if (!param.isVararg()) continue;
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)param.getSource(), FirJvmErrors.INSTANCE.getJVM_RECORD_NOT_LAST_VARARG_PARAMETER(), null, 8, null);
                }
            }
            Iterable $this$forEach$iv = declaration.getDeclarations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirDeclaration decl = (FirDeclaration)element$iv;
                boolean bl5 = false;
                if (decl instanceof FirProperty) {
                    KtSourceElement ktSourceElement = ((FirProperty)decl).getSource();
                    boolean fromConstructor = Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE);
                    if (((FirProperty)decl).isVar() && fromConstructor) {
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirProperty)decl).getSource(), FirJvmErrors.INSTANCE.getJVM_RECORD_NOT_VAL_PARAMETER(), null, 8, null);
                        continue;
                    }
                    if (fromConstructor || !DeclarationAttributesKt.getHasBackingField((FirProperty)decl) && ((FirProperty)decl).getDelegateFieldSymbol() == null) continue;
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirProperty)decl).getSource(), FirJvmErrors.INSTANCE.getFIELD_IN_JVM_RECORD(), null, 8, null);
                    continue;
                }
                if (!(decl instanceof FirField)) continue;
                FirDeclaration $this$isSynthetic$iv = decl;
                boolean $i$f$isSynthetic = false;
                if (!($this$isSynthetic$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic)) continue;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirField)decl).getSource(), FirJvmErrors.INSTANCE.getDELEGATION_BY_IN_JVM_RECORD(), null, 8, null);
            }
            FirTypeRef firTypeRef2 = (FirTypeRef)CollectionsKt.firstOrNull(declaration.getSuperTypeRefs());
            if (firTypeRef2 == null) break block17;
            FirTypeRef typeRef = firTypeRef2;
            boolean bl6 = false;
            KtSourceElement ktSourceElement = typeRef.getSource();
            if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtRealSourceElementKind.INSTANCE)) {
                FirRegularClassSymbol firRegularClassSymbol = TypeUtilsKt.toRegularClassSymbol(typeRef, context2.getSession());
                if ((firRegularClassSymbol != null ? firRegularClassSymbol.getClassKind() : null) == ClassKind.CLASS) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration.getSource(), FirJvmErrors.INSTANCE.getJVM_RECORD_EXTENDS_CLASS(), (Object)FirTypeUtilsKt.getConeType(typeRef), null, 16, null);
                }
            }
        }
    }

    private final boolean areRecordsAllowed(JvmTarget $this$areRecordsAllowed, boolean enableJvmPreview) {
        if ($this$areRecordsAllowed.getMajorVersion() < JvmTarget.JVM_15.getMajorVersion()) {
            return false;
        }
        return enableJvmPreview || $this$areRecordsAllowed.getMajorVersion() > JvmTarget.JVM_15.getMajorVersion();
    }
}

