/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.renderer;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.renderer.ConeAttributeRenderer;
import org.jetbrains.kotlin.fir.renderer.ConeIdRenderer;
import org.jetbrains.kotlin.fir.renderer.ConeTypeRenderer;
import org.jetbrains.kotlin.fir.renderer.ConeTypeRendererForDebugInfo;
import org.jetbrains.kotlin.fir.types.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeRigidType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B/\u0012\u0018\b\u0002\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nB=\b\u0016\u0012\n\u0010\u000b\u001a\u00060\fj\u0002`\r\u0012\u0018\b\u0002\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0000H\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u0018\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0005H\u0014J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020 H\u0014J \u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u0005H\u0016R\u001e\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/fir/renderer/ConeTypeRendererForReadability;", "Lorg/jetbrains/kotlin/fir/renderer/ConeTypeRendererForDebugInfo;", "preRenderedConstructors", "", "Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;", "", "idRendererCreator", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/fir/renderer/ConeIdRenderer;", "<init>", "(Ljava/util/Map;Lkotlin/jvm/functions/Function0;)V", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "(Ljava/lang/StringBuilder;Ljava/util/Map;Lkotlin/jvm/functions/Function0;)V", "render", "", "flexibleType", "Lorg/jetbrains/kotlin/fir/types/ConeFlexibleType;", "renderBound", "bound", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "newRenderer", "renderFlexibleTypeCompact", "lowerRendered", "upperRendered", "renderSimpleType", "type", "Lorg/jetbrains/kotlin/fir/types/ConeSimpleKotlinType;", "nullabilityMarker", "renderTypeArgument", "typeArgument", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "couldBenefitFromParenthesizing", "", "projection", "renderDiagnostic", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "prefix", "suffix", "cones"})
@SourceDebugExtension(value={"SMAP\nConeTypeRendererForReadability.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConeTypeRendererForReadability.kt\norg/jetbrains/kotlin/fir/renderer/ConeTypeRendererForReadability\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n11693#2:112\n12040#2,3:113\n37#3,2:116\n1#4:118\n*S KotlinDebug\n*F\n+ 1 ConeTypeRendererForReadability.kt\norg/jetbrains/kotlin/fir/renderer/ConeTypeRendererForReadability\n*L\n83#1:112\n83#1:113,3\n83#1:116,2\n*E\n"})
public class ConeTypeRendererForReadability
extends ConeTypeRendererForDebugInfo {
    @Nullable
    private final Map<TypeConstructorMarker, String> preRenderedConstructors;
    @NotNull
    private final Function0<ConeIdRenderer> idRendererCreator;

    public ConeTypeRendererForReadability(@Nullable Map<TypeConstructorMarker, String> preRenderedConstructors, @NotNull Function0<? extends ConeIdRenderer> idRendererCreator) {
        Intrinsics.checkNotNullParameter(idRendererCreator, (String)"idRendererCreator");
        super(false, ConeAttributeRenderer.None.INSTANCE, 1, null);
        this.preRenderedConstructors = preRenderedConstructors;
        this.idRendererCreator = idRendererCreator;
    }

    public /* synthetic */ ConeTypeRendererForReadability(Map map, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = null;
        }
        this(map, (Function0<? extends ConeIdRenderer>)function0);
    }

    public ConeTypeRendererForReadability(@NotNull StringBuilder builder2, @Nullable Map<TypeConstructorMarker, String> preRenderedConstructors, @NotNull Function0<? extends ConeIdRenderer> idRendererCreator) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter(idRendererCreator, (String)"idRendererCreator");
        this(preRenderedConstructors, idRendererCreator);
        this.setBuilder(builder2);
        this.setIdRenderer((ConeIdRenderer)idRendererCreator.invoke());
        this.getIdRenderer().setBuilder(builder2);
    }

    public /* synthetic */ ConeTypeRendererForReadability(StringBuilder stringBuilder, Map map, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = null;
        }
        this(stringBuilder, map, (Function0<? extends ConeIdRenderer>)function0);
    }

    @Override
    protected void render(@NotNull ConeFlexibleType flexibleType) {
        Intrinsics.checkNotNullParameter((Object)flexibleType, (String)"flexibleType");
        ConeRigidType lower2 = flexibleType.getLowerBound();
        String lowerRendered = this.renderBound(lower2);
        String upperRendered = this.renderBound(flexibleType.getUpperBound());
        String string = this.renderFlexibleTypeCompact(lowerRendered, upperRendered);
        if (string == null) {
            ConeTypeRendererForReadability $this$render_u24lambda_u240 = this;
            boolean bl = false;
            String string2 = lower2 instanceof ConeDefinitelyNotNullType ? $this$render_u24lambda_u240.renderFlexibleTypeCompact($this$render_u24lambda_u240.renderBound(((ConeDefinitelyNotNullType)lower2).getOriginal()), upperRendered) : null;
            string = string2;
            if (string2 == null) {
                string = '(' + lowerRendered + ".." + upperRendered + ')';
            }
        }
        String rendered = string;
        this.getBuilder().append(rendered);
    }

    private final String renderBound(ConeKotlinType bound) {
        ConeTypeRendererForReadability $this$renderBound_u24lambda_u240 = this.newRenderer();
        boolean bl = false;
        ConeTypeRenderer.render$default($this$renderBound_u24lambda_u240, bound, null, 2, null);
        String string = $this$renderBound_u24lambda_u240.getBuilder().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"with(...)");
        return string;
    }

    private final ConeTypeRendererForReadability newRenderer() {
        return new ConeTypeRendererForReadability(new StringBuilder(), this.preRenderedConstructors, this.idRendererCreator);
    }

    private final String renderFlexibleTypeCompact(String lowerRendered, String upperRendered) {
        if (Intrinsics.areEqual((Object)lowerRendered, (Object)StringsKt.replace$default((String)upperRendered, (String)"?", (String)"", (boolean)false, (int)4, null))) {
            return StringsKt.replace$default((String)upperRendered, (String)"?", (String)"!", (boolean)false, (int)4, null);
        }
        if (StringsKt.endsWith$default((String)upperRendered, (String)"?", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)(lowerRendered + '?'), (Object)upperRendered)) {
            return lowerRendered + '!';
        }
        if (Intrinsics.areEqual((Object)('(' + lowerRendered + ")?"), (Object)upperRendered)) {
            return '(' + lowerRendered + ")!";
        }
        return RenderingUtilsKt.renderFlexibleMutabilityOrArrayElementVarianceType$default(lowerRendered, upperRendered, () -> ConeTypeRendererForReadability.renderFlexibleTypeCompact$lambda$0(lowerRendered), () -> ConeTypeRendererForReadability.renderFlexibleTypeCompact$lambda$1(lowerRendered), null, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void renderSimpleType(@NotNull ConeSimpleKotlinType type, @NotNull String nullabilityMarker) {
        String string;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)nullabilityMarker, (String)"nullabilityMarker");
        TypeConstructorMarker constructor = ConeTypeUtilsKt.getConstructor(type);
        Map<TypeConstructorMarker, String> map = this.preRenderedConstructors;
        if (map != null && (string = map.get(constructor)) != null) {
            void $this$toTypedArray$iv;
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            Collection $this$map$iv;
            String it = string;
            boolean bl = false;
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            ConeTypeProjection[] coneTypeProjectionArray = type.getTypeArguments();
            SpreadBuilder spreadBuilder2 = spreadBuilder;
            String string2 = it;
            boolean $i$f$map = false;
            void var13_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it2;
                void item$iv$iv;
                void var19_19 = item$iv$iv = $this$mapTo$iv$iv[i];
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(this.renderTypeArgument((ConeTypeProjection)it2));
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = collection;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            spreadBuilder2.addSpread((Object)thisCollection$iv.toArray(new String[0]));
            spreadBuilder.add((Object)nullabilityMarker);
            String formatted = MessageFormat.format(string2, spreadBuilder.toArray(new Object[spreadBuilder.size()]));
            this.getBuilder().append(formatted);
            return;
        }
        super.renderSimpleType(type, nullabilityMarker);
    }

    private final String renderTypeArgument(ConeTypeProjection typeArgument) {
        ConeTypeRendererForReadability $this$renderTypeArgument_u24lambda_u240 = this.newRenderer();
        boolean bl = false;
        $this$renderTypeArgument_u24lambda_u240.render(typeArgument);
        String string = $this$renderTypeArgument_u24lambda_u240.getBuilder().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"with(...)");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean couldBenefitFromParenthesizing(@NotNull ConeTypeProjection projection) {
        Intrinsics.checkNotNullParameter((Object)projection, (String)"projection");
        ConeKotlinType coneKotlinType = projection instanceof ConeKotlinType ? (ConeKotlinType)projection : null;
        ConeClassifierLookupTag constructor = coneKotlinType != null ? ConeTypeUtilsKt.getLookupTagIfAny(coneKotlinType) : null;
        if (constructor != null) {
            boolean bl;
            Map<TypeConstructorMarker, String> map = this.preRenderedConstructors;
            if (map != null && (map = map.get(constructor)) != null) {
                if (StringsKt.contains$default((CharSequence)((CharSequence)((Object)map)), (CharSequence)" ", (boolean)false, (int)2, null)) {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) {
                return true;
            }
        }
        boolean bl = super.couldBenefitFromParenthesizing(projection);
        return bl;
    }

    @Override
    @NotNull
    public String renderDiagnostic(@NotNull ConeDiagnostic diagnostic, @NotNull String prefix, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        return "??? (" + diagnostic.getReadableDescriptionAsTypeConstructor() + ')';
    }

    private static final String renderFlexibleTypeCompact$lambda$0(String $lowerRendered) {
        String string;
        String it = string = StandardNames.COLLECTIONS_PACKAGE_FQ_NAME.asString() + '.';
        boolean bl = false;
        String string2 = StringsKt.startsWith$default((String)$lowerRendered, (String)it, (boolean)false, (int)2, null) ? string : null;
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    private static final String renderFlexibleTypeCompact$lambda$1(String $lowerRendered) {
        String string;
        String it = string = StandardNames.BUILT_INS_PACKAGE_FQ_NAME.asString() + '.';
        boolean bl = false;
        String string2 = StringsKt.startsWith$default((String)$lowerRendered, (String)it, (boolean)false, (int)2, null) ? string : null;
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }
}

