/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirCollectionLiteral;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCallOrigin;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirArgumentListBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirFunctionCallBuilder;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.builder.FirSimpleNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.ResolutionMode;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.ConeAtomWithCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.ConeCollectionLiteralAtom;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.FirNamedReferenceWithCandidate;
import org.jetbrains.kotlin.fir.resolve.inference.FirCallCompleter;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousObjectSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a)\u0010\u0005\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u0001H\u0002R\u00020\u0007j\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000b\u001a\"\u0010\u000f\u001a\u00020\u0010*\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u0012\u0010\u0016\u001a\u00020\u0017*\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019\"$\u0010\f\u001a\u0004\u0018\u00010\u0001*\u00020\u00028Fb\u00020\u0007\u008a\u0001\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"getClassRepresentativeForCollectionLiteralResolution", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "canBeMainOperatorOfOverload", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "resolutionContext", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "outerClass", "(Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;)Z", "companionObjectIfDefinedOperatorOf", "getCompanionObjectIfDefinedOperatorOf", "(Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "runCollectionLiteralResolution", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "collectionLiteralAtom", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConeCollectionLiteralAtom;", "companion", "topLevelCandidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "runResolutionForDanglingCollectionLiteral", "", "collectionLiteral", "Lorg/jetbrains/kotlin/fir/expressions/FirCollectionLiteral;", "resolve"})
@SourceDebugExtension(value={"SMAP\nCollectionLiteralsUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollectionLiteralsUtils.kt\norg/jetbrains/kotlin/fir/resolve/CollectionLiteralsUtilsKt\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 FirFunctionCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirFunctionCallBuilderKt\n+ 6 FirSimpleNamedReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirSimpleNamedReferenceBuilderKt\n+ 7 FirArgumentListBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirArgumentListBuilderKt\n+ 8 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 9 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n30#2:139\n2792#3,3:140\n294#4:143\n66#5:144\n41#6:145\n39#7:146\n57#8:147\n1#9:148\n*S KotlinDebug\n*F\n+ 1 CollectionLiteralsUtils.kt\norg/jetbrains/kotlin/fir/resolve/CollectionLiteralsUtilsKt\n*L\n55#1:139\n55#1:140,3\n77#1:143\n90#1:144\n97#1:145\n125#1:146\n126#1:147\n*E\n"})
public final class CollectionLiteralsUtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final FirRegularClassSymbol getClassRepresentativeForCollectionLiteralResolution(ConeKotlinType $this$getClassRepresentativeForCollectionLiteralResolution, FirSession session) {
        FirRegularClassSymbol firRegularClassSymbol;
        if (!($this$getClassRepresentativeForCollectionLiteralResolution instanceof ConeLookupTagBasedType)) return null;
        FirClassifierSymbol<?> symbol = ToSymbolUtilsKt.toSymbol(((ConeLookupTagBasedType)$this$getClassRepresentativeForCollectionLiteralResolution).getLookupTag(), session);
        if (symbol instanceof FirTypeParameterSymbol) return null;
        if (symbol instanceof FirAnonymousObjectSymbol) return null;
        if (symbol == null) {
            return null;
        }
        if (symbol instanceof FirRegularClassSymbol) {
            firRegularClassSymbol = (FirRegularClassSymbol)symbol;
            return firRegularClassSymbol;
        } else {
            if (!(symbol instanceof FirTypeAliasSymbol)) throw new NoWhenBranchMatchedException();
            firRegularClassSymbol = CollectionLiteralsUtilsKt.getClassRepresentativeForCollectionLiteralResolution(TypeExpansionUtilsKt.fullyExpandedType$default((ConeSimpleKotlinType)$this$getClassRepresentativeForCollectionLiteralResolution, session, null, 2, null), session);
        }
        return firRegularClassSymbol;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean canBeMainOperatorOfOverload(ResolutionContext resolutionContext, FirCallableSymbol<?> $this$canBeMainOperatorOfOverload, FirRegularClassSymbol outerClass) {
        FirValueParameterSymbol it;
        if (!($this$canBeMainOperatorOfOverload instanceof FirNamedFunctionSymbol)) {
            return false;
        }
        FirCallableSymbol<?> $this$isOperator$iv = $this$canBeMainOperatorOfOverload;
        boolean $i$f$isOperator = false;
        if (!$this$isOperator$iv.getResolvedStatus().isOperator()) return false;
        if (!Intrinsics.areEqual((Object)((FirNamedFunctionSymbol)$this$canBeMainOperatorOfOverload).getName(), (Object)OperatorNameConventions.OF)) return false;
        Iterable $this$none$iv = ((FirNamedFunctionSymbol)$this$canBeMainOperatorOfOverload).getValueParameterSymbols();
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$none$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (FirValueParameterSymbol)element$iv;
            boolean bl = false;
        } while (!it.isVararg());
        boolean bl = false;
        if (bl) {
            return false;
        }
        ConeKotlinType returnType = resolutionContext.getReturnTypeCalculator().tryCalculateReturnType($this$canBeMainOperatorOfOverload).getConeType();
        if (returnType instanceof ConeClassLikeType && Intrinsics.areEqual((Object)TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)resolutionContext, (ConeClassLikeType)returnType).getLookupTag(), (Object)outerClass.toLookupTag())) {
            return true;
        }
        if (!(returnType instanceof ConeErrorType)) return false;
        return true;
    }

    @Nullable
    public static final FirRegularClassSymbol getCompanionObjectIfDefinedOperatorOf(@NotNull ResolutionContext resolutionContext, @NotNull ConeKotlinType $this$companionObjectIfDefinedOperatorOf) {
        FirRegularClassSymbol firRegularClassSymbol;
        Intrinsics.checkNotNullParameter((Object)resolutionContext, (String)"resolutionContext");
        Intrinsics.checkNotNullParameter((Object)$this$companionObjectIfDefinedOperatorOf, (String)"<this>");
        FirRegularClassSymbol firRegularClassSymbol2 = CollectionLiteralsUtilsKt.getClassRepresentativeForCollectionLiteralResolution($this$companionObjectIfDefinedOperatorOf, resolutionContext.getSession());
        if (firRegularClassSymbol2 == null) {
            return null;
        }
        FirRegularClassSymbol classSymbol = firRegularClassSymbol2;
        FirRegularClassSymbol firRegularClassSymbol3 = classSymbol.getResolvedCompanionObjectSymbol();
        if (firRegularClassSymbol3 == null) {
            return null;
        }
        FirRegularClassSymbol companionObjectSymbol = firRegularClassSymbol3;
        Ref.BooleanRef overloadFound = new Ref.BooleanRef();
        DeclarationUtilsKt.processAllDeclaredCallables$default(companionObjectSymbol, resolutionContext.getSession(), null, arg_0 -> CollectionLiteralsUtilsKt._get_companionObjectIfDefinedOperatorOf_$lambda$0(resolutionContext, classSymbol, overloadFound, arg_0), 2, null);
        boolean $this$ifTrue$iv = overloadFound.element;
        boolean $i$f$ifTrue = false;
        if ($this$ifTrue$iv) {
            boolean bl = false;
            firRegularClassSymbol = companionObjectSymbol;
        } else {
            firRegularClassSymbol = null;
        }
        return firRegularClassSymbol;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirFunctionCall runCollectionLiteralResolution(@NotNull ResolutionContext $this$runCollectionLiteralResolution, @NotNull ConeCollectionLiteralAtom collectionLiteralAtom, @NotNull FirRegularClassSymbol companion, @NotNull Candidate topLevelCandidate) {
        FirFunctionCall firFunctionCall;
        void $this$runCollectionLiteralResolution_u24lambda_u240_u240;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
        FirFunctionCallBuilder firFunctionCallBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$runCollectionLiteralResolution, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)collectionLiteralAtom, (String)"collectionLiteralAtom");
        Intrinsics.checkNotNullParameter((Object)companion, (String)"companion");
        Intrinsics.checkNotNullParameter((Object)topLevelCandidate, (String)"topLevelCandidate");
        FirCollectionLiteral collectionLiteral = collectionLiteralAtom.getExpression();
        BodyResolveComponents components = $this$runCollectionLiteralResolution.getBodyResolveComponents();
        boolean $i$f$buildFunctionCall = false;
        FirFunctionCallBuilder $this$runCollectionLiteralResolution_u24lambda_u240 = firFunctionCallBuilder = new FirFunctionCallBuilder();
        boolean bl = false;
        KtSourceElement ktSourceElement = collectionLiteral.getSource();
        $this$runCollectionLiteralResolution_u24lambda_u240.setExplicitReceiver(ResolveUtilsKt.toImplicitResolvedQualifierReceiver(companion, components, ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.CompanionObjectForOperatorOfCall.INSTANCE, null, 2, null) : null));
        KtSourceElement ktSourceElement2 = collectionLiteral.getSource();
        $this$runCollectionLiteralResolution_u24lambda_u240.setSource(ktSourceElement2 != null ? KtSourceElementKt.fakeElement$default(ktSourceElement2, KtFakeSourceElementKind.OperatorOfCall.INSTANCE, null, 2, null) : null);
        boolean $i$f$buildSimpleNamedReference = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        FirFunctionCallBuilder firFunctionCallBuilder2 = $this$runCollectionLiteralResolution_u24lambda_u240;
        boolean bl2 = false;
        $this$runCollectionLiteralResolution_u24lambda_u240_u240.setSource(collectionLiteral.getSource());
        $this$runCollectionLiteralResolution_u24lambda_u240_u240.setName(OperatorNameConventions.OF);
        firFunctionCallBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        $this$runCollectionLiteralResolution_u24lambda_u240.setArgumentList(collectionLiteral.getArgumentList());
        $this$runCollectionLiteralResolution_u24lambda_u240.setOrigin(FirFunctionCallOrigin.Operator);
        FirFunctionCall functionCall = firFunctionCallBuilder.build();
        FirFunctionCall selectedCall = components.getCallResolver().resolveCallAndSelectCandidate(functionCall, ResolutionMode.ContextDependent.INSTANCE, topLevelCandidate);
        FirFunctionCall completedCall = (FirFunctionCall)FirCallCompleter.completeCall$default(components.getCallCompleter(), selectedCall, ResolutionMode.ContextDependent.INSTANCE, false, 4, null);
        FirNamedReference calleeRef = completedCall.getCalleeReference();
        if (calleeRef instanceof FirNamedReferenceWithCandidate) {
            topLevelCandidate.getSystem().replaceContentWith(((FirNamedReferenceWithCandidate)calleeRef).getCandidate().getSystem().currentStorage());
            collectionLiteralAtom.setSubAtom(new ConeAtomWithCandidate(collectionLiteral, ((FirNamedReferenceWithCandidate)calleeRef).getCandidate()));
            firFunctionCall = completedCall;
        } else {
            firFunctionCall = completedCall;
        }
        return firFunctionCall;
    }

    public static final void runResolutionForDanglingCollectionLiteral(@NotNull ResolutionContext $this$runResolutionForDanglingCollectionLiteral, @NotNull FirCollectionLiteral collectionLiteral) {
        FirArgumentListBuilder firArgumentListBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$runResolutionForDanglingCollectionLiteral, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)collectionLiteral, (String)"collectionLiteral");
        FirFunctionCall fakeCall = $this$runResolutionForDanglingCollectionLiteral.getBodyResolveComponents().getSyntheticCallGenerator().generateFakeCallForDanglingCollectionLiteral(collectionLiteral, $this$runResolutionForDanglingCollectionLiteral);
        FirFunctionCall completedCall = (FirFunctionCall)FirCallCompleter.completeCall$default($this$runResolutionForDanglingCollectionLiteral.getBodyResolveComponents().getCallCompleter(), fakeCall, ResolutionMode.ContextIndependent.INSTANCE, false, 4, null);
        boolean $i$f$buildArgumentList = false;
        FirArgumentListBuilder $this$runResolutionForDanglingCollectionLiteral_u24lambda_u240 = firArgumentListBuilder = new FirArgumentListBuilder();
        boolean bl = false;
        FirCall $this$arguments$iv = completedCall;
        boolean $i$f$getArguments = false;
        for (FirExpression argument : $this$arguments$iv.getArgumentList().getArguments()) {
            if (!(argument instanceof FirVarargArgumentsExpression)) {
                boolean bl2 = false;
                String string = "Arguments should me mapped to vararg";
                throw new IllegalStateException(string.toString());
            }
            CollectionsKt.addAll((Collection)$this$runResolutionForDanglingCollectionLiteral_u24lambda_u240.getArguments(), (Iterable)((FirVarargArgumentsExpression)argument).getArguments());
        }
        FirArgumentList newArgumentList = firArgumentListBuilder.build();
        collectionLiteral.replaceArgumentList(newArgumentList);
    }

    private static final Unit _get_companionObjectIfDefinedOperatorOf_$lambda$0(ResolutionContext $resolutionContext, FirRegularClassSymbol $classSymbol, Ref.BooleanRef $overloadFound, FirCallableSymbol declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (CollectionLiteralsUtilsKt.canBeMainOperatorOfOverload($resolutionContext, declaration, $classSymbol)) {
            $overloadFound.element = true;
        }
        return Unit.INSTANCE;
    }
}

