/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.dfa.cfg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.dfa.DataFlowVariable;
import org.jetbrains.kotlin.fir.resolve.dfa.Implication;
import org.jetbrains.kotlin.fir.resolve.dfa.OperationStatement;
import org.jetbrains.kotlin.fir.resolve.dfa.PersistentFlow;
import org.jetbrains.kotlin.fir.resolve.dfa.RealVariable;
import org.jetbrains.kotlin.fir.resolve.dfa.Statement;
import org.jetbrains.kotlin.fir.resolve.dfa.SyntheticVariable;
import org.jetbrains.kotlin.fir.resolve.dfa.TypeStatement;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNodeRendererKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNodeWithSubgraphs;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphRenderOptions;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphRenderer;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.Edge;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.EnterNodeMarker;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ExitNodeMarker;
import org.jetbrains.kotlin.utils.DFS;
import org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 ,2\u00020\u0001:\u0001,B\u001b\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013J\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016J$\u0010\u0017\u001a\u00020\u000f*\u00020\n2\u0016\u0010\u0018\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a\u0012\u0004\u0012\u00020\f0\u0019H\u0002J$\u0010\u001f\u001a\u00020\u000f*\u00020\n2\u0016\u0010\u0018\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a\u0012\u0004\u0012\u00020\f0\u0019H\u0002J\u0014\u0010 \u001a\u00020\u000f*\u00020\n2\u0006\u0010!\u001a\u00020\u0011H\u0002J\f\u0010\"\u001a\u00020\u000f*\u00020\nH\u0002J\f\u0010#\u001a\u00020\u0011*\u00020$H\u0002J\f\u0010#\u001a\u00020\u0011*\u00020(H\u0002J\f\u0010#\u001a\u00020\u0011*\u00020)H\u0002J\f\u0010*\u001a\u00020\u0011*\u00020+H\u0002J\f\u0010#\u001a\u00020\u0011*\u00020\u0001H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u0011*\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\f0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphRenderer;", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "options", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphRenderOptions;", "<init>", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphRenderOptions;)V", "printer", "Lorg/jetbrains/kotlin/utils/Printer;", "nodeCounter", "", "clusterCounter", "renderCompleteGraph", "", "graphName", "", "printNodesAndEdges", "Lkotlin/Function0;", "renderPartialGraph", "controlFlowGraph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "renderNodes", "nodes", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "style", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/Edge;", "getStyle", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/Edge;)Ljava/lang/String;", "renderEdges", "enterCluster", "color", "exitCluster", "renderHtmlLike", "Lorg/jetbrains/kotlin/fir/resolve/dfa/PersistentFlow;", "firElementIndices", "", "Lorg/jetbrains/kotlin/fir/FirElement;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/DataFlowVariable;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/Statement;", "renderTypeHtmlLike", "Lorg/jetbrains/kotlin/fir/resolve/dfa/TypeStatement;", "Companion", "semantics"})
@SourceDebugExtension(value={"SMAP\nControlFlowGraphRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ControlFlowGraphRenderer.kt\norg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,285:1\n1315#2,4:286\n1512#2:298\n1538#2,3:299\n1541#2,3:309\n1068#2:312\n1586#2:313\n1661#2,3:314\n1642#2,10:317\n1915#2:327\n1916#2:329\n1652#2:330\n491#3,7:290\n383#3,7:302\n383#3,7:331\n1#4:297\n1#4:328\n*S KotlinDebug\n*F\n+ 1 ControlFlowGraphRenderer.kt\norg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphRenderer\n*L\n56#1:286,4\n125#1:298\n125#1:299,3\n125#1:309,3\n125#1:312\n126#1:313\n126#1:314,3\n135#1:317,10\n135#1:327\n135#1:329\n135#1:330\n57#1:290,7\n125#1:302,7\n217#1:331,7\n135#1:328\n*E\n"})
final class ControlFlowGraphRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ControlFlowGraphRenderOptions options;
    @NotNull
    private final Printer printer;
    private int nodeCounter;
    private int clusterCounter;
    @NotNull
    private final Map<FirElement, Integer> firElementIndices;
    @NotNull
    private static final Regex DIGIT_REGEX = new Regex("\\d");

    public ControlFlowGraphRenderer(@NotNull StringBuilder builder2, @NotNull ControlFlowGraphRenderOptions options) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options;
        this.printer = new Printer(builder2, 0, null, 6, null);
        this.firElementIndices = new LinkedHashMap();
    }

    public final void renderCompleteGraph(@NotNull String graphName, @NotNull Function0<Unit> printNodesAndEdges) {
        Intrinsics.checkNotNullParameter((Object)graphName, (String)"graphName");
        Intrinsics.checkNotNullParameter(printNodesAndEdges, (String)"printNodesAndEdges");
        String sanitizedName = StringsKt.replace$default((String)graphName, (String)".", (String)"_", (boolean)false, (int)4, null);
        if (((CharSequence)sanitizedName).length() > 0 && DIGIT_REGEX.matches((CharSequence)String.valueOf(StringsKt.first((CharSequence)sanitizedName)))) {
            sanitizedName = '_' + sanitizedName;
        }
        Object[] objectArray = new Object[]{"digraph " + sanitizedName + " {"};
        Printer printer = this.printer.println(objectArray).pushIndent();
        objectArray = new Object[]{"graph [nodesep=3]"};
        Printer printer2 = printer.println(objectArray);
        objectArray = new Object[]{"node [shape=box penwidth=2]"};
        Printer printer3 = printer2.println(objectArray);
        objectArray = new Object[]{"edge [penwidth=2]"};
        printer3.println(objectArray).println(new Object[0]);
        printNodesAndEdges.invoke();
        objectArray = new Object[]{"}"};
        this.printer.popIndent().println(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public final void renderPartialGraph(@NotNull ControlFlowGraph controlFlowGraph) {
        void $this$filterKeys$iv;
        Object object;
        boolean bl;
        ControlFlowGraphRenderer controlFlowGraphRenderer;
        void destination$iv;
        Object object2;
        Map $this$associateWithTo$iv;
        Intrinsics.checkNotNullParameter((Object)controlFlowGraph, (String)"controlFlowGraph");
        List<CFGNode> list = DFS.topologicalOrder(CollectionsKt.listOf(controlFlowGraph.getEnterNode()), ControlFlowGraphRenderer::renderPartialGraph$lambda$0);
        Intrinsics.checkNotNullExpressionValue(list, (String)"topologicalOrder(...)");
        Iterable iterable = list;
        Map map = new LinkedHashMap();
        boolean $i$f$associateWithTo = false;
        Iterator<Object> iterator2 = $this$associateWithTo$iv.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            CFGNode cFGNode = (CFGNode)t;
            object2 = t;
            controlFlowGraphRenderer = destination$iv;
            bl = false;
            int n = this.nodeCounter;
            this.nodeCounter = n + 1;
            object = n;
            controlFlowGraphRenderer.put(object2, object);
        }
        LinkedHashMap nodes = (LinkedHashMap)destination$iv;
        $this$associateWithTo$iv = nodes;
        object2 = this.printer;
        controlFlowGraphRenderer = this;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterKeys$iv.entrySet()) {
            CFGNode it = (CFGNode)entry.getKey();
            bl = false;
            if (!(it.getLevel() >= controlFlowGraph.getEnterNode().getLevel())) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        object = result$iv;
        controlFlowGraphRenderer.renderNodes((Printer)object2, (Map<CFGNode<?>, Integer>)object);
        this.renderEdges(this.printer, nodes);
        this.printer.println(new Object[0]);
    }

    private final void renderNodes(Printer $this$renderNodes, Map<CFGNode<?>, Integer> nodes) {
        String color = "red";
        for (Map.Entry<CFGNode<?>, Integer> entry : nodes.entrySet()) {
            CFGNode<?> node = entry.getKey();
            int index = ((Number)entry.getValue()).intValue();
            if (node instanceof EnterNodeMarker) {
                this.enterCluster($this$renderNodes, color);
                color = "blue";
            }
            List attributes = new ArrayList();
            String nodeName = CFGNodeRendererKt.render(node);
            String nodeHeader = this.options.getRenderLevels() ? nodeName + " [" + node.getLevel() + ']' : nodeName;
            Object[] objectArray = node;
            CFGNode<?> it = objectArray;
            boolean bl = false;
            Object object = this.options.getRenderFlow() && it.getFlowInitialized() ? objectArray : null;
            String flowInfo = object != null && (object = ((CFGNode)object).getFlow()) != null ? this.renderHtmlLike((PersistentFlow)object) : null;
            String nodeData = (String)this.options.getData().invoke(node);
            objectArray = flowInfo;
            if (!(objectArray == null || objectArray.length() == 0) || !((objectArray = (CharSequence)nodeData) == null || objectArray.length() == 0)) {
                StringBuilder stringBuilder;
                StringBuilder $this$renderNodes_u24lambda_u241 = stringBuilder = new StringBuilder();
                boolean bl2 = false;
                $this$renderNodes_u24lambda_u241.append("<TABLE BORDER=\"0\">");
                $this$renderNodes_u24lambda_u241.append("<TR><TD>").append(this.renderHtmlLike(nodeHeader)).append("</TD></TR>");
                CharSequence charSequence = flowInfo;
                if (!(charSequence == null || charSequence.length() == 0)) {
                    $this$renderNodes_u24lambda_u241.append("<TR><TD ALIGN=\"LEFT\" BALIGN=\"LEFT\">").append(flowInfo).append("</TD></TR>");
                }
                if (!((charSequence = (CharSequence)nodeData) == null || charSequence.length() == 0)) {
                    $this$renderNodes_u24lambda_u241.append("<TR><TD ALIGN=\"LEFT\" BALIGN=\"LEFT\">").append(this.renderHtmlLike(nodeData)).append("</TD></TR>");
                }
                $this$renderNodes_u24lambda_u241.append("</TABLE>");
                String label = stringBuilder.toString();
                ((Collection)attributes).add("label=< " + label + " >");
            } else {
                ((Collection)attributes).add("label=\"" + StringsKt.replace$default((String)nodeHeader, (String)"\"", (String)"", (boolean)false, (int)4, null) + '\"');
            }
            Object object2 = node.isDead() ? "gray" : (Intrinsics.areEqual(node, node.getOwner().getEnterNode()) || Intrinsics.areEqual(node, node.getOwner().getExitNode()) ? "red" : (objectArray = node.isUnion() ? "yellow" : null));
            if (objectArray != null) {
                Object[] it2 = objectArray;
                boolean bl3 = false;
                ((Collection)attributes).add("style=\"filled\"");
                ((Collection)attributes).add("fillcolor=" + (String)it2);
            }
            objectArray = new Object[]{index, CollectionsKt.joinToString$default((Iterable)attributes, (CharSequence)" ", (CharSequence)" [", (CharSequence)"];", (int)0, null, null, (int)56, null)};
            $this$renderNodes.println(objectArray);
            if (!(node instanceof ExitNodeMarker)) continue;
            this.exitCluster($this$renderNodes);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String getStyle(Edge $this$style) {
        Object object;
        String string;
        Object object2 = new String[3];
        object2[0] = !$this$style.getKind().getUsedInDfa() && !$this$style.getKind().getUsedInDeadDfa() ? "color=green" : (!$this$style.getKind().getUsedInCfa() ? "color=red" : null);
        object2[1] = $this$style.getKind().isDead() ? "style=dotted" : ($this$style.getKind().isBack() ? "style=dashed" : null);
        Object[] objectArray = object2;
        int n = 2;
        String string2 = $this$style.getLabel().getLabel();
        if (string2 != null) {
            void it;
            String string3 = string2;
            int n2 = n;
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            String string4 = "label=\"" + (String)it + '\"';
            objectArray = objectArray2;
            n = n2;
            string = string4;
        } else {
            string = null;
        }
        objectArray[n] = string;
        object2 = CollectionsKt.listOfNotNull((Object[])object2);
        if (object2.isEmpty()) {
            boolean bl = false;
            object = null;
        } else {
            object = object2;
        }
        List list = (List)object;
        return list != null ? CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)56, null) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final void renderEdges(Printer $this$renderEdges, Map<CFGNode<?>, Integer> nodes) {
        for (Map.Entry<CFGNode<?>, Integer> entry : nodes.entrySet()) {
            void $this$mapNotNullTo$iv$iv;
            Object[] objectArray;
            ControlFlowGraph it;
            Iterable group;
            Object key$iv$iv$iv;
            void $this$groupByTo$iv$iv;
            CFGNode<?> node = entry.getKey();
            int index = ((Number)entry.getValue()).intValue();
            Iterable $this$groupBy$iv = node.getFollowingNodes();
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                void $this$getOrPut$iv$iv$iv;
                CFGNode it2 = (CFGNode)element$iv$iv;
                boolean bl = false;
                String key$iv$iv = this.getStyle(node.edgeTo(it2));
                Map map = destination$iv$iv;
                key$iv$iv$iv = key$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Object $this$sortedBy$iv2 = destination$iv$iv.entrySet();
            boolean $i$f$sortedBy = false;
            for (Object $this$sortedBy$iv2 : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                    it = (Map.Entry)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
                }
            })) {
                void $this$mapTo$iv$iv;
                String style = (String)$this$sortedBy$iv2.getKey();
                group = (List)$this$sortedBy$iv2.getValue();
                Object[] $this$map$iv = (Object[])group;
                boolean $i$f$map = false;
                Object[] element$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    key$iv$iv$iv = (CFGNode)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl = false;
                    collection.add(((Number)MapsKt.getValue(nodes, (Object)it)).intValue());
                }
                List mappedGroup = CollectionsKt.sorted((Iterable)((List)destination$iv$iv2));
                $this$map$iv = new Object[]{index, " -> ", CollectionsKt.joinToString$default((Iterable)mappedGroup, (CharSequence)" ", (CharSequence)"{", (CharSequence)"}", (int)0, null, null, (int)56, null)};
                $this$renderEdges.print($this$map$iv);
                if (style != null) {
                    String it3;
                    boolean bl = false;
                    objectArray = new Object[]{' ' + it3};
                    $this$renderEdges.printWithNoIndent(objectArray);
                }
                $this$map$iv = new Object[]{";"};
                $this$renderEdges.printlnWithNoIndent($this$map$iv);
            }
            if (!(node instanceof CFGNodeWithSubgraphs)) continue;
            Iterable $this$mapNotNull$iv = ((CFGNodeWithSubgraphs)node).getSubGraphs();
            boolean $i$f$mapNotNull = false;
            group = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            objectArray = $this$forEach$iv$iv$iv.iterator();
            while (objectArray.hasNext()) {
                Integer it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = objectArray.next();
                boolean bl = false;
                it = (ControlFlowGraph)element$iv$iv;
                boolean bl3 = false;
                if (nodes.get(it.getEnterNode()) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List subNodes = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
            if (!(!((Collection)subNodes).isEmpty())) continue;
            Object[] objectArray2 = new Object[]{index, " -> ", CollectionsKt.joinToString$default((Iterable)subNodes, (CharSequence)" ", (CharSequence)"{", (CharSequence)"}", (int)0, null, null, (int)56, null)};
            $this$renderEdges.print(objectArray2);
            objectArray2 = new Object[]{" [style=dashed];"};
            $this$renderEdges.printlnWithNoIndent(objectArray2);
        }
    }

    private final void enterCluster(Printer $this$enterCluster, String color) {
        Object[] objectArray = new Object[1];
        int n = this.clusterCounter;
        this.clusterCounter = n + 1;
        objectArray[0] = "subgraph cluster_" + n + " {";
        $this$enterCluster.println(objectArray);
        $this$enterCluster.pushIndent();
        objectArray = new Object[]{"color=" + color};
        $this$enterCluster.println(objectArray);
    }

    private final void exitCluster(Printer $this$exitCluster) {
        $this$exitCluster.popIndent();
        Object[] objectArray = new Object[]{"}"};
        $this$exitCluster.println(objectArray);
    }

    private final String renderHtmlLike(PersistentFlow $this$renderHtmlLike) {
        Set<DataFlowVariable> variables2 = $this$renderHtmlLike.getAllVariablesForDebug();
        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003*\u0001\u0000\b\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0000H\u0096\u0082\u0004\u00a2\u0006\u0002\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u000e"}, d2={"org/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphRenderer$renderHtmlLike$OutputEntity", "", "name", "", "text", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getText", "compareTo", "", "other", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphRenderer$renderHtmlLike$OutputEntity;)I", "semantics"})
        public final class OutputEntity
        implements Comparable<OutputEntity> {
            private final String name;
            private final String text;

            public OutputEntity(String name2, String text) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                this.name = name2;
                this.text = text;
            }

            public final String getName() {
                return this.name;
            }

            public final String getText() {
                return this.text;
            }

            public int compareTo(OutputEntity other) {
                Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                Function1[] function1Array = new Function1[]{OutputEntity::compareTo$lambda$0, OutputEntity::compareTo$lambda$1};
                return ComparisonsKt.compareValuesBy((Object)this, (Object)other, (Function1[])function1Array);
            }

            private static final Comparable compareTo$lambda$0(OutputEntity it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (Comparable)((Object)it.name);
            }

            private static final Comparable compareTo$lambda$1(OutputEntity it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (Comparable)((Object)it.text);
            }
        }
        ArrayList<OutputEntity> variableOutputs = new ArrayList<OutputEntity>(variables2.size());
        for (DataFlowVariable variable : variables2) {
            Collection collection;
            StringBuilder stringBuilder;
            String variableName = this.renderHtmlLike(variable);
            StringBuilder $this$renderHtmlLike_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$renderHtmlLike_u24lambda_u240.append("<BR/>");
            $this$renderHtmlLike_u24lambda_u240.append("<B>").append(variableName).append("</B>");
            if (variable instanceof RealVariable) {
                StringBuilder stringBuilder2;
                RealVariable aliased = $this$renderHtmlLike.unwrapVariable((RealVariable)variable);
                if (!Intrinsics.areEqual((Object)aliased, (Object)variable)) {
                    stringBuilder2 = $this$renderHtmlLike_u24lambda_u240.append(" = ").append(this.renderHtmlLike(aliased));
                } else if ($this$renderHtmlLike.getTypeStatement(variable) != null) {
                    TypeStatement it;
                    boolean bl2 = false;
                    stringBuilder2 = $this$renderHtmlLike_u24lambda_u240.append(": ").append(this.renderTypeHtmlLike(it));
                } else {
                    stringBuilder2 = null;
                }
            } else if (variable instanceof SyntheticVariable) {
                $this$renderHtmlLike_u24lambda_u240.append(" = '").append(this.renderHtmlLike(UtilsKt.render(((SyntheticVariable)variable).getFir()))).append("'");
            }
            if ((collection = $this$renderHtmlLike.getImplications(variable)) == null) {
                collection = CollectionsKt.emptyList();
            }
            Collection implications = collection;
            ArrayList<OutputEntity> implicationOutputs = new ArrayList<OutputEntity>(implications.size());
            for (Implication implication : implications) {
                StringBuilder stringBuilder3;
                String implicationName = this.renderHtmlLike(implication.getEffect().getVariable());
                StringBuilder $this$renderHtmlLike_u24lambda_u240_u241 = stringBuilder3 = new StringBuilder();
                boolean bl3 = false;
                $this$renderHtmlLike_u24lambda_u240_u241.append("<BR/> ").append(this.renderHtmlLike((Object)implication.getCondition().getOperation()));
                $this$renderHtmlLike_u24lambda_u240_u241.append(" =&gt; ").append(this.renderHtmlLike(implication.getEffect()));
                String implicationText = stringBuilder3.toString();
                implicationOutputs.add(new OutputEntity(implicationName, implicationText));
            }
            CollectionsKt.sort((List)implicationOutputs);
            CollectionsKt.joinTo$default((Iterable)implicationOutputs, (Appendable)$this$renderHtmlLike_u24lambda_u240, (CharSequence)"", null, null, (int)0, null, ControlFlowGraphRenderer::renderHtmlLike$lambda$0$2, (int)60, null);
            $this$renderHtmlLike_u24lambda_u240.append("<BR/>");
            String variableText = stringBuilder.toString();
            variableOutputs.add(new OutputEntity(variableName, variableText));
        }
        CollectionsKt.sort((List)variableOutputs);
        return CollectionsKt.joinToString$default((Iterable)variableOutputs, (CharSequence)"", null, null, (int)0, null, ControlFlowGraphRenderer::renderHtmlLike$lambda$1, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String renderHtmlLike(DataFlowVariable $this$renderHtmlLike) {
        String string;
        DataFlowVariable dataFlowVariable = $this$renderHtmlLike;
        if (dataFlowVariable instanceof RealVariable) {
            string = this.renderHtmlLike(((RealVariable)$this$renderHtmlLike).toString());
        } else if (dataFlowVariable instanceof SyntheticVariable) {
            Object object;
            void $this$getOrPut$iv;
            StringBuilder stringBuilder = new StringBuilder().append('#');
            Map<FirElement, Integer> map = this.firElementIndices;
            FirExpression key$iv = ((SyntheticVariable)$this$renderHtmlLike).getFir();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                StringBuilder stringBuilder2 = stringBuilder;
                boolean bl = false;
                stringBuilder = stringBuilder2;
                Integer answer$iv = this.firElementIndices.size();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            string = stringBuilder.append(((Number)object).intValue()).toString();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final String renderHtmlLike(Statement $this$renderHtmlLike) {
        String string;
        Statement statement = $this$renderHtmlLike;
        if (statement instanceof OperationStatement) {
            string = this.renderHtmlLike(((OperationStatement)$this$renderHtmlLike).getVariable()) + ' ' + this.renderHtmlLike((Object)((OperationStatement)$this$renderHtmlLike).getOperation());
        } else if (statement instanceof TypeStatement) {
            string = this.renderHtmlLike(((TypeStatement)$this$renderHtmlLike).getVariable()) + ": " + this.renderTypeHtmlLike((TypeStatement)$this$renderHtmlLike);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final String renderTypeHtmlLike(TypeStatement $this$renderTypeHtmlLike) {
        return this.renderHtmlLike($this$renderTypeHtmlLike.renderType());
    }

    private final String renderHtmlLike(Object $this$renderHtmlLike) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)$this$renderHtmlLike.toString(), (String)"&", (String)"&amp;", (boolean)false, (int)4, null), (String)">", (String)"&gt;", (boolean)false, (int)4, null), (String)"<", (String)"&lt;", (boolean)false, (int)4, null), (String)"\n", (String)"<BR/>", (boolean)false, (int)4, null);
    }

    private static final Iterable renderPartialGraph$lambda$0(CFGNode it) {
        return it.getFollowingNodes();
    }

    private static final CharSequence renderHtmlLike$lambda$0$2(renderHtmlLike.OutputEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText();
    }

    private static final CharSequence renderHtmlLike$lambda$1(renderHtmlLike.OutputEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphRenderer$Companion;", "", "<init>", "()V", "EDGE", "", "RED", "BLUE", "DIGIT_REGEX", "Lkotlin/text/Regex;", "semantics"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

