/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.resolve.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.resolve.SupertypeSupplier;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSupertypesResolutionKt;
import org.jetbrains.kotlin.fir.resolve.transformers.SupertypeComputationStatus;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.LocalClassesNavigationInfo;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeRigidType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;
import org.jetbrains.kotlin.kotlinx.collections.immutable.PersistentList;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0011J0\u0010\u001a\u001a\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t2\u0006\u0010\u001b\u001a\u00020\u00062\u0016\u0010\u001c\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t0\u001dJ0\u0010\u001e\u001a\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t2\u0006\u0010\u001f\u001a\u00020\f2\u0016\u0010\u001c\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t0\u001dJ0\u0010 \u001a\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t2\u0006\u0010\u001f\u001a\u00020\f2\u0016\u0010\u001c\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t0\u001dJ0\u0010!\u001a\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t2\u0006\u0010\u001f\u001a\u00020\f2\u0016\u0010\u001c\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t0\u001dJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u0011J\u001c\u0010$\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u00112\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&J\u001e\u0010*\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u00112\f\u0010+\u001a\b\u0012\u0004\u0012\u00020'0&H\u0014J\u001e\u0010,\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010-\u001a\u00020.H\u0014J\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00020/0&2\u0006\u00100\u001a\u00020\u00112\u0006\u0010-\u001a\u00020.H\u0016JV\u00101\u001a\u00020#2\u0006\u00100\u001a\u00020\u00112\u0006\u00102\u001a\u00020.2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u0011042\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u0011042\u0016\u00106\u001a\u0012\u0012\u0004\u0012\u00020\u001107j\b\u0012\u0004\u0012\u00020\u0011`82\b\u00109\u001a\u0004\u0018\u00010:H\u0004J\u0018\u0010;\u001a\u00020#2\u0006\u00102\u001a\u00020.2\b\u00109\u001a\u0004\u0018\u00010:J\u0014\u0010<\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010\u0019\u001a\u00020\u0011J\u000e\u0010=\u001a\u00020/2\u0006\u0010>\u001a\u00020?J\u0016\u0010@\u001a\u00020/2\u0006\u0010A\u001a\u00020/2\u0006\u00102\u001a\u00020.J\u0012\u0010B\u001a\u0004\u0018\u00010C2\u0006\u0010>\u001a\u00020?H\u0002R>\u0010\u0004\u001a2\u0012\u0004\u0012\u00020\u0006\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t0\u0005j\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u000b\u001a2\u0012\u0004\u0012\u00020\f\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t0\u0005j\u0018\u0012\u0004\u0012\u00020\f\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\r\u001a2\u0012\u0004\u0012\u00020\f\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t0\u0005j\u0018\u0012\u0004\u0012\u00020\f\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u000e\u001a2\u0012\u0004\u0012\u00020\f\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t0\u0005j\u0018\u0012\u0004\u0012\u00020\f\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00110)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/SupertypeComputationSession;", "", "<init>", "()V", "fileScopesMap", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/kotlinx/collections/immutable/PersistentList;", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ScopePersistentList;", "Lkotlin/collections/HashMap;", "scopesForNestedClassesMap", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "scopesForStaticNestedClassesMap", "scopesForCompanionMap", "supertypeStatusMap", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/SupertypeComputationStatus;", "Lkotlin/collections/LinkedHashMap;", "supertypesSupplier", "Lorg/jetbrains/kotlin/fir/resolve/SupertypeSupplier;", "getSupertypesSupplier", "()Lorg/jetbrains/kotlin/fir/resolve/SupertypeSupplier;", "getSupertypesComputationStatus", "classLikeDeclaration", "getOrPutFileScope", "file", "scope", "Lkotlin/Function0;", "getOrPutScopeForNestedClasses", "klass", "getOrPutScopeForStaticNestedClasses", "getOrPutScopeForCompanion", "startComputingSupertypes", "", "storeSupertypes", "resolvedTypesRefs", "", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "newClassifiersForBreakingLoops", "", "reportLoopErrorRefs", "supertypeRefs", "getResolvedSuperTypeRefsForOutOfSessionDeclaration", "useSiteSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "declaration", "breakLoopFor", "session", "visited", "", "looped", "pathOrderedSet", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "localClassesNavigationInfo", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/LocalClassesNavigationInfo;", "breakLoops", "getResolvedSupertypeRefs", "getResolvedExpandedTypeRef", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "expandTypealiasInPlace", "typeRef", "getResolvedExpandedType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirSupertypesResolution.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSupertypesResolution.kt\norg/jetbrains/kotlin/fir/resolve/transformers/SupertypeComputationSession\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n*L\n1#1,906:1\n383#2,7:907\n383#2,7:914\n383#2,7:921\n383#2,7:928\n812#3,12:935\n975#3,7:949\n1#4:947\n29#5:948\n*S KotlinDebug\n*F\n+ 1 FirSupertypesResolution.kt\norg/jetbrains/kotlin/fir/resolve/transformers/SupertypeComputationSession\n*L\n622#1:907,7\n625#1:914,7\n628#1:921,7\n631#1:928,7\n663#1:935,12\n739#1:949,7\n890#1:948\n*E\n"})
public class SupertypeComputationSession {
    @NotNull
    private final HashMap<FirFile, PersistentList<FirScope>> fileScopesMap = new HashMap();
    @NotNull
    private final HashMap<FirClass, PersistentList<FirScope>> scopesForNestedClassesMap = new HashMap();
    @NotNull
    private final HashMap<FirClass, PersistentList<FirScope>> scopesForStaticNestedClassesMap = new HashMap();
    @NotNull
    private final HashMap<FirClass, PersistentList<FirScope>> scopesForCompanionMap = new HashMap();
    @NotNull
    private final LinkedHashMap<FirClassLikeDeclaration, SupertypeComputationStatus> supertypeStatusMap = new LinkedHashMap();
    @NotNull
    private final SupertypeSupplier supertypesSupplier = new SupertypeSupplier(this){
        final /* synthetic */ SupertypeComputationSession this$0;
        {
            this.this$0 = $receiver;
        }

        /*
         * WARNING - void declaration
         */
        public List<ConeClassLikeType> forClass(FirClass firClass, FirSession useSiteSession) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)firClass, (String)"firClass");
            Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
            SupertypeComputationStatus supertypeComputationStatus = this.this$0.getSupertypesComputationStatus(firClass);
            SupertypeComputationStatus.Computed computed = supertypeComputationStatus instanceof SupertypeComputationStatus.Computed ? (SupertypeComputationStatus.Computed)supertypeComputationStatus : null;
            List<FirResolvedTypeRef> typeRefsFromSession = computed != null ? computed.getSupertypeRefs() : null;
            List<FirResolvedTypeRef> list = typeRefsFromSession;
            if (list == null) {
                list = this.this$0.getResolvedSuperTypeRefsForOutOfSessionDeclaration(firClass, useSiteSession);
            }
            List<FirResolvedTypeRef> typeRefsToReturn = list;
            Iterable $this$mapNotNull$iv = typeRefsToReturn;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList<E>();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                ConeClassLikeType it$iv$iv;
                T element$iv$iv$iv;
                T element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                FirResolvedTypeRef it = (FirResolvedTypeRef)element$iv$iv;
                boolean bl2 = false;
                FirTypeRef $this$coneTypeSafe$iv = it;
                boolean $i$f$coneTypeSafe = false;
                FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getConeType() : null;
                if (!(coneKotlinType instanceof ConeClassLikeType)) {
                    coneKotlinType = null;
                }
                if ((ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType)) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public ConeClassLikeType expansionForTypeAlias(FirTypeAlias typeAlias, FirSession useSiteSession) {
            ConeClassLikeType coneClassLikeType;
            Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
            Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
            if (typeAlias.getExpandedTypeRef() instanceof FirResolvedTypeRef) {
                return FirDeclarationUtilKt.getExpandedConeType(typeAlias);
            }
            SupertypeComputationStatus supertypeComputationStatus = this.this$0.getSupertypesComputationStatus(typeAlias);
            SupertypeComputationStatus.Computed computed = supertypeComputationStatus instanceof SupertypeComputationStatus.Computed ? (SupertypeComputationStatus.Computed)supertypeComputationStatus : null;
            List<FirResolvedTypeRef> typeRefsFromSession = computed != null ? computed.getSupertypeRefs() : null;
            List<FirResolvedTypeRef> list = typeRefsFromSession;
            if (list == null) {
                list = this.this$0.getResolvedSuperTypeRefsForOutOfSessionDeclaration(typeAlias, useSiteSession);
            }
            List<FirResolvedTypeRef> typeRefsToReturn = list;
            FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)CollectionsKt.firstOrNull(typeRefsToReturn);
            if (firResolvedTypeRef != null) {
                FirTypeRef $this$coneTypeSafe$iv = firResolvedTypeRef;
                boolean $i$f$coneTypeSafe = false;
                FirResolvedTypeRef firResolvedTypeRef2 = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                ConeKotlinType coneKotlinType = firResolvedTypeRef2 != null ? firResolvedTypeRef2.getConeType() : null;
                if (!(coneKotlinType instanceof ConeClassLikeType)) {
                    coneKotlinType = null;
                }
                coneClassLikeType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType));
            } else {
                coneClassLikeType = null;
            }
            return coneClassLikeType;
        }
    };
    @NotNull
    private final List<FirClassLikeDeclaration> newClassifiersForBreakingLoops = new ArrayList();

    @NotNull
    public final SupertypeSupplier getSupertypesSupplier() {
        return this.supertypesSupplier;
    }

    @NotNull
    public final SupertypeComputationStatus getSupertypesComputationStatus(@NotNull FirClassLikeDeclaration classLikeDeclaration) {
        Intrinsics.checkNotNullParameter((Object)classLikeDeclaration, (String)"classLikeDeclaration");
        SupertypeComputationStatus supertypeComputationStatus = this.supertypeStatusMap.get(classLikeDeclaration);
        if (supertypeComputationStatus == null) {
            supertypeComputationStatus = SupertypeComputationStatus.NotComputed.INSTANCE;
        }
        return supertypeComputationStatus;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PersistentList<FirScope> getOrPutFileScope(@NotNull FirFile file, @NotNull Function0<? extends PersistentList<? extends FirScope>> scope2) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(scope2, (String)"scope");
        Map map = this.fileScopesMap;
        FirFile key$iv = file;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            PersistentList answer$iv = (PersistentList)scope2.invoke();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (PersistentList)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PersistentList<FirScope> getOrPutScopeForNestedClasses(@NotNull FirClass klass, @NotNull Function0<? extends PersistentList<? extends FirScope>> scope2) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter(scope2, (String)"scope");
        Map map = this.scopesForNestedClassesMap;
        FirClass key$iv = klass;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            PersistentList answer$iv = (PersistentList)scope2.invoke();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (PersistentList)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PersistentList<FirScope> getOrPutScopeForStaticNestedClasses(@NotNull FirClass klass, @NotNull Function0<? extends PersistentList<? extends FirScope>> scope2) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter(scope2, (String)"scope");
        Map map = this.scopesForStaticNestedClassesMap;
        FirClass key$iv = klass;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            PersistentList answer$iv = (PersistentList)scope2.invoke();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (PersistentList)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PersistentList<FirScope> getOrPutScopeForCompanion(@NotNull FirClass klass, @NotNull Function0<? extends PersistentList<? extends FirScope>> scope2) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter(scope2, (String)"scope");
        Map map = this.scopesForCompanionMap;
        FirClass key$iv = klass;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            PersistentList answer$iv = (PersistentList)scope2.invoke();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (PersistentList)object;
    }

    public final void startComputingSupertypes(@NotNull FirClassLikeDeclaration classLikeDeclaration) {
        Intrinsics.checkNotNullParameter((Object)classLikeDeclaration, (String)"classLikeDeclaration");
        if (!(this.supertypeStatusMap.get(classLikeDeclaration) == null)) {
            boolean bl = false;
            String string = "Unexpected in startComputingSupertypes supertype status for " + classLikeDeclaration + ": " + this.supertypeStatusMap.get(classLikeDeclaration);
            throw new IllegalArgumentException(string.toString());
        }
        ((Map)this.supertypeStatusMap).put(classLikeDeclaration, SupertypeComputationStatus.Computing.INSTANCE);
    }

    public final void storeSupertypes(@NotNull FirClassLikeDeclaration classLikeDeclaration, @NotNull List<? extends FirResolvedTypeRef> resolvedTypesRefs) {
        Intrinsics.checkNotNullParameter((Object)classLikeDeclaration, (String)"classLikeDeclaration");
        Intrinsics.checkNotNullParameter(resolvedTypesRefs, (String)"resolvedTypesRefs");
        if (!(this.supertypeStatusMap.get(classLikeDeclaration) instanceof SupertypeComputationStatus.Computing)) {
            boolean bl = false;
            String string = "Unexpected in storeSupertypes supertype status for " + classLikeDeclaration + ": " + this.supertypeStatusMap.get(classLikeDeclaration);
            throw new IllegalArgumentException(string.toString());
        }
        ((Map)this.supertypeStatusMap).put(classLikeDeclaration, new SupertypeComputationStatus.Computed(resolvedTypesRefs));
        this.newClassifiersForBreakingLoops.add(classLikeDeclaration);
    }

    protected void reportLoopErrorRefs(@NotNull FirClassLikeDeclaration classLikeDeclaration, @NotNull List<? extends FirResolvedTypeRef> supertypeRefs) {
        Intrinsics.checkNotNullParameter((Object)classLikeDeclaration, (String)"classLikeDeclaration");
        Intrinsics.checkNotNullParameter(supertypeRefs, (String)"supertypeRefs");
        ((Map)this.supertypeStatusMap).put(classLikeDeclaration, new SupertypeComputationStatus.Computed(supertypeRefs));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<FirResolvedTypeRef> getResolvedSuperTypeRefsForOutOfSessionDeclaration(@NotNull FirClassLikeDeclaration classLikeDeclaration, @NotNull FirSession useSiteSession) {
        List list;
        Intrinsics.checkNotNullParameter((Object)classLikeDeclaration, (String)"classLikeDeclaration");
        Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
        FirClassLikeDeclaration firClassLikeDeclaration = classLikeDeclaration;
        if (firClassLikeDeclaration instanceof FirClass) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = ((FirClass)classLikeDeclaration).getSuperTypeRefs();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof FirResolvedTypeRef)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else if (firClassLikeDeclaration instanceof FirTypeAlias) {
            FirTypeRef firTypeRef = ((FirTypeAlias)classLikeDeclaration).getExpandedTypeRef();
            list = CollectionsKt.listOfNotNull((Object)(firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    @NotNull
    public List<FirTypeRef> supertypeRefs(@NotNull FirClassLikeDeclaration declaration, @NotNull FirSession useSiteSession) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
        FirClassLikeDeclaration firClassLikeDeclaration = declaration;
        return firClassLikeDeclaration instanceof FirRegularClass ? ((FirRegularClass)declaration).getSuperTypeRefs() : (firClassLikeDeclaration instanceof FirTypeAlias ? CollectionsKt.listOf((Object)((FirTypeAlias)declaration).getExpandedTypeRef()) : CollectionsKt.emptyList());
    }

    protected final void breakLoopFor(@NotNull FirClassLikeDeclaration declaration, @NotNull FirSession session, @NotNull Set<FirClassLikeDeclaration> visited2, @NotNull Set<FirClassLikeDeclaration> looped, @NotNull LinkedHashSet<FirClassLikeDeclaration> pathOrderedSet, @Nullable LocalClassesNavigationInfo localClassesNavigationInfo) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(visited2, (String)"visited");
        Intrinsics.checkNotNullParameter(looped, (String)"looped");
        Intrinsics.checkNotNullParameter(pathOrderedSet, (String)"pathOrderedSet");
        if (!pathOrderedSet.isEmpty()) {
            boolean $i$a$-require-SupertypeComputationSession$breakLoopFor$32 = false;
            String $i$a$-require-SupertypeComputationSession$breakLoopFor$32 = "Path ordered set should be empty before starting";
            throw new IllegalArgumentException($i$a$-require-SupertypeComputationSession$breakLoopFor$32.toString());
        }
        SupertypeComputationSession.breakLoopFor$checkIsInLoop(this, session, visited2, pathOrderedSet, looped, localClassesNavigationInfo, declaration, false, false);
        if (!pathOrderedSet.isEmpty()) {
            boolean bl = false;
            String string = "Path ordered set should be empty after finishing";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final void breakLoops(@NotNull FirSession session, @Nullable LocalClassesNavigationInfo localClassesNavigationInfo) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Set visitedClassLikeDecls = new LinkedHashSet();
        Set loopedClassLikeDecls = new LinkedHashSet();
        LinkedHashSet<FirClassLikeDeclaration> pathOrderedSet = new LinkedHashSet<FirClassLikeDeclaration>();
        for (FirClassLikeDeclaration classifier : this.newClassifiersForBreakingLoops) {
            this.breakLoopFor(classifier, session, visitedClassLikeDecls, loopedClassLikeDecls, pathOrderedSet, localClassesNavigationInfo);
        }
        this.newClassifiersForBreakingLoops.clear();
    }

    @NotNull
    public final List<FirResolvedTypeRef> getResolvedSupertypeRefs(@NotNull FirClassLikeDeclaration classLikeDeclaration) {
        Intrinsics.checkNotNullParameter((Object)classLikeDeclaration, (String)"classLikeDeclaration");
        SupertypeComputationStatus status2 = this.getSupertypesComputationStatus(classLikeDeclaration);
        if (!(status2 instanceof SupertypeComputationStatus.Computed)) {
            boolean bl = false;
            String string = "Unexpected status at FirApplySupertypesTransformer: " + status2 + " for " + ((FirClassLikeSymbol)classLikeDeclaration.getSymbol()).getClassId();
            throw new IllegalArgumentException(string.toString());
        }
        return ((SupertypeComputationStatus.Computed)status2).getSupertypeRefs();
    }

    @NotNull
    public final FirTypeRef getResolvedExpandedTypeRef(@NotNull FirTypeAlias typeAlias) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
        List<FirResolvedTypeRef> supertypeRefs = this.getResolvedSupertypeRefs(typeAlias);
        boolean bl2 = bl = supertypeRefs.size() == 1;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Expected single supertypeRefs, but found " + supertypeRefs.size() + " in " + typeAlias.getSymbol().getClassId();
            throw new AssertionError((Object)string);
        }
        return supertypeRefs.get(0);
    }

    @NotNull
    public final FirTypeRef expandTypealiasInPlace(@NotNull FirTypeRef typeRef, @NotNull FirSession session) {
        FirTypeRef firTypeRef;
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        FirTypeRef firTypeRef2 = typeRef;
        if (firTypeRef2 instanceof FirImplicitBuiltinTypeRef || firTypeRef2 instanceof FirErrorTypeRef) {
            firTypeRef = typeRef;
        } else {
            ConeKotlinType expanded2 = TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getConeType(typeRef), session, (Function1<? super FirTypeAlias, ? extends ConeClassLikeType>)((Function1)new Function1<FirTypeAlias, ConeClassLikeType>((Object)this){

                public final ConeClassLikeType invoke(FirTypeAlias p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return SupertypeComputationSession.access$getResolvedExpandedType((SupertypeComputationSession)this.receiver, p0);
                }
            }));
            if (Intrinsics.areEqual((Object)expanded2, (Object)FirTypeUtilsKt.getConeType(typeRef))) {
                firTypeRef = typeRef;
            } else if (FirLanguageSettingsComponentKt.getLanguageVersionSettings(session).getFlag(AnalysisFlags.getExpandTypeAliasesInTypeResolution()).booleanValue()) {
                ConeKotlinType p0 = expanded2;
                boolean bl = false;
                firTypeRef = TypeUtilsKt.withReplacedConeType$default(typeRef, p0, null, 2, null);
            } else {
                firTypeRef = typeRef;
            }
        }
        return firTypeRef;
    }

    private final ConeClassLikeType getResolvedExpandedType(FirTypeAlias typeAlias) {
        FirTypeRef firTypeRef;
        FirTypeRef it = firTypeRef = typeAlias.getExpandedTypeRef();
        boolean bl = false;
        FirTypeRef firTypeRef2 = it instanceof FirResolvedTypeRef ? firTypeRef : null;
        if (firTypeRef2 == null) {
            firTypeRef2 = this.getResolvedExpandedTypeRef(typeAlias);
        }
        FirTypeRef $this$coneTypeSafe$iv = firTypeRef2;
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getConeType() : null;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        return (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType));
    }

    private static final void breakLoopFor$checkIsInLoop$checkTypeArgumentsRecursively(FirSession $session, boolean $wasSubtypingInvolved, boolean areTypeArgumentsCurrentlyInvolved, SupertypeComputationSession this$0, Set<FirClassLikeDeclaration> $visited, LinkedHashSet<FirClassLikeDeclaration> $pathOrderedSet, Set<FirClassLikeDeclaration> $looped, LocalClassesNavigationInfo $localClassesNavigationInfo, ConeKotlinType type, Set<ConeKotlinType> visitedTypes) {
        if (visitedTypes.contains(type)) {
            return;
        }
        ((Collection)visitedTypes).add(type);
        for (ConeTypeProjection typeArgument : type.getTypeArguments()) {
            ConeClassLikeType typeToCheck;
            ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType(typeArgument);
            ConeRigidType coneRigidType = coneKotlinType != null ? ConeTypeUtilsKt.lowerBoundIfFlexible(coneKotlinType) : null;
            if ((coneRigidType instanceof ConeClassLikeType ? (ConeClassLikeType)coneRigidType : null) == null) continue;
            typeToCheck = typeToCheck;
            FirClassLikeSymbol<?> firClassLikeSymbol = ToSymbolUtilsKt.toSymbol(typeToCheck.getLookupTag(), $session);
            SupertypeComputationSession.breakLoopFor$checkIsInLoop(this$0, $session, $visited, $pathOrderedSet, $looped, $localClassesNavigationInfo, firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null, $wasSubtypingInvolved, areTypeArgumentsCurrentlyInvolved);
            SupertypeComputationSession.breakLoopFor$checkIsInLoop$checkTypeArgumentsRecursively($session, $wasSubtypingInvolved, areTypeArgumentsCurrentlyInvolved, this$0, $visited, $pathOrderedSet, $looped, $localClassesNavigationInfo, typeToCheck, visitedTypes);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void breakLoopFor$checkIsInLoop(SupertypeComputationSession this$0, FirSession $session, Set<FirClassLikeDeclaration> $visited, LinkedHashSet<FirClassLikeDeclaration> $pathOrderedSet, Set<FirClassLikeDeclaration> $looped, LocalClassesNavigationInfo $localClassesNavigationInfo, FirClassLikeDeclaration classLikeDeclaration, boolean wasSubtypingInvolved, boolean wereTypeArgumentsInvolved) {
        boolean isTypeAlias;
        boolean isSubtypingCurrentlyInvolved;
        List<FirResolvedTypeRef> supertypeRefs;
        List<FirResolvedTypeRef> list;
        if (classLikeDeclaration == null) {
            return;
        }
        if (!(!wasSubtypingInvolved || !wereTypeArgumentsInvolved)) {
            boolean $i$a$-require-SupertypeComputationSession$breakLoopFor$checkIsInLoop$22 = false;
            String $i$a$-require-SupertypeComputationSession$breakLoopFor$checkIsInLoop$22 = "This must hold by induction, because otherwise such a loop is allowed";
            throw new IllegalArgumentException($i$a$-require-SupertypeComputationSession$breakLoopFor$checkIsInLoop$22.toString());
        }
        SupertypeComputationStatus supertypeStatus = this$0.supertypeStatusMap.get(classLikeDeclaration);
        if (supertypeStatus != null) {
            if (!(supertypeStatus instanceof SupertypeComputationStatus.Computed)) {
                boolean $i$a$-require-SupertypeComputationSession$breakLoopFor$checkIsInLoop$supertypeRefs$22 = false;
                String $i$a$-require-SupertypeComputationSession$breakLoopFor$checkIsInLoop$supertypeRefs$22 = "Expected computed supertypes in breakLoops for " + ((FirClassLikeSymbol)classLikeDeclaration.getSymbol()).getClassId();
                throw new IllegalArgumentException($i$a$-require-SupertypeComputationSession$breakLoopFor$checkIsInLoop$supertypeRefs$22.toString());
            }
            list = ((SupertypeComputationStatus.Computed)supertypeStatus).getSupertypeRefs();
        } else {
            list = supertypeRefs = this$0.getResolvedSuperTypeRefsForOutOfSessionDeclaration(classLikeDeclaration, $session);
        }
        if ($visited.contains(classLikeDeclaration)) {
            if ($pathOrderedSet.contains(classLikeDeclaration)) {
                void $this$takeWhile$iv;
                $looped.add(classLikeDeclaration);
                Iterable iterable = CollectionsKt.reversed((Iterable)$pathOrderedSet);
                Set<FirClassLikeDeclaration> set = $looped;
                boolean $i$f$takeWhile = false;
                ArrayList list$iv = new ArrayList();
                for (Object item$iv : $this$takeWhile$iv) {
                    FirClassLikeDeclaration element = (FirClassLikeDeclaration)item$iv;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)element, (Object)classLikeDeclaration))) break;
                    list$iv.add(item$iv);
                }
                set.addAll(list$iv);
            }
            return;
        }
        boolean declarationIsAdded = $pathOrderedSet.add(classLikeDeclaration);
        if (!declarationIsAdded) {
            boolean $i$a$-require-SupertypeComputationSession$breakLoopFor$checkIsInLoop$42 = false;
            String $i$a$-require-SupertypeComputationSession$breakLoopFor$checkIsInLoop$42 = "The considered declaration should be unique";
            throw new IllegalArgumentException($i$a$-require-SupertypeComputationSession$breakLoopFor$checkIsInLoop$42.toString());
        }
        $visited.add(classLikeDeclaration);
        ClassId classId = FirDeclarationUtilKt.getClassId(classLikeDeclaration);
        if (classId.isNestedClass()) {
            FirClassLikeDeclaration firClassLikeDeclaration;
            if (!classLikeDeclaration.isLocal()) {
                FirClassLikeSymbol<?> firClassLikeSymbol = FirProviderKt.getFirProvider($session).getContainingClass(classLikeDeclaration.getSymbol());
                firClassLikeDeclaration = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
            } else {
                LocalClassesNavigationInfo localClassesNavigationInfo = $localClassesNavigationInfo;
                if (localClassesNavigationInfo != null) {
                    firClassLikeDeclaration = localClassesNavigationInfo.getParentForClass().get(classLikeDeclaration);
                } else {
                    String string = "Couldn't retrieve the parent of a local class because there's no `LocalClassesNavigationInfo`";
                    throw new IllegalStateException(string.toString());
                }
            }
            FirClassLikeDeclaration parentFir = firClassLikeDeclaration;
            if (parentFir != null) {
                SupertypeComputationSession.breakLoopFor$checkIsInLoop(this$0, $session, $visited, $pathOrderedSet, $looped, $localClassesNavigationInfo, parentFir, wasSubtypingInvolved, wereTypeArgumentsInvolved);
            }
        }
        boolean bl = isSubtypingCurrentlyInvolved = !(isTypeAlias = classLikeDeclaration instanceof FirTypeAlias);
        if (wereTypeArgumentsInvolved && isSubtypingCurrentlyInvolved) {
            $pathOrderedSet.remove(classLikeDeclaration);
            $visited.remove(classLikeDeclaration);
            return;
        }
        boolean isSubtypingInvolved = wasSubtypingInvolved || isSubtypingCurrentlyInvolved;
        boolean isErrorInSupertypesFound = false;
        List resultSupertypeRefs = new ArrayList();
        for (FirResolvedTypeRef supertypeRef : supertypeRefs) {
            FirResolvedTypeRef firResolvedTypeRef;
            FirClassLikeDeclaration firClassLikeDeclaration;
            if (isTypeAlias) {
                for (FirAnnotation annotation : supertypeRef.getAnnotations()) {
                    ConeClassLikeType resolvedType;
                    ConeKotlinType coneKotlinType = FirTypeUtilsKt.getResolvedType(annotation);
                    if ((coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null) == null) continue;
                    resolvedType = resolvedType;
                    FirClassLikeSymbol<?> firClassLikeSymbol = ToSymbolUtilsKt.toSymbol(resolvedType.getLookupTag(), $session);
                    FirClassLikeDeclaration annotationClassLikeDeclaration = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
                    SupertypeComputationSession.breakLoopFor$checkIsInLoop(this$0, $session, $visited, $pathOrderedSet, $looped, $localClassesNavigationInfo, annotationClassLikeDeclaration, wasSubtypingInvolved, wereTypeArgumentsInvolved);
                }
            }
            if ((firClassLikeDeclaration = DeclarationUtilsKt.firClassLike(supertypeRef, $session)) == null) {
                firClassLikeDeclaration = DeclarationUtilsKt.firClassLike(supertypeRef, classLikeDeclaration.getModuleData().getSession());
            }
            FirClassLikeDeclaration supertypeFir = firClassLikeDeclaration;
            SupertypeComputationSession.breakLoopFor$checkIsInLoop(this$0, $session, $visited, $pathOrderedSet, $looped, $localClassesNavigationInfo, supertypeFir, isSubtypingInvolved, wereTypeArgumentsInvolved);
            if (!isSubtypingInvolved) {
                boolean areTypeArgumentsCurrentlyInvolved = true;
                SupertypeComputationSession.breakLoopFor$checkIsInLoop$checkTypeArgumentsRecursively($session, wasSubtypingInvolved, areTypeArgumentsCurrentlyInvolved, this$0, $visited, $pathOrderedSet, $looped, $localClassesNavigationInfo, supertypeRef.getConeType(), new LinkedHashSet());
            }
            if ($looped.contains(classLikeDeclaration) && !(supertypeRef instanceof FirImplicitBuiltinTypeRef)) {
                isErrorInSupertypesFound = true;
                firResolvedTypeRef = FirSupertypesResolutionKt.access$createErrorTypeRef(supertypeRef.getSource(), "Loop in supertypes involving " + ((FirClassLikeSymbol)classLikeDeclaration.getSymbol()).getClassId(), isTypeAlias ? DiagnosticKind.RecursiveTypealiasExpansion : DiagnosticKind.LoopInSupertype);
            } else {
                firResolvedTypeRef = supertypeRef;
            }
            resultSupertypeRefs.add(firResolvedTypeRef);
        }
        if (isErrorInSupertypesFound) {
            this$0.reportLoopErrorRefs(classLikeDeclaration, resultSupertypeRefs);
        }
        $pathOrderedSet.remove(classLikeDeclaration);
    }

    public static final /* synthetic */ ConeClassLikeType access$getResolvedExpandedType(SupertypeComputationSession $this, FirTypeAlias typeAlias) {
        return $this.getResolvedExpandedType(typeAlias);
    }
}

