/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.JsCommonBackendContext;
import org.jetbrains.kotlin.ir.backend.js.utils.JsMainFunctionDetectorKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/JsMainFunctionDetector;", "", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "isMain", "", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "allowEmptyParameters", "getMainFunctionOrNull", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "module", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nJsMainFunctionDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsMainFunctionDetector.kt\norg/jetbrains/kotlin/ir/backend/js/utils/JsMainFunctionDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n812#2,12:93\n1807#2,3:105\n812#2,12:108\n672#2,11:120\n1915#2,2:131\n*S KotlinDebug\n*F\n+ 1 JsMainFunctionDetector.kt\norg/jetbrains/kotlin/ir/backend/js/utils/JsMainFunctionDetector\n*L\n42#1:93,12\n42#1:105,3\n48#1:108,12\n48#1:120,11\n55#1:131,2\n*E\n"})
public final class JsMainFunctionDetector {
    @NotNull
    private final JsCommonBackendContext context;

    public JsMainFunctionDetector(@NotNull JsCommonBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final JsCommonBackendContext getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isMain(IrSimpleFunction $this$isMain, boolean allowEmptyParameters) {
        boolean bl;
        block11: {
            void $this$any$iv;
            void $this$filterIsInstanceTo$iv$iv;
            boolean hasCorrectShape;
            if (!((Collection)$this$isMain.getTypeParameters()).isEmpty()) {
                return false;
            }
            boolean hasSingleParameter = IrUtilsKt.hasShape$default($this$isMain, false, false, 0, 1, null, 23, null);
            boolean hasTwoParameters = IrUtilsKt.hasShape$default($this$isMain, false, false, 0, 2, null, 23, null);
            boolean bl2 = hasCorrectShape = hasSingleParameter || hasTwoParameters || allowEmptyParameters && IrUtilsKt.hasShape$default($this$isMain, false, false, 0, 0, null, 23, null);
            if (!hasCorrectShape) {
                return false;
            }
            boolean isLoweredSuspendFunction = JsMainFunctionDetectorKt.isLoweredSuspendFunction($this$isMain, this.context);
            if (!(IrTypePredicatesKt.isUnit($this$isMain.getReturnType()) || isLoweredSuspendFunction && (Intrinsics.areEqual((Object)$this$isMain.getReturnType(), (Object)this.context.getIrBuiltIns().getAnyNType()) || Intrinsics.areEqual((Object)$this$isMain.getReturnType(), (Object)this.context.getIrBuiltIns().getAnyType())))) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)$this$isMain.getName().asString(), (Object)"main")) {
                return false;
            }
            if (hasSingleParameter) {
                return isLoweredSuspendFunction || JsMainFunctionDetectorKt.isStringArrayParameter($this$isMain.getParameters().get(0));
            }
            if (hasTwoParameters) {
                return JsMainFunctionDetectorKt.isStringArrayParameter($this$isMain.getParameters().get(0)) && isLoweredSuspendFunction;
            }
            if (!allowEmptyParameters) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            IrDeclarationParent irDeclarationParent = $this$isMain.getParent();
            Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFile");
            IrFile file = (IrFile)irDeclarationParent;
            Iterable $this$filterIsInstance$iv = file.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrSimpleFunction it = (IrSimpleFunction)element$iv;
                    boolean bl3 = false;
                    if (!this.isMain(it, false)) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        return !bl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final IrSimpleFunction getMainFunctionOrNull(@NotNull IrFile file) {
        Object v0;
        block3: {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Iterable $this$filterIsInstance$iv = file.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$singleOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IrSimpleFunction it = (IrSimpleFunction)element$iv;
                boolean bl = false;
                if (!this.isMain(it, true)) continue;
                if (found$iv) {
                    v0 = null;
                    break block3;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        return v0;
    }

    @Nullable
    public final IrSimpleFunction getMainFunctionOrNull(@NotNull IrModuleFragment module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Pair resultPair = null;
        Iterable $this$forEach$iv = module2.getFiles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrSimpleFunction it;
            IrFile f = (IrFile)element$iv;
            boolean bl = false;
            String fqn = f.getPackageFqName().asString();
            if (this.getMainFunctionOrNull(f) == null) continue;
            boolean bl2 = false;
            Pair result2 = resultPair;
            if (result2 == null) {
                resultPair = new Pair((Object)fqn, (Object)it);
                continue;
            }
            if (fqn.compareTo((String)result2.getFirst()) >= 0) continue;
            resultPair = new Pair((Object)fqn, (Object)it);
        }
        Pair pair = resultPair;
        return pair != null ? (IrSimpleFunction)pair.getSecond() : null;
    }
}

