/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.validation.checkers.declaration;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.validation.checkers.IrElementChecker;
import org.jetbrains.kotlin.ir.validation.checkers.context.CheckerContext;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/ir/validation/checkers/declaration/IrFunctionParametersChecker;", "Lorg/jetbrains/kotlin/ir/validation/checkers/IrElementChecker;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "<init>", "()V", "check", "", "element", "context", "Lorg/jetbrains/kotlin/ir/validation/checkers/context/CheckerContext;", "ir.validation"})
public final class IrFunctionParametersChecker
extends IrElementChecker<IrFunction> {
    @NotNull
    public static final IrFunctionParametersChecker INSTANCE = new IrFunctionParametersChecker();

    private IrFunctionParametersChecker() {
        super(Reflection.getOrCreateKotlinClass(IrFunction.class));
    }

    @Override
    public void check(@NotNull IrFunction element, @NotNull CheckerContext context2) {
        IrDeclarationBase param;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Iterator iterator2 = ((Iterable)element.getValueParameters()).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            IrValueParameter param2 = (IrValueParameter)iterator2.next();
            if (param2.getIndexInOldValueParameters() == i) continue;
            context2.error(this, element, "Inconsistent index (old API) of value parameter " + param2.getIndexInOldValueParameters() + " != " + i);
        }
        IrParameterKind lastKind = null;
        Iterator iterator3 = ((Iterable)element.getParameters()).iterator();
        int n2 = 0;
        while (iterator3.hasNext()) {
            int i = n2++;
            param = (IrValueParameter)iterator3.next();
            if (((IrValueParameter)param).getIndexInParameters() != i) {
                context2.error(this, element, "Inconsistent index (new API) of value parameter " + ((IrValueParameter)param).getIndexInParameters() + " != " + i);
            }
            IrParameterKind kind = ((IrValueParameter)param).getKind();
            if (lastKind != null) {
                if (kind.compareTo((Enum)lastKind) < 0) {
                    context2.error(this, element, "Invalid order of function parameters: " + (Object)((Object)kind) + " is placed after " + (Object)((Object)lastKind) + ".\nParameters must follow a strict order: [dispatch receiver, context parameters, extension receiver, regular parameters].");
                }
                if ((kind == IrParameterKind.DispatchReceiver || kind == IrParameterKind.ExtensionReceiver) && kind == lastKind) {
                    context2.error(this, element, "Function may have only one " + (Object)((Object)kind) + " parameter");
                }
            }
            lastKind = kind;
        }
        iterator3 = ((Iterable)element.getTypeParameters()).iterator();
        n2 = 0;
        while (iterator3.hasNext()) {
            int i = n2++;
            param = (IrTypeParameter)iterator3.next();
            if (((IrTypeParameter)param).getIndex() == i) continue;
            context2.error(this, element, "Inconsistent index of type parameter " + ((IrTypeParameter)param).getIndex() + " != " + i);
        }
    }
}

