/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.model;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.stream.Collectors;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatchImpl;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatchStatus;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentUnmapped;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tasks.OldResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.CastImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;

public class ResolvedCallImpl<D extends CallableDescriptor>
implements MutableResolvedCall<D> {
    private static final Logger LOG = Logger.getInstance(ResolvedCallImpl.class);
    private final Call call;
    private final D candidateDescriptor;
    private D resultingDescriptor;
    private ReceiverValue dispatchReceiver;
    private ReceiverValue extensionReceiver;
    private final ExplicitReceiverKind explicitReceiverKind;
    private final TypeSubstitutor knownTypeParametersSubstitutor;
    @NotNull
    private Map<TypeParameterDescriptor, KotlinType> typeArguments;
    @NotNull
    private final Map<ValueParameterDescriptor, ResolvedValueArgument> valueArguments;
    private final MutableDataFlowInfoForArguments dataFlowInfoForArguments;
    @NotNull
    private final Map<ValueArgument, ArgumentMatchImpl> argumentToParameterMap;
    private DelegatingBindingTrace trace;
    private TracingStrategy tracing;
    private ResolutionStatus status;
    private ConstraintSystem constraintSystem;
    private Boolean hasInferredReturnType;
    private boolean completed;
    private KotlinType smartCastDispatchReceiverType;
    private Queue<Function0<Unit>> remainingTasks;

    @NotNull
    public static <D extends CallableDescriptor> ResolvedCallImpl<D> create(@NotNull OldResolutionCandidate<D> candidate2, @NotNull DelegatingBindingTrace trace, @NotNull TracingStrategy tracing, @NotNull MutableDataFlowInfoForArguments dataFlowInfoForArguments) {
        if (candidate2 == null) {
            ResolvedCallImpl.$$$reportNull$$$0(0);
        }
        if (trace == null) {
            ResolvedCallImpl.$$$reportNull$$$0(1);
        }
        if (tracing == null) {
            ResolvedCallImpl.$$$reportNull$$$0(2);
        }
        if (dataFlowInfoForArguments == null) {
            ResolvedCallImpl.$$$reportNull$$$0(3);
        }
        return new ResolvedCallImpl<D>(candidate2, trace, tracing, dataFlowInfoForArguments);
    }

    private ResolvedCallImpl(@NotNull OldResolutionCandidate<D> candidate2, @NotNull DelegatingBindingTrace trace, @NotNull TracingStrategy tracing, @NotNull MutableDataFlowInfoForArguments dataFlowInfoForArguments) {
        if (candidate2 == null) {
            ResolvedCallImpl.$$$reportNull$$$0(4);
        }
        if (trace == null) {
            ResolvedCallImpl.$$$reportNull$$$0(5);
        }
        if (tracing == null) {
            ResolvedCallImpl.$$$reportNull$$$0(6);
        }
        if (dataFlowInfoForArguments == null) {
            ResolvedCallImpl.$$$reportNull$$$0(7);
        }
        this.status = ResolutionStatus.UNKNOWN_STATUS;
        this.constraintSystem = null;
        this.hasInferredReturnType = null;
        this.completed = false;
        this.smartCastDispatchReceiverType = null;
        this.remainingTasks = null;
        this.call = candidate2.getCall();
        this.candidateDescriptor = candidate2.getDescriptor();
        this.dispatchReceiver = candidate2.getDispatchReceiver();
        this.extensionReceiver = null;
        this.explicitReceiverKind = candidate2.getExplicitReceiverKind();
        this.knownTypeParametersSubstitutor = candidate2.getKnownTypeParametersResultingSubstitutor();
        this.trace = trace;
        this.tracing = tracing;
        this.dataFlowInfoForArguments = dataFlowInfoForArguments;
        this.typeArguments = ResolvedCallImpl.createTypeArgumentsMap(this.candidateDescriptor);
        this.valueArguments = ResolvedCallImpl.createValueArgumentsMap(this.candidateDescriptor);
        this.argumentToParameterMap = ResolvedCallImpl.createArgumentsToParameterMap(this.candidateDescriptor);
    }

    public ResolvedCallImpl(@NotNull Call call, @NotNull D candidateDescriptor, @Nullable ReceiverValue dispatchReceiver, @Nullable ReceiverValue extensionReceiver, @NotNull ExplicitReceiverKind explicitReceiverKind, @Nullable TypeSubstitutor knownTypeParametersSubstitutor, @NotNull DelegatingBindingTrace trace, @NotNull TracingStrategy tracing, @NotNull MutableDataFlowInfoForArguments dataFlowInfoForArguments) {
        if (call == null) {
            ResolvedCallImpl.$$$reportNull$$$0(8);
        }
        if (candidateDescriptor == null) {
            ResolvedCallImpl.$$$reportNull$$$0(9);
        }
        if (explicitReceiverKind == null) {
            ResolvedCallImpl.$$$reportNull$$$0(10);
        }
        if (trace == null) {
            ResolvedCallImpl.$$$reportNull$$$0(11);
        }
        if (tracing == null) {
            ResolvedCallImpl.$$$reportNull$$$0(12);
        }
        if (dataFlowInfoForArguments == null) {
            ResolvedCallImpl.$$$reportNull$$$0(13);
        }
        this.status = ResolutionStatus.UNKNOWN_STATUS;
        this.constraintSystem = null;
        this.hasInferredReturnType = null;
        this.completed = false;
        this.smartCastDispatchReceiverType = null;
        this.remainingTasks = null;
        this.call = call;
        this.candidateDescriptor = candidateDescriptor;
        this.dispatchReceiver = dispatchReceiver;
        this.extensionReceiver = extensionReceiver;
        this.explicitReceiverKind = explicitReceiverKind;
        this.knownTypeParametersSubstitutor = knownTypeParametersSubstitutor;
        this.trace = trace;
        this.tracing = tracing;
        this.dataFlowInfoForArguments = dataFlowInfoForArguments;
        this.typeArguments = ResolvedCallImpl.createTypeArgumentsMap(candidateDescriptor);
        this.valueArguments = ResolvedCallImpl.createValueArgumentsMap(candidateDescriptor);
        this.argumentToParameterMap = ResolvedCallImpl.createArgumentsToParameterMap(candidateDescriptor);
    }

    @NotNull
    private static Map<ValueParameterDescriptor, ResolvedValueArgument> createValueArgumentsMap(CallableDescriptor descriptor) {
        return descriptor.getValueParameters().isEmpty() ? Collections.emptyMap() : new LinkedHashMap();
    }

    @NotNull
    private static Map<ValueArgument, ArgumentMatchImpl> createArgumentsToParameterMap(CallableDescriptor descriptor) {
        return descriptor.getValueParameters().isEmpty() ? Collections.emptyMap() : new HashMap();
    }

    @NotNull
    private static Map<TypeParameterDescriptor, KotlinType> createTypeArgumentsMap(CallableDescriptor descriptor) {
        return descriptor.getTypeParameters().isEmpty() ? Collections.emptyMap() : new LinkedHashMap();
    }

    @Override
    @NotNull
    public ResolutionStatus getStatus() {
        ResolutionStatus resolutionStatus = this.status;
        if (resolutionStatus == null) {
            ResolvedCallImpl.$$$reportNull$$$0(14);
        }
        return resolutionStatus;
    }

    @Override
    public void addStatus(@NotNull ResolutionStatus status2) {
        if (status2 == null) {
            ResolvedCallImpl.$$$reportNull$$$0(15);
        }
        this.status = this.status.combine(status2);
    }

    @Override
    public void setStatusToSuccess() {
        assert (this.status == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE || this.status == ResolutionStatus.UNKNOWN_STATUS);
        this.status = ResolutionStatus.SUCCESS;
    }

    @Override
    @NotNull
    public DelegatingBindingTrace getTrace() {
        this.assertNotCompleted("Trace");
        DelegatingBindingTrace delegatingBindingTrace = this.trace;
        if (delegatingBindingTrace == null) {
            ResolvedCallImpl.$$$reportNull$$$0(16);
        }
        return delegatingBindingTrace;
    }

    @Override
    @NotNull
    public TracingStrategy getTracingStrategy() {
        this.assertNotCompleted("TracingStrategy");
        TracingStrategy tracingStrategy = this.tracing;
        if (tracingStrategy == null) {
            ResolvedCallImpl.$$$reportNull$$$0(17);
        }
        return tracingStrategy;
    }

    @Override
    @NotNull
    public Call getCall() {
        Call call = this.call;
        if (call == null) {
            ResolvedCallImpl.$$$reportNull$$$0(18);
        }
        return call;
    }

    @Override
    @NotNull
    public D getCandidateDescriptor() {
        D d = this.candidateDescriptor;
        if (d == null) {
            ResolvedCallImpl.$$$reportNull$$$0(19);
        }
        return d;
    }

    @Override
    @NotNull
    public D getResultingDescriptor() {
        D d = this.resultingDescriptor == null ? this.candidateDescriptor : this.resultingDescriptor;
        if (d == null) {
            ResolvedCallImpl.$$$reportNull$$$0(20);
        }
        return d;
    }

    public void setResultingSubstitutor(@NotNull TypeSubstitutor substitutor2) {
        if (substitutor2 == null) {
            ResolvedCallImpl.$$$reportNull$$$0(21);
        }
        D descriptorToSubstitute = this.resultingDescriptor != null && DescriptorUtilsKt.shouldBeSubstituteWithStubTypes(this.resultingDescriptor) ? this.resultingDescriptor : this.candidateDescriptor;
        this.resultingDescriptor = (CallableDescriptor)descriptorToSubstitute.substitute(substitutor2);
    }

    public void setResolvedCallSubstitutor(@NotNull TypeSubstitutor substitutor2) {
        if (substitutor2 == null) {
            ResolvedCallImpl.$$$reportNull$$$0(22);
        }
        for (TypeParameterDescriptor typeParameter : this.candidateDescriptor.getTypeParameters()) {
            TypeProjection typeArgumentProjection = substitutor2.getSubstitution().get(typeParameter.getDefaultType());
            if (typeArgumentProjection == null) continue;
            this.typeArguments.put(typeParameter, typeArgumentProjection.getType());
        }
        this.typeArguments = this.typeArguments.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> substitutor2.safeSubstitute((KotlinType)e.getValue(), ((TypeParameterDescriptor)e.getKey()).getVariance())));
        if (this.dispatchReceiver instanceof ExpressionReceiver) {
            this.dispatchReceiver = this.dispatchReceiver.replaceType(substitutor2.safeSubstitute(this.dispatchReceiver.getType(), Variance.IN_VARIANCE));
        }
        if (this.extensionReceiver instanceof ExtensionReceiver) {
            this.extensionReceiver = this.extensionReceiver.replaceType(substitutor2.safeSubstitute(this.extensionReceiver.getType(), Variance.IN_VARIANCE));
        }
        if (this.candidateDescriptor.getValueParameters().isEmpty()) {
            return;
        }
        List<ValueParameterDescriptor> substitutedParameters = this.resultingDescriptor.getValueParameters();
        SmartList<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> valueArgumentsBeforeSubstitution = new SmartList<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>>((Collection<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>>)this.valueArguments.entrySet());
        this.valueArguments.clear();
        for (Map.Entry entry : valueArgumentsBeforeSubstitution) {
            ValueParameterDescriptor valueParameterDescriptor = substitutedParameters.get(((ValueParameterDescriptor)entry.getKey()).getIndex());
            assert (valueParameterDescriptor != null) : (ValueParameterDescriptor)entry.getKey();
            this.valueArguments.put(valueParameterDescriptor, (ResolvedValueArgument)entry.getValue());
        }
        SmartList<Map.Entry<ValueArgument, ArgumentMatchImpl>> unsubstitutedArgumentMappings = new SmartList<Map.Entry<ValueArgument, ArgumentMatchImpl>>((Collection<Map.Entry<ValueArgument, ArgumentMatchImpl>>)this.argumentToParameterMap.entrySet());
        this.argumentToParameterMap.clear();
        for (Map.Entry entry : unsubstitutedArgumentMappings) {
            ArgumentMatchImpl argumentMatch = (ArgumentMatchImpl)entry.getValue();
            ValueParameterDescriptor valueParameterDescriptor = argumentMatch.getValueParameter();
            ValueParameterDescriptor substitutedVersion = substitutedParameters.get(valueParameterDescriptor.getIndex());
            assert (substitutedVersion != null) : valueParameterDescriptor;
            this.argumentToParameterMap.put((ValueArgument)entry.getKey(), argumentMatch.replaceValueParameter(substitutedVersion));
        }
    }

    @Override
    public void setSubstitutor(@NotNull TypeSubstitutor substitutor2) {
        if (substitutor2 == null) {
            ResolvedCallImpl.$$$reportNull$$$0(23);
        }
        this.setResultingSubstitutor(substitutor2);
        this.setResolvedCallSubstitutor(substitutor2);
    }

    @Override
    public void setConstraintSystem(@NotNull ConstraintSystem constraintSystem) {
        if (constraintSystem == null) {
            ResolvedCallImpl.$$$reportNull$$$0(24);
        }
        this.constraintSystem = constraintSystem;
    }

    @Override
    @Nullable
    public ConstraintSystem getConstraintSystem() {
        this.assertNotCompleted("ConstraintSystem");
        return this.constraintSystem;
    }

    @Override
    public void recordValueArgument(@NotNull ValueParameterDescriptor valueParameter2, @NotNull ResolvedValueArgument valueArgument) {
        if (valueParameter2 == null) {
            ResolvedCallImpl.$$$reportNull$$$0(25);
        }
        if (valueArgument == null) {
            ResolvedCallImpl.$$$reportNull$$$0(26);
        }
        assert (!this.valueArguments.containsKey(valueParameter2)) : valueParameter2 + " -> " + valueArgument;
        this.valueArguments.put(valueParameter2, valueArgument);
        for (ValueArgument argument : valueArgument.getArguments()) {
            this.argumentToParameterMap.put(argument, new ArgumentMatchImpl(valueParameter2));
        }
    }

    @Override
    @Nullable
    public ReceiverValue getExtensionReceiver() {
        return this.extensionReceiver;
    }

    @Override
    @Nullable
    public ReceiverValue getDispatchReceiver() {
        return this.dispatchReceiver;
    }

    @Override
    @NotNull
    public List<ReceiverValue> getContextReceivers() {
        List<ReceiverValue> list = Collections.emptyList();
        if (list == null) {
            ResolvedCallImpl.$$$reportNull$$$0(27);
        }
        return list;
    }

    @Override
    @NotNull
    public ExplicitReceiverKind getExplicitReceiverKind() {
        ExplicitReceiverKind explicitReceiverKind = this.explicitReceiverKind;
        if (explicitReceiverKind == null) {
            ResolvedCallImpl.$$$reportNull$$$0(28);
        }
        return explicitReceiverKind;
    }

    @Override
    @NotNull
    public Map<ValueParameterDescriptor, ResolvedValueArgument> getValueArguments() {
        Map<ValueParameterDescriptor, ResolvedValueArgument> map = this.valueArguments;
        if (map == null) {
            ResolvedCallImpl.$$$reportNull$$$0(29);
        }
        return map;
    }

    @Override
    @Nullable
    public List<ResolvedValueArgument> getValueArgumentsByIndex() {
        ArrayList<ResolvedValueArgument> arguments = new ArrayList<ResolvedValueArgument>(this.candidateDescriptor.getValueParameters().size());
        for (int i = 0; i < this.candidateDescriptor.getValueParameters().size(); ++i) {
            arguments.add(null);
        }
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : this.valueArguments.entrySet()) {
            ValueParameterDescriptor parameterDescriptor = entry.getKey();
            ResolvedValueArgument value2 = entry.getValue();
            ResolvedValueArgument oldValue = arguments.set(parameterDescriptor.getIndex(), value2);
            if (oldValue == null) continue;
            return null;
        }
        for (int i = 0; i < arguments.size(); ++i) {
            Object o = arguments.get(i);
            if (o != null) continue;
            return null;
        }
        return arguments;
    }

    @Override
    public void recordArgumentMatchStatus(@NotNull ValueArgument valueArgument, @NotNull ArgumentMatchStatus matchStatus) {
        if (valueArgument == null) {
            ResolvedCallImpl.$$$reportNull$$$0(30);
        }
        if (matchStatus == null) {
            ResolvedCallImpl.$$$reportNull$$$0(31);
        }
        ArgumentMatchImpl argumentMatch = this.argumentToParameterMap.get(valueArgument);
        argumentMatch.recordMatchStatus(matchStatus);
    }

    @Override
    @NotNull
    public ArgumentMapping getArgumentMapping(@NotNull ValueArgument valueArgument) {
        ArgumentMatch argumentMatch;
        if (valueArgument == null) {
            ResolvedCallImpl.$$$reportNull$$$0(32);
        }
        if ((argumentMatch = (ArgumentMatch)this.argumentToParameterMap.get(valueArgument)) == null) {
            if (ArgumentMappingKt.isReallySuccess(this)) {
                LOG.error("ArgumentUnmapped for " + valueArgument + " in successfully resolved call: " + this.call.getCallElement().getText());
            }
            ArgumentUnmapped argumentUnmapped = ArgumentUnmapped.INSTANCE;
            if (argumentUnmapped == null) {
                ResolvedCallImpl.$$$reportNull$$$0(33);
            }
            return argumentUnmapped;
        }
        ArgumentMatch argumentMatch2 = argumentMatch;
        if (argumentMatch2 == null) {
            ResolvedCallImpl.$$$reportNull$$$0(34);
        }
        return argumentMatch2;
    }

    @Override
    @NotNull
    public Map<TypeParameterDescriptor, KotlinType> getTypeArguments() {
        Map<TypeParameterDescriptor, KotlinType> map = this.typeArguments;
        if (map == null) {
            ResolvedCallImpl.$$$reportNull$$$0(35);
        }
        return map;
    }

    @Override
    @NotNull
    public MutableDataFlowInfoForArguments getDataFlowInfoForArguments() {
        MutableDataFlowInfoForArguments mutableDataFlowInfoForArguments = this.dataFlowInfoForArguments;
        if (mutableDataFlowInfoForArguments == null) {
            ResolvedCallImpl.$$$reportNull$$$0(36);
        }
        return mutableDataFlowInfoForArguments;
    }

    @Override
    public boolean hasInferredReturnType() {
        if (!this.completed) {
            this.hasInferredReturnType = this.constraintSystem == null || CallResolverUtilKt.hasInferredReturnType(this.candidateDescriptor, this.constraintSystem);
        }
        assert (this.hasInferredReturnType != null) : "The property 'hasInferredReturnType' was not set when the call was completed.";
        return this.hasInferredReturnType;
    }

    @Override
    public void markCallAsCompleted() {
        if (!this.completed) {
            this.hasInferredReturnType();
        }
        this.trace = null;
        this.constraintSystem = null;
        this.tracing = null;
        this.completed = true;
        this.remainingTasks = null;
    }

    @Override
    public void addRemainingTasks(Function0<Unit> task) {
        if (this.remainingTasks == null) {
            this.remainingTasks = new ArrayDeque<Function0<Unit>>();
        }
        this.remainingTasks.add(task);
    }

    @Override
    public void performRemainingTasks() {
        if (this.remainingTasks == null) {
            return;
        }
        while (!this.remainingTasks.isEmpty()) {
            this.remainingTasks.poll().invoke();
        }
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    private void assertNotCompleted(String elementName) {
        assert (!this.completed) : elementName + " is erased after resolution completion.";
    }

    @Override
    @Nullable
    public TypeSubstitutor getKnownTypeParametersSubstitutor() {
        return this.knownTypeParametersSubstitutor;
    }

    @Override
    public void setSmartCastDispatchReceiverType(@NotNull KotlinType smartCastDispatchReceiverType) {
        if (smartCastDispatchReceiverType == null) {
            ResolvedCallImpl.$$$reportNull$$$0(37);
        }
        this.smartCastDispatchReceiverType = smartCastDispatchReceiverType;
    }

    @Override
    @Nullable
    public KotlinType getSmartCastDispatchReceiverType() {
        return this.smartCastDispatchReceiverType;
    }

    @Override
    public void updateExtensionReceiverWithSmartCastIfNeeded(@NotNull KotlinType smartCastExtensionReceiverType) {
        if (smartCastExtensionReceiverType == null) {
            ResolvedCallImpl.$$$reportNull$$$0(38);
        }
        if (this.extensionReceiver instanceof ImplicitClassReceiver) {
            this.extensionReceiver = new CastImplicitClassReceiver(((ImplicitClassReceiver)this.extensionReceiver).getClassDescriptor(), smartCastExtensionReceiverType);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 1: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 2: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracing";
                break;
            }
            case 3: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataFlowInfoForArguments";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateDescriptor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "explicitReceiverKind";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintSystem";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueParameter";
                break;
            }
            case 26: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueArgument";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchStatus";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "smartCastDispatchReceiverType";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "smartCastExtensionReceiverType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrace";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTracingStrategy";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCall";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidateDescriptor";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultingDescriptor";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextReceivers";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitReceiverKind";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueArguments";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentMapping";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArguments";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataFlowInfoForArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addStatus";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setResultingSubstitutor";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setResolvedCallSubstitutor";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setSubstitutor";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setConstraintSystem";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "recordValueArgument";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "recordArgumentMatchStatus";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentMapping";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "setSmartCastDispatchReceiverType";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "updateExtensionReceiverWithSmartCastIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

