/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.FunctionExpressionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.ObservableBindingTrace;
import org.jetbrains.kotlin.resolve.OverloadChecker;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.TraceBasedLocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingFacade;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;

public class ExpressionTypingUtils {
    @Nullable
    public static ExpressionReceiver getExpressionReceiver(@NotNull ExpressionTypingFacade facade, @NotNull KtExpression expression2, ExpressionTypingContext context2) {
        KotlinType type;
        if (facade == null) {
            ExpressionTypingUtils.$$$reportNull$$$0(0);
        }
        if (expression2 == null) {
            ExpressionTypingUtils.$$$reportNull$$$0(1);
        }
        if ((type = facade.getTypeInfo(expression2, context2).getType()) == null) {
            return null;
        }
        return ExpressionReceiver.Companion.create(expression2, type, context2.trace.getBindingContext());
    }

    @NotNull
    public static ExpressionReceiver safeGetExpressionReceiver(@NotNull ExpressionTypingFacade facade, @NotNull KtExpression expression2, ExpressionTypingContext context2) {
        if (facade == null) {
            ExpressionTypingUtils.$$$reportNull$$$0(2);
        }
        if (expression2 == null) {
            ExpressionTypingUtils.$$$reportNull$$$0(3);
        }
        KotlinType type = ExpressionTypingUtils.safeGetType(facade.safeGetTypeInfo(expression2, context2));
        ExpressionReceiver expressionReceiver = ExpressionReceiver.Companion.create(expression2, type, context2.trace.getBindingContext());
        if (expressionReceiver == null) {
            ExpressionTypingUtils.$$$reportNull$$$0(4);
        }
        return expressionReceiver;
    }

    @NotNull
    public static KotlinType safeGetType(@NotNull KotlinTypeInfo typeInfo) {
        if (typeInfo == null) {
            ExpressionTypingUtils.$$$reportNull$$$0(5);
        }
        KotlinType type = typeInfo.getType();
        assert (type != null) : "safeGetType should be invoked on safe KotlinTypeInfo; safeGetTypeInfo should return @NotNull type";
        KotlinType kotlinType = type;
        if (kotlinType == null) {
            ExpressionTypingUtils.$$$reportNull$$$0(6);
        }
        return kotlinType;
    }

    @NotNull
    public static LexicalWritableScope newWritableScopeImpl(@NotNull ExpressionTypingContext context2, @NotNull LexicalScopeKind scopeKind, @NotNull OverloadChecker overloadChecker) {
        if (context2 == null) {
            ExpressionTypingUtils.$$$reportNull$$$0(7);
        }
        if (scopeKind == null) {
            ExpressionTypingUtils.$$$reportNull$$$0(8);
        }
        if (overloadChecker == null) {
            ExpressionTypingUtils.$$$reportNull$$$0(9);
        }
        return new LexicalWritableScope(context2.scope, context2.scope.getOwnerDescriptor(), false, new TraceBasedLocalRedeclarationChecker(context2.trace, overloadChecker), scopeKind);
    }

    public static KtExpression createFakeExpressionOfType(@NotNull Project project, @NotNull BindingTrace trace, @NotNull String argumentName, @NotNull KotlinType argumentType) {
        if (project == null) {
            ExpressionTypingUtils.$$$reportNull$$$0(10);
        }
        if (trace == null) {
            ExpressionTypingUtils.$$$reportNull$$$0(11);
        }
        if (argumentName == null) {
            ExpressionTypingUtils.$$$reportNull$$$0(12);
        }
        if (argumentType == null) {
            ExpressionTypingUtils.$$$reportNull$$$0(13);
        }
        KtExpression fakeExpression = new KtPsiFactory(project, false).createExpression(argumentName);
        trace.recordType(fakeExpression, argumentType);
        trace.record(BindingContext.PROCESSED, fakeExpression);
        return fakeExpression;
    }

    public static void checkVariableShadowing(@NotNull LexicalScope scope2, @NotNull BindingTrace trace, @NotNull VariableDescriptor variableDescriptor) {
        PsiElement declaration;
        VariableDescriptor oldDescriptor;
        if (scope2 == null) {
            ExpressionTypingUtils.$$$reportNull$$$0(14);
        }
        if (trace == null) {
            ExpressionTypingUtils.$$$reportNull$$$0(15);
        }
        if (variableDescriptor == null) {
            ExpressionTypingUtils.$$$reportNull$$$0(16);
        }
        if ((oldDescriptor = ScopeUtilsKt.findLocalVariable(scope2, variableDescriptor.getName())) == null) {
            return;
        }
        DeclarationDescriptor variableContainingDeclaration = variableDescriptor.getContainingDeclaration();
        if (!ExpressionTypingUtils.isLocal(variableContainingDeclaration, oldDescriptor)) {
            return;
        }
        if (variableDescriptor instanceof ParameterDescriptor) {
            if (!ExpressionTypingUtils.isFunctionLiteral(variableContainingDeclaration)) {
                return;
            }
            if (variableContainingDeclaration.getContainingDeclaration() != oldDescriptor.getContainingDeclaration()) {
                return;
            }
        }
        if ((declaration = DescriptorToSourceUtils.descriptorToDeclaration(variableDescriptor)) != null) {
            PsiElement oldElement;
            if (declaration instanceof KtDestructuringDeclarationEntry && declaration.getParent().getParent() instanceof KtParameter && (oldElement = DescriptorToSourceUtils.descriptorToDeclaration(oldDescriptor)) != null && oldElement.getParent().equals(declaration.getParent().getParent().getParent())) {
                return;
            }
            trace.report(Errors.NAME_SHADOWING.on(declaration, variableDescriptor.getName().asString()));
        }
    }

    public static ObservableBindingTrace makeTraceInterceptingTypeMismatch(@NotNull BindingTrace trace, final @NotNull KtElement expressionToWatch, final @NotNull boolean[] mismatchFound) {
        if (trace == null) {
            ExpressionTypingUtils.$$$reportNull$$$0(17);
        }
        if (expressionToWatch == null) {
            ExpressionTypingUtils.$$$reportNull$$$0(18);
        }
        if (mismatchFound == null) {
            ExpressionTypingUtils.$$$reportNull$$$0(19);
        }
        return new ObservableBindingTrace(trace){

            @Override
            public void report(@NotNull Diagnostic diagnostic) {
                DiagnosticFactory<?> factory;
                if (diagnostic == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (Errors.TYPE_MISMATCH_ERRORS.contains(factory = diagnostic.getFactory()) && diagnostic.getPsiElement() == expressionToWatch) {
                    mismatchFound[0] = true;
                }
                if (Errors.TYPE_INFERENCE_ERRORS.contains(factory) && PsiTreeUtil.isAncestor(expressionToWatch, diagnostic.getPsiElement(), false)) {
                    mismatchFound[0] = true;
                }
                super.report(diagnostic);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils$1", "report"));
            }
        };
    }

    @NotNull
    public static KotlinTypeInfo getTypeInfoOrNullType(@Nullable KtExpression expression2, @NotNull ExpressionTypingContext context2, @NotNull ExpressionTypingInternals facade) {
        if (context2 == null) {
            ExpressionTypingUtils.$$$reportNull$$$0(20);
        }
        if (facade == null) {
            ExpressionTypingUtils.$$$reportNull$$$0(21);
        }
        KotlinTypeInfo kotlinTypeInfo = expression2 != null ? facade.getTypeInfo(expression2, context2) : TypeInfoFactoryKt.noTypeInfo(context2);
        if (kotlinTypeInfo == null) {
            ExpressionTypingUtils.$$$reportNull$$$0(22);
        }
        return kotlinTypeInfo;
    }

    public static boolean isBinaryExpressionDependentOnExpectedType(@NotNull KtBinaryExpression expression2) {
        IElementType operationType;
        if (expression2 == null) {
            ExpressionTypingUtils.$$$reportNull$$$0(23);
        }
        return (operationType = expression2.getOperationReference().getReferencedNameElementType()) == KtTokens.IDENTIFIER || OperatorConventions.BINARY_OPERATION_NAMES.containsKey(operationType) || operationType == KtTokens.ELVIS;
    }

    public static boolean isUnaryExpressionDependentOnExpectedType(@NotNull KtUnaryExpression expression2) {
        if (expression2 == null) {
            ExpressionTypingUtils.$$$reportNull$$$0(24);
        }
        return expression2.getOperationReference().getReferencedNameElementType() == KtTokens.EXCLEXCL;
    }

    public static boolean isExclExclExpression(@Nullable KtExpression expression2) {
        return expression2 instanceof KtUnaryExpression && ((KtUnaryExpression)expression2).getOperationReference().getReferencedNameElementType() == KtTokens.EXCLEXCL;
    }

    public static boolean isLocal(DeclarationDescriptor containerOfTheCurrentLocality, DeclarationDescriptor candidate2) {
        if (candidate2 instanceof ValueParameterDescriptor) {
            return true;
        }
        DeclarationDescriptor parent2 = candidate2.getContainingDeclaration();
        if (!(parent2 instanceof FunctionDescriptor)) {
            return false;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)parent2;
        for (DeclarationDescriptor current = containerOfTheCurrentLocality; current != null; current = current.getContainingDeclaration()) {
            if (current != functionDescriptor) continue;
            return true;
        }
        return false;
    }

    public static boolean dependsOnExpectedType(@Nullable KtExpression expression2) {
        KtExpression expr = KtPsiUtil.deparenthesize(expression2);
        if (expr == null) {
            return false;
        }
        if (expr instanceof KtBinaryExpressionWithTypeRHS) {
            return false;
        }
        if (expr instanceof KtBinaryExpression) {
            return ExpressionTypingUtils.isBinaryExpressionDependentOnExpectedType((KtBinaryExpression)expr);
        }
        if (expr instanceof KtUnaryExpression) {
            return ExpressionTypingUtils.isUnaryExpressionDependentOnExpectedType((KtUnaryExpression)expr);
        }
        return true;
    }

    private ExpressionTypingUtils() {
    }

    public static boolean isFunctionLiteral(@Nullable DeclarationDescriptor descriptor) {
        return descriptor instanceof AnonymousFunctionDescriptor;
    }

    public static boolean isLocalFunction(@Nullable DeclarationDescriptor descriptor) {
        if (descriptor != null && descriptor.getClass() == SimpleFunctionDescriptorImpl.class) {
            return ((SimpleFunctionDescriptorImpl)descriptor).getVisibility() == DescriptorVisibilities.LOCAL;
        }
        return false;
    }

    public static boolean isFunctionExpression(@Nullable DeclarationDescriptor descriptor) {
        return descriptor instanceof FunctionExpressionDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 1: 
            case 3: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: 
            case 6: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeInfo";
                break;
            }
            case 7: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeKind";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overloadChecker";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableDescriptor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionToWatch";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mismatchFound";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "safeGetExpressionReceiver";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "safeGetType";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeInfoOrNullType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionReceiver";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "safeGetExpressionReceiver";
                break;
            }
            case 4: 
            case 6: 
            case 22: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "safeGetType";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "newWritableScopeImpl";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createFakeExpressionOfType";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkVariableShadowing";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "makeTraceInterceptingTypeMismatch";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getTypeInfoOrNullType";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryExpressionDependentOnExpectedType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isUnaryExpressionDependentOnExpectedType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

