/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.injection;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InjectedLanguageManager {
    protected static final NotNullLazyKey<InjectedLanguageManager, Project> INSTANCE_CACHE = ServiceManager.createLazyKey(InjectedLanguageManager.class);
    public static final Key<Boolean> FRANKENSTEIN_INJECTION = Key.create("FRANKENSTEIN_INJECTION");

    public static InjectedLanguageManager getInstance(Project project) {
        return INSTANCE_CACHE.getValue(project);
    }

    @Nullable
    public abstract PsiLanguageInjectionHost getInjectionHost(@NotNull PsiElement var1);

    @NotNull
    public abstract TextRange injectedToHost(@NotNull PsiElement var1, @NotNull TextRange var2);

    public abstract boolean isInjectedFragment(@NotNull PsiFile var1);

    @Nullable
    public abstract List<Pair<PsiElement, TextRange>> getInjectedPsiFiles(@NotNull PsiElement var1);

    @NotNull
    public abstract List<DocumentWindow> getCachedInjectedDocumentsInRange(@NotNull PsiFile var1, @NotNull TextRange var2);

    @NotNull
    public abstract List<TextRange> getNonEditableFragments(@NotNull DocumentWindow var1);
}

