/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.LowMemoryWatcherManager;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.AppDelayQueue;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.concurrency.SchedulingWrapper;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class AppScheduledExecutorService
extends SchedulingWrapper {
    private static final Logger LOG = Logger.getInstance("#org.jetbrains.ide.PooledThreadExecutor");
    @NotNull
    private final String myName;
    private final LowMemoryWatcherManager myLowMemoryWatcherManager;
    private Consumer<? super Thread> newThreadListener;
    private final AtomicInteger counter;

    @NotNull
    static ScheduledExecutorService getInstance() {
        AppScheduledExecutorService appScheduledExecutorService = Holder.INSTANCE;
        if (appScheduledExecutorService == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(0);
        }
        return appScheduledExecutorService;
    }

    AppScheduledExecutorService(@NotNull String name) {
        if (name == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(1);
        }
        super(new BackendThreadPoolExecutor(), new AppDelayQueue());
        this.counter = new AtomicInteger();
        this.myName = name;
        ((BackendThreadPoolExecutor)this.backendExecutorService).doSetThreadFactory(new ThreadFactory(){

            @Override
            @NotNull
            public Thread newThread(@NotNull Runnable r) {
                if (r == null) {
                    1.$$$reportNull$$$0(0);
                }
                Thread thread = new Thread(r, "ApplicationImpl pooled thread " + AppScheduledExecutorService.this.counter.incrementAndGet());
                thread.setPriority(4);
                Consumer listener = AppScheduledExecutorService.this.newThreadListener;
                if (listener != null) {
                    listener.consume(thread);
                }
                Thread thread2 = thread;
                if (thread2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return thread2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "r";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/util/concurrency/AppScheduledExecutorService$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/util/concurrency/AppScheduledExecutorService$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "newThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "newThread";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        this.myLowMemoryWatcherManager = new LowMemoryWatcherManager(this);
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        List<Runnable> list2 = AppScheduledExecutorService.error();
        if (list2 == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Override
    public void shutdown() {
        AppScheduledExecutorService.error();
    }

    static List<Runnable> error() {
        throw new IncorrectOperationException("You must not call this method on the global app pool");
    }

    @Override
    void doShutdown() {
        super.doShutdown();
        ((BackendThreadPoolExecutor)this.backendExecutorService).doShutdown();
    }

    @Override
    @NotNull
    List<Runnable> doShutdownNow() {
        List<Runnable> list2 = ContainerUtil.concat(super.doShutdownNow(), ((BackendThreadPoolExecutor)this.backendExecutorService).doShutdownNow());
        if (list2 == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(4);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/concurrency/AppScheduledExecutorService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/concurrency/AppScheduledExecutorService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "shutdownNow";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doShutdownNow";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "statistics";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPeriodicTasksThread";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setNewThreadListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BackendThreadPoolExecutor
    extends ThreadPoolExecutor {
        BackendThreadPoolExecutor() {
            super(1, Integer.MAX_VALUE, 1L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>());
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("beforeExecute " + BoundedTaskExecutor.info(r) + " in " + t);
            }
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("afterExecute  " + BoundedTaskExecutor.info(r) + " in " + Thread.currentThread());
            }
            if (t != null) {
                LOG.error("Worker exited due to exception", t);
            }
        }

        private void doShutdown() {
            super.shutdown();
        }

        @NotNull
        private List<Runnable> doShutdownNow() {
            List<Runnable> list2 = super.shutdownNow();
            if (list2 == null) {
                BackendThreadPoolExecutor.$$$reportNull$$$0(0);
            }
            return list2;
        }

        private void doSetThreadFactory(@NotNull ThreadFactory threadFactory) {
            if (threadFactory == null) {
                BackendThreadPoolExecutor.$$$reportNull$$$0(1);
            }
            super.setThreadFactory(threadFactory);
        }

        @Override
        public void shutdown() {
            AppScheduledExecutorService.error();
        }

        @Override
        @NotNull
        public List<Runnable> shutdownNow() {
            List<Runnable> list2 = AppScheduledExecutorService.error();
            if (list2 == null) {
                BackendThreadPoolExecutor.$$$reportNull$$$0(2);
            }
            return list2;
        }

        @Override
        public void setCorePoolSize(int corePoolSize) {
            AppScheduledExecutorService.error();
        }

        @Override
        public void allowCoreThreadTimeOut(boolean value) {
            AppScheduledExecutorService.error();
        }

        @Override
        public void setMaximumPoolSize(int maximumPoolSize) {
            AppScheduledExecutorService.error();
        }

        @Override
        public void setKeepAliveTime(long time, TimeUnit unit) {
            AppScheduledExecutorService.error();
        }

        @Override
        public void setThreadFactory(ThreadFactory threadFactory) {
            AppScheduledExecutorService.error();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/concurrency/AppScheduledExecutorService$BackendThreadPoolExecutor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "threadFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doShutdownNow";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/concurrency/AppScheduledExecutorService$BackendThreadPoolExecutor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "shutdownNow";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "doSetThreadFactory";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Holder {
        private static final AppScheduledExecutorService INSTANCE = new AppScheduledExecutorService("Global instance");
    }
}

