/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl.classFiles;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.StringInterner;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.JavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryJavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.ClassifierResolutionContext;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.PlainJavaArrayType;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.PlainJavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.PlainJavaPrimitiveType;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.PlainJavaWildcardType;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u001f B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u0013\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u001a\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser;", "", "()V", "canonicalNameInterner", "Lcom/intellij/util/containers/StringInterner;", "mapAsmType", "Lorg/jetbrains/kotlin/load/java/structure/JavaType;", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "context", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext;", "parseClassOrTypeVariableElement", "signature", "Ljava/text/CharacterIterator;", "parseClassifierRefSignature", "Lorg/jetbrains/kotlin/load/java/structure/JavaClassifierType;", "parseDimensions", "", "parseParameterizedClassRefSignature", "parsePrimitiveType", "primitiveType", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "parseTypeParameter", "Lorg/jetbrains/kotlin/load/java/structure/JavaTypeParameter;", "parseTypeParametersDeclaration", "", "parseTypeString", "parseTypeVariableRefSignature", "parseTypeWithoutVarianceAndArray", "parseVariance", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser$JavaSignatureVariance;", "ClsFormatException", "JavaSignatureVariance", "frontend.java"})
public final class BinaryClassSignatureParser {
    private final StringInterner canonicalNameInterner = new StringInterner();

    @NotNull
    public final List<JavaTypeParameter> parseTypeParametersDeclaration(@NotNull CharacterIterator signature, @NotNull ClassifierResolutionContext context) {
        Intrinsics.checkParameterIsNotNull((Object)signature, (String)"signature");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (signature.current() != '<') {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        ArrayList arrayList = ContainerUtil.newArrayList();
        Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"ContainerUtil.newArrayList<JavaTypeParameter>()");
        ArrayList typeParameters2 = arrayList;
        signature.next();
        while (signature.current() != '>') {
            typeParameters2.add(this.parseTypeParameter(signature, context));
        }
        signature.next();
        return CollectionsKt.compact(typeParameters2);
    }

    private final JavaTypeParameter parseTypeParameter(CharacterIterator signature, ClassifierResolutionContext context) {
        StringBuilder name = new StringBuilder();
        while (signature.current() != ':' && signature.current() != '\uffff') {
            name.append(signature.current());
            signature.next();
        }
        if (signature.current() == '\uffff') {
            throw (Throwable)new ClsFormatException(null, null, 3, null);
        }
        String string = name.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name.toString()");
        String parameterName = string;
        List list2 = ContainerUtil.newSmartList();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"ContainerUtil.newSmartList()");
        List bounds = list2;
        while (signature.current() == ':') {
            JavaClassifierType bound;
            signature.next();
            if (this.parseClassifierRefSignature(signature, context) == null) {
                continue;
            }
            bounds.add(bound);
        }
        Name name2 = Name.identifier(parameterName);
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(parameterName)");
        return new BinaryJavaTypeParameter(name2, bounds);
    }

    @Nullable
    public final JavaClassifierType parseClassifierRefSignature(@NotNull CharacterIterator signature, @NotNull ClassifierResolutionContext context) {
        JavaClassifierType javaClassifierType;
        Intrinsics.checkParameterIsNotNull((Object)signature, (String)"signature");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        switch (signature.current()) {
            case 'L': {
                javaClassifierType = this.parseParameterizedClassRefSignature(signature, context);
                break;
            }
            case 'T': {
                javaClassifierType = this.parseTypeVariableRefSignature(signature, context);
                break;
            }
            default: {
                javaClassifierType = null;
            }
        }
        return javaClassifierType;
    }

    private final JavaClassifierType parseTypeVariableRefSignature(CharacterIterator signature, ClassifierResolutionContext context) {
        StringBuilder id = new StringBuilder();
        signature.next();
        while (signature.current() != ';' && signature.current() != '>' && signature.current() != '\uffff') {
            id.append(signature.current());
            signature.next();
        }
        if (signature.current() == '\uffff') {
            throw (Throwable)new ClsFormatException(null, null, 3, null);
        }
        if (signature.current() == ';') {
            signature.next();
        }
        String string = this.canonicalNameInterner.intern(id.toString());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"canonicalNameInterner.intern(id.toString())");
        String parameterName = string;
        return new PlainJavaClassifierType((Function0<ClassifierResolutionContext.Result>)((Function0)new Function0<ClassifierResolutionContext.Result>(context, parameterName){
            final /* synthetic */ ClassifierResolutionContext $context;
            final /* synthetic */ String $parameterName;

            @NotNull
            public final ClassifierResolutionContext.Result invoke() {
                return this.$context.resolveTypeParameter$frontend_java(this.$parameterName);
            }
            {
                this.$context = classifierResolutionContext;
                this.$parameterName = string;
                super(0);
            }
        }), kotlin.collections.CollectionsKt.emptyList());
    }

    private final JavaClassifierType parseParameterizedClassRefSignature(CharacterIterator signature, ClassifierResolutionContext context) {
        StringBuilder canonicalName = new StringBuilder();
        List list2 = ContainerUtil.newSmartList();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"ContainerUtil.newSmartList<List<JavaType>>()");
        List argumentGroups = list2;
        signature.next();
        while (signature.current() != ';' && signature.current() != '\uffff') {
            char c = signature.current();
            if (c == '<') {
                List group = new ArrayList();
                signature.next();
                do {
                    group.add(this.parseClassOrTypeVariableElement(signature, context));
                } while (signature.current() != '>');
                argumentGroups.add(group);
            } else if (c != ' ') {
                canonicalName.append(c);
            }
            signature.next();
        }
        if (signature.current() == '\uffff') {
            throw (Throwable)new ClsFormatException(null, null, 3, null);
        }
        signature.next();
        String string = canonicalName.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"canonicalName.toString()");
        String string2 = this.canonicalNameInterner.intern(StringsKt.replace$default((String)string, (char)'.', (char)'$', (boolean)false, (int)4, null));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"canonicalNameInterner.in\u2026ring().replace('.', '$'))");
        String internalName = string2;
        Iterable iterable = kotlin.collections.CollectionsKt.reversed((Iterable)argumentGroups);
        Function0 function0 = (Function0)new Function0<ClassifierResolutionContext.Result>(context, internalName){
            final /* synthetic */ ClassifierResolutionContext $context;
            final /* synthetic */ String $internalName;

            @NotNull
            public final ClassifierResolutionContext.Result invoke() {
                return this.$context.resolveByInternalName$frontend_java(this.$internalName);
            }
            {
                this.$context = classifierResolutionContext;
                this.$internalName = string;
                super(0);
            }
        };
        ArrayList arrayList = new ArrayList();
        List list3 = CollectionsKt.compact((ArrayList)AddToStdlibKt.flattenTo(iterable, (Collection)arrayList));
        Function0 function02 = function0;
        return new PlainJavaClassifierType((Function0<ClassifierResolutionContext.Result>)function02, list3);
    }

    private final JavaType parseClassOrTypeVariableElement(CharacterIterator signature, ClassifierResolutionContext context) {
        JavaSignatureVariance variance = this.parseVariance(signature);
        if (variance == JavaSignatureVariance.STAR) {
            return new PlainJavaWildcardType(null, true);
        }
        JavaType type2 = this.parseTypeString(signature, context);
        if (variance == JavaSignatureVariance.NO_VARIANCE) {
            return type2;
        }
        return new PlainJavaWildcardType(type2, variance == JavaSignatureVariance.PLUS);
    }

    private final JavaSignatureVariance parseVariance(CharacterIterator signature) {
        JavaSignatureVariance variance;
        boolean advance = true;
        switch (signature.current()) {
            case '+': {
                JavaSignatureVariance javaSignatureVariance = JavaSignatureVariance.PLUS;
                break;
            }
            case '-': {
                JavaSignatureVariance javaSignatureVariance = JavaSignatureVariance.MINUS;
                break;
            }
            case '*': {
                JavaSignatureVariance javaSignatureVariance = JavaSignatureVariance.STAR;
                break;
            }
            case '.': 
            case '=': {
                JavaSignatureVariance javaSignatureVariance = JavaSignatureVariance.NO_VARIANCE;
                break;
            }
            default: {
                advance = false;
                JavaSignatureVariance javaSignatureVariance = variance = JavaSignatureVariance.NO_VARIANCE;
            }
        }
        if (advance) {
            signature.next();
        }
        return variance;
    }

    private final int parseDimensions(CharacterIterator signature) {
        int dimensions = 0;
        while (signature.current() == '[') {
            ++dimensions;
            signature.next();
        }
        return dimensions;
    }

    @NotNull
    public final JavaType parseTypeString(@NotNull CharacterIterator signature, @NotNull ClassifierResolutionContext context) {
        Intrinsics.checkParameterIsNotNull((Object)signature, (String)"signature");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        int dimensions = this.parseDimensions(signature);
        JavaType javaType = this.parseTypeWithoutVarianceAndArray(signature, context);
        if (javaType == null) {
            throw (Throwable)new ClsFormatException(null, null, 3, null);
        }
        JavaType type2 = javaType;
        int n = 1;
        Iterable $receiver$iv = (Iterable)new IntRange(n, dimensions);
        JavaType accumulator$iv = type2;
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int n2 = element$iv = ((IntIterator)iterator2).nextInt();
            JavaType result2 = accumulator$iv;
            accumulator$iv = new PlainJavaArrayType(result2);
        }
        return accumulator$iv;
    }

    @NotNull
    public final JavaType mapAsmType(@NotNull Type type2, @NotNull ClassifierResolutionContext context) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.parseTypeString(new StringCharacterIterator(type2.getDescriptor()), context);
    }

    private final JavaType parseTypeWithoutVarianceAndArray(CharacterIterator signature, ClassifierResolutionContext context) {
        JavaType javaType;
        switch (signature.current()) {
            case 'L': {
                javaType = this.parseParameterizedClassRefSignature(signature, context);
                break;
            }
            case 'T': {
                javaType = this.parseTypeVariableRefSignature(signature, context);
                break;
            }
            case 'B': {
                javaType = this.parsePrimitiveType(signature, PrimitiveType.BYTE);
                break;
            }
            case 'C': {
                javaType = this.parsePrimitiveType(signature, PrimitiveType.CHAR);
                break;
            }
            case 'D': {
                javaType = this.parsePrimitiveType(signature, PrimitiveType.DOUBLE);
                break;
            }
            case 'F': {
                javaType = this.parsePrimitiveType(signature, PrimitiveType.FLOAT);
                break;
            }
            case 'I': {
                javaType = this.parsePrimitiveType(signature, PrimitiveType.INT);
                break;
            }
            case 'J': {
                javaType = this.parsePrimitiveType(signature, PrimitiveType.LONG);
                break;
            }
            case 'Z': {
                javaType = this.parsePrimitiveType(signature, PrimitiveType.BOOLEAN);
                break;
            }
            case 'S': {
                javaType = this.parsePrimitiveType(signature, PrimitiveType.SHORT);
                break;
            }
            case 'V': {
                javaType = this.parsePrimitiveType(signature, null);
                break;
            }
            default: {
                javaType = null;
            }
        }
        return javaType;
    }

    private final JavaType parsePrimitiveType(CharacterIterator signature, PrimitiveType primitiveType) {
        signature.next();
        return new PlainJavaPrimitiveType(primitiveType);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser$JavaSignatureVariance;", "", "(Ljava/lang/String;I)V", "PLUS", "MINUS", "STAR", "NO_VARIANCE", "frontend.java"})
    private static final class JavaSignatureVariance
    extends Enum<JavaSignatureVariance> {
        public static final /* enum */ JavaSignatureVariance PLUS;
        public static final /* enum */ JavaSignatureVariance MINUS;
        public static final /* enum */ JavaSignatureVariance STAR;
        public static final /* enum */ JavaSignatureVariance NO_VARIANCE;
        private static final /* synthetic */ JavaSignatureVariance[] $VALUES;

        static {
            JavaSignatureVariance[] javaSignatureVarianceArray = new JavaSignatureVariance[4];
            JavaSignatureVariance[] javaSignatureVarianceArray2 = javaSignatureVarianceArray;
            javaSignatureVarianceArray[0] = PLUS = new JavaSignatureVariance();
            javaSignatureVarianceArray[1] = MINUS = new JavaSignatureVariance();
            javaSignatureVarianceArray[2] = STAR = new JavaSignatureVariance();
            javaSignatureVarianceArray[3] = NO_VARIANCE = new JavaSignatureVariance();
            $VALUES = javaSignatureVarianceArray;
        }

        public static JavaSignatureVariance[] values() {
            return (JavaSignatureVariance[])$VALUES.clone();
        }

        public static JavaSignatureVariance valueOf(String string) {
            return Enum.valueOf(JavaSignatureVariance.class, string);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser$ClsFormatException;", "", "message", "", "cause", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "frontend.java"})
    public static final class ClsFormatException
    extends Throwable {
        public ClsFormatException(@Nullable String message, @Nullable Throwable cause) {
            super(message, cause);
        }

        public /* synthetic */ ClsFormatException(String string, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string, throwable);
        }

        public ClsFormatException() {
            this(null, null, 3, null);
        }
    }
}

