/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.PluginException;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.LoadDescriptorsContext;
import com.intellij.ide.plugins.PluginXmlPathResolver;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionInstantiationException;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SafeJdomFactory;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.serialization.SerializationException;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.FilteredTraverserBase;
import com.intellij.util.containers.Interner;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.util.xmlb.JDOMXIncluder;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jdom.JDOMException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginManagerCore {
    public static final PluginId CORE_ID = PluginId.getId("com.intellij");
    private static final PluginId JAVA_PLUGIN_ID = PluginId.getId("com.intellij.java");
    private static final PluginId JAVA_MODULE_ID = PluginId.getId("com.intellij.modules.java");
    private static final PluginId ALL_MODULES_MARKER = PluginId.getId("com.intellij.modules.all");
    public static String BUILD_NUMBER;
    private static final TObjectIntHashMap<PluginId> ourId2Index;
    private static Set<String> ourDisabledPlugins;
    private static Reference<Map<String, Set<String>>> ourBrokenPluginVersions;
    private static volatile IdeaPluginDescriptorImpl[] ourPlugins;
    private static List<IdeaPluginDescriptor> ourLoadedPlugins;
    public static volatile boolean isUnitTestMode;
    private static boolean ourUnitTestWithBundledPlugins;
    @ApiStatus.Internal
    public static String ourPluginError;
    @ApiStatus.Internal
    public static Set<String> ourPlugins2Disable;
    @ApiStatus.Internal
    public static Set<String> ourPlugins2Enable;
    private static final List<Runnable> ourDisabledPluginsListeners;

    @NotNull
    public static IdeaPluginDescriptor[] getPlugins() {
        IdeaPluginDescriptorImpl[] result2 = ourPlugins;
        IdeaPluginDescriptor[] ideaPluginDescriptorArray = result2 == null ? PluginManagerCore.initPlugins(null) : result2;
        if (ideaPluginDescriptorArray == null) {
            PluginManagerCore.$$$reportNull$$$0(0);
        }
        return ideaPluginDescriptorArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDisabledPlugins(@NotNull String configPath, @NotNull Collection<String> disabledPlugins) {
        File file2;
        if (configPath == null) {
            PluginManagerCore.$$$reportNull$$$0(3);
        }
        if (disabledPlugins == null) {
            PluginManagerCore.$$$reportNull$$$0(4);
        }
        if ((file2 = new File(configPath, "disabled_plugins.txt")).isFile()) {
            ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
            List<String> requiredPlugins = StringUtil.split(System.getProperty("idea.required.plugins.id", ""), ",");
            try {
                boolean updateDisablePluginsList = false;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), StandardCharsets.UTF_8));){
                    String id;
                    while ((id = reader.readLine()) != null) {
                        if (!requiredPlugins.contains(id = id.trim()) && !appInfo.isEssentialPlugin(id)) {
                            disabledPlugins.add(id);
                            continue;
                        }
                        updateDisablePluginsList = true;
                    }
                }
                finally {
                    if (updateDisablePluginsList) {
                        PluginManagerCore.savePluginsList(disabledPlugins, false, file2);
                        PluginManagerCore.fireEditDisablePlugins();
                    }
                }
            }
            catch (IOException e) {
                PluginManagerCore.getLogger().info("Unable to load disabled plugins list from " + file2, e);
            }
        }
    }

    public static void dontLoadDisabledPlugins() {
        ourDisabledPlugins = Collections.emptySet();
    }

    private static void loadDisabledPlugins() {
        if (ourDisabledPlugins == null) {
            ourDisabledPlugins = new LinkedHashSet<String>();
            if (System.getProperty("idea.ignore.disabled.plugins") == null) {
                PluginManagerCore.loadDisabledPlugins(PathManager.getConfigPath(), ourDisabledPlugins);
            }
        }
    }

    @NotNull
    public static Collection<String> disabledPlugins() {
        PluginManagerCore.loadDisabledPlugins();
        Collection<String> collection = Collections.unmodifiableCollection(ourDisabledPlugins);
        if (collection == null) {
            PluginManagerCore.$$$reportNull$$$0(5);
        }
        return collection;
    }

    public static boolean isDisabled(@NotNull String pluginId) {
        if (pluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(6);
        }
        PluginManagerCore.loadDisabledPlugins();
        return ourDisabledPlugins.contains(pluginId);
    }

    public static boolean isBrokenPlugin(@NotNull IdeaPluginDescriptor descriptor2) {
        PluginId pluginId;
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(7);
        }
        if ((pluginId = descriptor2.getPluginId()) == null) {
            return true;
        }
        Set<String> set = PluginManagerCore.getBrokenPluginVersions().get(pluginId.getIdString());
        return set != null && set.contains(descriptor2.getVersion());
    }

    @NotNull
    private static Map<String, Set<String>> getBrokenPluginVersions() {
        Map<String, Set<String>> result2 = com.intellij.reference.SoftReference.dereference(ourBrokenPluginVersions);
        if (result2 != null) {
            Map<String, Set<String>> map2 = result2;
            if (map2 == null) {
                PluginManagerCore.$$$reportNull$$$0(8);
            }
            return map2;
        }
        result2 = new HashMap<String, Set<String>>();
        if (System.getProperty("idea.ignore.disabled.plugins") == null) {
            try (InputStream resource = PluginManagerCore.class.getResourceAsStream("/brokenPlugins.txt");
                 BufferedReader br = new BufferedReader(new InputStreamReader(resource, StandardCharsets.UTF_8));){
                String s;
                while ((s = br.readLine()) != null) {
                    List<String> tokens;
                    if ((s = s.trim()).startsWith("//") || (tokens = ParametersListUtil.parse(s)).isEmpty()) continue;
                    if (tokens.size() == 1) {
                        throw new RuntimeException("brokenPlugins.txt is broken. The line contains plugin name, but does not contains version: " + s);
                    }
                    String pluginId = tokens.get(0);
                    List<String> versions2 = tokens.subList(1, tokens.size());
                    Set<String> set = result2.get(pluginId);
                    if (set == null) {
                        set = new HashSet<String>();
                        result2.put(pluginId, set);
                    }
                    set.addAll(versions2);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read /brokenPlugins.txt", e);
            }
        }
        ourBrokenPluginVersions = new SoftReference<Map<String, Set<String>>>(result2);
        Map<String, Set<String>> map3 = result2;
        if (map3 == null) {
            PluginManagerCore.$$$reportNull$$$0(9);
        }
        return map3;
    }

    private static void fireEditDisablePlugins() {
        for (Runnable listener : ourDisabledPluginsListeners) {
            listener.run();
        }
    }

    public static void savePluginsList(@NotNull Collection<String> ids, boolean append2, @NotNull File plugins) throws IOException {
        if (ids == null) {
            PluginManagerCore.$$$reportNull$$$0(12);
        }
        if (plugins == null) {
            PluginManagerCore.$$$reportNull$$$0(13);
        }
        if (!plugins.isFile()) {
            FileUtil.ensureCanCreateFile(plugins);
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(plugins, append2), StandardCharsets.UTF_8));){
            PluginManagerCore.writePluginsList(ids, writer);
        }
    }

    public static void writePluginsList(@NotNull Collection<String> ids, @NotNull Writer writer) throws IOException {
        if (ids == null) {
            PluginManagerCore.$$$reportNull$$$0(14);
        }
        if (writer == null) {
            PluginManagerCore.$$$reportNull$$$0(15);
        }
        Object[] sortedIds = ArrayUtil.toStringArray(ids);
        Arrays.sort(sortedIds);
        String separator = LineSeparator.getSystemLineSeparator().getSeparatorString();
        for (Object id : sortedIds) {
            writer.write((String)id);
            writer.write(separator);
        }
    }

    public static boolean isModuleDependency(@NotNull PluginId dependentPluginId) {
        if (dependentPluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(22);
        }
        return dependentPluginId.getIdString().startsWith("com.intellij.module");
    }

    @Nullable
    public static PluginId getPluginByClassName(@NotNull String className2) {
        PluginId id;
        if (className2 == null) {
            PluginManagerCore.$$$reportNull$$$0(25);
        }
        return (id = PluginManagerCore.getPluginOrPlatformByClassName(className2)) == null || CORE_ID == id ? null : id;
    }

    @Nullable
    public static PluginId getPluginOrPlatformByClassName(@NotNull String className2) {
        if (className2 == null) {
            PluginManagerCore.$$$reportNull$$$0(26);
        }
        if (className2.startsWith("java.") || className2.startsWith("javax.") || className2.startsWith("kotlin.") || className2.startsWith("groovy.")) {
            return null;
        }
        PluginDescriptor result2 = null;
        for (IdeaPluginDescriptor o : PluginManagerCore.getPlugins()) {
            if (!PluginManagerCore.hasLoadedClass(className2, o.getPluginClassLoader())) continue;
            result2 = o;
            break;
        }
        if (result2 == null) {
            return null;
        }
        if (CORE_ID != result2.getPluginId() || className2.startsWith("com.jetbrains.") || className2.startsWith("org.jetbrains.") || className2.startsWith("com.intellij.") || className2.startsWith("org.intellij.") || className2.startsWith("com.android.") || className2.startsWith("git4idea.") || className2.startsWith("org.angularjs.")) {
            return result2.getPluginId();
        }
        String root2 = PathManager.getResourceRoot(result2.getPluginClassLoader(), "/" + className2.replace('.', '/') + ".class");
        if (root2 == null) {
            return null;
        }
        for (IdeaPluginDescriptor o : PluginManagerCore.getPlugins()) {
            String pluginPath;
            if (!o.getUseIdeaClassLoader()) continue;
            File path2 = o.getPath();
            String string2 = pluginPath = path2 == null ? null : FileUtil.toSystemIndependentName(path2.getPath());
            if (pluginPath == null || !root2.startsWith(pluginPath)) continue;
            result2 = o;
            break;
        }
        return result2.getPluginId();
    }

    private static boolean hasLoadedClass(@NotNull String className2, ClassLoader loader) {
        if (className2 == null) {
            PluginManagerCore.$$$reportNull$$$0(27);
        }
        if (loader instanceof UrlClassLoader) {
            return ((UrlClassLoader)loader).hasLoadedClass(className2);
        }
        try {
            return (Boolean)loader.getClass().getMethod("hasLoadedClass", String.class).invoke((Object)loader, className2);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Nullable
    private static PluginId getImplicitDependency(@NotNull IdeaPluginDescriptor descriptor2, @NotNull Map<PluginId, ? extends IdeaPluginDescriptor> idMap) {
        PluginId id;
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(28);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(29);
        }
        if ((id = descriptor2.getPluginId()) == CORE_ID || id == JAVA_PLUGIN_ID || "JetBrains".equals(descriptor2.getVendor()) || !idMap.containsKey(ALL_MODULES_MARKER) || !idMap.containsKey(JAVA_MODULE_ID)) {
            return null;
        }
        boolean isLegacyPlugin = !PluginManagerCore.hasModuleDependencies(descriptor2);
        boolean isCustomPlugin = !descriptor2.isBundled();
        return isLegacyPlugin || isCustomPlugin ? JAVA_MODULE_ID : null;
    }

    private static boolean hasModuleDependencies(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(30);
        }
        for (PluginId depId : descriptor2.getDependentPluginIds()) {
            if (!PluginManagerCore.isModuleDependency(depId)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldLoadPlugins() {
        try {
            Class.forName("com.intellij.openapi.extensions.Extensions");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        String loadPlugins = System.getProperty("idea.load.plugins");
        return loadPlugins == null || Boolean.TRUE.toString().equals(loadPlugins);
    }

    @Nullable
    private static ClassLoader createPluginClassLoader(@NotNull File[] classPath2, @NotNull ClassLoader[] parentLoaders, @NotNull IdeaPluginDescriptor descriptor2) {
        if (classPath2 == null) {
            PluginManagerCore.$$$reportNull$$$0(31);
        }
        if (parentLoaders == null) {
            PluginManagerCore.$$$reportNull$$$0(32);
        }
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(33);
        }
        if (isUnitTestMode && !ourUnitTestWithBundledPlugins) {
            return null;
        }
        if (descriptor2.getUseIdeaClassLoader()) {
            PluginManagerCore.getLogger().warn(descriptor2.getPluginId() + " uses deprecated `use-idea-classloader` attribute");
            ClassLoader loader = PluginManagerCore.class.getClassLoader();
            try {
                MethodHandle addURL = MethodHandles.lookup().findVirtual(loader.getClass(), "addURL", MethodType.methodType(Void.TYPE, URL.class));
                for (File pathElement : classPath2) {
                    addURL.invoke(loader, PluginManagerCore.classpathElementToUrl(pathElement, descriptor2));
                }
                return loader;
            }
            catch (Throwable t) {
                throw new IllegalStateException("An unexpected core classloader: " + loader.getClass(), t);
            }
        }
        ArrayList<URL> urls = new ArrayList<URL>(classPath2.length);
        for (File pathElement : classPath2) {
            urls.add(PluginManagerCore.classpathElementToUrl(pathElement, descriptor2));
        }
        return new PluginClassLoader(urls, parentLoaders, descriptor2.getPluginId(), descriptor2.getVersion(), descriptor2.getPath());
    }

    private static URL classpathElementToUrl(File cpElement, IdeaPluginDescriptor descriptor2) {
        try {
            return cpElement.toPath().normalize().toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new PluginException("Corrupted path element: `" + cpElement + '`', e, descriptor2.getPluginId());
        }
    }

    private static void logPlugins(@NotNull IdeaPluginDescriptor[] plugins) {
        if (plugins == null) {
            PluginManagerCore.$$$reportNull$$$0(35);
        }
        ArrayList<String> bundled = new ArrayList<String>();
        ArrayList<String> disabled = new ArrayList<String>();
        ArrayList<String> custom = new ArrayList<String>();
        for (IdeaPluginDescriptor descriptor2 : plugins) {
            String version = descriptor2.getVersion();
            String s = descriptor2.getName() + (version != null ? " (" + version + ")" : "");
            if (!descriptor2.isEnabled()) {
                disabled.add(s);
                continue;
            }
            if ("IDEA CORE".equals(descriptor2.getName()) || descriptor2.isBundled()) {
                bundled.add(s);
                continue;
            }
            custom.add(s);
        }
        Collections.sort(bundled);
        Collections.sort(custom);
        Collections.sort(disabled);
        Logger logger = PluginManagerCore.getLogger();
        logger.info("Loaded bundled plugins: " + StringUtil.join(bundled, ", "));
        if (!custom.isEmpty()) {
            logger.info("Loaded custom plugins: " + StringUtil.join(custom, ", "));
        }
        if (!disabled.isEmpty()) {
            logger.info("Disabled plugins: " + StringUtil.join(disabled, ", "));
        }
    }

    @NotNull
    private static ClassLoader[] getParentLoaders(@NotNull IdeaPluginDescriptor descriptor2, @NotNull PluginTraverser traverser) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(36);
        }
        if (traverser == null) {
            PluginManagerCore.$$$reportNull$$$0(37);
        }
        if (isUnitTestMode && !ourUnitTestWithBundledPlugins) {
            return new ClassLoader[0];
        }
        JBIterable<PluginId> dependencies2 = traverser.children(descriptor2.getPluginId());
        LinkedHashSet<ClassLoader> loaders = new LinkedHashSet<ClassLoader>();
        for (PluginId depId : dependencies2) {
            IdeaPluginDescriptor dep = traverser.idMap.get(depId);
            if (dep == null) continue;
            ClassLoader loader = dep.getPluginClassLoader();
            if (loader == null) {
                PluginManagerCore.getLogger().error("Plugin \"" + PluginManagerCore.toPresentableName(descriptor2) + "\" requires missing class loader for " + PluginManagerCore.toPresentableName(dep));
                continue;
            }
            loaders.add(loader);
        }
        ClassLoader[] classLoaderArray = loaders.toArray(new ClassLoader[0]);
        if (classLoaderArray == null) {
            PluginManagerCore.$$$reportNull$$$0(38);
        }
        return classLoaderArray;
    }

    public static boolean isRunningFromSources() {
        return Holder.ourIsRunningFromSources;
    }

    private static void prepareLoadingPluginsErrorMessage(@NotNull List<String> errors) {
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(39);
        }
        PluginManagerCore.prepareLoadingPluginsErrorMessage(errors, Collections.emptyList());
    }

    private static void prepareLoadingPluginsErrorMessage(@NotNull List<String> errors, @NotNull List<String> actions) {
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(40);
        }
        if (actions == null) {
            PluginManagerCore.$$$reportNull$$$0(41);
        }
        if (errors.isEmpty()) {
            return;
        }
        Application app = ApplicationManager.getApplication();
        String title = "Problems found loading plugins:";
        if (app == null || !app.isHeadlessEnvironment() || isUnitTestMode) {
            String errorMessage2 = StringUtil.join(JBIterable.from(errors).map(o -> o + ".").append((String)((Object)actions)), "<p/>");
            ourPluginError = ourPluginError == null ? errorMessage2 : ourPluginError + "<p/>\n" + errorMessage2;
            PluginManagerCore.getLogger().warn(StringUtil.join(JBIterable.of(title).append((String)((Object)errors)), "\n"));
        } else {
            PluginManagerCore.getLogger().error(StringUtil.join(JBIterable.of(title).append((String)((Object)errors)), "\n"));
        }
    }

    private static void checkPluginCycles(@NotNull JBTreeTraverser<PluginId> traverser, @NotNull Map<PluginId, ? extends IdeaPluginDescriptor> idMap, @NotNull List<? super String> errors) {
        if (traverser == null) {
            PluginManagerCore.$$$reportNull$$$0(42);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(43);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(44);
        }
        ArrayList cycles = new ArrayList();
        THashMap countMap = new THashMap(ContainerUtil.identityStrategy());
        HashSet ignored = new HashSet();
        JBIterable dfs = ((JBTreeTraverser)((JBTreeTraverser)traverser.withRoots((Iterable<PluginId>)idMap.keySet())).forceIgnore(ignored::contains)).traverse(TreeTraversal.BI_ORDER_DFS);
        TreeTraversal.TracingIt it = (TreeTraversal.TracingIt)dfs.typedIterator();
        while (it.hasNext()) {
            PluginId pluginId = (PluginId)it.next();
            int[] counter = (int[])countMap.get((Object)pluginId);
            if (counter == null) {
                counter = new int[]{1};
                countMap.put((Object)pluginId, (Object)counter);
            } else {
                counter[0] = counter[0] + 1;
            }
            if (counter[0] % 2 != 0 || !it.isDescending()) continue;
            List backtrace = it.backtrace().skip(1).toList();
            int idx = backtrace.indexOf(pluginId);
            List cycle = backtrace.subList(0, idx + 1);
            cycles.add(cycle);
            ignored.addAll(cycle);
        }
        if (cycles.isEmpty()) {
            return;
        }
        for (PluginId pluginId : JBIterable.from(cycles).flatMap(o -> o)) {
            idMap.get(pluginId).setEnabled(false);
        }
        for (List list2 : cycles) {
            JBIterable<String> names2 = JBIterable.from(list2).map(o -> PluginManagerCore.toPresentableName((IdeaPluginDescriptor)idMap.get(o)));
            String cycleText = StringUtil.join(names2.sort(String::compareTo), ", ");
            errors.add("Plugins " + cycleText + " form a dependency cycle");
        }
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromDir(@NotNull File file2, @NotNull String pathName, @Nullable File pluginPath, @NotNull LoadingContext loadingContext) {
        File descriptorFile;
        if (file2 == null) {
            PluginManagerCore.$$$reportNull$$$0(45);
        }
        if (pathName == null) {
            PluginManagerCore.$$$reportNull$$$0(46);
        }
        if (loadingContext == null) {
            PluginManagerCore.$$$reportNull$$$0(47);
        }
        if (!(descriptorFile = new File(file2, "META-INF/" + pathName)).exists()) {
            return null;
        }
        try {
            IdeaPluginDescriptorImpl descriptor2 = new IdeaPluginDescriptorImpl(ObjectUtils.notNull(pluginPath, file2), loadingContext.isBundled);
            descriptor2.loadFromFile(descriptorFile, loadingContext.getXmlFactory(), isUnitTestMode, loadingContext.ignoreDisabled);
            return descriptor2;
        }
        catch (SerializationException | IOException | JDOMException e) {
            if (loadingContext.isEssential) {
                ExceptionUtil.rethrow(e);
            }
            PluginManagerCore.getLogger().warn("Cannot load " + descriptorFile, e);
            PluginManagerCore.prepareLoadingPluginsErrorMessage(Collections.singletonList("File '" + file2.getName() + "' contains invalid plugin descriptor"));
        }
        catch (Throwable e) {
            if (loadingContext.isEssential) {
                ExceptionUtil.rethrow(e);
            }
            PluginManagerCore.getLogger().warn("Cannot load " + descriptorFile, e);
        }
        return null;
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromJar(@NotNull File file2, @NotNull String fileName, @NotNull JDOMXIncluder.PathResolver pathResolver, @NotNull LoadingContext context2, @Nullable File pluginPath) {
        if (file2 == null) {
            PluginManagerCore.$$$reportNull$$$0(48);
        }
        if (fileName == null) {
            PluginManagerCore.$$$reportNull$$$0(49);
        }
        if (pathResolver == null) {
            PluginManagerCore.$$$reportNull$$$0(50);
        }
        if (context2 == null) {
            PluginManagerCore.$$$reportNull$$$0(51);
        }
        try {
            String entryName = "META-INF/" + fileName;
            URL jarURL = URLUtil.getJarEntryURL(file2, FileUtil.toCanonicalPath(entryName, '/'));
            ZipFile zipFile2 = context2.open(file2);
            ZipEntry entry = zipFile2.getEntry(entryName);
            if (entry != null) {
                IdeaPluginDescriptorImpl descriptor2 = new IdeaPluginDescriptorImpl(ObjectUtils.notNull(pluginPath, file2), context2.isBundled);
                SafeJdomFactory factory2 = context2.getXmlFactory();
                Interner<String> interner = factory2 == null ? null : factory2.stringInterner();
                descriptor2.readExternal(JDOMUtil.load(zipFile2.getInputStream(entry), factory2), jarURL, pathResolver, interner, context2.ignoreDisabled);
                context2.lastZipWithDescriptor = file2;
                return descriptor2;
            }
        }
        catch (InvalidDataException | SerializationException e) {
            if (context2.isEssential) {
                ExceptionUtil.rethrow(e);
            }
            PluginManagerCore.getLogger().info("Cannot load " + file2 + "!/META-INF/" + fileName, e);
            PluginManagerCore.prepareLoadingPluginsErrorMessage(Collections.singletonList("File '" + file2.getName() + "' contains invalid plugin descriptor"));
        }
        catch (Throwable e) {
            if (context2.isEssential) {
                ExceptionUtil.rethrow(e);
            }
            PluginManagerCore.getLogger().info("Cannot load " + file2 + "!/META-INF/" + fileName, e);
        }
        return null;
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptor(@NotNull File file2, @NotNull String fileName, boolean bundled, boolean essential, boolean ignoreDisabled, @Nullable LoadDescriptorsContext parentContext) {
        if (file2 == null) {
            PluginManagerCore.$$$reportNull$$$0(56);
        }
        if (fileName == null) {
            PluginManagerCore.$$$reportNull$$$0(57);
        }
        try (LoadingContext context2 = new LoadingContext(parentContext, bundled, essential, ignoreDisabled);){
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = PluginManagerCore.loadDescriptor(file2, fileName, context2);
            return ideaPluginDescriptorImpl;
        }
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptor(@NotNull File file2, @NotNull String pathName, @NotNull LoadingContext context2) {
        if (file2 == null) {
            PluginManagerCore.$$$reportNull$$$0(58);
        }
        if (pathName == null) {
            PluginManagerCore.$$$reportNull$$$0(59);
        }
        if (context2 == null) {
            PluginManagerCore.$$$reportNull$$$0(60);
        }
        IdeaPluginDescriptorImpl descriptor2 = null;
        boolean isDirectory = file2.isDirectory();
        if (isDirectory) {
            descriptor2 = PluginManagerCore.loadDescriptorFromDir(file2, pathName, null, context2);
            if (descriptor2 == null) {
                File[] files2 = new File(file2, "lib").listFiles();
                if (files2 == null || files2.length == 0) {
                    return null;
                }
                PluginManagerCore.putMoreLikelyPluginJarsFirst(file2, files2);
                List<File> pluginJarFiles = null;
                for (File f : files2) {
                    if (f.isDirectory()) {
                        IdeaPluginDescriptorImpl descriptor1 = PluginManagerCore.loadDescriptorFromDir(f, pathName, file2, context2);
                        if (descriptor1 == null) continue;
                        if (descriptor2 != null) {
                            PluginManagerCore.getLogger().info("Cannot load " + file2 + " because two or more plugin.xml's detected");
                            return null;
                        }
                        descriptor2 = descriptor1;
                        continue;
                    }
                    if (!FileUtilRt.isJarOrZip(f, false)) continue;
                    if (files2.length == 1) {
                        pluginJarFiles = Collections.singletonList(f);
                        continue;
                    }
                    if (pluginJarFiles == null) {
                        pluginJarFiles = new ArrayList<File>();
                    }
                    pluginJarFiles.add(f);
                }
                if (pluginJarFiles != null) {
                    File jarFile;
                    PluginXmlPathResolver pathResolver = new PluginXmlPathResolver(files2);
                    Iterator iterator2 = pluginJarFiles.iterator();
                    while (iterator2.hasNext() && (descriptor2 = PluginManagerCore.loadDescriptorFromJar(jarFile = (File)iterator2.next(), pathName, pathResolver, context2, file2)) == null) {
                    }
                }
            }
        } else if (StringUtilRt.endsWithIgnoreCase(file2.getPath(), ".jar")) {
            descriptor2 = PluginManagerCore.loadDescriptorFromJar(file2, pathName, JDOMXIncluder.DEFAULT_PATH_RESOLVER, context2, null);
        }
        if (descriptor2 == null) {
            return null;
        }
        if ("plugin.xml".equals(pathName) && (descriptor2.getPluginId() == null || descriptor2.getName() == null)) {
            PluginManagerCore.getLogger().info("Cannot load descriptor from " + file2 + ": ID or name missing");
            PluginManagerCore.prepareLoadingPluginsErrorMessage(Collections.singletonList("'" + file2.getName() + "' contains invalid plugin descriptor"));
            return null;
        }
        context2.visitedFiles.add(Pair.create(pathName, descriptor2));
        PluginManagerCore.resolveOptionalDescriptors(descriptor2, context2, optPathName -> {
            URL resource;
            IdeaPluginDescriptorImpl optionalDescriptor = null;
            if (context2.lastZipWithDescriptor != null) {
                optionalDescriptor = PluginManagerCore.loadDescriptor(context2.lastZipWithDescriptor, optPathName, context2);
            }
            if (optionalDescriptor == null) {
                optionalDescriptor = PluginManagerCore.loadDescriptor(file2, optPathName, context2);
            }
            if (optionalDescriptor == null && (isDirectory || PluginManagerCore.resolveDescriptorsInResources()) && (resource = PluginManagerCore.class.getClassLoader().getResource("META-INF/" + optPathName)) != null) {
                optionalDescriptor = PluginManagerCore.loadDescriptorFromResource(resource, optPathName, context2.isBundled, false, context2.ignoreDisabled, context2.parentContext);
            }
            return optionalDescriptor;
        });
        context2.visitedFiles.remove(context2.visitedFiles.size() - 1);
        return descriptor2;
    }

    private static boolean resolveDescriptorsInResources() {
        return System.getProperty("resolve.descriptors.in.resources") != null;
    }

    private static void putMoreLikelyPluginJarsFirst(File pluginDir, File[] filesInLibUnderPluginDir) {
        String pluginDirName = pluginDir.getName();
        Arrays.parallelSort(filesInLibUnderPluginDir, (o1, o2) -> {
            boolean o1StartsWithNeededName;
            boolean o1IsVersioned;
            boolean o1StartsWithResources;
            String o2Name = o2.getName();
            String o1Name = o1.getName();
            boolean o2StartsWithResources = o2Name.startsWith("resources");
            if (o2StartsWithResources != (o1StartsWithResources = o1Name.startsWith("resources"))) {
                return o2StartsWithResources ? -1 : 1;
            }
            boolean o2IsVersioned = PluginManagerCore.fileNameIsLikeVersionedLibraryName(o2Name);
            if (o2IsVersioned != (o1IsVersioned = PluginManagerCore.fileNameIsLikeVersionedLibraryName(o1Name))) {
                return o2IsVersioned ? -1 : 1;
            }
            boolean o2StartsWithNeededName = StringUtil.startsWithIgnoreCase(o2Name, pluginDirName);
            if (o2StartsWithNeededName != (o1StartsWithNeededName = StringUtil.startsWithIgnoreCase(o1Name, pluginDirName))) {
                return o2StartsWithNeededName ? 1 : -1;
            }
            return o1Name.length() - o2Name.length();
        });
    }

    private static boolean fileNameIsLikeVersionedLibraryName(String name) {
        int i = name.lastIndexOf(45);
        if (i == -1) {
            return false;
        }
        if (i + 1 < name.length()) {
            char c = name.charAt(i + 1);
            if (Character.isDigit(c)) {
                return true;
            }
            return (c == 'm' || c == 'M') && i + 2 < name.length() && Character.isDigit(name.charAt(i + 2));
        }
        return false;
    }

    private static void resolveOptionalDescriptors(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull LoadingContext context2, @NotNull Function<? super String, IdeaPluginDescriptorImpl> optionalDescriptorLoader) {
        Map<PluginId, List<String>> optionalConfigs;
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(61);
        }
        if (context2 == null) {
            PluginManagerCore.$$$reportNull$$$0(62);
        }
        if (optionalDescriptorLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(63);
        }
        if ((optionalConfigs = descriptor2.getOptionalConfigs()) == null || optionalConfigs.isEmpty()) {
            return;
        }
        LinkedHashMap<PluginId, List<IdeaPluginDescriptorImpl>> descriptors = new LinkedHashMap<PluginId, List<IdeaPluginDescriptorImpl>>(optionalConfigs.size());
        for (Map.Entry<PluginId, List<String>> entry : optionalConfigs.entrySet()) {
            for (String configFile : entry.getValue()) {
                int idx = ContainerUtil.indexOf(context2.visitedFiles, o -> ((String)o.getFirst()).equals(configFile));
                if (idx != -1) {
                    List<Pair<String, IdeaPluginDescriptorImpl>> cycle = context2.visitedFiles.subList(idx, context2.visitedFiles.size());
                    PluginManagerCore.getLogger().info("Plugin " + PluginManagerCore.toPresentableName((IdeaPluginDescriptor)context2.visitedFiles.get((int)0).second) + " optional descriptors form a cycle: " + StringUtil.join(cycle, o -> (String)o.getFirst(), ", "));
                    continue;
                }
                IdeaPluginDescriptorImpl optionalDescriptor = optionalDescriptorLoader.fun(configFile);
                if (optionalDescriptor == null) {
                    PluginManagerCore.getLogger().info("Plugin " + PluginManagerCore.toPresentableName(descriptor2) + " misses optional descriptor " + configFile);
                    continue;
                }
                descriptors.computeIfAbsent(entry.getKey(), it -> new SmartList()).add(optionalDescriptor);
            }
        }
        descriptor2.setOptionalDescriptors(descriptors);
    }

    private static void loadDescriptorsFromDir(@NotNull File dir, @NotNull List<IdeaPluginDescriptorImpl> result2, boolean bundled, @NotNull LoadDescriptorsContext context2) throws ExecutionException, InterruptedException {
        File[] files2;
        if (dir == null) {
            PluginManagerCore.$$$reportNull$$$0(64);
        }
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(65);
        }
        if (context2 == null) {
            PluginManagerCore.$$$reportNull$$$0(66);
        }
        if ((files2 = dir.listFiles()) == null || files2.length == 0) {
            return;
        }
        THashSet existingResults = new THashSet(result2);
        ArrayList<Future<IdeaPluginDescriptorImpl>> tasks = new ArrayList<Future<IdeaPluginDescriptorImpl>>(files2.length);
        for (File file2 : files2) {
            tasks.add(context2.getExecutorService().submit(() -> PluginManagerCore.loadDescriptor(file2, "plugin.xml", bundled, false, false, context2)));
        }
        for (Future future : tasks) {
            boolean newer;
            IdeaPluginDescriptorImpl descriptor2 = (IdeaPluginDescriptorImpl)future.get();
            if (descriptor2 == null) continue;
            if (existingResults.add(descriptor2)) {
                result2.add(descriptor2);
                continue;
            }
            int prevIndex = result2.indexOf(descriptor2);
            IdeaPluginDescriptor prevDescriptor = result2.get(prevIndex);
            boolean compatible = PluginManagerCore.isCompatible(descriptor2);
            boolean prevCompatible = PluginManagerCore.isCompatible(prevDescriptor);
            boolean bl = newer = VersionComparatorUtil.compare(descriptor2.getVersion(), prevDescriptor.getVersion()) > 0;
            if ((!compatible || prevCompatible) && (compatible != prevCompatible || !newer)) continue;
            result2.set(prevIndex, descriptor2);
            PluginManagerCore.getLogger().info(descriptor2.getPath() + " overrides " + prevDescriptor.getPath());
        }
    }

    private static void prepareLoadingPluginsErrorMessage(@NotNull Map<PluginId, String> disabledIds, @NotNull Set<? extends PluginId> disabledRequiredIds, @NotNull Map<PluginId, ? extends IdeaPluginDescriptor> idMap, @NotNull List<String> errors) {
        if (disabledIds == null) {
            PluginManagerCore.$$$reportNull$$$0(67);
        }
        if (disabledRequiredIds == null) {
            PluginManagerCore.$$$reportNull$$$0(68);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(69);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(70);
        }
        ArrayList<String> actions = new ArrayList<String>();
        if (!disabledIds.isEmpty()) {
            String text2 = "<br><a href=\"disable\">Disable ";
            if (disabledIds.size() == 1) {
                PluginId id = disabledIds.keySet().iterator().next();
                text2 = text2 + (idMap.containsKey(id) ? PluginManagerCore.toPresentableName(idMap.get(id)) : PluginManagerCore.toPresentableName(id.getIdString()));
            } else {
                text2 = text2 + "not loaded plugins";
            }
            actions.add(text2 + "</a>");
            if (!disabledRequiredIds.isEmpty()) {
                String name = disabledRequiredIds.size() == 1 ? PluginManagerCore.toPresentableName(idMap.get(disabledRequiredIds.iterator().next())) : "all necessary plugins";
                actions.add("<a href=\"enable\">Enable " + name + "</a>");
            }
            actions.add("<a href=\"edit\">Open plugin manager</a>");
        }
        PluginManagerCore.prepareLoadingPluginsErrorMessage(errors, actions);
    }

    private static void loadDescriptorsFromClassPath(@NotNull Map<URL, String> urls, @NotNull List<IdeaPluginDescriptorImpl> result2, @NotNull LoadDescriptorsContext context2, @Nullable URL platformPluginURL) throws ExecutionException, InterruptedException {
        if (urls == null) {
            PluginManagerCore.$$$reportNull$$$0(72);
        }
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(73);
        }
        if (context2 == null) {
            PluginManagerCore.$$$reportNull$$$0(74);
        }
        if (urls.isEmpty()) {
            return;
        }
        ArrayList<Future<IdeaPluginDescriptorImpl>> tasks = new ArrayList<Future<IdeaPluginDescriptorImpl>>(urls.size());
        for (Map.Entry<URL, String> entry : urls.entrySet()) {
            URL uRL = entry.getKey();
            tasks.add(context2.getExecutorService().submit(() -> PluginManagerCore.loadDescriptorFromResource(url, (String)entry.getValue(), true, url.equals(platformPluginURL), false, context2)));
        }
        THashSet existingResults = new THashSet(result2);
        for (Future future : tasks) {
            IdeaPluginDescriptorImpl descriptor2 = (IdeaPluginDescriptorImpl)future.get();
            if (descriptor2 == null || !existingResults.add(descriptor2)) continue;
            descriptor2.setUseCoreClassLoader(true);
            result2.add(descriptor2);
        }
    }

    @Nullable
    private static URL computePlatformPluginUrlAndCollectPluginUrls(@NotNull ClassLoader loader, @NotNull Map<URL, String> urls) {
        if (loader == null) {
            PluginManagerCore.$$$reportNull$$$0(75);
        }
        if (urls == null) {
            PluginManagerCore.$$$reportNull$$$0(76);
        }
        String platformPrefix = System.getProperty("idea.platform.prefix");
        URL result2 = null;
        if (platformPrefix != null) {
            String fileName = platformPrefix + "Plugin.xml";
            URL resource = loader.getResource("META-INF/" + fileName);
            if (resource != null) {
                urls.put(resource, fileName);
                result2 = resource;
            }
        }
        try {
            Enumeration<URL> enumeration = loader.getResources("META-INF/plugin.xml");
            while (enumeration.hasMoreElements()) {
                urls.put(enumeration.nextElement(), "plugin.xml");
            }
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().info(e);
        }
        return result2;
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromResource(@NotNull URL resource, @NotNull String pathName, boolean bundled, boolean essential, boolean ignoreDisabled, @Nullable LoadDescriptorsContext parentContext) {
        if (resource == null) {
            PluginManagerCore.$$$reportNull$$$0(77);
        }
        if (pathName == null) {
            PluginManagerCore.$$$reportNull$$$0(78);
        }
        try {
            if ("file".equals(resource.getProtocol())) {
                File descriptorFile = PluginManagerCore.urlToFile(resource);
                String pathname = StringUtil.trimEnd(FileUtil.toSystemIndependentName(descriptorFile.getPath()), pathName);
                File pluginDir = new File(pathname).getParentFile();
                return PluginManagerCore.loadDescriptor(pluginDir, pathName, bundled, essential, ignoreDisabled, parentContext);
            }
            if ("jar".equals(resource.getProtocol())) {
                String path2 = resource.getFile();
                File pluginJar = PluginManagerCore.urlToFile(new URL(path2.substring(0, path2.indexOf("!/"))));
                return PluginManagerCore.loadDescriptor(pluginJar, pathName, bundled, essential, ignoreDisabled, parentContext);
            }
        }
        catch (Throwable e) {
            if (essential) {
                ExceptionUtil.rethrow(e);
            }
            PluginManagerCore.getLogger().info("Cannot load " + resource, e);
        }
        return null;
    }

    private static File urlToFile(URL url) throws URISyntaxException, MalformedURLException {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            String str = url.toString();
            if (str.indexOf(32) > 0) {
                return new File(new URL(StringUtil.replace(str, " ", "%20")).toURI());
            }
            throw e;
        }
    }

    private static void loadDescriptorsFromProperty(@NotNull List<? super IdeaPluginDescriptorImpl> result2, @NotNull LoadDescriptorsContext context2) {
        String pathProperty;
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(79);
        }
        if (context2 == null) {
            PluginManagerCore.$$$reportNull$$$0(80);
        }
        if ((pathProperty = System.getProperty("plugin.path")) == null) {
            return;
        }
        StringTokenizer t = new StringTokenizer(pathProperty, File.pathSeparator + ",");
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            IdeaPluginDescriptorImpl ideaPluginDescriptor = PluginManagerCore.loadDescriptor(new File(s), "plugin.xml", false, false, false, context2);
            if (ideaPluginDescriptor == null) continue;
            result2.add(ideaPluginDescriptor);
        }
    }

    @NotNull
    public static IdeaPluginDescriptorImpl[] loadDescriptors() {
        ArrayList<IdeaPluginDescriptorImpl> result2 = new ArrayList<IdeaPluginDescriptorImpl>();
        LinkedHashMap<URL, String> urlsFromClassPath = new LinkedHashMap<URL, String>();
        URL platformPluginURL = PluginManagerCore.computePlatformPluginUrlAndCollectPluginUrls(PluginManagerCore.class.getClassLoader(), urlsFromClassPath);
        boolean parallel = SystemProperties.getBooleanProperty("parallel.pluginDescriptors.loading", true);
        try (LoadDescriptorsContext context2 = new LoadDescriptorsContext(parallel);){
            PluginManagerCore.loadDescriptorsFromProperty(result2, context2);
            PluginManagerCore.loadDescriptorsFromClassPath(urlsFromClassPath, result2, context2, platformPluginURL);
            PluginManagerCore.loadDescriptorsFromDir(new File(PathManager.getPluginsPath()), result2, false, context2);
            if (!isUnitTestMode) {
                PluginManagerCore.loadDescriptorsFromDir(new File(PathManager.getPreInstalledPluginsPath()), result2, true, context2);
            }
            if (isUnitTestMode && result2.size() <= 1) {
                ourUnitTestWithBundledPlugins = true;
                PluginManagerCore.loadDescriptorsFromDir(new File(PathManager.getPreInstalledPluginsPath()), result2, true, context2);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            ExceptionUtil.rethrow(e);
        }
        result2.sort((o1, o2) -> Comparing.compare(String.valueOf(o1.getPluginId()), String.valueOf(o2.getPluginId())));
        IdeaPluginDescriptorImpl[] ideaPluginDescriptorImplArray = result2.toArray(IdeaPluginDescriptorImpl.EMPTY_ARRAY);
        if (ideaPluginDescriptorImplArray == null) {
            PluginManagerCore.$$$reportNull$$$0(81);
        }
        return ideaPluginDescriptorImplArray;
    }

    private static void mergeOptionalConfigs(@NotNull List<IdeaPluginDescriptorImpl> result2, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap) {
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(82);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(83);
        }
        Condition<PluginId> enabledCondition = depId -> {
            IdeaPluginDescriptorImpl dep = (IdeaPluginDescriptorImpl)idMap.get(depId);
            return dep != null && dep.isEnabled();
        };
        for (IdeaPluginDescriptorImpl descriptor2 : result2) {
            for (IdeaPluginDescriptorImpl dep : PluginManagerCore.optionalDescriptorRecursively(descriptor2, enabledCondition)) {
                boolean requiredDepMissing = false;
                for (PluginId depId2 : dep.getDependentPluginIds()) {
                    if (enabledCondition.value(depId2) || ArrayUtil.indexOf(dep.getOptionalDependentPluginIds(), depId2) != -1) continue;
                    requiredDepMissing = true;
                    break;
                }
                if (requiredDepMissing) continue;
                descriptor2.mergeOptionalConfig(dep);
            }
        }
        for (IdeaPluginDescriptorImpl descriptor2 : result2) {
            descriptor2.setOptionalDescriptors(null);
        }
    }

    @ApiStatus.Internal
    public static void initClassLoader(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull ClassLoader coreLoader, @NotNull JBTreeTraverser<PluginId> traverser) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(84);
        }
        if (coreLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(85);
        }
        if (traverser == null) {
            PluginManagerCore.$$$reportNull$$$0(86);
        }
        File[] classPath2 = descriptor2.getClassPath().toArray(ArrayUtilRt.EMPTY_FILE_ARRAY);
        ClassLoader[] parentLoaders = PluginManagerCore.getParentLoaders(descriptor2, (PluginTraverser)traverser);
        if (parentLoaders.length == 0) {
            parentLoaders = new ClassLoader[]{coreLoader};
        }
        descriptor2.setLoader(PluginManagerCore.createPluginClassLoader(classPath2, parentLoaders, descriptor2));
    }

    private static void initClassLoaderForDisabledPlugin(@NotNull ClassLoader parentLoader, @NotNull IdeaPluginDescriptorImpl descriptor2) {
        if (parentLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(87);
        }
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(88);
        }
        File[] classPath2 = descriptor2.getClassPath().toArray(ArrayUtilRt.EMPTY_FILE_ARRAY);
        descriptor2.setLoader(PluginManagerCore.createPluginClassLoader(classPath2, new ClassLoader[]{parentLoader}, descriptor2));
    }

    static BuildNumber getBuildNumber() {
        return Holder.ourBuildNumber;
    }

    private static void disableIncompatiblePlugins(@NotNull JBTreeTraverser<PluginId> traverser, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap, @NotNull Set<? super PluginId> brokenIds, @NotNull List<? super String> errors) {
        if (traverser == null) {
            PluginManagerCore.$$$reportNull$$$0(89);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(90);
        }
        if (brokenIds == null) {
            PluginManagerCore.$$$reportNull$$$0(91);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(92);
        }
        String selectedIds = System.getProperty("idea.load.plugins.id");
        String selectedCategory = System.getProperty("idea.load.plugins.category");
        boolean shouldLoadPlugins = PluginManagerCore.shouldLoadPlugins();
        LinkedHashSet<IdeaPluginDescriptorImpl> allDescriptors2 = new LinkedHashSet<IdeaPluginDescriptorImpl>(idMap.values());
        IdeaPluginDescriptorImpl coreDescriptor = ObjectUtils.notNull(idMap.get(CORE_ID));
        boolean checkModuleDependencies = !coreDescriptor.getModules().isEmpty() && !coreDescriptor.getModules().contains(ALL_MODULES_MARKER.getIdString());
        Set explicitlyEnabled = null;
        if (selectedIds != null) {
            HashSet<String> set = new HashSet<String>(StringUtil.split(selectedIds, ","));
            set.addAll(((ApplicationInfoImpl)ApplicationInfoImpl.getShadowInstance()).getEssentialPluginsIds());
            explicitlyEnabled = JBIterable.from(allDescriptors2).map(PluginDescriptor::getPluginId).filter(o -> set.contains(o.getIdString())).addAllTo(new LinkedHashSet());
        } else if (selectedCategory != null) {
            explicitlyEnabled = JBIterable.from(allDescriptors2).filter(o -> selectedCategory.equals(o.getCategory())).map(PluginDescriptor::getPluginId).addAllTo(new LinkedHashSet());
        }
        if (explicitlyEnabled != null) {
            ((JBTreeTraverser)((JBTreeTraverser)traverser.withRoots(new ArrayList(explicitlyEnabled))).unique()).traverse().addAllTo(explicitlyEnabled);
        }
        BuildNumber buildNumber = PluginManagerCore.getBuildNumber();
        for (IdeaPluginDescriptor ideaPluginDescriptor : allDescriptors2) {
            String errorSuffix;
            if (ideaPluginDescriptor == coreDescriptor) {
                errorSuffix = null;
            } else if (!ideaPluginDescriptor.isEnabled()) {
                errorSuffix = "is not enabled";
            } else if (explicitlyEnabled != null) {
                if (!explicitlyEnabled.contains(ideaPluginDescriptor.getPluginId())) {
                    errorSuffix = "";
                    PluginManagerCore.getLogger().info("Plugin " + PluginManagerCore.toPresentableName(ideaPluginDescriptor) + " " + (selectedIds != null ? "is not in 'idea.load.plugins.id' system property" : "category doesn't match 'idea.load.plugins.category' system property"));
                } else {
                    errorSuffix = null;
                }
            } else if (!shouldLoadPlugins) {
                errorSuffix = "is skipped (plugins loading disabled)";
            } else if (checkModuleDependencies && !PluginManagerCore.hasModuleDependencies(ideaPluginDescriptor)) {
                errorSuffix = "defines no module dependencies (supported only in IntelliJ IDEA)";
            } else if (PluginManagerCore.isDisabled(ideaPluginDescriptor.getPluginId().getIdString())) {
                errorSuffix = "";
            } else if (PluginManagerCore.isIncompatible(buildNumber, ideaPluginDescriptor.getSinceBuild(), ideaPluginDescriptor.getUntilBuild()) != null) {
                String since = StringUtil.notNullize(ideaPluginDescriptor.getSinceBuild(), "0.0");
                String until = StringUtil.notNullize(ideaPluginDescriptor.getUntilBuild(), "*.*");
                errorSuffix = "is incompatible (target build " + (since.equals(until) ? "is " + since : "range is " + since + " to " + until) + ")";
            } else if (PluginManagerCore.isBrokenPlugin(ideaPluginDescriptor)) {
                errorSuffix = "version was marked as incompatible";
                brokenIds.add(ideaPluginDescriptor.getPluginId());
            } else {
                errorSuffix = null;
            }
            if (errorSuffix == null) continue;
            ideaPluginDescriptor.setEnabled(false);
            if (!StringUtil.isNotEmpty(errorSuffix)) continue;
            errors.add("Plugin " + PluginManagerCore.toPresentableName(ideaPluginDescriptor) + " " + errorSuffix);
        }
    }

    public static boolean isCompatible(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(93);
        }
        return !PluginManagerCore.isIncompatible(descriptor2);
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(95);
        }
        return PluginManagerCore.isIncompatible(descriptor2, PluginManagerCore.getBuildNumber());
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor2, @Nullable BuildNumber buildNumber) {
        String message2;
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(96);
        }
        if (buildNumber == null) {
            buildNumber = PluginManagerCore.getBuildNumber();
        }
        if ((message2 = PluginManagerCore.isIncompatible(buildNumber, descriptor2.getSinceBuild(), descriptor2.getUntilBuild())) != null) {
            PluginManagerCore.getLogger().warn("Plugin " + PluginManagerCore.toPresentableName(descriptor2) + " is incompatible (" + message2 + ")");
            return true;
        }
        return false;
    }

    @Nullable
    static String isIncompatible(@NotNull BuildNumber buildNumber, @Nullable String sinceBuild, @Nullable String untilBuild) {
        if (buildNumber == null) {
            PluginManagerCore.$$$reportNull$$$0(97);
        }
        try {
            BuildNumber untilBuildNumber;
            BuildNumber sinceBuildNumber;
            String message2 = "";
            BuildNumber buildNumber2 = sinceBuildNumber = StringUtil.isEmpty(sinceBuild) ? null : BuildNumber.fromString(sinceBuild, null, null);
            if (sinceBuildNumber != null && sinceBuildNumber.compareTo(buildNumber) > 0) {
                message2 = message2 + "since build " + sinceBuildNumber + " > " + buildNumber;
            }
            BuildNumber buildNumber3 = untilBuildNumber = StringUtil.isEmpty(untilBuild) ? null : BuildNumber.fromString(untilBuild, null, null);
            if (untilBuildNumber != null && untilBuildNumber.compareTo(buildNumber) < 0) {
                if (!message2.isEmpty()) {
                    message2 = message2 + ", ";
                }
                message2 = message2 + "until build " + untilBuildNumber + " < " + buildNumber;
            }
            return StringUtil.nullize(message2);
        }
        catch (Exception e) {
            PluginManagerCore.getLogger().error(e);
            return "version check failed";
        }
    }

    private static void checkEssentialPluginsAreAvailable(@NotNull Collection<? extends IdeaPluginDescriptor> plugins) {
        if (plugins == null) {
            PluginManagerCore.$$$reportNull$$$0(98);
        }
        if (isUnitTestMode) {
            return;
        }
        Set<String> available = ContainerUtil.map2Set(plugins, plugin -> plugin.getPluginId().getIdString());
        List<String> required = ((ApplicationInfoImpl)ApplicationInfoImpl.getShadowInstance()).getEssentialPluginsIds();
        SmartList<String> missing = new SmartList<String>();
        for (String id : required) {
            if (available.contains(id)) continue;
            missing.add(id);
        }
        if (!missing.isEmpty()) {
            throw new EssentialPluginMissingException(missing);
        }
    }

    @ApiStatus.Internal
    @NotNull
    static IdeaPluginDescriptorImpl[] initializePlugins(@NotNull IdeaPluginDescriptorImpl[] descriptors, @NotNull ClassLoader coreLoader, @Nullable PairConsumer<? super Set<String>, ? super Set<String>> disabledAndPossibleToEnableConsumer) {
        if (descriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(99);
        }
        if (coreLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(100);
        }
        ArrayList<String> errors = new ArrayList<String>();
        Map<PluginId, IdeaPluginDescriptorImpl> idMap = PluginManagerCore.buildPluginIdMap(descriptors, errors);
        LinkedHashMap<PluginId, String> disabledIds = new LinkedHashMap<PluginId, String>();
        LinkedHashSet disabledRequiredIds = new LinkedHashSet();
        LinkedHashSet brokenIds = new LinkedHashSet();
        LinkedHashSet<PluginId> enabledIds = new LinkedHashSet<PluginId>();
        PluginTraverser requiredDepsTraverser = new PluginTraverser(idMap, false, false);
        PluginTraverser allDepsTraverser = new PluginTraverser(idMap, true, false);
        PluginManagerCore.disableIncompatiblePlugins(requiredDepsTraverser, idMap, brokenIds, errors);
        PluginManagerCore.checkPluginCycles(allDepsTraverser, idMap, errors);
        JBIterable<IdeaPluginDescriptorImpl> sortedRequired = ((JBTreeTraverser)((JBTreeTraverser)requiredDepsTraverser.withRoots(idMap.keySet())).unique()).traverse(TreeTraversal.POST_ORDER_DFS);
        for (IdeaPluginDescriptorImpl descriptor2 : sortedRequired.filterMap(idMap::get).unique()) {
            boolean wasEnabled = descriptor2.isEnabled();
            if (wasEnabled && PluginManagerCore.computePluginEnabled(descriptor2, enabledIds, idMap, disabledRequiredIds, errors)) {
                enabledIds.add(descriptor2.getPluginId());
                for (String module2 : descriptor2.getModules()) {
                    enabledIds.add(PluginId.getId(module2));
                }
                continue;
            }
            descriptor2.setEnabled(false);
            if (wasEnabled) {
                disabledIds.put(descriptor2.getPluginId(), descriptor2.getName());
            }
            PluginManagerCore.initClassLoaderForDisabledPlugin(coreLoader, descriptor2);
        }
        JBIterable<IdeaPluginDescriptorImpl> sortedAll = ((JBTreeTraverser)((JBTreeTraverser)allDepsTraverser.withRoots(sortedRequired)).unique()).traverse(TreeTraversal.POST_ORDER_DFS);
        JBIterable<IdeaPluginDescriptorImpl> allPlugins = sortedAll.filterMap(idMap::get).unique().collect();
        List enabledPlugins = allPlugins.filter(IdeaPluginDescriptor::isEnabled).addAllTo(new ArrayList());
        PluginManagerCore.prepareLoadingPluginsErrorMessage(disabledIds, disabledRequiredIds, idMap, errors);
        PluginManagerCore.fixDependencies(enabledPlugins, idMap);
        for (IdeaPluginDescriptorImpl pluginDescriptor : enabledPlugins) {
            if (CORE_ID == pluginDescriptor.getPluginId() || pluginDescriptor.isUseCoreClassLoader()) {
                pluginDescriptor.setLoader(coreLoader);
                continue;
            }
            PluginManagerCore.initClassLoader(pluginDescriptor, coreLoader, allDepsTraverser);
        }
        if (disabledAndPossibleToEnableConsumer != null) {
            disabledAndPossibleToEnableConsumer.consume(JBIterable.from(disabledIds.keySet()).map(PluginId::getIdString).toSet(), JBIterable.from(disabledRequiredIds).map(PluginId::getIdString).toSet());
        }
        IdeaPluginDescriptorImpl[] ideaPluginDescriptorImplArray = allPlugins.toArray((IdeaPluginDescriptorImpl[])IdeaPluginDescriptorImpl.EMPTY_ARRAY);
        if (ideaPluginDescriptorImplArray == null) {
            PluginManagerCore.$$$reportNull$$$0(101);
        }
        return ideaPluginDescriptorImplArray;
    }

    @NotNull
    private static Map<PluginId, IdeaPluginDescriptorImpl> buildPluginIdMap(@NotNull IdeaPluginDescriptorImpl[] descriptors, @NotNull List<? super String> errors) {
        if (descriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(102);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(103);
        }
        LinkedHashMap idMultiMap = new LinkedHashMap(descriptors.length);
        for (IdeaPluginDescriptorImpl o2 : descriptors) {
            ContainerUtilRt.putValue(o2.getPluginId(), o2, idMultiMap);
            for (String module2 : o2.getModules()) {
                ContainerUtilRt.putValue(PluginId.getId(module2), o2, idMultiMap);
            }
        }
        if (((List)idMultiMap.get(CORE_ID)).isEmpty()) {
            String message2 = "IDEA CORE (platform prefix: " + System.getProperty("idea.platform.prefix") + ")";
            throw new EssentialPluginMissingException(Collections.singletonList(message2));
        }
        LinkedHashMap<PluginId, IdeaPluginDescriptorImpl> idMap = new LinkedHashMap<PluginId, IdeaPluginDescriptorImpl>();
        for (PluginId id : idMultiMap.keySet()) {
            Collection values = (Collection)idMultiMap.get(id);
            if (id != null && values.size() == 1) {
                idMap.put(id, (IdeaPluginDescriptorImpl)values.iterator().next());
            }
            if (id == null) {
                errors.add("No id is provided by " + StringUtil.join(values, o -> PluginManagerCore.toPresentableName(o.getPath().getName()), ", "));
                continue;
            }
            if (values.size() <= 1) continue;
            if (PluginManagerCore.isModuleDependency(id)) {
                errors.add(PluginManagerCore.toPresentableName(id.getIdString()) + " module is declared by plugins " + StringUtil.join(values, PluginManagerCore::toPresentableName, ", "));
                continue;
            }
            errors.add(PluginManagerCore.toPresentableName(id.getIdString()) + " id is declared by plugins " + StringUtil.join(values, o -> PluginManagerCore.toPresentableName(o.getPath().getName()), ", "));
        }
        LinkedHashMap<PluginId, IdeaPluginDescriptorImpl> linkedHashMap = idMap;
        if (linkedHashMap == null) {
            PluginManagerCore.$$$reportNull$$$0(104);
        }
        return linkedHashMap;
    }

    private static boolean computePluginEnabled(@NotNull IdeaPluginDescriptor descriptor2, @NotNull Set<? extends PluginId> loadedIds, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap, @NotNull Set<? super PluginId> disabledRequiredIds, @NotNull List<? super String> errors) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(105);
        }
        if (loadedIds == null) {
            PluginManagerCore.$$$reportNull$$$0(106);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(107);
        }
        if (disabledRequiredIds == null) {
            PluginManagerCore.$$$reportNull$$$0(108);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(109);
        }
        if (CORE_ID == descriptor2.getPluginId()) {
            return true;
        }
        boolean result2 = true;
        for (PluginId depId : descriptor2.getDependentPluginIds()) {
            String depName;
            if (loadedIds.contains(depId) || ArrayUtil.indexOf(descriptor2.getOptionalDependentPluginIds(), depId) != -1) continue;
            result2 = false;
            if (descriptor2.isImplementationDetail()) continue;
            IdeaPluginDescriptor dep = idMap.get(depId);
            if (dep != null && PluginManagerCore.isDisabled(depId.getIdString())) {
                disabledRequiredIds.add(dep.getPluginId());
            }
            String name = descriptor2.getName();
            String string2 = depName = dep == null ? null : dep.getName();
            if (depName == null) {
                errors.add("Plugin " + PluginManagerCore.toPresentableName(name) + " requires missing " + PluginManagerCore.toPresentableName(depId.getIdString()));
                continue;
            }
            errors.add("Plugin " + PluginManagerCore.toPresentableName(name) + " requires disabled " + PluginManagerCore.toPresentableName(depName));
        }
        return result2;
    }

    private static void fixDependencies(@NotNull List<IdeaPluginDescriptorImpl> result2, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap) {
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(110);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(111);
        }
        IdeaPluginDescriptor coreDescriptor = ObjectUtils.notNull(idMap.get(CORE_ID));
        for (IdeaPluginDescriptorImpl descriptor2 : result2) {
            if (descriptor2 == coreDescriptor) continue;
            descriptor2.insertDependency(coreDescriptor);
        }
        PluginManagerCore.fixOptionalConfigs(result2, idMap);
        PluginManagerCore.mergeOptionalConfigs(result2, idMap);
    }

    private static void fixOptionalConfigs(@NotNull List<IdeaPluginDescriptorImpl> result2, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap) {
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(112);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(113);
        }
        if (!PluginManagerCore.isRunningFromSources()) {
            return;
        }
        for (IdeaPluginDescriptorImpl descriptor2 : result2) {
            if (!descriptor2.isUseCoreClassLoader() || descriptor2.getOptionalDescriptors() == null) continue;
            descriptor2.getOptionalDescriptors().entrySet().removeIf(entry -> {
                IdeaPluginDescriptorImpl dependent = (IdeaPluginDescriptorImpl)idMap.get(entry.getKey());
                return dependent != null && !dependent.isUseCoreClassLoader();
            });
        }
    }

    private static String toPresentableName(@Nullable IdeaPluginDescriptor descriptor2) {
        return PluginManagerCore.toPresentableName(descriptor2 == null ? null : descriptor2.getName());
    }

    @NotNull
    private static String toPresentableName(@Nullable String s) {
        String string2 = "\"" + (s == null ? "" : s) + "\"";
        if (string2 == null) {
            PluginManagerCore.$$$reportNull$$$0(114);
        }
        return string2;
    }

    public static void registerExtensionPointAndExtensions(@NotNull File pluginRoot2, @NotNull String fileName, @NotNull ExtensionsArea area) {
        IdeaPluginDescriptorImpl descriptor2;
        if (pluginRoot2 == null) {
            PluginManagerCore.$$$reportNull$$$0(115);
        }
        if (fileName == null) {
            PluginManagerCore.$$$reportNull$$$0(116);
        }
        if (area == null) {
            PluginManagerCore.$$$reportNull$$$0(117);
        }
        try (LoadingContext context2 = new LoadingContext(null, true, true, false);){
            descriptor2 = pluginRoot2.isDirectory() ? PluginManagerCore.loadDescriptorFromDir(pluginRoot2, fileName, null, context2) : PluginManagerCore.loadDescriptorFromJar(pluginRoot2, fileName, JDOMXIncluder.DEFAULT_PATH_RESOLVER, context2, null);
        }
        if (descriptor2 != null) {
            descriptor2.registerExtensionPoints((ExtensionsAreaImpl)area, ApplicationManager.getApplication());
            descriptor2.registerExtensions((ExtensionsAreaImpl)area, ApplicationManager.getApplication(), false);
        } else {
            PluginManagerCore.getLogger().error("Cannot load " + fileName + " from " + pluginRoot2);
        }
    }

    @NotNull
    private static synchronized IdeaPluginDescriptor[] initPlugins(@Nullable ClassLoader coreLoader) {
        IdeaPluginDescriptor[] result2;
        if (coreLoader == null) {
            Class<?> callerClass = ReflectionUtil.findCallerClass(1);
            assert (callerClass != null);
            coreLoader = callerClass.getClassLoader();
        }
        try {
            Activity loadPluginsActivity = StartUpMeasurer.startActivity("plugin initialization");
            result2 = PluginManagerCore.loadDescriptors();
            IdeaPluginDescriptorImpl[] sorted = PluginManagerCore.initializePlugins((IdeaPluginDescriptorImpl[])result2, coreLoader, (d, e) -> {
                ourPlugins2Disable = d;
                ourPlugins2Enable = e;
            });
            ourPlugins = sorted;
            ourLoadedPlugins = JBIterable.of((IdeaPluginDescriptor[])sorted).filter(IdeaPluginDescriptor::isEnabled).toList();
            PluginManagerCore.checkEssentialPluginsAreAvailable(ourLoadedPlugins);
            int count = 0;
            for (IdeaPluginDescriptor descriptor2 : ourLoadedPlugins) {
                ourId2Index.put((Object)descriptor2.getPluginId(), count++);
            }
            loadPluginsActivity.end();
            loadPluginsActivity.setDescription("plugin count: " + result2.length);
        }
        catch (ExtensionInstantiationException e2) {
            throw new PluginException(e2, e2.getExtensionOwnerId());
        }
        catch (RuntimeException e3) {
            PluginManagerCore.getLogger().error(e3);
            throw e3;
        }
        PluginManagerCore.logPlugins(result2);
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(118);
        }
        return result2;
    }

    @NotNull
    public static Logger getLogger() {
        Logger logger = Logger.getInstance("#com.intellij.ide.plugins.PluginManager");
        if (logger == null) {
            PluginManagerCore.$$$reportNull$$$0(119);
        }
        return logger;
    }

    @NotNull
    private static JBIterable<IdeaPluginDescriptorImpl> optionalDescriptorRecursively(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull Condition<? super PluginId> condition) {
        Map<PluginId, List<IdeaPluginDescriptorImpl>> optMap;
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(121);
        }
        if (condition == null) {
            PluginManagerCore.$$$reportNull$$$0(122);
        }
        if ((optMap = descriptor2.getOptionalDescriptors()) == null || optMap.isEmpty()) {
            JBIterable<IdeaPluginDescriptorImpl> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                PluginManagerCore.$$$reportNull$$$0(123);
            }
            return jBIterable;
        }
        JBIterable<IdeaPluginDescriptorImpl> jBIterable = ((JBTreeTraverser)JBTreeTraverser.from(d -> {
            Map<PluginId, List<IdeaPluginDescriptorImpl>> map2 = d.getOptionalDescriptors();
            if (map2 == null || map2.isEmpty()) {
                return JBIterable.empty();
            }
            return JBIterable.from(map2.entrySet()).filter(o -> condition.value((PluginId)o.getKey())).flatten(o -> (List)o.getValue());
        }).withRoot(descriptor2)).traverse().skip(1);
        if (jBIterable == null) {
            PluginManagerCore.$$$reportNull$$$0(124);
        }
        return jBIterable;
    }

    static {
        ourId2Index = new TObjectIntHashMap();
        isUnitTestMode = Boolean.getBoolean("idea.is.unit.test");
        ourUnitTestWithBundledPlugins = Boolean.getBoolean("idea.run.tests.with.bundled.plugins");
        ourDisabledPluginsListeners = new CopyOnWriteArrayList<Runnable>();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 115: 
            case 116: 
            case 117: 
            case 121: 
            case 122: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 115: 
            case 116: 
            case 117: 
            case 121: 
            case 122: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginManagerCore";
                break;
            }
            case 2: 
            case 99: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 3: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledPlugins";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 7: 
            case 28: 
            case 30: 
            case 33: 
            case 36: 
            case 61: 
            case 84: 
            case 88: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 105: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 12: 
            case 14: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 13: 
            case 35: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 16: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentPluginId";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginClass";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 29: 
            case 43: 
            case 69: 
            case 83: 
            case 90: 
            case 107: 
            case 111: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idMap";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPath";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentLoaders";
                break;
            }
            case 37: 
            case 42: 
            case 86: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traverser";
                break;
            }
            case 39: 
            case 40: 
            case 44: 
            case 70: 
            case 92: 
            case 103: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 45: 
            case 48: 
            case 52: 
            case 54: 
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 46: 
            case 59: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathName";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadingContext";
                break;
            }
            case 49: 
            case 53: 
            case 55: 
            case 57: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathResolver";
                break;
            }
            case 51: 
            case 60: 
            case 62: 
            case 66: 
            case 74: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionalDescriptorLoader";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 65: 
            case 73: 
            case 79: 
            case 82: 
            case 110: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledIds";
                break;
            }
            case 68: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledRequiredIds";
                break;
            }
            case 71: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 72: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 85: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreLoader";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentLoader";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "brokenIds";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildNumber";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadedIds";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginRoot";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlugins";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedPlugins";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 115: 
            case 116: 
            case 117: 
            case 121: 
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginManagerCore";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "disabledPlugins";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrokenPluginVersions";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentLoaders";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDescriptors";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "initializePlugins";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPluginIdMap";
                break;
            }
            case 114: {
                objectArray = objectArray2;
                objectArray2[1] = "toPresentableName";
                break;
            }
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "initPlugins";
                break;
            }
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "pluginIdTraverser";
                break;
            }
            case 123: 
            case 124: {
                objectArray = objectArray2;
                objectArray2[1] = "optionalDescriptorRecursively";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setPlugins";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadDisabledPlugins";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDisabled";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isBrokenPlugin";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addDisablePluginListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeDisablePluginListener";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "savePluginsList";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "writePluginsList";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "disablePlugin";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "enablePlugin";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "saveDisabledPlugins";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPluginLoadingOrder";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDependency";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createPluginException";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getPluginByClassName";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getPluginOrPlatformByClassName";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "hasLoadedClass";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitDependency";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "hasModuleDependencies";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createPluginClassLoader";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isPluginClass";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "logPlugins";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getParentLoaders";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "prepareLoadingPluginsErrorMessage";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "checkPluginCycles";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromDir";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromJar";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptor";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "resolveOptionalDescriptors";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorsFromDir";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "testLoadDescriptorsFromClassPath";
                break;
            }
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorsFromClassPath";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "computePlatformPluginUrlAndCollectPluginUrls";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromResource";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorsFromProperty";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "mergeOptionalConfigs";
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "initClassLoader";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "initClassLoaderForDisabledPlugin";
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "disableIncompatiblePlugins";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "isIncompatible";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "checkEssentialPluginsAreAvailable";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "initializePlugins";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "buildPluginIdMap";
                break;
            }
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "computePluginEnabled";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "fixDependencies";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "fixOptionalConfigs";
                break;
            }
            case 115: 
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPointAndExtensions";
                break;
            }
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "optionalDescriptorRecursively";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 115: 
            case 116: 
            case 117: 
            case 121: 
            case 122: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PluginTraverser
    extends JBTreeTraverser<PluginId> {
        final Map<PluginId, IdeaPluginDescriptorImpl> idMap;

        PluginTraverser(final @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap, final boolean withOptionalDeps, final boolean convertModulesToPlugins) {
            if (idMap == null) {
                PluginTraverser.$$$reportNull$$$0(0);
            }
            super(new Function<PluginId, Iterable<? extends PluginId>>(){
                final Map<IdeaPluginDescriptorImpl, JBIterable<? extends PluginId>> cache = new IdentityHashMap<IdeaPluginDescriptorImpl, JBIterable<? extends PluginId>>();

                @Override
                public Iterable<? extends PluginId> fun(PluginId o) {
                    IdeaPluginDescriptorImpl descriptor2 = (IdeaPluginDescriptorImpl)idMap.get(o);
                    if (descriptor2 == null) {
                        return JBIterable.empty();
                    }
                    return this.cache.computeIfAbsent(descriptor2, oo -> PluginTraverser.childrenImpl(oo, idMap, withOptionalDeps, convertModulesToPlugins).collect());
                }
            });
            this.idMap = idMap;
        }

        @NotNull
        static JBIterable<? extends PluginId> childrenImpl(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap, boolean withOptionalDeps, boolean convertModulesToPlugins) {
            if (descriptor2 == null) {
                PluginTraverser.$$$reportNull$$$0(1);
            }
            if (idMap == null) {
                PluginTraverser.$$$reportNull$$$0(2);
            }
            PluginId implicitDep = PluginManagerCore.getImplicitDependency(descriptor2, idMap);
            JBIterable<PluginId> allDeps = JBIterable.from(Arrays.asList(descriptor2.getDependentPluginIds())).append(implicitDep);
            JBIterable<PluginId> selectedDeps = withOptionalDeps ? allDeps.append((PluginId)((Object)PluginManagerCore.optionalDescriptorRecursively(descriptor2, Conditions.alwaysTrue()).flatten(d -> JBIterable.from(Arrays.asList(d.getDependentPluginIds()))))) : allDeps.filter((? super E id) -> ArrayUtil.indexOf(descriptor2.getOptionalDependentPluginIds(), id) == -1);
            JBIterable<PluginId> convertedDeps = selectedDeps.filterMap(id -> {
                IdeaPluginDescriptor plugin = (IdeaPluginDescriptor)idMap.get(id);
                if (plugin == descriptor2) {
                    return null;
                }
                return plugin != null && convertModulesToPlugins && PluginManagerCore.isModuleDependency(id) ? plugin.getPluginId() : id;
            });
            JBIterable<PluginId> jBIterable = convertedDeps.unique();
            if (jBIterable == null) {
                PluginTraverser.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }

        PluginTraverser(@NotNull FilteredTraverserBase.Meta<PluginId> meta, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap) {
            if (meta == null) {
                PluginTraverser.$$$reportNull$$$0(4);
            }
            if (idMap == null) {
                PluginTraverser.$$$reportNull$$$0(5);
            }
            super(meta);
            this.idMap = idMap;
        }

        @Override
        @NotNull
        protected JBTreeTraverser<PluginId> newInstance(@NotNull FilteredTraverserBase.Meta<PluginId> meta) {
            if (meta == null) {
                PluginTraverser.$$$reportNull$$$0(6);
            }
            return new PluginTraverser(meta, this.idMap);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "idMap";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/plugins/PluginManagerCore$PluginTraverser";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "meta";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/plugins/PluginManagerCore$PluginTraverser";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "childrenImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "childrenImpl";
                    break;
                }
                case 3: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "newInstance";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class EssentialPluginMissingException
    extends RuntimeException {
        public final List<String> pluginIds;

        EssentialPluginMissingException(@NotNull List<String> ids) {
            if (ids == null) {
                EssentialPluginMissingException.$$$reportNull$$$0(0);
            }
            super("Missing essential plugins: " + StringUtil.join(ids, ", "));
            this.pluginIds = ids;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "com/intellij/ide/plugins/PluginManagerCore$EssentialPluginMissingException", "<init>"));
        }
    }

    static class LoadingContext
    implements AutoCloseable {
        final Map<File, ZipFile> openedFiles = new THashMap();
        final LoadDescriptorsContext parentContext;
        final boolean isBundled;
        final boolean isEssential;
        final boolean ignoreDisabled;
        final List<Pair<String, IdeaPluginDescriptorImpl>> visitedFiles = new ArrayList<Pair<String, IdeaPluginDescriptorImpl>>(3);
        File lastZipWithDescriptor;

        LoadingContext(@Nullable LoadDescriptorsContext parentContext, boolean isBundled, boolean isEssential, boolean ignoreDisabled) {
            this.parentContext = parentContext;
            this.isBundled = isBundled;
            this.isEssential = isEssential;
            this.ignoreDisabled = ignoreDisabled;
        }

        ZipFile open(File file2) throws IOException {
            ZipFile zipFile2 = this.openedFiles.get(file2);
            if (zipFile2 == null) {
                zipFile2 = new ZipFile(file2);
                this.openedFiles.put(file2, zipFile2);
            }
            return zipFile2;
        }

        @Nullable
        SafeJdomFactory getXmlFactory() {
            return this.parentContext != null ? this.parentContext.getXmlFactory() : null;
        }

        @Override
        public void close() {
            for (ZipFile file2 : this.openedFiles.values()) {
                try {
                    file2.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static class Holder {
        private static final BuildNumber ourBuildNumber = Holder.calcBuildNumber();
        private static final boolean ourIsRunningFromSources = new File(PathManager.getHomePath(), ".idea").isDirectory();

        private static BuildNumber calcBuildNumber() {
            BuildNumber ourBuildNumber = BuildNumber.fromString(System.getProperty("idea.plugins.compatible.build"));
            if (ourBuildNumber == null) {
                BuildNumber buildNumber = ourBuildNumber = BUILD_NUMBER == null ? null : BuildNumber.fromString(BUILD_NUMBER);
                if (ourBuildNumber == null) {
                    ourBuildNumber = BuildNumber.currentVersion();
                }
            }
            return ourBuildNumber;
        }
    }
}

