/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\"\u001c\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\"\u0014\u0010\n\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0014\u0010\r\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\"\u0014\u0010\u000f\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0011"}, d2={"functionPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getFunctionPattern", "()Ljava/util/regex/Pattern;", "functionalPackages", "", "Lorg/jetbrains/kotlin/name/FqName;", "getFunctionalPackages", "()Ljava/util/List;", "kotlinCoroutinesFqn", "getKotlinCoroutinesFqn", "()Lorg/jetbrains/kotlin/name/FqName;", "kotlinFqn", "getKotlinFqn", "kotlinReflectFqn", "getKotlinReflectFqn", "ir.serialization.common"})
public final class FunctionalInterfacesUtilsKt {
    private static final Pattern functionPattern = Pattern.compile("^K?(Suspend)?Function\\d+$");
    @NotNull
    private static final FqName kotlinFqn = new FqName("kotlin");
    @NotNull
    private static final FqName kotlinCoroutinesFqn;
    @NotNull
    private static final FqName kotlinReflectFqn;
    @NotNull
    private static final List<FqName> functionalPackages;

    public static final Pattern getFunctionPattern() {
        return functionPattern;
    }

    @NotNull
    public static final FqName getKotlinFqn() {
        return kotlinFqn;
    }

    @NotNull
    public static final FqName getKotlinCoroutinesFqn() {
        return kotlinCoroutinesFqn;
    }

    @NotNull
    public static final FqName getKotlinReflectFqn() {
        return kotlinReflectFqn;
    }

    @NotNull
    public static final List<FqName> getFunctionalPackages() {
        return functionalPackages;
    }

    static {
        FqName fqName2 = kotlinFqn.child(Name.identifier("coroutines"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"kotlinFqn.child(Name.identifier(\"coroutines\"))");
        kotlinCoroutinesFqn = fqName2;
        FqName fqName3 = kotlinFqn.child(Name.identifier("reflect"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"kotlinFqn.child(Name.identifier(\"reflect\"))");
        kotlinReflectFqn = fqName3;
        functionalPackages = CollectionsKt.listOf((Object[])new FqName[]{kotlinFqn, kotlinCoroutinesFqn, kotlinReflectFqn});
    }
}

