/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.codegen.BlockInfo;
import org.jetbrains.kotlin.backend.jvm.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.backend.jvm.codegen.IrTypeMappingKt;
import org.jetbrains.kotlin.backend.jvm.codegen.MaterialValue;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValue;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValueKt;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeInliner;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/GetJavaObjectType;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "()V", "invoke", "Lorg/jetbrains/kotlin/backend/jvm/codegen/PromisedValue;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "codegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ExpressionCodegen;", "data", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BlockInfo;", "backend.jvm"})
public final class GetJavaObjectType
extends IntrinsicMethod {
    public static final GetJavaObjectType INSTANCE;

    @Override
    @Nullable
    public PromisedValue invoke(@NotNull IrFunctionAccessExpression expression2, @NotNull ExpressionCodegen codegen2, @NotNull BlockInfo data) {
        MaterialValue materialValue;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)codegen2, (String)"codegen");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        IrExpression receiver = expression2.getExtensionReceiver();
        if (receiver instanceof IrClassReference) {
            boolean bl;
            boolean bl2;
            IrClassifierSymbol symbol2 = ((IrClassReference)receiver).getSymbol();
            if (symbol2 instanceof IrTypeParameterSymbol) {
                bl2 = ((IrTypeParameter)((IrTypeParameterSymbol)symbol2).getOwner()).isReified();
                bl = false;
                if (_Assertions.ENABLED && !bl2) {
                    boolean $i$a$-assert-GetJavaObjectType$invoke$22 = false;
                    String $i$a$-assert-GetJavaObjectType$invoke$22 = "Non-reified type parameter under ::class should be rejected by type checker: " + DumpIrTreeKt.dump$default((IrElement)((IrTypeParameterSymbol)symbol2).getOwner(), false, 1, null);
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-GetJavaObjectType$invoke$22));
                }
                codegen2.putReifiedOperationMarkerIfTypeIsReifiedParameter(((IrClassReference)receiver).getClassType(), ReifiedTypeInliner.OperationKind.JAVA_CLASS);
            }
            codegen2.getMv().aconst(AsmUtil.boxType(IrTypeMappingKt.mapTypeAsDeclaration(codegen2.getTypeMapper(), ((IrClassReference)receiver).getClassType())));
            bl2 = false;
            bl = false;
            ExpressionCodegen $this$with = codegen2;
            boolean bl3 = false;
            materialValue = $this$with.getOnStack(expression2);
        } else if (receiver instanceof IrGetClass) {
            PromisedValue argumentValue = (PromisedValue)((IrGetClass)receiver).getArgument().accept(codegen2, data);
            PromisedValueKt.materialize(argumentValue);
            Type argumentType = argumentValue.getType();
            if (Intrinsics.areEqual((Object)argumentType, (Object)Type.VOID_TYPE)) {
                codegen2.getMv().aconst(AsmTypes.UNIT_TYPE);
            } else if (AsmUtil.isPrimitive(argumentType) || AsmUtil.unboxPrimitiveTypeOrNull(argumentType) != null) {
                AsmUtil.pop(codegen2.getMv(), argumentType);
                codegen2.getMv().aconst(AsmUtil.boxType(argumentType));
            } else {
                codegen2.getMv().invokevirtual("java/lang/Object", "getClass", "()Ljava/lang/Class;", false);
            }
            boolean bl = false;
            boolean bl4 = false;
            ExpressionCodegen $this$with = codegen2;
            boolean bl5 = false;
            materialValue = $this$with.getOnStack(expression2);
        } else {
            materialValue = null;
        }
        return materialValue;
    }

    private GetJavaObjectType() {
    }

    static {
        GetJavaObjectType getJavaObjectType;
        INSTANCE = getJavaObjectType = new GetJavaObjectType();
    }
}

