/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxingInterpreterKt;
import org.jetbrains.kotlin.codegen.optimization.boxing.CleanBoxedValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.ProgressionIteratorBasicValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.TaintedBoxedValue;
import org.jetbrains.kotlin.codegen.optimization.common.OptimizationBasicInterpreter;
import org.jetbrains.kotlin.codegen.optimization.common.StrictBasicValue;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\r\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0004J\"\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0018\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000eH\u0016J \u0010\u001b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001dH\u0016J \u0010\u001e\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\nH\u0014J \u0010!\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\nH\u0014J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0014J\u0018\u0010#\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\nH\u0014J\u0010\u0010$\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0014J\u0010\u0010%\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0014J \u0010&\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u0013H\u0014J\u001a\u0010(\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010)\u001a\u00020\f*\b\u0012\u0004\u0012\u00020\u000e0\u001dH\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/boxing/BoxingInterpreter;", "Lorg/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter;", "insnList", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "generationState", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "(Lorg/jetbrains/org/objectweb/asm/tree/InsnList;Lorg/jetbrains/kotlin/codegen/state/GenerationState;)V", "boxingPlaces", "Ljava/util/HashMap;", "", "Lorg/jetbrains/kotlin/codegen/optimization/boxing/BoxedBasicValue;", "checkUsedValue", "", "value", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "createNewBoxing", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "progressionIterator", "Lorg/jetbrains/kotlin/codegen/optimization/boxing/ProgressionIteratorBasicValue;", "isExactValue", "", "merge", "v", "w", "naryOperation", "values", "", "onAreEqual", "value1", "value2", "onCompareTo", "onMergeFail", "onMergeSuccess", "onMethodCallWithBoxedValue", "onNewBoxedValue", "onUnboxing", "resultType", "unaryOperation", "markBoxedArgumentValues", "backend"})
public class BoxingInterpreter
extends OptimizationBasicInterpreter {
    private final HashMap<Integer, BoxedBasicValue> boxingPlaces;
    private final InsnList insnList;
    private final GenerationState generationState;

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected BasicValue createNewBoxing(@NotNull AbstractInsnNode insn, @NotNull Type type2, @Nullable ProgressionIteratorBasicValue progressionIterator) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Map map2 = this.boxingPlaces;
        Integer key$iv = this.insnList.indexOf(insn);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            CleanBoxedValue boxedBasicValue = new CleanBoxedValue(type2, insn, progressionIterator, this.generationState);
            this.onNewBoxedValue(boxedBasicValue);
            BoxedBasicValue answer$iv = boxedBasicValue;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (BasicValue)object;
    }

    protected final void checkUsedValue(@NotNull BasicValue value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (value2 instanceof TaintedBoxedValue) {
            this.onMergeFail((BoxedBasicValue)value2);
        }
    }

    @Override
    @Nullable
    public BasicValue naryOperation(@NotNull AbstractInsnNode insn, @NotNull List<? extends BasicValue> values) {
        Value value2;
        Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Iterable $this$forEach$iv = values;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BasicValue it = (BasicValue)element$iv;
            boolean bl = false;
            this.checkUsedValue(it);
        }
        Value value3 = super.naryOperation(insn, (List)values);
        BasicValue basicValue = (BasicValue)CollectionsKt.firstOrNull(values);
        if (basicValue == null) {
            return value3;
        }
        BasicValue firstArg = basicValue;
        if (BoxingInterpreterKt.isBoxing(insn, this.generationState)) {
            this.markBoxedArgumentValues(values);
            Value value4 = value3;
            Intrinsics.checkNotNullExpressionValue((Object)value4, (String)"value");
            Type type2 = ((BasicValue)value4).getType();
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"value.type");
            value2 = this.createNewBoxing(insn, type2, null);
        } else if (BoxingInterpreterKt.isUnboxing(insn, this.generationState) && firstArg instanceof BoxedBasicValue) {
            BoxedBasicValue boxedBasicValue = (BoxedBasicValue)firstArg;
            Value value5 = value3;
            Intrinsics.checkNotNullExpressionValue((Object)value5, (String)"value");
            Type type3 = ((BasicValue)value5).getType();
            Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"value.type");
            this.onUnboxing(insn, boxedBasicValue, type3);
            value2 = value3;
        } else if (BoxingInterpreterKt.isIteratorMethodCallOfProgression(insn, values)) {
            Type type4 = firstArg.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type4, (String)"firstArg.type");
            value2 = ProgressionIteratorBasicValue.Companion.byProgressionClassType(type4);
        } else if (BoxingInterpreterKt.isNextMethodCallOfProgressionIterator(insn, values)) {
            BasicValue basicValue2 = firstArg;
            if (!(basicValue2 instanceof ProgressionIteratorBasicValue)) {
                basicValue2 = null;
            }
            ProgressionIteratorBasicValue progressionIteratorBasicValue = (ProgressionIteratorBasicValue)basicValue2;
            if (progressionIteratorBasicValue == null) {
                throw (Throwable)((Object)new AssertionError((Object)"firstArg should be progression iterator"));
            }
            ProgressionIteratorBasicValue progressionIterator = progressionIteratorBasicValue;
            value2 = this.createNewBoxing(insn, progressionIterator.getBoxedElementType(), progressionIterator);
        } else if (BoxingInterpreterKt.isAreEqualIntrinsicForSameTypedBoxedValues(insn, values) && BoxingInterpreterKt.canValuesBeUnboxedForAreEqual(values, this.generationState)) {
            BasicValue basicValue3 = values.get(0);
            if (basicValue3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue");
            }
            BasicValue basicValue4 = values.get(1);
            if (basicValue4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue");
            }
            this.onAreEqual(insn, (BoxedBasicValue)basicValue3, (BoxedBasicValue)basicValue4);
            value2 = value3;
        } else if (BoxingInterpreterKt.isJavaLangComparableCompareToForSameTypedBoxedValues(insn, values)) {
            BasicValue basicValue5 = values.get(0);
            if (basicValue5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue");
            }
            BasicValue basicValue6 = values.get(1);
            if (basicValue6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue");
            }
            this.onCompareTo(insn, (BoxedBasicValue)basicValue5, (BoxedBasicValue)basicValue6);
            value2 = value3;
        } else {
            this.markBoxedArgumentValues(values);
            value2 = value3;
        }
        return value2;
    }

    private final void markBoxedArgumentValues(List<? extends BasicValue> $this$markBoxedArgumentValues) {
        for (BasicValue basicValue : $this$markBoxedArgumentValues) {
            if (!(basicValue instanceof BoxedBasicValue)) continue;
            this.onMethodCallWithBoxedValue((BoxedBasicValue)basicValue);
        }
    }

    @Override
    @Nullable
    public BasicValue unaryOperation(@NotNull AbstractInsnNode insn, @NotNull BasicValue value2) {
        Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.checkUsedValue(value2);
        return insn.getOpcode() == 192 && this.isExactValue(value2) ? value2 : super.unaryOperation(insn, value2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isExactValue(@NotNull BasicValue value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (value2 instanceof ProgressionIteratorBasicValue) return true;
        if (value2 instanceof CleanBoxedValue) return true;
        if (value2.getType() == null) return false;
        Type type2 = value2.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"value.type");
        if (!BoxingInterpreterKt.access$isProgressionClass(type2)) return false;
        return true;
    }

    @Override
    @NotNull
    public BasicValue merge(@NotNull BasicValue v, @NotNull BasicValue w) {
        BasicValue basicValue;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        if (Intrinsics.areEqual((Object)v, (Object)StrictBasicValue.UNINITIALIZED_VALUE) || Intrinsics.areEqual((Object)w, (Object)StrictBasicValue.UNINITIALIZED_VALUE)) {
            basicValue = StrictBasicValue.UNINITIALIZED_VALUE;
        } else if (v instanceof BoxedBasicValue && w instanceof BoxedBasicValue) {
            this.onMergeSuccess((BoxedBasicValue)v, (BoxedBasicValue)w);
            basicValue = v instanceof TaintedBoxedValue ? (BoxedBasicValue)v : (w instanceof TaintedBoxedValue ? (BoxedBasicValue)w : (Intrinsics.areEqual((Object)((BoxedBasicValue)v).getType(), (Object)((BoxedBasicValue)w).getType()) ^ true ? ((BoxedBasicValue)v).taint() : (BoxedBasicValue)v));
        } else {
            basicValue = v instanceof BoxedBasicValue ? (BasicValue)((BoxedBasicValue)v).taint() : (w instanceof BoxedBasicValue ? (BasicValue)((BoxedBasicValue)w).taint() : super.merge(v, w));
        }
        Intrinsics.checkNotNullExpressionValue((Object)basicValue, (String)"when {\n            v == \u2026per.merge(v, w)\n        }");
        return basicValue;
    }

    protected void onNewBoxedValue(@NotNull BoxedBasicValue value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
    }

    protected void onUnboxing(@NotNull AbstractInsnNode insn, @NotNull BoxedBasicValue value2, @NotNull Type resultType) {
        Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)resultType, (String)"resultType");
    }

    protected void onAreEqual(@NotNull AbstractInsnNode insn, @NotNull BoxedBasicValue value1, @NotNull BoxedBasicValue value2) {
        Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
        Intrinsics.checkNotNullParameter((Object)value1, (String)"value1");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value2");
    }

    protected void onCompareTo(@NotNull AbstractInsnNode insn, @NotNull BoxedBasicValue value1, @NotNull BoxedBasicValue value2) {
        Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
        Intrinsics.checkNotNullParameter((Object)value1, (String)"value1");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value2");
    }

    protected void onMethodCallWithBoxedValue(@NotNull BoxedBasicValue value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
    }

    protected void onMergeFail(@NotNull BoxedBasicValue value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
    }

    protected void onMergeSuccess(@NotNull BoxedBasicValue v, @NotNull BoxedBasicValue w) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
    }

    public BoxingInterpreter(@NotNull InsnList insnList, @NotNull GenerationState generationState) {
        Intrinsics.checkNotNullParameter((Object)insnList, (String)"insnList");
        Intrinsics.checkNotNullParameter((Object)generationState, (String)"generationState");
        this.insnList = insnList;
        this.generationState = generationState;
        this.boxingPlaces = new HashMap();
    }
}

