/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import com.intellij.util.containers.MultiMap;
import java.io.Closeable;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.container.CacheKt;
import org.jetbrains.kotlin.container.ClassInfo;
import org.jetbrains.kotlin.container.ComponentDescriptor;
import org.jetbrains.kotlin.container.ComponentRegistry;
import org.jetbrains.kotlin.container.ComponentResolveContext;
import org.jetbrains.kotlin.container.ComponentStorage;
import org.jetbrains.kotlin.container.ComponentStorageState;
import org.jetbrains.kotlin.container.ContainerConsistencyException;
import org.jetbrains.kotlin.container.DataStructuresKt;
import org.jetbrains.kotlin.container.DefaultInstanceComponentDescriptor;
import org.jetbrains.kotlin.container.DefaultSingletonTypeComponentDescriptor;
import org.jetbrains.kotlin.container.ImplicitSingletonTypeComponentDescriptor;
import org.jetbrains.kotlin.container.InvalidCardinalityException;
import org.jetbrains.kotlin.container.MethodBinding;
import org.jetbrains.kotlin.container.PlatformExtensionsClashResolver;
import org.jetbrains.kotlin.container.ResolveKt;
import org.jetbrains.kotlin.container.SetterInfo;
import org.jetbrains.kotlin.container.ValueDescriptor;
import org.jetbrains.kotlin.container.ValueResolveContext;
import org.jetbrains.kotlin.container.ValueResolver;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0005J4\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0002J\u000e\u0010 \u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u001e\u0010!\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\"H\u0002J\u0006\u0010#\u001a\u00020\u0019J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u000bH\u0002J\u000e\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000b0)H\u0002J\u001e\u0010*\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030,H\u0002J\u0018\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020/2\u0006\u0010\u001a\u001a\u000200H\u0002J\u001e\u0010-\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u000b0\"H\u0002J$\u00102\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\"H\u0002J\u001f\u00103\u001a\u00020\u00192\u0010\u00104\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0)H\u0000\u00a2\u0006\u0002\b5J\u0018\u00106\u001a\u00020\u00192\u0006\u00107\u001a\u00020\r2\u0006\u0010\u001a\u001a\u000200H\u0002J#\u00108\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u000b0)H\u0000\u00a2\u0006\u0002\b:J\u001a\u0010;\u001a\u0004\u0018\u00010<2\u0006\u00107\u001a\u00020\r2\u0006\u0010\u001a\u001a\u000200H\u0016J\u001c\u0010=\u001a\b\u0012\u0004\u0012\u00020<0>2\u0006\u00107\u001a\u00020\r2\u0006\u0010\u001a\u001a\u000200R\u0018\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006?"}, d2={"Lorg/jetbrains/kotlin/container/ComponentStorage;", "Lorg/jetbrains/kotlin/container/ValueResolver;", "myId", "", "parent", "(Ljava/lang/String;Lorg/jetbrains/kotlin/container/ComponentStorage;)V", "clashResolvers", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/container/PlatformExtensionsClashResolver;", "dependencies", "Lcom/intellij/util/containers/MultiMap;", "Lorg/jetbrains/kotlin/container/ComponentDescriptor;", "kotlin.jvm.PlatformType", "Ljava/lang/reflect/Type;", "descriptors", "Ljava/util/LinkedHashSet;", "registry", "Lorg/jetbrains/kotlin/container/ComponentRegistry;", "state", "Lorg/jetbrains/kotlin/container/ComponentStorageState;", "getState", "()Lorg/jetbrains/kotlin/container/ComponentStorageState;", "setState", "(Lorg/jetbrains/kotlin/container/ComponentStorageState;)V", "collectAdhocComponents", "", "context", "Lorg/jetbrains/kotlin/container/ComponentResolveContext;", "descriptor", "visitedTypes", "Ljava/util/HashSet;", "adhocDescriptors", "compose", "composeDescriptors", "", "dispose", "disposeDescriptor", "dump", "printer", "Ljava/io/PrintStream;", "getDescriptorsInDisposeOrder", "", "getImplicitlyDefinedDependency", "rawType", "Ljava/lang/Class;", "injectProperties", "instance", "", "Lorg/jetbrains/kotlin/container/ValueResolveContext;", "components", "inspectDependenciesAndRegisterAdhoc", "registerClashResolvers", "resolvers", "registerClashResolvers$container", "registerDependency", "request", "registerDescriptors", "items", "registerDescriptors$container", "resolve", "Lorg/jetbrains/kotlin/container/ValueDescriptor;", "resolveMultiple", "", "container"})
public final class ComponentStorage
implements ValueResolver {
    @NotNull
    private ComponentStorageState state;
    private final LinkedHashSet<ComponentDescriptor> descriptors;
    private final MultiMap<ComponentDescriptor, Type> dependencies;
    private final ArrayList<PlatformExtensionsClashResolver<?>> clashResolvers;
    private final ComponentRegistry registry;
    private final String myId;

    @NotNull
    public final ComponentStorageState getState() {
        return this.state;
    }

    public final void setState(@NotNull ComponentStorageState componentStorageState) {
        Intrinsics.checkNotNullParameter((Object)((Object)componentStorageState), (String)"<set-?>");
        this.state = componentStorageState;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public ValueDescriptor resolve(@NotNull Type request, @NotNull ValueResolveContext context2) {
        Collection<ComponentDescriptor> entry;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        resolve.1 $fun$isDefaultComponent$1 = resolve.1.INSTANCE;
        if (this.state == ComponentStorageState.Initial) {
            throw (Throwable)new ContainerConsistencyException("Container was not composed before resolving");
        }
        Collection<ComponentDescriptor> collection = entry = this.registry.tryGetEntry(request);
        boolean bl = false;
        if (!collection.isEmpty()) {
            void $this$filterNotTo$iv$iv;
            this.registerDependency(request, context2);
            if (entry.size() == 1) {
                return (ValueDescriptor)CollectionsKt.single((Iterable)entry);
            }
            Iterable $this$filterNot$iv = entry;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                ComponentDescriptor it = (ComponentDescriptor)element$iv$iv;
                boolean bl2 = false;
                if (resolve.1.INSTANCE.invoke(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List nonDefault = (List)destination$iv$iv;
            if (nonDefault.isEmpty()) {
                return (ValueDescriptor)CollectionsKt.first((Iterable)entry);
            }
            ComponentDescriptor componentDescriptor = (ComponentDescriptor)CollectionsKt.singleOrNull((List)nonDefault);
            if (componentDescriptor == null) {
                throw (Throwable)new InvalidCardinalityException("Request " + request + " cannot be satisfied because there is more than one type registered\n" + "Clashed registrations: " + CollectionsKt.joinToString$default((Iterable)entry, null, null, null, (int)0, null, null, (int)63, null));
            }
            return componentDescriptor;
        }
        return null;
    }

    private final void registerDependency(Type request, ValueResolveContext context2) {
        ValueDescriptor descriptor2;
        if (context2 instanceof ComponentResolveContext && (descriptor2 = ((ComponentResolveContext)context2).getRequestingDescriptor()) instanceof ComponentDescriptor) {
            this.dependencies.putValue((ComponentDescriptor)descriptor2, request);
        }
    }

    public final void dump(@NotNull PrintStream printer) {
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        boolean bl = false;
        boolean bl2 = false;
        PrintStream $this$with = printer;
        boolean bl3 = false;
        String heading = "Container: " + this.myId;
        $this$with.println(heading);
        $this$with.println(StringsKt.repeat((CharSequence)"=", (int)heading.length()));
        $this$with.println();
        Iterable $this$forEach$iv = this.getDescriptorsInDisposeOrder();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ComponentDescriptor descriptor2 = (ComponentDescriptor)element$iv;
            boolean bl4 = false;
            $this$with.println(descriptor2);
            Collection<Type> collection = this.dependencies.get(descriptor2);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"dependencies[descriptor]");
            Iterable $this$forEach$iv2 = collection;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Type it = (Type)element$iv2;
                boolean bl5 = false;
                $this$with.print("   -> ");
                String typeName = it.toString();
                $this$with.print(StringsKt.substringBefore$default((String)typeName, (String)" ", null, (int)2, null));
                $this$with.print(" ");
                $this$with.print(StringsKt.substringAfterLast$default((String)typeName, (String)".", null, (int)2, null));
                Type type2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"it");
                Collection<ComponentDescriptor> resolve2 = this.registry.tryGetEntry(type2);
                $this$with.print(" as ");
                $this$with.print(resolve2);
                $this$with.println();
            }
            $this$with.println();
        }
    }

    @NotNull
    public final Iterable<ValueDescriptor> resolveMultiple(@NotNull Type request, @NotNull ValueResolveContext context2) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.registerDependency(request, context2);
        return this.registry.tryGetEntry(request);
    }

    public final void registerClashResolvers$container(@NotNull List<? extends PlatformExtensionsClashResolver<?>> resolvers) {
        Intrinsics.checkNotNullParameter(resolvers, (String)"resolvers");
        this.clashResolvers.addAll((Collection)resolvers);
    }

    public final void registerDescriptors$container(@NotNull ComponentResolveContext context2, @NotNull List<? extends ComponentDescriptor> items) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        if (this.state == ComponentStorageState.Disposed) {
            throw (Throwable)new ContainerConsistencyException("Cannot register descriptors in " + (Object)((Object)this.state) + " state");
        }
        for (ComponentDescriptor componentDescriptor : items) {
            this.descriptors.add(componentDescriptor);
        }
        if (this.state == ComponentStorageState.Initialized) {
            this.composeDescriptors(context2, (Collection<? extends ComponentDescriptor>)items);
        }
    }

    public final void compose(@NotNull ComponentResolveContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (this.state != ComponentStorageState.Initial) {
            throw (Throwable)new ContainerConsistencyException("Container " + this.myId + " was already composed.");
        }
        this.state = ComponentStorageState.Initialized;
        this.composeDescriptors(context2, (Collection<? extends ComponentDescriptor>)this.descriptors);
    }

    private final void composeDescriptors(ComponentResolveContext context2, Collection<? extends ComponentDescriptor> descriptors) {
        if (descriptors.isEmpty()) {
            return;
        }
        this.registry.addAll(descriptors);
        LinkedHashSet<ComponentDescriptor> implicits = this.inspectDependenciesAndRegisterAdhoc(context2, descriptors);
        this.registry.resolveClashesIfAny(context2.getContainer(), (List)this.clashResolvers);
        this.injectProperties(context2, CollectionsKt.plus(descriptors, (Iterable)implicits));
    }

    private final void injectProperties(ComponentResolveContext context2, Collection<? extends ComponentDescriptor> components) {
        for (ComponentDescriptor componentDescriptor : components) {
            if (!componentDescriptor.getShouldInjectProperties()) continue;
            this.injectProperties(componentDescriptor.getValue(), context2.getContainer().createResolveContext(componentDescriptor));
        }
    }

    private final LinkedHashSet<ComponentDescriptor> inspectDependenciesAndRegisterAdhoc(ComponentResolveContext context2, Collection<? extends ComponentDescriptor> descriptors) {
        LinkedHashSet<ComponentDescriptor> adhoc = new LinkedHashSet<ComponentDescriptor>();
        HashSet<Type> visitedTypes = new HashSet<Type>();
        for (ComponentDescriptor componentDescriptor : descriptors) {
            this.collectAdhocComponents(context2, componentDescriptor, visitedTypes, adhoc);
        }
        this.registry.addAll((Collection<? extends ComponentDescriptor>)adhoc);
        return adhoc;
    }

    private final void collectAdhocComponents(ComponentResolveContext context2, ComponentDescriptor descriptor2, HashSet<Type> visitedTypes, LinkedHashSet<ComponentDescriptor> adhocDescriptors) {
        Collection<Type> dependencies2 = descriptor2.getDependencies(context2);
        for (Type type2 : dependencies2) {
            Class rawType;
            Object object;
            Class clazz;
            Collection<ComponentDescriptor> entry;
            if (!visitedTypes.add(type2) || !(entry = this.registry.tryGetEntry(type2)).isEmpty()) continue;
            Type type3 = type2;
            if (type3 instanceof Class) {
                clazz = (Class)type2;
            } else if (type3 instanceof ParameterizedType) {
                Type type4 = ((ParameterizedType)type2).getRawType();
                if (!(type4 instanceof Class)) {
                    type4 = null;
                }
                clazz = (Class)type4;
            } else {
                clazz = null;
            }
            if ((object = (rawType = clazz)) == null) continue;
            Class clazz2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Class it = clazz2;
            boolean bl3 = false;
            object = this.getImplicitlyDefinedDependency(context2, it);
            if (object == null) {
                continue;
            }
            Object implicitDependency = object;
            adhocDescriptors.add((ComponentDescriptor)implicitDependency);
            this.collectAdhocComponents(context2, (ComponentDescriptor)implicitDependency, visitedTypes, adhocDescriptors);
        }
    }

    private final ComponentDescriptor getImplicitlyDefinedDependency(ComponentResolveContext context2, Class<?> rawType) {
        if (!Modifier.isAbstract(rawType.getModifiers()) && !rawType.isPrimitive()) {
            return new ImplicitSingletonTypeComponentDescriptor(context2.getContainer(), rawType);
        }
        Class<?> defaultImplementation = CacheKt.getInfo(rawType).getDefaultImplementation();
        if (defaultImplementation != null && CacheKt.getInfo(defaultImplementation).getConstructorInfo() != null) {
            return new DefaultSingletonTypeComponentDescriptor(context2.getContainer(), defaultImplementation);
        }
        if (defaultImplementation != null) {
            DefaultInstanceComponentDescriptor defaultInstanceComponentDescriptor;
            Object object = defaultImplementation.getField("INSTANCE");
            if (object != null && (object = ((Field)object).get(null)) != null) {
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object p1 = object2;
                boolean bl3 = false;
                defaultInstanceComponentDescriptor = new DefaultInstanceComponentDescriptor(p1);
            } else {
                defaultInstanceComponentDescriptor = null;
            }
            return defaultInstanceComponentDescriptor;
        }
        return null;
    }

    private final void injectProperties(Object instance, ValueResolveContext context2) {
        ClassInfo classInfo = CacheKt.getInfo(instance.getClass());
        Iterable $this$forEach$iv = classInfo.getSetterInfos();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SetterInfo $dstr$method = (SetterInfo)element$iv;
            boolean bl = false;
            Method method = $dstr$method.component1();
            MethodBinding methodBinding = ResolveKt.bindToMethod(method, context2);
            methodBinding.invoke(instance);
        }
    }

    public final void dispose() {
        if (this.state != ComponentStorageState.Initialized) {
            if (this.state == ComponentStorageState.Initial) {
                return;
            }
            throw (Throwable)new ContainerConsistencyException("Component container cannot be disposed in the " + (Object)((Object)this.state) + " state.");
        }
        this.state = ComponentStorageState.Disposing;
        List<ComponentDescriptor> disposeList = this.getDescriptorsInDisposeOrder();
        for (ComponentDescriptor descriptor2 : disposeList) {
            this.disposeDescriptor(descriptor2);
        }
        this.state = ComponentStorageState.Disposed;
    }

    private final List<ComponentDescriptor> getDescriptorsInDisposeOrder() {
        return DataStructuresKt.topologicalSort((Iterable)this.descriptors, (Function1)new Function1<ComponentDescriptor, Iterable<? extends ComponentDescriptor>>(this){
            final /* synthetic */ ComponentStorage this$0;

            @NotNull
            public final Iterable<ComponentDescriptor> invoke(@NotNull ComponentDescriptor it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ArrayList<ComponentDescriptor> dependent = new ArrayList<ComponentDescriptor>();
                for (Type interfaceType : ComponentStorage.access$getDependencies$p(this.this$0).get(it)) {
                    ComponentRegistry componentRegistry = ComponentStorage.access$getRegistry$p(this.this$0);
                    Type type2 = interfaceType;
                    Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"interfaceType");
                    for (ComponentDescriptor dependency : componentRegistry.tryGetEntry(type2)) {
                        dependent.add(dependency);
                    }
                }
                return dependent;
            }
            {
                this.this$0 = componentStorage;
                super(1);
            }
        });
    }

    private final void disposeDescriptor(ComponentDescriptor descriptor2) {
        if (descriptor2 instanceof Closeable) {
            ((Closeable)((Object)descriptor2)).close();
        }
    }

    public ComponentStorage(@NotNull String myId, @Nullable ComponentStorage parent2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)myId, (String)"myId");
            this.myId = myId;
            this.state = ComponentStorageState.Initial;
            this.descriptors = new LinkedHashSet();
            MultiMap multiMap = MultiMap.createLinkedSet();
            Intrinsics.checkNotNullExpressionValue(multiMap, (String)"MultiMap.createLinkedSet\u2026ponentDescriptor, Type>()");
            this.dependencies = multiMap;
            this.clashResolvers = new ArrayList();
            this.registry = new ComponentRegistry();
            ComponentStorage componentStorage = parent2;
            if (componentStorage == null) break block0;
            ComponentStorage componentStorage2 = componentStorage;
            boolean bl = false;
            boolean bl2 = false;
            ComponentStorage it = componentStorage2;
            boolean bl3 = false;
            this.registry.addAll(it.registry);
            this.clashResolvers.addAll((Collection)it.clashResolvers);
        }
    }

    public static final /* synthetic */ MultiMap access$getDependencies$p(ComponentStorage $this) {
        return $this.dependencies;
    }

    public static final /* synthetic */ ComponentRegistry access$getRegistry$p(ComponentStorage $this) {
        return $this.registry;
    }
}

