/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKt;
import org.jetbrains.kotlin.fir.backend.ConversionTypeContext;
import org.jetbrains.kotlin.fir.backend.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrClassifierStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrConversionScope;
import org.jetbrains.kotlin.fir.backend.Fir2IrDeclarationStorage;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.synthetic.FirSyntheticProperty;
import org.jetbrains.kotlin.fir.declarations.synthetic.FirSyntheticPropertyAccessor;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirConstKind;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.references.FirThisReference;
import org.jetbrains.kotlin.fir.references.impl.FirPropertyFromParameterResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.SamResolutionKt;
import org.jetbrains.kotlin.fir.resolve.calls.SyntheticPropertySymbol;
import org.jetbrains.kotlin.fir.resolve.providers.FirProvider;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.AccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirBackingFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirDelegateFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunctionKt;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.impl.IrValueParameterImpl;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.descriptors.WrappedReceiverParameterDescriptor;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStatementOriginImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrClassPublicSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrClassSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrErrorType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeCheckerContext;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.impl.IrErrorTypeImpl;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.AbstractTypeCheckerContext;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u008a\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\f\u001a\u00020\rH\u0000\u001a\u001e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012\u001a\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015*\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u001aJ\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u001a*\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\u0017\u001a\u00020\u00182$\u0010\u001b\u001a \u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u0001\u0012\u0004\u0012\u00020\u00070\u0005H\u0000\u001a^\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u001a*\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u00012$\u0010\u001b\u001a \u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u0001\u0012\u0004\u0012\u00020\u00070\u0005H\u0002\u001aZ\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u001a*\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u00012$\u0010\u001b\u001a \u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u0001\u0012\u0004\u0012\u00020\u00070\u0005H\u0002\u001aS\u0010 \u001a\u0002H!\"\b\b\u0000\u0010!*\u00020\"*\u00020#26\u0010$\u001a2\u0012\u0013\u0012\u00110%\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b((\u0012\u0013\u0012\u00110%\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b()\u0012\u0004\u0012\u0002H!0\u0005H\u0000\u00a2\u0006\u0002\u0010*\u001a8\u0010+\u001a\u00020,*\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\n2\u0006\u00101\u001a\u0002022\b\b\u0002\u0010(\u001a\u00020%2\b\b\u0002\u0010)\u001a\u00020%H\u0000\u001a#\u00103\u001a\u0006\u0012\u0002\b\u000304*\u0006\u0012\u0002\b\u0003042\f\b\u0002\u00105\u001a\u0006\u0012\u0002\b\u000304H\u0080\u0010\u001a\u0015\u00106\u001a\u0006\u0012\u0002\b\u000304*\u0006\u0012\u0002\b\u000304H\u0080\u0010\u001aB\u00107\u001a\b\u0012\u0004\u0012\u00020908*\u00020:2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002090;2\u000e\b\u0002\u0010<\u001a\b\u0012\u0004\u0012\u00020:0=H\u0000\u001a>\u0010>\u001a\b\u0012\u0004\u0012\u00020908*\u00020:2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002090;2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020:0=H\u0002\u001a\u0012\u0010?\u001a\u0006\u0012\u0002\b\u00030@*\u0006\u0012\u0002\b\u00030A\u001a\u0010\u0010B\u001a\u0004\u0018\u00010C*\u0006\u0012\u0002\b\u00030\u0016\u001a\u0010\u0010D\u001a\u0004\u0018\u00010E*\u0006\u0012\u0002\b\u00030\u0016\u001a\u0016\u0010F\u001a\u000202*\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010G\u001a\u00020H\u001a\u000e\u0010I\u001a\u0004\u0018\u00010J*\u00020KH\u0000\u001a$\u0010L\u001a\b\u0012\u0004\u0012\u0002H!0M\"\u0004\b\u0000\u0010!*\b\u0012\u0004\u0012\u0002H!0A2\u0006\u0010N\u001a\u00020\n\u001a\u0014\u0010O\u001a\u0006\u0012\u0002\b\u00030@*\u0006\u0012\u0002\b\u00030PH\u0002\u001a6\u0010Q\u001a\u0004\u0018\u000109*\u00020K2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020W2\b\b\u0002\u0010X\u001a\u00020\t\u001a\"\u0010Q\u001a\u0004\u0018\u000109*\u0006\u0012\u0002\b\u0003042\u0006\u0010T\u001a\u00020U2\u0006\u0010X\u001a\u00020\tH\u0002\u001a(\u0010Q\u001a\u00020Y*\u0006\u0012\u0002\b\u00030Z2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010R\u001a\u00020S2\b\b\u0002\u0010[\u001a\u00020\\\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\",\u0010\u0004\u001a \u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u0001\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\b\u001a\u00020\t*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u000b\u00a8\u0006]"}, d2={"nameToOperationConventionOrigin", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOriginImpl;", "simpleDeclarationCollector", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "", "isSamType", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Z", "createErrorType", "Lorg/jetbrains/kotlin/ir/types/IrErrorType;", "isOverriding", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "target", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "superCandidate", "collectCallableNamesFromSupertypes", "", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "collectContributedFunctionsFromSupertypes", "", "record", "collectDeclarationsFromSupertypes", "result", "collectDeclarationsFromThisAndSupertypes", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "convertWithOffsets", "T", "Lorg/jetbrains/kotlin/ir/IrElement;", "Lorg/jetbrains/kotlin/fir/FirElement;", "f", "", "Lkotlin/ParameterName;", "name", "startOffset", "endOffset", "(Lorg/jetbrains/kotlin/fir/FirElement;Lkotlin/jvm/functions/Function2;)Lorg/jetbrains/kotlin/ir/IrElement;", "declareThisReceiverParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "thisType", "thisOrigin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "deepestMatchingOverriddenSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "root", "deepestOverriddenSymbol", "findMatchingOverriddenSymbolsFromSupertypes", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "", "visited", "", "findMatchingOverriddenSymbolsFromThisAndSupertypes", "getIrConstKind", "Lorg/jetbrains/kotlin/ir/expressions/IrConstKind;", "Lorg/jetbrains/kotlin/fir/expressions/FirConstExpression;", "getPrimaryConstructorIfAny", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "getSamIfAny", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "irOrigin", "firProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirProvider;", "statementOrigin", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;", "Lorg/jetbrains/kotlin/fir/references/FirReference;", "toIrConst", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "irType", "toIrConstKind", "Lorg/jetbrains/kotlin/fir/expressions/FirConstKind;", "toSymbol", "classifierStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "declarationStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "conversionScope", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;", "preferGetter", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "typeContext", "Lorg/jetbrains/kotlin/fir/backend/ConversionTypeContext;", "fir2ir"})
public final class ConversionUtilsKt {
    private static final Function2<FirDeclaration, Map<Name, FirDeclaration>, Unit> simpleDeclarationCollector = simpleDeclarationCollector.1.INSTANCE;
    private static final Map<Name, IrStatementOriginImpl> nameToOperationConventionOrigin = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)OperatorNameConventions.PLUS, (Object)IrStatementOrigin.PLUS.INSTANCE), TuplesKt.to((Object)OperatorNameConventions.MINUS, (Object)IrStatementOrigin.MINUS.INSTANCE), TuplesKt.to((Object)OperatorNameConventions.TIMES, (Object)IrStatementOrigin.MUL.INSTANCE), TuplesKt.to((Object)OperatorNameConventions.DIV, (Object)IrStatementOrigin.DIV.INSTANCE), TuplesKt.to((Object)OperatorNameConventions.MOD, (Object)IrStatementOrigin.PERC.INSTANCE), TuplesKt.to((Object)OperatorNameConventions.REM, (Object)IrStatementOrigin.PERC.INSTANCE), TuplesKt.to((Object)OperatorNameConventions.RANGE_TO, (Object)IrStatementOrigin.RANGE.INSTANCE)});

    @NotNull
    public static final <T extends IrElement> T convertWithOffsets(@NotNull FirElement $this$convertWithOffsets, @NotNull Function2<? super Integer, ? super Integer, ? extends T> f) {
        Intrinsics.checkNotNullParameter((Object)$this$convertWithOffsets, (String)"$this$convertWithOffsets");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        if (FirSourceElementKt.getPsi($this$convertWithOffsets) instanceof PsiCompiledElement) {
            return (T)((IrElement)f.invoke((Object)-1, (Object)-1));
        }
        PsiElement psiElement = FirSourceElementKt.getPsi($this$convertWithOffsets);
        int startOffset = psiElement != null ? PsiUtilsKt.getStartOffsetSkippingComments(psiElement) : -1;
        PsiElement psiElement2 = FirSourceElementKt.getPsi($this$convertWithOffsets);
        int endOffset = psiElement2 != null ? PsiUtilsKt.getEndOffset(psiElement2) : -1;
        return (T)((IrElement)f.invoke((Object)startOffset, (Object)endOffset));
    }

    @NotNull
    public static final IrErrorType createErrorType() {
        return new IrErrorTypeImpl(null, CollectionsKt.emptyList(), Variance.INVARIANT);
    }

    @NotNull
    public static final IrClassifierSymbol toSymbol(@NotNull FirClassifierSymbol<?> $this$toSymbol, @NotNull FirSession session, @NotNull Fir2IrClassifierStorage classifierStorage, @NotNull ConversionTypeContext typeContext) {
        IrClassifierSymbol irClassifierSymbol;
        Intrinsics.checkNotNullParameter($this$toSymbol, (String)"$this$toSymbol");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)classifierStorage, (String)"classifierStorage");
        Intrinsics.checkNotNullParameter((Object)typeContext, (String)"typeContext");
        FirClassifierSymbol<?> firClassifierSymbol = $this$toSymbol;
        if (firClassifierSymbol instanceof FirTypeParameterSymbol) {
            irClassifierSymbol = classifierStorage.getIrTypeParameterSymbol((FirTypeParameterSymbol)$this$toSymbol, typeContext);
        } else if (firClassifierSymbol instanceof FirTypeAliasSymbol) {
            FirTypeAlias typeAlias = (FirTypeAlias)((FirTypeAliasSymbol)$this$toSymbol).getFir();
            FirTypeRef firTypeRef = typeAlias.getExpandedTypeRef();
            if (firTypeRef == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.FirResolvedTypeRef");
            }
            ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)firTypeRef).getType();
            if (coneKotlinType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeClassLikeType");
            }
            ConeClassLikeType coneClassLikeType = (ConeClassLikeType)coneKotlinType;
            FirClassLikeSymbol<?> firClassLikeSymbol = ResolveUtilsKt.toSymbol(coneClassLikeType.getLookupTag(), session);
            Intrinsics.checkNotNull(firClassLikeSymbol);
            irClassifierSymbol = ConversionUtilsKt.toSymbol$default(firClassLikeSymbol, session, classifierStorage, null, 4, null);
        } else if (firClassifierSymbol instanceof FirClassSymbol) {
            irClassifierSymbol = classifierStorage.getIrClassSymbol((FirClassSymbol)$this$toSymbol);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Should not be here: " + $this$toSymbol)));
        }
        return irClassifierSymbol;
    }

    public static /* synthetic */ IrClassifierSymbol toSymbol$default(FirClassifierSymbol firClassifierSymbol, FirSession firSession, Fir2IrClassifierStorage fir2IrClassifierStorage, ConversionTypeContext conversionTypeContext, int n, Object object) {
        if ((n & 4) != 0) {
            conversionTypeContext = ConversionTypeContext.Companion.getDEFAULT$fir2ir();
        }
        return ConversionUtilsKt.toSymbol(firClassifierSymbol, firSession, fir2IrClassifierStorage, conversionTypeContext);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final IrSymbol toSymbol(@NotNull FirReference $this$toSymbol, @NotNull FirSession session, @NotNull Fir2IrClassifierStorage classifierStorage, @NotNull Fir2IrDeclarationStorage declarationStorage, @NotNull Fir2IrConversionScope conversionScope, boolean preferGetter) {
        block5: {
            block7: {
                block9: {
                    block11: {
                        block10: {
                            block8: {
                                block3: {
                                    block6: {
                                        block4: {
                                            Intrinsics.checkNotNullParameter((Object)$this$toSymbol, (String)"$this$toSymbol");
                                            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                                            Intrinsics.checkNotNullParameter((Object)classifierStorage, (String)"classifierStorage");
                                            Intrinsics.checkNotNullParameter((Object)declarationStorage, (String)"declarationStorage");
                                            Intrinsics.checkNotNullParameter((Object)conversionScope, (String)"conversionScope");
                                            var6_6 = $this$toSymbol;
                                            if (!(var6_6 instanceof FirResolvedNamedReference)) break block3;
                                            resolvedSymbol = ((FirResolvedNamedReference)$this$toSymbol).getResolvedSymbol();
                                            if (!(resolvedSymbol instanceof FirCallableSymbol)) break block4;
                                            v0 = ConversionUtilsKt.toSymbol(ConversionUtilsKt.deepestMatchingOverriddenSymbol$default((FirCallableSymbol)resolvedSymbol, null, 1, null), declarationStorage, preferGetter);
                                            break block5;
                                        }
                                        if (!(resolvedSymbol instanceof FirClassifierSymbol)) break block6;
                                        v0 = ConversionUtilsKt.toSymbol$default((FirClassifierSymbol)resolvedSymbol, session, classifierStorage, null, 4, null);
                                        break block5;
                                    }
                                    throw (Throwable)new AssertionError((Object)("Unknown symbol: " + resolvedSymbol));
                                }
                                if (!(var6_6 instanceof FirThisReference)) break block7;
                                boundSymbol = ((FirThisReference)$this$toSymbol).getBoundSymbol();
                                if (!(boundSymbol instanceof FirClassSymbol)) break block8;
                                v1 = ((IrClass)classifierStorage.getIrClassSymbol((FirClassSymbol)boundSymbol).getOwner()).getThisReceiver();
                                v2 = v1 != null ? (IrValueParameterSymbol)v1.getSymbol() : null;
                                break block9;
                            }
                            if (!(boundSymbol instanceof FirFunctionSymbol)) break block10;
                            v3 = declarationStorage.getIrFunctionSymbol((FirFunctionSymbol)boundSymbol).getOwner().getExtensionReceiverParameter();
                            v2 = v3 != null ? (IrValueParameterSymbol)v3.getSymbol() : null;
                            break block9;
                        }
                        if (!(boundSymbol instanceof FirPropertySymbol)) break block11;
                        v4 = declarationStorage.getIrPropertyOrFieldSymbol((FirVariableSymbol)boundSymbol).getOwner();
                        if (!(v4 instanceof IrProperty)) {
                            v4 = null;
                        }
                        if ((v5 = (property = (IrProperty)v4)) == null) ** GOTO lbl-1000
                        var9_10 = v5;
                        var10_11 = false;
                        var11_12 = false;
                        it = var9_10;
                        $i$a$-let-ConversionUtilsKt$toSymbol$1 = false;
                        v5 = conversionScope.parentAccessorOfPropertyFromStack(it);
                        if (v5 != null) {
                            v6 = (IrSimpleFunctionSymbol)v5.getSymbol();
                        } else lbl-1000:
                        // 2 sources

                        {
                            v6 = null;
                        }
                        v2 = v6;
                        break block9;
                    }
                    v2 = null;
                }
                v0 = v2;
                break block5;
            }
            v0 = null;
        }
        return v0;
    }

    public static /* synthetic */ IrSymbol toSymbol$default(FirReference firReference, FirSession firSession, Fir2IrClassifierStorage fir2IrClassifierStorage, Fir2IrDeclarationStorage fir2IrDeclarationStorage, Fir2IrConversionScope fir2IrConversionScope, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        return ConversionUtilsKt.toSymbol(firReference, firSession, fir2IrClassifierStorage, fir2IrDeclarationStorage, fir2IrConversionScope, bl);
    }

    private static final IrSymbol toSymbol(FirCallableSymbol<?> $this$toSymbol, Fir2IrDeclarationStorage declarationStorage, boolean preferGetter) {
        Object object;
        block6: {
            FirCallableSymbol<?> firCallableSymbol;
            block7: {
                block8: {
                    IrSymbol irSymbol;
                    block5: {
                        firCallableSymbol = $this$toSymbol;
                        if (!(firCallableSymbol instanceof FirFunctionSymbol)) break block5;
                        object = declarationStorage.getIrFunctionSymbol((FirFunctionSymbol)$this$toSymbol);
                        break block6;
                    }
                    if (!(firCallableSymbol instanceof SyntheticPropertySymbol)) break block7;
                    Object e = ((SyntheticPropertySymbol)$this$toSymbol).getFir();
                    if (!(e instanceof FirSyntheticProperty)) {
                        e = null;
                    }
                    if ((object = (FirSyntheticProperty)e) == null) break block8;
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object syntheticProperty = object2;
                    boolean bl3 = false;
                    if (preferGetter) {
                        irSymbol = ConversionUtilsKt.toSymbol((FirCallableSymbol)((FirSyntheticProperty)syntheticProperty).getGetter().getDelegate().getSymbol(), declarationStorage, preferGetter);
                    } else {
                        FirSyntheticPropertyAccessor firSyntheticPropertyAccessor = ((FirSyntheticProperty)syntheticProperty).getSetter();
                        Intrinsics.checkNotNull((Object)firSyntheticPropertyAccessor);
                        irSymbol = ConversionUtilsKt.toSymbol((FirCallableSymbol)firSyntheticPropertyAccessor.getDelegate().getSymbol(), declarationStorage, preferGetter);
                    }
                    object = irSymbol;
                    if (irSymbol != null) break block6;
                }
                object = ((FirProperty)((SyntheticPropertySymbol)$this$toSymbol).getFir()).isLocal() ? declarationStorage.getIrValueSymbol((FirVariableSymbol)$this$toSymbol) : declarationStorage.getIrPropertyOrFieldSymbol((FirVariableSymbol)$this$toSymbol);
                break block6;
            }
            object = firCallableSymbol instanceof FirPropertySymbol ? (((FirProperty)((FirPropertySymbol)$this$toSymbol).getFir()).isLocal() ? declarationStorage.getIrValueSymbol((FirVariableSymbol)$this$toSymbol) : declarationStorage.getIrPropertyOrFieldSymbol((FirVariableSymbol)$this$toSymbol)) : (firCallableSymbol instanceof FirFieldSymbol ? declarationStorage.getIrPropertyOrFieldSymbol((FirVariableSymbol)$this$toSymbol) : (firCallableSymbol instanceof FirBackingFieldSymbol ? declarationStorage.getIrBackingFieldSymbol((FirVariableSymbol)$this$toSymbol) : (firCallableSymbol instanceof FirDelegateFieldSymbol ? declarationStorage.getIrBackingFieldSymbol((FirVariableSymbol)$this$toSymbol) : (firCallableSymbol instanceof FirVariableSymbol ? declarationStorage.getIrValueSymbol((FirVariableSymbol)$this$toSymbol) : null))));
        }
        return object;
    }

    @NotNull
    public static final IrConstKind<?> getIrConstKind(@NotNull FirConstExpression<?> $this$getIrConstKind) {
        IrConstKind<?> irConstKind;
        Intrinsics.checkNotNullParameter($this$getIrConstKind, (String)"$this$getIrConstKind");
        FirConstKind<?> firConstKind = $this$getIrConstKind.getKind();
        if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.IntegerLiteral.INSTANCE)) {
            FirTypeRef $this$coneTypeUnsafe$iv = $this$getIrConstKind.getTypeRef();
            boolean $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getType();
            if (coneKotlinType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType");
            }
            ConeIntegerLiteralType type2 = (ConeIntegerLiteralType)((ConeKotlinType)((ConeIntegerLiteralType)coneKotlinType));
            FirConstKind<?> firConstKind2 = FirTypeUtilsKt.toConstKind(ConeIntegerLiteralType.getApproximatedType$default(type2, null, 1, null));
            Intrinsics.checkNotNull(firConstKind2);
            irConstKind = ConversionUtilsKt.toIrConstKind(firConstKind2);
        } else {
            irConstKind = ConversionUtilsKt.toIrConstKind($this$getIrConstKind.getKind());
        }
        return irConstKind;
    }

    @NotNull
    public static final <T> IrConst<T> toIrConst(@NotNull FirConstExpression<T> $this$toIrConst, @NotNull IrType irType) {
        Intrinsics.checkNotNullParameter($this$toIrConst, (String)"$this$toIrConst");
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        return (IrConst)ConversionUtilsKt.convertWithOffsets($this$toIrConst, (Function2)new Function2<Integer, Integer, IrConstImpl<T>>($this$toIrConst, irType){
            final /* synthetic */ FirConstExpression $this_toIrConst;
            final /* synthetic */ IrType $irType;

            @NotNull
            public final IrConstImpl<T> invoke(int startOffset, int endOffset) {
                Byte by;
                Number number;
                IrConstKind<?> irConstKind = ConversionUtilsKt.getIrConstKind(this.$this_toIrConst);
                if (irConstKind == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConstKind<T>");
                }
                IrConstKind<?> kind = irConstKind;
                T t = this.$this_toIrConst.getValue();
                if (!(t instanceof Long)) {
                    t = null;
                }
                Long l = (Long)t;
                if (l != null) {
                    Long l2 = l;
                    boolean bl = false;
                    boolean bl2 = false;
                    long it = ((Number)l2).longValue();
                    boolean bl3 = false;
                    IrConstKind<?> irConstKind2 = kind;
                    number = Intrinsics.areEqual(irConstKind2, (Object)IrConstKind.Byte.INSTANCE) ? (Number)Byte.valueOf((byte)it) : (Number)(Intrinsics.areEqual(irConstKind2, (Object)IrConstKind.Short.INSTANCE) ? (Number)Short.valueOf((short)it) : (Number)(Intrinsics.areEqual(irConstKind2, (Object)IrConstKind.Int.INSTANCE) ? (Number)Integer.valueOf((int)it) : (Number)(Intrinsics.areEqual(irConstKind2, (Object)IrConstKind.Float.INSTANCE) ? (Number)Float.valueOf(it) : (Number)(Intrinsics.areEqual(irConstKind2, (Object)IrConstKind.Double.INSTANCE) ? (Number)Double.valueOf(it) : (Number)Long.valueOf(it)))));
                } else {
                    number = by = null;
                }
                if (number == null) {
                    by = (Byte)this.$this_toIrConst.getValue();
                }
                Byte value2 = by;
                return new IrConstImpl<Object>(startOffset, endOffset, this.$irType, (IrConstKind<Object>)kind, value2);
            }
            {
                this.$this_toIrConst = firConstExpression;
                this.$irType = irType;
                super(2);
            }
        });
    }

    private static final IrConstKind<?> toIrConstKind(FirConstKind<?> $this$toIrConstKind) {
        IrConstKind irConstKind;
        FirConstKind<?> firConstKind = $this$toIrConstKind;
        if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.Null.INSTANCE)) {
            irConstKind = IrConstKind.Null.INSTANCE;
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.Boolean.INSTANCE)) {
            irConstKind = IrConstKind.Boolean.INSTANCE;
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.Char.INSTANCE)) {
            irConstKind = IrConstKind.Char.INSTANCE;
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.Byte.INSTANCE)) {
            irConstKind = IrConstKind.Byte.INSTANCE;
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.Short.INSTANCE)) {
            irConstKind = IrConstKind.Short.INSTANCE;
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.Int.INSTANCE)) {
            irConstKind = IrConstKind.Int.INSTANCE;
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.Long.INSTANCE)) {
            irConstKind = IrConstKind.Long.INSTANCE;
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.UnsignedByte.INSTANCE)) {
            irConstKind = IrConstKind.Byte.INSTANCE;
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.UnsignedShort.INSTANCE)) {
            irConstKind = IrConstKind.Short.INSTANCE;
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.UnsignedInt.INSTANCE)) {
            irConstKind = IrConstKind.Int.INSTANCE;
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.UnsignedLong.INSTANCE)) {
            irConstKind = IrConstKind.Long.INSTANCE;
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.String.INSTANCE)) {
            irConstKind = IrConstKind.String.INSTANCE;
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.Float.INSTANCE)) {
            irConstKind = IrConstKind.Float.INSTANCE;
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.Double.INSTANCE)) {
            irConstKind = IrConstKind.Double.INSTANCE;
        } else {
            if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.IntegerLiteral.INSTANCE) || Intrinsics.areEqual(firConstKind, (Object)FirConstKind.UnsignedIntegerLiteral.INSTANCE)) {
                throw (Throwable)new IllegalArgumentException();
            }
            throw new NoWhenBranchMatchedException();
        }
        return irConstKind;
    }

    @NotNull
    public static final Set<Name> collectCallableNamesFromSupertypes(@NotNull FirClass<?> $this$collectCallableNamesFromSupertypes, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$collectCallableNamesFromSupertypes, (String)"$this$collectCallableNamesFromSupertypes");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        boolean bl = false;
        Map result2 = new LinkedHashMap();
        for (FirTypeRef superTypeRef : $this$collectCallableNamesFromSupertypes.getSuperTypeRefs()) {
            ConversionUtilsKt.collectDeclarationsFromThisAndSupertypes(superTypeRef, session, result2, simpleDeclarationCollector);
        }
        return result2.keySet();
    }

    @NotNull
    public static final Map<Name, FirDeclaration> collectContributedFunctionsFromSupertypes(@NotNull FirClass<?> $this$collectContributedFunctionsFromSupertypes, @NotNull FirSession session, @NotNull Function2<? super FirDeclaration, ? super Map<Name, FirDeclaration>, Unit> record2) {
        Intrinsics.checkNotNullParameter($this$collectContributedFunctionsFromSupertypes, (String)"$this$collectContributedFunctionsFromSupertypes");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(record2, (String)"record");
        boolean bl = false;
        Map result2 = new LinkedHashMap();
        for (FirTypeRef superTypeRef : $this$collectContributedFunctionsFromSupertypes.getSuperTypeRefs()) {
            ConversionUtilsKt.collectDeclarationsFromThisAndSupertypes(superTypeRef, session, result2, record2);
        }
        return result2;
    }

    private static final Map<Name, FirDeclaration> collectDeclarationsFromSupertypes(FirClass<?> $this$collectDeclarationsFromSupertypes, FirSession session, Map<Name, FirDeclaration> result2, Function2<? super FirDeclaration, ? super Map<Name, FirDeclaration>, Unit> record2) {
        for (FirTypeRef superTypeRef : $this$collectDeclarationsFromSupertypes.getSuperTypeRefs()) {
            ConversionUtilsKt.collectDeclarationsFromThisAndSupertypes(superTypeRef, session, result2, record2);
        }
        return result2;
    }

    private static final Map<Name, FirDeclaration> collectDeclarationsFromThisAndSupertypes(FirTypeRef $this$collectDeclarationsFromThisAndSupertypes, FirSession session, Map<Name, FirDeclaration> result2, Function2<? super FirDeclaration, ? super Map<Name, FirDeclaration>, Unit> record2) {
        block2: {
            FirClassLikeSymbol<?> superSymbol;
            block3: {
                ConeKotlinType superType;
                if (!($this$collectDeclarationsFromThisAndSupertypes instanceof FirResolvedTypeRef) || !((superType = ((FirResolvedTypeRef)$this$collectDeclarationsFromThisAndSupertypes).getType()) instanceof ConeClassLikeType)) break block2;
                superSymbol = ResolveUtilsKt.toSymbol(((ConeClassLikeType)superType).getLookupTag(), session);
                if (!(superSymbol instanceof FirClassSymbol)) break block3;
                Object e = superSymbol.getFir();
                if (e == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirClass<*>");
                }
                FirClass superClass = (FirClass)e;
                for (FirDeclaration declaration2 : superClass.getDeclarations()) {
                    record2.invoke((Object)declaration2, result2);
                }
                ConversionUtilsKt.collectDeclarationsFromSupertypes(superClass, session, result2, record2);
                break block2;
            }
            if (!(superSymbol instanceof FirTypeAliasSymbol)) break block2;
            FirTypeAlias superAlias = (FirTypeAlias)((FirTypeAliasSymbol)superSymbol).getFir();
            ConversionUtilsKt.collectDeclarationsFromThisAndSupertypes(superAlias.getExpandedTypeRef(), session, result2, record2);
        }
        return result2;
    }

    @NotNull
    public static final FirCallableSymbol<?> deepestOverriddenSymbol(@NotNull FirCallableSymbol<?> $this$deepestOverriddenSymbol) {
        while (true) {
            FirCallableSymbol<?> overriddenSymbol;
            Intrinsics.checkNotNullParameter($this$deepestOverriddenSymbol, (String)"$this$deepestOverriddenSymbol");
            if ($this$deepestOverriddenSymbol.getOverriddenSymbol() == null) {
                return $this$deepestOverriddenSymbol;
            }
            $this$deepestOverriddenSymbol = overriddenSymbol;
        }
    }

    @NotNull
    public static final FirCallableSymbol<?> deepestMatchingOverriddenSymbol(@NotNull FirCallableSymbol<?> $this$deepestMatchingOverriddenSymbol, @NotNull FirCallableSymbol<?> root2) {
        while (true) {
            FirCallableSymbol<Object> firCallableSymbol;
            block4: {
                block3: {
                    Intrinsics.checkNotNullParameter($this$deepestMatchingOverriddenSymbol, (String)"$this$deepestMatchingOverriddenSymbol");
                    Intrinsics.checkNotNullParameter(root2, (String)"root");
                    firCallableSymbol = $this$deepestMatchingOverriddenSymbol.getOverriddenSymbol();
                    if (firCallableSymbol == null) break block3;
                    FirCallableSymbol<?> firCallableSymbol2 = firCallableSymbol;
                    boolean bl = false;
                    boolean bl2 = false;
                    FirCallableSymbol<?> it = firCallableSymbol2;
                    boolean bl3 = false;
                    firCallableSymbol = Intrinsics.areEqual((Object)it.getCallableId(), (Object)root2.getCallableId()) ? firCallableSymbol2 : null;
                    if (firCallableSymbol != null) break block4;
                }
                return $this$deepestMatchingOverriddenSymbol;
            }
            FirCallableSymbol<?> overriddenSymbol = firCallableSymbol;
            root2 = $this$deepestMatchingOverriddenSymbol;
            $this$deepestMatchingOverriddenSymbol = overriddenSymbol;
        }
    }

    public static /* synthetic */ FirCallableSymbol deepestMatchingOverriddenSymbol$default(FirCallableSymbol firCallableSymbol, FirCallableSymbol firCallableSymbol2, int n, Object object) {
        if ((n & 1) != 0) {
            firCallableSymbol2 = firCallableSymbol;
        }
        return ConversionUtilsKt.deepestMatchingOverriddenSymbol(firCallableSymbol, firCallableSymbol2);
    }

    @NotNull
    public static final List<IrSymbol> findMatchingOverriddenSymbolsFromSupertypes(@NotNull IrClass $this$findMatchingOverriddenSymbolsFromSupertypes, @NotNull IrBuiltIns irBuiltIns, @NotNull IrDeclaration target, @NotNull List<IrSymbol> result2, @NotNull Set<IrClass> visited2) {
        Intrinsics.checkNotNullParameter((Object)$this$findMatchingOverriddenSymbolsFromSupertypes, (String)"$this$findMatchingOverriddenSymbolsFromSupertypes");
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        Intrinsics.checkNotNullParameter(visited2, (String)"visited");
        for (IrType superType : $this$findMatchingOverriddenSymbolsFromSupertypes.getSuperTypes()) {
            IrClassSymbol superTypeClass = IrTypesKt.getClassOrNull(superType);
            if (!(superTypeClass instanceof IrClassSymbolImpl) && !(superTypeClass instanceof IrClassPublicSymbolImpl)) continue;
            ConversionUtilsKt.findMatchingOverriddenSymbolsFromThisAndSupertypes((IrClass)superTypeClass.getOwner(), irBuiltIns, target, result2, visited2);
        }
        return result2;
    }

    public static /* synthetic */ List findMatchingOverriddenSymbolsFromSupertypes$default(IrClass irClass2, IrBuiltIns irBuiltIns, IrDeclaration irDeclaration2, List list2, Set set, int n, Object object) {
        boolean bl;
        if ((n & 4) != 0) {
            bl = false;
            list2 = new ArrayList();
        }
        if ((n & 8) != 0) {
            bl = false;
            set = new LinkedHashSet();
        }
        return ConversionUtilsKt.findMatchingOverriddenSymbolsFromSupertypes(irClass2, irBuiltIns, irDeclaration2, list2, set);
    }

    private static final List<IrSymbol> findMatchingOverriddenSymbolsFromThisAndSupertypes(IrClass $this$findMatchingOverriddenSymbolsFromThisAndSupertypes, IrBuiltIns irBuiltIns, IrDeclaration target, List<IrSymbol> result2, Set<IrClass> visited2) {
        if (visited2.contains($this$findMatchingOverriddenSymbolsFromThisAndSupertypes)) {
            return result2;
        }
        Collection collection = visited2;
        boolean bl = false;
        collection.add($this$findMatchingOverriddenSymbolsFromThisAndSupertypes);
        boolean targetIsPropertyAccessor = target instanceof IrFunction && IrSimpleFunctionKt.isPropertyAccessor((IrFunction)target);
        for (IrDeclaration declaration2 : $this$findMatchingOverriddenSymbolsFromThisAndSupertypes.getDeclarations()) {
            IrSimpleFunction setter2;
            if (IrFakeOverrideUtilsKt.isFakeOverride(declaration2) || declaration2 instanceof IrConstructor) continue;
            if (declaration2 instanceof IrSimpleFunction && target instanceof IrSimpleFunction) {
                if (((IrSimpleFunction)declaration2).getModality() == Modality.FINAL || Visibilities.isPrivate(((IrSimpleFunction)declaration2).getVisibility()) || !ConversionUtilsKt.isOverriding(irBuiltIns, target, declaration2)) continue;
                result2.add(((IrSimpleFunction)declaration2).getSymbol());
                continue;
            }
            if (!(declaration2 instanceof IrProperty) || !(target instanceof IrField) && !targetIsPropertyAccessor) continue;
            IrField backingField2 = ((IrProperty)declaration2).getBackingField();
            if (target instanceof IrField && backingField2 != null && !backingField2.isFinal() && !backingField2.isStatic() && !Visibilities.isPrivate(backingField2.getVisibility()) && ConversionUtilsKt.isOverriding(irBuiltIns, target, backingField2)) {
                result2.add((IrSymbol)backingField2.getSymbol());
            }
            if (!targetIsPropertyAccessor) continue;
            IrSimpleFunction getter2 = ((IrProperty)declaration2).getGetter();
            if (getter2 != null && getter2.getModality() != Modality.FINAL && !Visibilities.isPrivate(getter2.getVisibility()) && ConversionUtilsKt.isOverriding(irBuiltIns, target, getter2)) {
                result2.add(getter2.getSymbol());
            }
            if ((setter2 = ((IrProperty)declaration2).getSetter()) == null || setter2.getModality() == Modality.FINAL || Visibilities.isPrivate(setter2.getVisibility()) || !ConversionUtilsKt.isOverriding(irBuiltIns, target, setter2)) continue;
            result2.add(setter2.getSymbol());
        }
        Collection collection2 = result2;
        boolean bl2 = false;
        if (!collection2.isEmpty()) {
            return result2;
        }
        return ConversionUtilsKt.findMatchingOverriddenSymbolsFromSupertypes($this$findMatchingOverriddenSymbolsFromThisAndSupertypes, irBuiltIns, target, result2, visited2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isOverriding(@NotNull IrBuiltIns irBuiltIns, @NotNull IrDeclaration target, @NotNull IrDeclaration superCandidate) {
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)superCandidate, (String)"superCandidate");
        AbstractTypeCheckerContext typeCheckerContext = new IrTypeCheckerContext(irBuiltIns);
        Function2<IrType, IrType, Boolean> $fun$equalTypes$1 = new Function2<IrType, IrType, Boolean>(typeCheckerContext){
            final /* synthetic */ AbstractTypeCheckerContext $typeCheckerContext;

            public final boolean invoke(@NotNull IrType first, @NotNull IrType second) {
                Intrinsics.checkNotNullParameter((Object)first, (String)"first");
                Intrinsics.checkNotNullParameter((Object)second, (String)"second");
                return AbstractTypeChecker.INSTANCE.equalTypes(this.$typeCheckerContext, first, second) || IrTypesKt.getClassifierOrNull(second) instanceof IrTypeParameterSymbol;
            }
            {
                this.$typeCheckerContext = abstractTypeCheckerContext;
                super(2);
            }
        };
        if (target instanceof IrFunction && superCandidate instanceof IrFunction) {
            IrValueParameter superCandidateParameter;
            void targetParameter;
            if (!Intrinsics.areEqual((Object)((IrFunction)target).getName(), (Object)((IrFunction)superCandidate).getName())) return false;
            IrAnnotationContainer irAnnotationContainer = ((IrFunction)target).getExtensionReceiverParameter();
            if (irAnnotationContainer != null && (irAnnotationContainer = irAnnotationContainer.getType()) != null) {
                IrAnnotationContainer irAnnotationContainer2 = irAnnotationContainer;
                boolean bl = false;
                boolean bl2 = false;
                IrAnnotationContainer irAnnotationContainer3 = irAnnotationContainer2;
                boolean bl3 = false;
                IrValueParameter irValueParameter = ((IrFunction)superCandidate).getExtensionReceiverParameter();
                if (irValueParameter == null) return false;
                IrType irType = irValueParameter.getType();
                IrType superCandidateReceiverType = irType;
                if (superCandidateReceiverType == null) return false;
                if (!$fun$equalTypes$1.invoke((IrType)irAnnotationContainer3, superCandidateReceiverType)) return false;
                boolean bl4 = true;
                if (!bl4) return false;
            }
            if (((IrFunction)target).getValueParameters().size() != ((IrFunction)superCandidate).getValueParameters().size()) return false;
            Iterable iterable = CollectionsKt.zip((Iterable)((IrFunction)target).getValueParameters(), (Iterable)((IrFunction)superCandidate).getValueParameters());
            boolean $i$f$all = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                return true;
            }
            Iterator iterator2 = iterable.iterator();
            do {
                if (!iterator2.hasNext()) return true;
                Object t = iterator2.next();
                Pair $dstr$targetParameter$superCandidateParameter = (Pair)t;
                boolean bl = false;
                IrValueParameter irValueParameter = (IrValueParameter)$dstr$targetParameter$superCandidateParameter.component1();
                superCandidateParameter = (IrValueParameter)$dstr$targetParameter$superCandidateParameter.component2();
            } while ($fun$equalTypes$1.invoke(targetParameter.getType(), superCandidateParameter.getType()));
            return false;
        }
        if (!(target instanceof IrField)) return false;
        if (!(superCandidate instanceof IrField)) return false;
        boolean bl = Intrinsics.areEqual((Object)((IrField)target).getName(), (Object)((IrField)superCandidate).getName());
        return bl;
    }

    @Nullable
    public static final IrStatementOrigin statementOrigin(@NotNull FirReference $this$statementOrigin) {
        IrStatementOriginImpl irStatementOriginImpl;
        Intrinsics.checkNotNullParameter((Object)$this$statementOrigin, (String)"$this$statementOrigin");
        FirReference firReference = $this$statementOrigin;
        if (firReference instanceof FirPropertyFromParameterResolvedNamedReference) {
            irStatementOriginImpl = IrStatementOrigin.INITIALIZE_PROPERTY_FROM_PARAMETER.INSTANCE;
        } else if (firReference instanceof FirResolvedNamedReference) {
            AbstractFirBasedSymbol<?> symbol2 = ((FirResolvedNamedReference)$this$statementOrigin).getResolvedSymbol();
            if (symbol2 instanceof AccessorSymbol || symbol2 instanceof SyntheticPropertySymbol) {
                irStatementOriginImpl = IrStatementOrigin.GET_PROPERTY.INSTANCE;
            } else if (symbol2 instanceof FirNamedFunctionSymbol) {
                if (ResolveUtilsKt.isInvoke(((FirNamedFunctionSymbol)symbol2).getCallableId())) {
                    irStatementOriginImpl = IrStatementOrigin.INVOKE.INSTANCE;
                } else {
                    FirSourceElement firSourceElement = $this$statementOrigin.getSource();
                    if (Intrinsics.areEqual((Object)(firSourceElement != null ? firSourceElement.getElementType() : null), (Object)KtNodeTypes.FOR) && ResolveUtilsKt.isIteratorNext(((FirNamedFunctionSymbol)symbol2).getCallableId())) {
                        irStatementOriginImpl = IrStatementOrigin.FOR_LOOP_NEXT.INSTANCE;
                    } else {
                        FirSourceElement firSourceElement2 = $this$statementOrigin.getSource();
                        if (Intrinsics.areEqual((Object)(firSourceElement2 != null ? firSourceElement2.getElementType() : null), (Object)KtNodeTypes.FOR) && ResolveUtilsKt.isIteratorHasNext(((FirNamedFunctionSymbol)symbol2).getCallableId())) {
                            irStatementOriginImpl = IrStatementOrigin.FOR_LOOP_HAS_NEXT.INSTANCE;
                        } else {
                            FirSourceElement firSourceElement3 = $this$statementOrigin.getSource();
                            if (Intrinsics.areEqual((Object)(firSourceElement3 != null ? firSourceElement3.getElementType() : null), (Object)KtNodeTypes.FOR) && ResolveUtilsKt.isIterator(((FirNamedFunctionSymbol)symbol2).getCallableId())) {
                                irStatementOriginImpl = IrStatementOrigin.FOR_LOOP_ITERATOR.INSTANCE;
                            } else {
                                FirSourceElement firSourceElement4 = $this$statementOrigin.getSource();
                                irStatementOriginImpl = Intrinsics.areEqual((Object)(firSourceElement4 != null ? firSourceElement4.getElementType() : null), (Object)KtNodeTypes.OPERATION_REFERENCE) ? nameToOperationConventionOrigin.get(((FirNamedFunctionSymbol)symbol2).getCallableId().getCallableName()) : null;
                            }
                        }
                    }
                }
            } else {
                irStatementOriginImpl = null;
            }
        } else {
            irStatementOriginImpl = null;
        }
        return irStatementOriginImpl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final FirConstructor getPrimaryConstructorIfAny(@NotNull FirClass<?> $this$getPrimaryConstructorIfAny) {
        FirConstructor firConstructor;
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$getPrimaryConstructorIfAny, (String)"$this$getPrimaryConstructorIfAny");
        Iterable $this$filterIsInstance$iv = $this$getPrimaryConstructorIfAny.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirConstructor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        FirConstructor firConstructor2 = (FirConstructor)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        if (firConstructor2 != null) {
            FirConstructor firConstructor3 = firConstructor2;
            boolean bl = false;
            boolean bl2 = false;
            FirConstructor it = firConstructor3;
            boolean bl3 = false;
            firConstructor = it.isPrimary() ? firConstructor3 : null;
        } else {
            firConstructor = null;
        }
        return firConstructor;
    }

    @NotNull
    public static final IrValueParameter declareThisReceiverParameter(@NotNull IrDeclarationParent $this$declareThisReceiverParameter, @NotNull SymbolTable symbolTable, @NotNull IrType thisType, @NotNull IrDeclarationOrigin thisOrigin, int startOffset, int endOffset) {
        Intrinsics.checkNotNullParameter((Object)$this$declareThisReceiverParameter, (String)"$this$declareThisReceiverParameter");
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        Intrinsics.checkNotNullParameter((Object)thisType, (String)"thisType");
        Intrinsics.checkNotNullParameter((Object)thisOrigin, (String)"thisOrigin");
        WrappedReceiverParameterDescriptor receiverDescriptor = new WrappedReceiverParameterDescriptor(null, null, 3, null);
        return SymbolTable.declareValueParameter$default(symbolTable, startOffset, endOffset, thisOrigin, receiverDescriptor, thisType, null, (Function1)new Function1<IrValueParameterSymbol, IrValueParameter>($this$declareThisReceiverParameter, startOffset, endOffset, thisOrigin, thisType, receiverDescriptor){
            final /* synthetic */ IrDeclarationParent $this_declareThisReceiverParameter;
            final /* synthetic */ int $startOffset;
            final /* synthetic */ int $endOffset;
            final /* synthetic */ IrDeclarationOrigin $thisOrigin;
            final /* synthetic */ IrType $thisType;
            final /* synthetic */ WrappedReceiverParameterDescriptor $receiverDescriptor;

            @NotNull
            public final IrValueParameter invoke(@NotNull IrValueParameterSymbol symbol2) {
                Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
                Name name = Name.special("<this>");
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"Name.special(\"<this>\")");
                IrValueParameterImpl irValueParameterImpl = new IrValueParameterImpl(this.$startOffset, this.$endOffset, this.$thisOrigin, symbol2, name, -1, this.$thisType, null, false, false);
                boolean bl = false;
                boolean bl2 = false;
                IrValueParameterImpl $this$apply = irValueParameterImpl;
                boolean bl3 = false;
                $this$apply.setParent(this.$this_declareThisReceiverParameter);
                this.$receiverDescriptor.bind((IrDeclaration)$this$apply);
                return irValueParameterImpl;
            }
            {
                this.$this_declareThisReceiverParameter = irDeclarationParent;
                this.$startOffset = n;
                this.$endOffset = n2;
                this.$thisOrigin = irDeclarationOrigin;
                this.$thisType = irType;
                this.$receiverDescriptor = wrappedReceiverParameterDescriptor;
                super(1);
            }
        }, 32, null);
    }

    public static /* synthetic */ IrValueParameter declareThisReceiverParameter$default(IrDeclarationParent irDeclarationParent, SymbolTable symbolTable, IrType irType, IrDeclarationOrigin irDeclarationOrigin, int n, int n2, int n3, Object object) {
        if ((n3 & 8) != 0) {
            n = irDeclarationParent.getStartOffset();
        }
        if ((n3 & 0x10) != 0) {
            n2 = irDeclarationParent.getEndOffset();
        }
        return ConversionUtilsKt.declareThisReceiverParameter(irDeclarationParent, symbolTable, irType, irDeclarationOrigin, n, n2);
    }

    @NotNull
    public static final IrDeclarationOrigin irOrigin(@NotNull FirClass<?> $this$irOrigin, @NotNull FirProvider firProvider) {
        Intrinsics.checkNotNullParameter($this$irOrigin, (String)"$this$irOrigin");
        Intrinsics.checkNotNullParameter((Object)firProvider, (String)"firProvider");
        return firProvider.getFirClassifierContainerFileIfAny((FirClassLikeSymbol)$this$irOrigin.getSymbol()) != null ? (IrDeclarationOriginImpl)IrDeclarationOrigin.DEFINED.INSTANCE : (Intrinsics.areEqual((Object)$this$irOrigin.getOrigin(), (Object)FirDeclarationOrigin.Java.INSTANCE) ? (IrDeclarationOriginImpl)IrDeclarationOrigin.IR_EXTERNAL_JAVA_DECLARATION_STUB.INSTANCE : (IrDeclarationOriginImpl)IrDeclarationOrigin.IR_EXTERNAL_DECLARATION_STUB.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final FirSimpleFunction getSamIfAny(@NotNull FirClass<?> $this$getSamIfAny) {
        Iterable iterable;
        block3: {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter($this$getSamIfAny, (String)"$this$getSamIfAny");
            Iterable $this$filterIsInstance$iv = $this$getSamIfAny.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof FirSimpleFunction)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$singleOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                FirSimpleFunction it = (FirSimpleFunction)element$iv;
                boolean bl = false;
                FirMemberDeclaration $this$modality$iv = it;
                boolean $i$f$getModality = false;
                if (!($this$modality$iv.getStatus().getModality() == Modality.ABSTRACT && !SamResolutionKt.isPublicInObject(it, true))) continue;
                if (found$iv) {
                    iterable = null;
                    break block3;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            iterable = !found$iv ? null : iterable2;
        }
        return (FirSimpleFunction)((Object)iterable);
    }

    public static final boolean isSamType(@NotNull IrType $this$isSamType) {
        Object v1;
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$isSamType, (String)"$this$isSamType");
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull($this$isSamType);
            if (irClassSymbol == null) {
                return false;
            }
            IrClassSymbol irClass2 = irClassSymbol;
            if (((IrClass)irClass2.getOwner()).getKind() != ClassKind.INTERFACE) {
                return false;
            }
            Sequence<IrSimpleFunctionSymbol> $this$singleOrNull$iv = IrUtilsKt.getFunctions(irClass2);
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
                boolean bl = false;
                if (!(((IrSimpleFunction)it.getOwner()).getModality() == Modality.ABSTRACT)) continue;
                if (found$iv) {
                    v1 = null;
                    break block4;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v1 = !found$iv ? null : single$iv;
        }
        IrSimpleFunctionSymbol am = v1;
        return am != null;
    }
}

