/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/NamedFunAsExpressionChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class NamedFunAsExpressionChecker
implements CallChecker {
    @NotNull
    public static final NamedFunAsExpressionChecker INSTANCE = new NamedFunAsExpressionChecker();

    private NamedFunAsExpressionChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.NewInference)) {
            return;
        }
        for (ExpressionValueArgument argument2 : CollectionsKt.filterIsInstance((Iterable)resolvedCall2.getValueArguments().values(), ExpressionValueArgument.class)) {
            KtNamedFunction expression2;
            ValueArgument valueArgument = argument2.getValueArgument();
            PsiElement psiElement = KtPsiUtil.deparenthesize(valueArgument == null ? null : valueArgument.getArgumentExpression());
            Object object = psiElement instanceof KtNamedFunction ? (KtNamedFunction)psiElement : null;
            if (object == null || KtPsiUtilKt.isFunctionalExpression(expression2 = object)) continue;
            BindingTrace bindingTrace = context2.getTrace();
            psiElement = expression2.getNameIdentifier();
            Intrinsics.checkNotNull((Object)psiElement);
            object = Errors.ANONYMOUS_FUNCTION_WITH_NAME.on(psiElement);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ANONYMOUS_FUNCTION_WITH_NAME.on(expression.nameIdentifier!!)");
            DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, (Diagnostic)object);
        }
    }
}

