/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.fir.expressions

import org.jetbrains.kotlin.fir.FirSourceElement
import org.jetbrains.kotlin.fir.visitors.*

/*
 * This file was generated automatically
 * DO NOT MODIFY IT MANUALLY
 */

interface FirCall : FirStatement {
    override val source: FirSourceElement?
    override val annotations: List<FirAnnotationCall>
    val argumentList: FirArgumentList

    override fun <R, D> accept(visitor: FirVisitor<R, D>, data: D): R = visitor.visitCall(this, data)

    fun replaceArgumentList(newArgumentList: FirArgumentList)

    override fun <D> transformAnnotations(transformer: FirTransformer<D>, data: D): FirCall
}
