/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.resolve.AdditionalAnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.checkers.ExperimentalMarkerDeclarationAnnotationChecker;
import org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u0010\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J*\u0010\u0011\u001a\u00020\t2\u0010\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\fH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalMarkerDeclarationAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/AdditionalAnnotationChecker;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)V", "WRONG_TARGETS_FOR_MARKER", "", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "checkEntries", "", "entries", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "actualTargets", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "checkMarkerTargets", "checkUseExperimentalUsage", "annotationClasses", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "entry", "frontend"})
public final class ExperimentalMarkerDeclarationAnnotationChecker
implements AdditionalAnnotationChecker {
    @NotNull
    private final ModuleDescriptor module;
    @NotNull
    private final Set<KotlinTarget> WRONG_TARGETS_FOR_MARKER;

    public ExperimentalMarkerDeclarationAnnotationChecker(@NotNull ModuleDescriptor module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        this.module = module2;
        KotlinTarget[] kotlinTargetArray = new KotlinTarget[]{KotlinTarget.EXPRESSION, KotlinTarget.FILE};
        this.WRONG_TARGETS_FOR_MARKER = SetsKt.setOf((Object[])kotlinTargetArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void checkEntries(@NotNull List<? extends KtAnnotationEntry> entries, @NotNull List<? extends KotlinTarget> actualTargets, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        Intrinsics.checkNotNullParameter(actualTargets, (String)"actualTargets");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        boolean isAnnotatedWithExperimental = false;
        for (KtAnnotationEntry ktAnnotationEntry : entries) {
            FqName fqName2;
            AnnotationDescriptor annotation2 = (AnnotationDescriptor)trace.getBindingContext().get(BindingContext.ANNOTATION, ktAnnotationEntry);
            AnnotationDescriptor annotationDescriptor = annotation2;
            FqName fqName3 = fqName2 = annotationDescriptor == null ? null : annotationDescriptor.getFqName();
            if (CollectionsKt.contains((Iterable)ExperimentalUsageChecker.Companion.getUSE_EXPERIMENTAL_FQ_NAMES(), (Object)fqName2)) {
                ArrayValue arrayValue;
                void $this$safeAs$iv;
                Intrinsics.checkNotNull((Object)annotation2);
                ConstantValue<?> constantValue = annotation2.getAllValueArguments().get(ExperimentalUsageChecker.Companion.getUSE_EXPERIMENTAL_ANNOTATION_CLASS$frontend());
                boolean $i$f$safeAs = false;
                Object v1 = $this$safeAs$iv;
                if (!(v1 instanceof ArrayValue)) {
                    v1 = null;
                }
                arrayValue = (arrayValue = (ArrayValue)v1) == null ? null : (List)arrayValue.getValue();
                boolean bl = false;
                Object object = arrayValue;
                if (object == null) {
                    object = CollectionsKt.emptyList();
                }
                ArrayValue annotationClasses = object;
                this.checkUseExperimentalUsage((List<? extends ConstantValue<?>>)((Object)annotationClasses), trace, ktAnnotationEntry);
                continue;
            }
            if (!CollectionsKt.contains((Iterable)ExperimentalUsageChecker.Companion.getEXPERIMENTAL_FQ_NAMES(), (Object)fqName2)) continue;
            isAnnotatedWithExperimental = true;
        }
        if (isAnnotatedWithExperimental) {
            this.checkMarkerTargets(entries, trace);
        }
    }

    private final void checkUseExperimentalUsage(List<? extends ConstantValue<?>> annotationClasses, BindingTrace trace, KtAnnotationEntry entry) {
        if (annotationClasses.isEmpty()) {
            trace.report(Errors.USE_EXPERIMENTAL_WITHOUT_ARGUMENTS.on((KtAnnotationEntry)((PsiElement)entry)));
            return;
        }
        for (ConstantValue<?> annotationClass : annotationClasses) {
            ClassDescriptor classDescriptor;
            KotlinType kotlinType;
            Object object = annotationClass instanceof KClassValue ? (KClassValue)annotationClass : null;
            KotlinType kotlinType2 = kotlinType = object == null ? null : ((KClassValue)object).getArgumentType(this.module);
            Object object2 = kotlinType == null ? null : ((object = kotlinType.getConstructor()) == null ? null : object.getDeclarationDescriptor());
            ClassDescriptor classDescriptor2 = classDescriptor = object2 instanceof ClassDescriptor ? (ClassDescriptor)object2 : null;
            if (classDescriptor == null) continue;
            ClassDescriptor classDescriptor3 = classDescriptor;
            object2 = ExperimentalUsageChecker.Companion;
            boolean bl = false;
            boolean bl2 = false;
            Object $this$checkUseExperimentalUsage_u24lambda_u2d0 = object2;
            boolean bl3 = false;
            ExperimentalUsageChecker.Experimentality experimentality = ((ExperimentalUsageChecker.Companion)$this$checkUseExperimentalUsage_u24lambda_u2d0).loadExperimentalityForMarkerAnnotation$frontend(classDescriptor3);
            if (experimentality != null) continue;
            trace.report(Errors.USE_EXPERIMENTAL_ARGUMENT_IS_NOT_MARKER.on((KtAnnotationEntry)((PsiElement)entry), DescriptorUtilsKt.getFqNameSafe(classDescriptor3)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkMarkerTargets(List<? extends KtAnnotationEntry> entries, BindingTrace trace) {
        Map.Entry targetEntry;
        Object v0;
        block5: {
            void $this$firstOrNull$iv;
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = entries;
            boolean $i$f$associate = false;
            int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                KtAnnotationEntry entry = (KtAnnotationEntry)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)entry, trace.getBindingContext().get(BindingContext.ANNOTATION, entry));
                boolean bl2 = false;
                map.put(pair.getFirst(), pair.getSecond());
            }
            $this$associate$iv = destination$iv$iv.entrySet();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv22 : $this$firstOrNull$iv) {
                Map.Entry $dstr$_u24__u24$descriptor = (Map.Entry)element$iv22;
                boolean bl = false;
                Map.Entry entry = $dstr$_u24__u24$descriptor;
                boolean bl3 = false;
                AnnotationDescriptor descriptor2 = (AnnotationDescriptor)entry.getValue();
                if (!(descriptor2 != null && Intrinsics.areEqual((Object)descriptor2.getFqName(), (Object)StandardNames.FqNames.target))) continue;
                v0 = element$iv22;
                break block5;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        if (entry == null) {
            return;
        }
        Map.Entry $i$f$firstOrNull = entry = (targetEntry = entry);
        boolean capacity$iv22 = false;
        KtAnnotationEntry entry2 = (KtAnnotationEntry)$i$f$firstOrNull.getKey();
        Map.Entry capacity$iv22 = entry;
        boolean element$iv22 = false;
        AnnotationDescriptor descriptor3 = (AnnotationDescriptor)capacity$iv22.getValue();
        Intrinsics.checkNotNull((Object)descriptor3);
        Object object = descriptor3;
        Set<KotlinTarget> element$iv22 = AnnotationChecker.Companion.loadAnnotationTargets((AnnotationDescriptor)object);
        if (element$iv22 == null) {
            return;
        }
        Set<KotlinTarget> allowedTargets = element$iv22;
        Set wrongTargets = CollectionsKt.intersect((Iterable)allowedTargets, (Iterable)this.WRONG_TARGETS_FOR_MARKER);
        object = wrongTargets;
        boolean bl = false;
        if (!object.isEmpty()) {
            trace.report(Errors.EXPERIMENTAL_ANNOTATION_WITH_WRONG_TARGET.on((KtAnnotationEntry)((PsiElement)entry2), CollectionsKt.joinToString$default((Iterable)wrongTargets, null, null, null, (int)0, null, (Function1)((Function1)checkMarkerTargets.1.INSTANCE), (int)31, null)));
        }
    }
}

