/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.lower.MethodsFromAnyGeneratorForLowerings;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010J\u0006\u0010\u0012\u001a\u00020\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/MethodsFromAnyGeneratorForLowerings;", "", "context", "Lorg/jetbrains/kotlin/backend/common/BackendContext;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "origin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "(Lorg/jetbrains/kotlin/backend/common/BackendContext;Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/BackendContext;", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getOrigin", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "createEqualsMethodDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "createHashCodeMethodDeclaration", "createToStringMethodDeclaration", "Companion", "ir.backend.common"})
public final class MethodsFromAnyGeneratorForLowerings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BackendContext context;
    @NotNull
    private final IrClass irClass;
    @NotNull
    private final IrDeclarationOrigin origin;

    public MethodsFromAnyGeneratorForLowerings(@NotNull BackendContext context2, @NotNull IrClass irClass2, @NotNull IrDeclarationOrigin origin) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        this.context = context2;
        this.irClass = irClass2;
        this.origin = origin;
    }

    @NotNull
    public final BackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrClass getIrClass() {
        return this.irClass;
    }

    @NotNull
    public final IrDeclarationOrigin getOrigin() {
        return this.origin;
    }

    @NotNull
    public final IrSimpleFunction createToStringMethodDeclaration() {
        IrSimpleFunction irSimpleFunction;
        IrSimpleFunction $this$createToStringMethodDeclaration_u24lambda_u2d0 = irSimpleFunction = DeclarationBuildersKt.addFunction$default(this.irClass, "toString", this.context.getIrBuiltIns().getStringType(), null, null, false, false, false, null, 0, 0, 1020, null);
        boolean bl = false;
        $this$createToStringMethodDeclaration_u24lambda_u2d0.setOverriddenSymbols(Companion.collectOverridenSymbols(this.getIrClass(), (Function1<? super IrFunction, Boolean>)((Function1)createToStringMethodDeclaration.1.1.INSTANCE)));
        return irSimpleFunction;
    }

    @NotNull
    public final IrSimpleFunction createHashCodeMethodDeclaration() {
        IrSimpleFunction irSimpleFunction;
        IrSimpleFunction $this$createHashCodeMethodDeclaration_u24lambda_u2d1 = irSimpleFunction = DeclarationBuildersKt.addFunction$default(this.irClass, "hashCode", this.context.getIrBuiltIns().getIntType(), null, null, false, false, false, null, 0, 0, 1020, null);
        boolean bl = false;
        $this$createHashCodeMethodDeclaration_u24lambda_u2d1.setOverriddenSymbols(Companion.collectOverridenSymbols(this.getIrClass(), (Function1<? super IrFunction, Boolean>)((Function1)createHashCodeMethodDeclaration.1.1.INSTANCE)));
        return irSimpleFunction;
    }

    @NotNull
    public final IrSimpleFunction createEqualsMethodDeclaration() {
        IrSimpleFunction irSimpleFunction;
        IrSimpleFunction $this$createEqualsMethodDeclaration_u24lambda_u2d2 = irSimpleFunction = DeclarationBuildersKt.addFunction$default(this.irClass, "equals", this.context.getIrBuiltIns().getBooleanType(), null, null, false, false, false, null, 0, 0, 1020, null);
        boolean bl = false;
        $this$createEqualsMethodDeclaration_u24lambda_u2d2.setOverriddenSymbols(Companion.collectOverridenSymbols(this.getIrClass(), (Function1<? super IrFunction, Boolean>)((Function1)new Function1<IrFunction, Boolean>(this){
            final /* synthetic */ MethodsFromAnyGeneratorForLowerings this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull IrFunction it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return MethodsFromAnyGeneratorForLowerings.Companion.isEquals(it, this.this$0.getContext());
            }
        })));
        DeclarationBuildersKt.addValueParameter$default((IrFunction)$this$createEqualsMethodDeclaration_u24lambda_u2d2, "other", this.getContext().getIrBuiltIns().getAnyNType(), null, 4, null);
        return irSimpleFunction;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bJ\u0012\u0010\u000b\u001a\u00020\n*\u00020\t2\u0006\u0010\f\u001a\u00020\rJ\n\u0010\u000e\u001a\u00020\n*\u00020\tJ\n\u0010\u000f\u001a\u00020\n*\u00020\t\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/MethodsFromAnyGeneratorForLowerings$Companion;", "", "()V", "collectOverridenSymbols", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "predicate", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "", "isEquals", "context", "Lorg/jetbrains/kotlin/backend/common/BackendContext;", "isHashCode", "isToString", "ir.backend.common"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isToString(@NotNull IrFunction $this$isToString) {
            Intrinsics.checkNotNullParameter((Object)$this$isToString, (String)"<this>");
            return Intrinsics.areEqual((Object)$this$isToString.getName().asString(), (Object)"toString") && $this$isToString.getExtensionReceiverParameter() == null && $this$isToString.getValueParameters().isEmpty();
        }

        public final boolean isHashCode(@NotNull IrFunction $this$isHashCode) {
            Intrinsics.checkNotNullParameter((Object)$this$isHashCode, (String)"<this>");
            return Intrinsics.areEqual((Object)$this$isHashCode.getName().asString(), (Object)"hashCode") && $this$isHashCode.getExtensionReceiverParameter() == null && $this$isHashCode.getValueParameters().isEmpty();
        }

        public final boolean isEquals(@NotNull IrFunction $this$isEquals, @NotNull BackendContext context2) {
            IrValueParameter irValueParameter;
            Intrinsics.checkNotNullParameter((Object)$this$isEquals, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            return Intrinsics.areEqual((Object)$this$isEquals.getName().asString(), (Object)"equals") && $this$isEquals.getExtensionReceiverParameter() == null && Intrinsics.areEqual((Object)((irValueParameter = (IrValueParameter)CollectionsKt.singleOrNull($this$isEquals.getValueParameters())) == null ? null : irValueParameter.getType()), (Object)context2.getIrBuiltIns().getAnyNType());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<IrSimpleFunctionSymbol> collectOverridenSymbols(@NotNull IrClass $this$collectOverridenSymbols, @NotNull Function1<? super IrFunction, Boolean> predicate) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$collectOverridenSymbols, (String)"<this>");
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Iterable $this$mapNotNull$iv = $this$collectOverridenSymbols.getSuperTypes();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                IrSimpleFunctionSymbol irSimpleFunctionSymbol;
                IrSimpleFunctionSymbol irSimpleFunctionSymbol2;
                IrSimpleFunctionSymbol irSimpleFunctionSymbol3;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                IrType it = (IrType)element$iv$iv;
                boolean bl2 = false;
                IrClass irClass2 = IrTypesKt.getClass(it);
                if (irClass2 == null) {
                    irSimpleFunctionSymbol3 = null;
                } else {
                    Object v1;
                    block5: {
                        Sequence<IrSimpleFunction> sequence2;
                        Sequence<IrSimpleFunction> $this$singleOrNull$iv = sequence2 = IrUtilsKt.getFunctions(irClass2);
                        boolean $i$f$singleOrNull = false;
                        Object single$iv = null;
                        boolean found$iv = false;
                        for (Object element$iv : $this$singleOrNull$iv) {
                            if (!((Boolean)predicate.invoke(element$iv)).booleanValue()) continue;
                            if (found$iv) {
                                v1 = null;
                                break block5;
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        v1 = !found$iv ? null : single$iv;
                    }
                    IrSimpleFunction irSimpleFunction = v1;
                    irSimpleFunctionSymbol3 = irSimpleFunctionSymbol2 = irSimpleFunction == null ? null : irSimpleFunction.getSymbol();
                }
                if (irSimpleFunctionSymbol2 == null) continue;
                IrSimpleFunctionSymbol it$iv$iv = irSimpleFunctionSymbol = irSimpleFunctionSymbol2;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

