/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.Check;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.OperatorFunctionChecks;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOperatorModifierChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSimpleFunctionChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirOperatorModifierChecker
extends FirDeclarationChecker<FirSimpleFunction> {
    @NotNull
    public static final FirOperatorModifierChecker INSTANCE = new FirOperatorModifierChecker();

    private FirOperatorModifierChecker() {
    }

    @Override
    public void check(@NotNull FirSimpleFunction declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        List checks2;
        List list2;
        Name name;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Object $this$isOperator$iv = declaration2;
        boolean $i$f$isOperator = false;
        if (!$this$isOperator$iv.getStatus().isOperator()) {
            return;
        }
        FirElement firElement = declaration2;
        $this$isOperator$iv = KtTokens.OPERATOR_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)$this$isOperator$iv, (String)"OPERATOR_KEYWORD");
        if (!FirKeywordUtilsKt.hasModifier(firElement, (KtModifierKeywordToken)$this$isOperator$iv)) {
            return;
        }
        Map<Name, List<Check>> map = OperatorFunctionChecks.INSTANCE.getChecksByName();
        Object object = map.get(name = declaration2.getName());
        if (object == null) {
            Object v2;
            block7: {
                Iterable iterable;
                boolean bl = false;
                Iterable iterable2 = iterable = (Iterable)OperatorFunctionChecks.INSTANCE.getRegexChecks();
                for (Object t : iterable2) {
                    Pair it = (Pair)t;
                    boolean bl2 = false;
                    Regex regex = (Regex)it.getFirst();
                    String string2 = declaration2.getName().asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"declaration.name.asString()");
                    if (!regex.matches((CharSequence)string2)) continue;
                    v2 = t;
                    break block7;
                }
                v2 = null;
            }
            Pair pair = v2;
            list2 = pair == null ? null : (List)pair.getSecond();
        } else {
            list2 = checks2 = object;
        }
        if (checks2 == null) {
            DiagnosticReporterKt.reportOn$default(reporter, declaration2.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_OPERATOR_MODIFIER(), (Object)"illegal function name", context2, null, 16, null);
            return;
        }
        for (Check check2 : checks2) {
            Object object2;
            object = check2.check(context2, declaration2);
            if (object == null) continue;
            Object error = object2 = object;
            boolean bl = false;
            DiagnosticReporterKt.reportOn$default(reporter, declaration2.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_OPERATOR_MODIFIER(), error, context2, null, 16, null);
            return;
        }
    }
}

