/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.BooleanDataDescriptor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.GeneratedJvmClass;
import org.jetbrains.kotlin.incremental.AbstractIncrementalCache;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.ClassProtoData;
import org.jetbrains.kotlin.incremental.IncrementalJvmCache;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;
import org.jetbrains.kotlin.incremental.JavaClassProtoMapValueExternalizer;
import org.jetbrains.kotlin.incremental.JavaClassesTrackerImplKt;
import org.jetbrains.kotlin.incremental.KotlinClassInfo;
import org.jetbrains.kotlin.incremental.PathCollectionExternalizer;
import org.jetbrains.kotlin.incremental.ProtoDifferenceUtilsKt;
import org.jetbrains.kotlin.incremental.SerializedJavaClass;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.incremental.storage.ClassAttributesMap;
import org.jetbrains.kotlin.incremental.storage.ConstantExternalizer;
import org.jetbrains.kotlin.incremental.storage.DirtyClassesJvmNameMap;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverterKt;
import org.jetbrains.kotlin.incremental.storage.LazyStorage;
import org.jetbrains.kotlin.incremental.storage.LinkedHashMapExternalizer;
import org.jetbrains.kotlin.incremental.storage.LongExternalizer;
import org.jetbrains.kotlin.incremental.storage.ProtoMapValue;
import org.jetbrains.kotlin.incremental.storage.ProtoMapValueExternalizer;
import org.jetbrains.kotlin.incremental.storage.SourceToJvmNameMap;
import org.jetbrains.kotlin.incremental.storage.StringCollectionExternalizer;
import org.jetbrains.kotlin.incremental.storage.StringExternalizer;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCache;
import org.jetbrains.kotlin.load.kotlin.incremental.components.JvmPackagePartProto;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.jvm.deserialization.BitEncoding;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmNameResolver;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmProtoBufUtil;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0016\u0018\u0000 ]2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\t]^_`abcdeB\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0005H\u0002J\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00050-J\u0010\u0010/\u001a\u00020(2\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020(2\u0006\u00103\u001a\u000204H\u0014J\u0016\u00105\u001a\n\u0012\u0004\u0012\u000204\u0018\u0001062\u0006\u00107\u001a\u00020\u0002J\u0010\u00108\u001a\u0002042\u0006\u00109\u001a\u000204H\u0016J\n\u0010:\u001a\u0004\u0018\u00010;H\u0016J\f\u0010<\u001a\b\u0012\u0004\u0012\u00020=06J\u000e\u0010>\u001a\b\u0012\u0004\u0012\u00020406H\u0016J\u000e\u0010?\u001a\b\u0012\u0004\u0012\u00020406H\u0016J\u0012\u0010@\u001a\u0004\u0018\u00010A2\u0006\u0010B\u001a\u000204H\u0016J\u0018\u0010C\u001a\n\u0012\u0004\u0012\u000204\u0018\u0001062\u0006\u0010D\u001a\u000204H\u0016J\u000e\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020=J\u000e\u0010H\u001a\u00020F2\u0006\u0010G\u001a\u00020=J\u000e\u0010I\u001a\u00020F2\u0006\u0010J\u001a\u00020\u0002J\u000e\u0010K\u001a\u00020F2\u0006\u0010L\u001a\u00020\u0005J&\u0010M\u001a\u00020(2\u0006\u0010N\u001a\u00020*2\u000e\u0010O\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010P2\u0006\u00100\u001a\u000201J\u0018\u0010Q\u001a\u00020(2\u0006\u0010R\u001a\u00020S2\u0006\u00100\u001a\u000201H\u0016J\u001e\u0010T\u001a\u00020(2\u0006\u0010U\u001a\u00020\u00052\u0006\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u000201J\u001c\u0010Y\u001a\u00020(2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020\u0005062\u0006\u0010L\u001a\u00020\u0005J\u000e\u0010Z\u001a\u00020F2\u0006\u0010L\u001a\u00020\u0005J\u0014\u0010[\u001a\b\u0012\u0004\u0012\u00020\u0005062\u0006\u0010\\\u001a\u000204R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00060\u0011R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00060\u0015R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00060\u0017R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0018\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u0012\u0010\u001d\u001a\u00060\u001eR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001f\u001a\u00060 R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010!\u001a\u00060\"R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020$X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006f"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;", "Lorg/jetbrains/kotlin/incremental/AbstractIncrementalCache;", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "Lorg/jetbrains/kotlin/load/kotlin/incremental/components/IncrementalCache;", "targetDataRoot", "Ljava/io/File;", "targetOutputDir", "pathConverter", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "(Ljava/io/File;Ljava/io/File;Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;)V", "constantsMap", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$ConstantsMap;", "dirtyOutputClassesMap", "Lorg/jetbrains/kotlin/incremental/storage/DirtyClassesJvmNameMap;", "getDirtyOutputClassesMap$kotlin_build_common", "()Lorg/jetbrains/kotlin/incremental/storage/DirtyClassesJvmNameMap;", "inlineFunctionsMap", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$InlineFunctionsMap;", "internalNameToSource", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$InternalNameToSourcesMap;", "javaSourcesProtoMap", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$JavaSourcesProtoMap;", "multifileFacadeToParts", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$MultifileClassFacadeMap;", "outputDir", "getOutputDir", "()Ljava/io/File;", "outputDir$delegate", "Lkotlin/Lazy;", "packagePartMap", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$PackagePartMap;", "partToMultifileFacade", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$MultifileClassPartMap;", "protoMap", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$ProtoMap;", "sourceToClassesMap", "Lorg/jetbrains/kotlin/incremental/storage/SourceToJvmNameMap;", "getSourceToClassesMap$kotlin_build_common", "()Lorg/jetbrains/kotlin/incremental/storage/SourceToJvmNameMap;", "addToClassStorage", "", "classInfo", "Lorg/jetbrains/kotlin/incremental/KotlinClassInfo;", "srcFile", "classesBySources", "", "sources", "clearCacheForRemovedClasses", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "debugLog", "message", "", "getAllPartsOfMultifileFacade", "", "facade", "getClassFilePath", "internalClassName", "getModuleMappingData", "", "getObsoleteJavaClasses", "Lorg/jetbrains/kotlin/name/ClassId;", "getObsoleteMultifileClasses", "getObsoletePackageParts", "getPackagePartData", "Lorg/jetbrains/kotlin/load/kotlin/incremental/components/JvmPackagePartProto;", "partInternalName", "getStableMultifileFacadeParts", "facadeInternalName", "isJavaClassAlreadyInCache", "", "classId", "isJavaClassToTrack", "isMultifileFacade", "className", "isTrackedFile", "file", "saveClassToCache", "kotlinClassInfo", "sourceFiles", "", "saveFileToCache", "generatedClass", "Lorg/jetbrains/kotlin/build/GeneratedJvmClass;", "saveJavaClassProto", "source", "serializedJavaClass", "Lorg/jetbrains/kotlin/incremental/SerializedJavaClass;", "collector", "saveModuleMappingToCache", "sourceInCache", "sourcesByInternalName", "internalName", "Companion", "ConstantsMap", "InlineFunctionsMap", "InternalNameToSourcesMap", "JavaSourcesProtoMap", "MultifileClassFacadeMap", "MultifileClassPartMap", "PackagePartMap", "ProtoMap", "kotlin-build-common"})
public class IncrementalJvmCache
extends AbstractIncrementalCache<JvmClassName>
implements IncrementalCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SourceToJvmNameMap sourceToClassesMap;
    @NotNull
    private final DirtyClassesJvmNameMap dirtyOutputClassesMap;
    @NotNull
    private final ProtoMap protoMap;
    @NotNull
    private final ConstantsMap constantsMap;
    @NotNull
    private final PackagePartMap packagePartMap;
    @NotNull
    private final MultifileClassFacadeMap multifileFacadeToParts;
    @NotNull
    private final MultifileClassPartMap partToMultifileFacade;
    @NotNull
    private final InlineFunctionsMap inlineFunctionsMap;
    @NotNull
    private final InternalNameToSourcesMap internalNameToSource;
    @NotNull
    private final JavaSourcesProtoMap javaSourcesProtoMap;
    @NotNull
    private final Lazy outputDir$delegate;
    @NotNull
    private static final String PROTO_MAP = "proto";
    @NotNull
    private static final String CONSTANTS_MAP = "constants";
    @NotNull
    private static final String PACKAGE_PARTS = "package-parts";
    @NotNull
    private static final String MULTIFILE_CLASS_FACADES = "multifile-class-facades";
    @NotNull
    private static final String MULTIFILE_CLASS_PARTS = "multifile-class-parts";
    @NotNull
    private static final String INLINE_FUNCTIONS = "inline-functions";
    @NotNull
    private static final String INTERNAL_NAME_TO_SOURCE = "internal-name-to-source";
    @NotNull
    private static final String JAVA_SOURCES_PROTO_MAP = "java-sources-proto-map";
    @NotNull
    private static final String MODULE_MAPPING_FILE_NAME = ".kotlin_module";

    public IncrementalJvmCache(@NotNull File targetDataRoot, @Nullable File targetOutputDir, @NotNull FileToPathConverter pathConverter) {
        Intrinsics.checkNotNullParameter((Object)targetDataRoot, (String)"targetDataRoot");
        Intrinsics.checkNotNullParameter((Object)pathConverter, (String)"pathConverter");
        super(new File(targetDataRoot, IncrementalJvmCacheKt.getKOTLIN_CACHE_DIRECTORY_NAME()), pathConverter);
        this.sourceToClassesMap = (SourceToJvmNameMap)this.registerMap((BasicMap)new SourceToJvmNameMap(this.getStorageFile(AbstractIncrementalCache.getSOURCE_TO_CLASSES()), pathConverter));
        this.dirtyOutputClassesMap = (DirtyClassesJvmNameMap)this.registerMap((BasicMap)new DirtyClassesJvmNameMap(this.getStorageFile(AbstractIncrementalCache.getDIRTY_OUTPUT_CLASSES())));
        this.protoMap = (ProtoMap)this.registerMap((BasicMap)new ProtoMap(this.getStorageFile(PROTO_MAP)));
        this.constantsMap = (ConstantsMap)this.registerMap((BasicMap)new ConstantsMap(this.getStorageFile(CONSTANTS_MAP)));
        this.packagePartMap = (PackagePartMap)this.registerMap((BasicMap)new PackagePartMap(this.getStorageFile(PACKAGE_PARTS)));
        this.multifileFacadeToParts = (MultifileClassFacadeMap)this.registerMap((BasicMap)new MultifileClassFacadeMap(this.getStorageFile(MULTIFILE_CLASS_FACADES)));
        this.partToMultifileFacade = (MultifileClassPartMap)this.registerMap((BasicMap)new MultifileClassPartMap(this.getStorageFile(MULTIFILE_CLASS_PARTS)));
        this.inlineFunctionsMap = (InlineFunctionsMap)this.registerMap((BasicMap)new InlineFunctionsMap(this.getStorageFile(INLINE_FUNCTIONS)));
        this.internalNameToSource = (InternalNameToSourcesMap)this.registerMap((BasicMap)new InternalNameToSourcesMap(this.getStorageFile(INTERNAL_NAME_TO_SOURCE), pathConverter));
        this.javaSourcesProtoMap = (JavaSourcesProtoMap)this.registerMap((BasicMap)new JavaSourcesProtoMap(this.getStorageFile(JAVA_SOURCES_PROTO_MAP)));
        this.outputDir$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<File>(targetOutputDir){
            final /* synthetic */ File $targetOutputDir;
            {
                this.$targetOutputDir = $targetOutputDir;
                super(0);
            }

            @NotNull
            public final File invoke() {
                File file2 = this.$targetOutputDir;
                if (file2 == null) {
                    boolean bl = false;
                    String string2 = "Target is expected to have output directory";
                    throw new IllegalArgumentException(string2.toString());
                }
                return file2;
            }
        }));
    }

    @NotNull
    public SourceToJvmNameMap getSourceToClassesMap$kotlin_build_common() {
        return this.sourceToClassesMap;
    }

    @NotNull
    public DirtyClassesJvmNameMap getDirtyOutputClassesMap$kotlin_build_common() {
        return this.dirtyOutputClassesMap;
    }

    private final File getOutputDir() {
        Lazy lazy = this.outputDir$delegate;
        Object var2_2 = null;
        return (File)lazy.getValue();
    }

    protected void debugLog(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
    }

    public final boolean isTrackedFile(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.getSourceToClassesMap$kotlin_build_common().contains(file2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Iterable<JvmClassName> classesBySources(@NotNull Iterable<? extends File> sources) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        Iterable<? extends File> $this$flatMap$iv = sources;
        boolean $i$f$flatMap = false;
        Iterable<? extends File> iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.getSourceToClassesMap$kotlin_build_common().get(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final boolean sourceInCache(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.getSourceToClassesMap$kotlin_build_common().contains(file2);
    }

    @NotNull
    public final Collection<File> sourcesByInternalName(@NotNull String internalName2) {
        Intrinsics.checkNotNullParameter((Object)internalName2, (String)"internalName");
        return this.internalNameToSource.get(internalName2);
    }

    @Nullable
    public final Collection<String> getAllPartsOfMultifileFacade(@NotNull JvmClassName facade) {
        Intrinsics.checkNotNullParameter((Object)facade, (String)"facade");
        return this.multifileFacadeToParts.get(facade);
    }

    public final boolean isMultifileFacade(@NotNull JvmClassName className2) {
        Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
        return this.multifileFacadeToParts.contains(className2);
    }

    @Override
    @NotNull
    public String getClassFilePath(@NotNull String internalClassName) {
        Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
        String string2 = FileUtil.toSystemIndependentName(new File(this.getOutputDir(), Intrinsics.stringPlus((String)internalClassName, (Object)".class")).getCanonicalPath());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(\u2026me.class\").canonicalPath)");
        return string2;
    }

    public final void saveModuleMappingToCache(@NotNull Collection<? extends File> sourceFiles2, @NotNull File file2) {
        Intrinsics.checkNotNullParameter(sourceFiles2, (String)"sourceFiles");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        JvmClassName jvmClassName = JvmClassName.byInternalName(MODULE_MAPPING_FILE_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"byInternalName(MODULE_MAPPING_FILE_NAME)");
        JvmClassName jvmClassName2 = jvmClassName;
        this.protoMap.storeModuleMapping(jvmClassName2, FilesKt.readBytes((File)file2));
        this.getDirtyOutputClassesMap$kotlin_build_common().notDirty(jvmClassName2);
        Iterable $this$forEach$iv = sourceFiles2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            this.getSourceToClassesMap$kotlin_build_common().add(it, jvmClassName2);
        }
    }

    public void saveFileToCache(@NotNull GeneratedJvmClass generatedClass, @NotNull ChangesCollector changesCollector) {
        Intrinsics.checkNotNullParameter((Object)generatedClass, (String)"generatedClass");
        Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
        this.saveClassToCache(KotlinClassInfo.Companion.createFrom(generatedClass.getOutputClass()), generatedClass.getSourceFiles(), changesCollector);
    }

    public final void saveClassToCache(@NotNull KotlinClassInfo kotlinClassInfo, @Nullable List<? extends File> sourceFiles2, @NotNull ChangesCollector changesCollector) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)kotlinClassInfo, (String)"kotlinClassInfo");
        Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
        JvmClassName className2 = kotlinClassInfo.getClassName();
        this.getDirtyOutputClassesMap$kotlin_build_common().notDirty(className2);
        if (sourceFiles2 != null) {
            Iterable $this$forEach$iv = sourceFiles2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                this.getSourceToClassesMap$kotlin_build_common().add(it, className2);
            }
            object = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"className.internalName");
            this.internalNameToSource.set((String)object, (Collection<? extends File>)sourceFiles2);
        }
        if (kotlinClassInfo.getClassId().isLocal()) {
            return;
        }
        object = kotlinClassInfo.getClassKind();
        int n = WhenMappings.$EnumSwitchMapping$0[object.ordinal()];
        switch (n) {
            case 1: {
                if (sourceFiles2 != null) {
                    boolean bl;
                    boolean bl2 = bl = sourceFiles2.size() == 1;
                    if (_Assertions.ENABLED && !bl) {
                        boolean $i$a$-assert-IncrementalJvmCache$saveClassToCache$322 = false;
                        String $i$a$-assert-IncrementalJvmCache$saveClassToCache$322 = Intrinsics.stringPlus((String)"Package part from several source files: ", sourceFiles2);
                        throw new AssertionError((Object)$i$a$-assert-IncrementalJvmCache$saveClassToCache$322);
                    }
                }
                this.packagePartMap.addPackagePart(className2);
                this.protoMap.process(kotlinClassInfo, changesCollector);
                this.constantsMap.process(kotlinClassInfo, changesCollector);
                this.inlineFunctionsMap.process(kotlinClassInfo, changesCollector);
                break;
            }
            case 2: {
                boolean $i$a$-assert-IncrementalJvmCache$saveClassToCache$322;
                List partNames = ArraysKt.toList((Object[])kotlinClassInfo.getClassHeaderData());
                boolean bl = $i$a$-assert-IncrementalJvmCache$saveClassToCache$322 = !((Collection)partNames).isEmpty();
                if (!$i$a$-assert-IncrementalJvmCache$saveClassToCache$322) {
                    boolean bl3 = false;
                    String string2 = Intrinsics.stringPlus((String)"Multifile class has no parts: ", (Object)className2);
                    throw new IllegalStateException(string2.toString());
                }
                this.multifileFacadeToParts.set(className2, partNames);
                if (this.protoMap.contains(className2)) {
                    FqName $i$a$-assert-IncrementalJvmCache$saveClassToCache$322 = className2.getFqNameForClassNameWithoutDollars();
                    Intrinsics.checkNotNullExpressionValue((Object)$i$a$-assert-IncrementalJvmCache$saveClassToCache$322, (String)"className.fqNameForClassNameWithoutDollars");
                    changesCollector.collectSignature($i$a$-assert-IncrementalJvmCache$saveClassToCache$322, true);
                }
                this.protoMap.remove(className2, changesCollector);
                AbstractIncrementalCache.ClassFqNameToSourceMap classFqNameToSourceMap = this.getClassFqNameToSourceMap();
                Object $i$a$-assert-IncrementalJvmCache$saveClassToCache$322 = className2.getFqNameForClassNameWithoutDollars();
                Intrinsics.checkNotNullExpressionValue((Object)$i$a$-assert-IncrementalJvmCache$saveClassToCache$322, (String)"className.fqNameForClassNameWithoutDollars");
                classFqNameToSourceMap.remove((FqName)$i$a$-assert-IncrementalJvmCache$saveClassToCache$322);
                ClassAttributesMap classAttributesMap = this.getClassAttributesMap$kotlin_build_common();
                $i$a$-assert-IncrementalJvmCache$saveClassToCache$322 = className2.getFqNameForClassNameWithoutDollars();
                Intrinsics.checkNotNullExpressionValue((Object)$i$a$-assert-IncrementalJvmCache$saveClassToCache$322, (String)"className.fqNameForClassNameWithoutDollars");
                classAttributesMap.remove((FqName)$i$a$-assert-IncrementalJvmCache$saveClassToCache$322);
                $i$a$-assert-IncrementalJvmCache$saveClassToCache$322 = className2.getInternalName();
                Intrinsics.checkNotNullExpressionValue((Object)$i$a$-assert-IncrementalJvmCache$saveClassToCache$322, (String)"className.internalName");
                this.internalNameToSource.remove((String)$i$a$-assert-IncrementalJvmCache$saveClassToCache$322);
                this.constantsMap.process(kotlinClassInfo, changesCollector);
                this.inlineFunctionsMap.process(kotlinClassInfo, changesCollector);
                break;
            }
            case 3: {
                if (sourceFiles2 != null) {
                    boolean bl;
                    boolean bl4 = bl = sourceFiles2.size() == 1;
                    if (_Assertions.ENABLED && !bl) {
                        boolean $i$a$-assert-IncrementalJvmCache$saveClassToCache$62 = false;
                        String $i$a$-assert-IncrementalJvmCache$saveClassToCache$62 = Intrinsics.stringPlus((String)"Multifile class part from several source files: ", sourceFiles2);
                        throw new AssertionError((Object)$i$a$-assert-IncrementalJvmCache$saveClassToCache$62);
                    }
                }
                this.packagePartMap.addPackagePart(className2);
                String string3 = className2.getInternalName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"className.internalName");
                String string4 = kotlinClassInfo.getMultifileClassName();
                Intrinsics.checkNotNull((Object)string4);
                this.partToMultifileFacade.set(string3, string4);
                this.protoMap.process(kotlinClassInfo, changesCollector);
                this.constantsMap.process(kotlinClassInfo, changesCollector);
                this.inlineFunctionsMap.process(kotlinClassInfo, changesCollector);
                break;
            }
            case 4: {
                if (sourceFiles2 != null) {
                    boolean bl;
                    boolean bl5 = bl = sourceFiles2.size() == 1;
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl6 = false;
                        String string5 = Intrinsics.stringPlus((String)"Class is expected to have only one source file: ", sourceFiles2);
                        throw new AssertionError((Object)string5);
                    }
                    this.addToClassStorage(kotlinClassInfo, (File)CollectionsKt.first(sourceFiles2));
                }
                this.protoMap.process(kotlinClassInfo, changesCollector);
                this.constantsMap.process(kotlinClassInfo, changesCollector);
                this.inlineFunctionsMap.process(kotlinClassInfo, changesCollector);
            }
        }
    }

    public final void saveJavaClassProto(@NotNull File source, @NotNull SerializedJavaClass serializedJavaClass, @NotNull ChangesCollector collector2) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)serializedJavaClass, (String)"serializedJavaClass");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        Object object = JvmClassName.byClassId(serializedJavaClass.getClassId());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"byClassId(serializedJavaClass.classId)");
        JvmClassName jvmClassName = object;
        this.javaSourcesProtoMap.process(jvmClassName, serializedJavaClass, collector2);
        this.getSourceToClassesMap$kotlin_build_common().add(source, jvmClassName);
        object = JavaClassesTrackerImplKt.toProtoData(serializedJavaClass);
        ProtoBuf.Class proto = ((ClassProtoData)object).component1();
        NameResolver nameResolver2 = ((ClassProtoData)object).component2();
        this.addToClassStorage(proto, nameResolver2, source);
        this.getDirtyOutputClassesMap$kotlin_build_common().notDirty(jvmClassName);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<ClassId> getObsoleteJavaClasses() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.getDirtyOutputClassesMap$kotlin_build_common().getDirtyOutputClasses();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ClassId classId;
            ClassId classId2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            JvmClassName it = (JvmClassName)element$iv$iv;
            boolean bl2 = false;
            SerializedJavaClass serializedJavaClass = this.javaSourcesProtoMap.get(it);
            ClassId classId3 = classId2 = serializedJavaClass == null ? null : serializedJavaClass.getClassId();
            if (classId2 == null) continue;
            ClassId it$iv$iv = classId = classId2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final boolean isJavaClassToTrack(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        JvmClassName jvmClassName = JvmClassName.byClassId(classId);
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"byClassId(classId)");
        JvmClassName jvmClassName2 = jvmClassName;
        return this.getDirtyOutputClassesMap$kotlin_build_common().isDirty(jvmClassName2) || !this.javaSourcesProtoMap.contains(jvmClassName2);
    }

    public final boolean isJavaClassAlreadyInCache(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        JvmClassName jvmClassName = JvmClassName.byClassId(classId);
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"byClassId(classId)");
        JvmClassName jvmClassName2 = jvmClassName;
        return this.javaSourcesProtoMap.contains(jvmClassName2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void clearCacheForRemovedClasses(@NotNull ChangesCollector changesCollector) {
        Collection<FqName> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable answer$iv;
        Object $this$getOrPut$iv;
        Object facade;
        Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
        Collection dirtyClasses = this.getDirtyOutputClassesMap$kotlin_build_common().getDirtyOutputClasses();
        HashMap facadesWithRemovedParts = new HashMap();
        for (JvmClassName jvmClassName : dirtyClasses) {
            Object object;
            String string2 = this.partToMultifileFacade.get(jvmClassName);
            if (string2 == null) continue;
            facade = string2;
            JvmClassName jvmClassName2 = JvmClassName.byInternalName((String)facade);
            Intrinsics.checkNotNullExpressionValue((Object)jvmClassName2, (String)"byInternalName(facade)");
            JvmClassName facadeClassName = jvmClassName2;
            $this$getOrPut$iv = facadesWithRemovedParts;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(facadeClassName);
            if (value$iv == null) {
                boolean bl = false;
                answer$iv = new HashSet();
                $this$getOrPut$iv.put(facadeClassName, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            Set removedParts = (Set)object;
            $this$getOrPut$iv = jvmClassName.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)$this$getOrPut$iv, (String)"dirtyClass.internalName");
            removedParts.add($this$getOrPut$iv);
        }
        for (Map.Entry entry : facadesWithRemovedParts.entrySet()) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"facadesWithRemovedParts.entries");
            facade = (JvmClassName)entry.getKey();
            Set removedParts = (Set)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)facade, (String)"facade");
            $this$getOrPut$iv = this.multifileFacadeToParts.get((JvmClassName)facade);
            if ($this$getOrPut$iv == null) continue;
            Object allParts = $this$getOrPut$iv;
            Iterable $this$filter$iv = (Iterable)allParts;
            boolean $i$f$filter = false;
            answer$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!(!removedParts.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List notRemovedParts = (List)destination$iv$iv;
            if (notRemovedParts.isEmpty()) {
                this.multifileFacadeToParts.remove((JvmClassName)facade);
                continue;
            }
            this.multifileFacadeToParts.set((JvmClassName)facade, notRemovedParts);
        }
        Iterable $this$forEach$iv = dirtyClasses;
        boolean bl = false;
        for (Object element$iv : $this$forEach$iv) {
            JvmClassName it = (JvmClassName)element$iv;
            boolean bl2 = false;
            this.protoMap.remove(it, changesCollector);
            this.packagePartMap.remove(it);
            this.multifileFacadeToParts.remove(it);
            this.partToMultifileFacade.remove(it);
            this.constantsMap.remove(it);
            this.inlineFunctionsMap.remove(it);
            String $this$filter$iv = it.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)$this$filter$iv, (String)"it.internalName");
            this.internalNameToSource.remove($this$filter$iv);
            this.javaSourcesProtoMap.remove(it, changesCollector);
        }
        $this$forEach$iv = dirtyClasses;
        IncrementalJvmCache incrementalJvmCache = this;
        boolean bl3 = false;
        facade = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JvmClassName $i$f$filter = (JvmClassName)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            FqName fqName2 = it.getFqNameForClassNameWithoutDollars();
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"it.fqNameForClassNameWithoutDollars");
            FqName fqName3 = fqName2;
            collection.add(fqName3);
        }
        collection = (List)destination$iv$iv;
        incrementalJvmCache.removeAllFromClassStorage(collection, changesCollector);
        this.getDirtyOutputClassesMap$kotlin_build_common().clean();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<String> getObsoletePackageParts() {
        void $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable = this.getDirtyOutputClassesMap$kotlin_build_common().getDirtyOutputClasses();
        PackagePartMap packagePartMap = this.packagePartMap;
        boolean $i$f$filter22 = false;
        void var5_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JvmClassName p0 = (JvmClassName)element$iv$iv;
            boolean bl = false;
            if (!packagePartMap.isPackagePart(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List obsoletePackageParts = (List)destination$iv$iv;
        this.debugLog(Intrinsics.stringPlus((String)"Obsolete package parts: ", (Object)obsoletePackageParts));
        Iterable $this$map$iv = obsoletePackageParts;
        boolean $i$f$map = false;
        Iterable $i$f$filter22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object element$iv$iv;
            element$iv$iv = (JvmClassName)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            String string2 = it.getInternalName();
            collection.add(string2);
        }
        return (List)destination$iv$iv2;
    }

    @Override
    @Nullable
    public JvmPackagePartProto getPackagePartData(@NotNull String partInternalName) {
        JvmPackagePartProto jvmPackagePartProto;
        Intrinsics.checkNotNullParameter((Object)partInternalName, (String)"partInternalName");
        Object object = JvmClassName.byInternalName(partInternalName);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"byInternalName(partInternalName)");
        ProtoMapValue protoMapValue = this.protoMap.get((JvmClassName)object);
        if (protoMapValue == null) {
            jvmPackagePartProto = null;
        } else {
            Object value2 = object = protoMapValue;
            boolean bl = false;
            jvmPackagePartProto = new JvmPackagePartProto(((ProtoMapValue)value2).getBytes(), ((ProtoMapValue)value2).getStrings());
        }
        return jvmPackagePartProto;
    }

    @Override
    @NotNull
    public Collection<String> getObsoleteMultifileClasses() {
        LinkedHashSet<String> obsoleteMultifileClasses = new LinkedHashSet<String>();
        for (JvmClassName dirtyClass : this.getDirtyOutputClassesMap$kotlin_build_common().getDirtyOutputClasses()) {
            String string2 = this.partToMultifileFacade.get(dirtyClass);
            if (string2 == null) continue;
            String dirtyFacade = string2;
            obsoleteMultifileClasses.add(dirtyFacade);
        }
        this.debugLog(Intrinsics.stringPlus((String)"Obsolete multifile class facades: ", obsoleteMultifileClasses));
        return obsoleteMultifileClasses;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Collection<String> getStableMultifileFacadeParts(@NotNull String facadeInternalName) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)facadeInternalName, (String)"facadeInternalName");
        JvmClassName jvmClassName = JvmClassName.byInternalName(facadeInternalName);
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"byInternalName(facadeInternalName)");
        JvmClassName jvmClassName2 = jvmClassName;
        Collection<String> collection = this.multifileFacadeToParts.get(jvmClassName2);
        if (collection == null) {
            return null;
        }
        Collection<String> partNames = collection;
        Iterable $this$filter$iv = partNames;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            DirtyClassesJvmNameMap dirtyClassesJvmNameMap = this.getDirtyOutputClassesMap$kotlin_build_common();
            JvmClassName jvmClassName3 = JvmClassName.byInternalName(it);
            Intrinsics.checkNotNullExpressionValue((Object)jvmClassName3, (String)"byInternalName(it)");
            if (!(!dirtyClassesJvmNameMap.isDirty(jvmClassName3))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public byte[] getModuleMappingData() {
        JvmClassName jvmClassName = JvmClassName.byInternalName(MODULE_MAPPING_FILE_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"byInternalName(MODULE_MAPPING_FILE_NAME)");
        ProtoMapValue protoMapValue = this.protoMap.get(jvmClassName);
        return protoMapValue == null ? null : protoMapValue.getBytes();
    }

    private final void addToClassStorage(KotlinClassInfo classInfo, File srcFile) {
        Pair<JvmNameResolver, ProtoBuf.Class> pair = JvmProtoBufUtil.readClassDataFrom(classInfo.getClassHeaderData(), classInfo.getClassHeaderStrings());
        JvmNameResolver nameResolver2 = (JvmNameResolver)pair.component1();
        ProtoBuf.Class proto = (ProtoBuf.Class)pair.component2();
        this.addToClassStorage(proto, nameResolver2, srcFile);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$Companion;", "", "()V", "CONSTANTS_MAP", "", "INLINE_FUNCTIONS", "INTERNAL_NAME_TO_SOURCE", "JAVA_SOURCES_PROTO_MAP", "MODULE_MAPPING_FILE_NAME", "MULTIFILE_CLASS_FACADES", "MULTIFILE_CLASS_PARTS", "PACKAGE_PARTS", "PROTO_MAP", "kotlin-build-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0086\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u0013\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0086\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$ProtoMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "Lorg/jetbrains/kotlin/incremental/storage/ProtoMapValue;", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "contains", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "", "value", "get", "process", "", "kotlinClassInfo", "Lorg/jetbrains/kotlin/incremental/KotlinClassInfo;", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "put", "remove", "storeModuleMapping", "bytes", "", "kotlin-build-common"})
    private final class ProtoMap
    extends BasicStringMap<ProtoMapValue> {
        public ProtoMap(File storageFile) {
            Intrinsics.checkNotNullParameter((Object)IncrementalJvmCache.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
            super(storageFile, ProtoMapValueExternalizer.INSTANCE);
        }

        public final synchronized void process(@NotNull KotlinClassInfo kotlinClassInfo, @NotNull ChangesCollector changesCollector) {
            Intrinsics.checkNotNullParameter((Object)kotlinClassInfo, (String)"kotlinClassInfo");
            Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
            this.put(kotlinClassInfo, changesCollector);
        }

        public final synchronized void storeModuleMapping(@NotNull JvmClassName className2, @NotNull byte[] bytes) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            LazyStorage<String, ProtoMapValue> lazyStorage = this.getStorage();
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            boolean $i$f$emptyArray = false;
            lazyStorage.set(string2, new ProtoMapValue(false, bytes, new String[0]));
        }

        private final synchronized void put(KotlinClassInfo kotlinClassInfo, ChangesCollector changesCollector) {
            String string2 = kotlinClassInfo.getClassName().getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"kotlinClassInfo.className.internalName");
            String key = string2;
            ProtoMapValue oldData = (ProtoMapValue)this.getStorage().get(key);
            boolean bl = kotlinClassInfo.getClassKind() != KotlinClassHeader.Kind.CLASS;
            byte[] byArray = BitEncoding.decodeBytes(kotlinClassInfo.getClassHeaderData());
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decodeBytes(kotlinClassInfo.classHeaderData)");
            ProtoMapValue newData = new ProtoMapValue(bl, byArray, kotlinClassInfo.getClassHeaderStrings());
            this.getStorage().set(key, newData);
            Object object = kotlinClassInfo.getClassName().getPackageFqName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"kotlinClassInfo.className.packageFqName");
            FqName packageFqName = object;
            object = oldData;
            ChangesCollector.collectProtoChanges$default(changesCollector, object == null ? null : ProtoDifferenceUtilsKt.toProtoData((ProtoMapValue)object, packageFqName), ProtoDifferenceUtilsKt.toProtoData(newData, packageFqName), false, key, 4, null);
        }

        public final boolean contains(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            return lazyStorage.contains(string2);
        }

        @Nullable
        public final ProtoMapValue get(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            return (ProtoMapValue)lazyStorage.get(string2);
        }

        public final synchronized void remove(@NotNull JvmClassName className2, @NotNull ChangesCollector changesCollector) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            String key = string2;
            Object object = (ProtoMapValue)this.getStorage().get(key);
            if (object == null) {
                return;
            }
            ProtoMapValue oldValue = object;
            if (!Intrinsics.areEqual((Object)key, (Object)MODULE_MAPPING_FILE_NAME)) {
                object = className2.getPackageFqName();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"className.packageFqName");
                ChangesCollector.collectProtoChanges$default(changesCollector, ProtoDifferenceUtilsKt.toProtoData(oldValue, (FqName)object), null, false, null, 12, null);
            }
            this.getStorage().remove(key);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull ProtoMapValue value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            return Intrinsics.stringPlus((String)(value2.isPackageFacade() ? "1" : "0"), (Object)Long.toHexString(IncrementalJvmCacheKt.md5(value2.getBytes())));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0086\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u0013\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0086\u0002J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$JavaSourcesProtoMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "Lorg/jetbrains/kotlin/incremental/SerializedJavaClass;", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "contains", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "", "value", "get", "process", "", "jvmClassName", "newData", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "remove", "kotlin-build-common"})
    private final class JavaSourcesProtoMap
    extends BasicStringMap<SerializedJavaClass> {
        public JavaSourcesProtoMap(File storageFile) {
            Intrinsics.checkNotNullParameter((Object)IncrementalJvmCache.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
            super(storageFile, JavaClassProtoMapValueExternalizer.INSTANCE);
        }

        public final synchronized void process(@NotNull JvmClassName jvmClassName, @NotNull SerializedJavaClass newData, @NotNull ChangesCollector changesCollector) {
            Intrinsics.checkNotNullParameter((Object)jvmClassName, (String)"jvmClassName");
            Intrinsics.checkNotNullParameter((Object)newData, (String)"newData");
            Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
            String string2 = jvmClassName.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jvmClassName.internalName");
            String key = string2;
            SerializedJavaClass oldData = (SerializedJavaClass)this.getStorage().get(key);
            this.getStorage().set(key, newData);
            SerializedJavaClass serializedJavaClass = oldData;
            ChangesCollector.collectProtoChanges$default(changesCollector, serializedJavaClass == null ? null : JavaClassesTrackerImplKt.toProtoData(serializedJavaClass), JavaClassesTrackerImplKt.toProtoData(newData), true, null, 8, null);
        }

        public final synchronized void remove(@NotNull JvmClassName className2, @NotNull ChangesCollector changesCollector) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            String key = string2;
            SerializedJavaClass serializedJavaClass = (SerializedJavaClass)this.getStorage().get(key);
            if (serializedJavaClass == null) {
                return;
            }
            SerializedJavaClass oldValue = serializedJavaClass;
            this.getStorage().remove(key);
            ChangesCollector.collectProtoChanges$default(changesCollector, JavaClassesTrackerImplKt.toProtoData(oldValue), null, false, null, 12, null);
        }

        @Nullable
        public final SerializedJavaClass get(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            return (SerializedJavaClass)lazyStorage.get(string2);
        }

        public final boolean contains(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            return lazyStorage.contains(string2);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull SerializedJavaClass value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            byte[] byArray = value2.getProto().toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"value.proto.toByteArray()");
            String string2 = Long.toHexString(IncrementalJvmCacheKt.md5(byArray));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toHexString(value.proto.toByteArray().md5())");
            return string2;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002$\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004`\u00050\u0001B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0086\u0002J,\u0010\r\u001a\u00020\u00032\"\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004`\u0005H\u0014J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$ConstantsMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "Ljava/util/LinkedHashMap;", "", "", "Lkotlin/collections/LinkedHashMap;", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "contains", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "value", "process", "", "kotlinClassInfo", "Lorg/jetbrains/kotlin/incremental/KotlinClassInfo;", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "remove", "kotlin-build-common"})
    private final class ConstantsMap
    extends BasicStringMap<LinkedHashMap<String, Object>> {
        public ConstantsMap(File storageFile) {
            Intrinsics.checkNotNullParameter((Object)IncrementalJvmCache.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
            super(storageFile, new LinkedHashMapExternalizer(StringExternalizer.INSTANCE, ConstantExternalizer.INSTANCE));
        }

        public final boolean contains(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            return lazyStorage.contains(string2);
        }

        public final synchronized void process(@NotNull KotlinClassInfo kotlinClassInfo, @NotNull ChangesCollector changesCollector) {
            Intrinsics.checkNotNullParameter((Object)kotlinClassInfo, (String)"kotlinClassInfo");
            Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
            String string2 = kotlinClassInfo.getClassName().getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"kotlinClassInfo.className.internalName");
            String key = string2;
            LinkedHashMap linkedHashMap = (LinkedHashMap)this.getStorage().get(key);
            Map oldMap2 = linkedHashMap == null ? MapsKt.emptyMap() : (Map)linkedHashMap;
            LinkedHashMap<String, Object> newMap2 = kotlinClassInfo.getConstantsMap();
            if (!((Map)newMap2).isEmpty()) {
                this.getStorage().set(key, newMap2);
            } else {
                this.getStorage().remove(key);
            }
            Set set = oldMap2.keySet();
            Set<String> set2 = newMap2.keySet();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"newMap.keys");
            for (String string3 : SetsKt.plus(set, (Iterable)set2)) {
                changesCollector.collectMemberIfValueWasChanged(kotlinClassInfo.scopeFqName(true), string3, oldMap2.get(string3), newMap2.get(string3));
                changesCollector.collectMemberIfValueWasChanged(kotlinClassInfo.scopeFqName(false), string3, oldMap2.get(string3), newMap2.get(string3));
            }
        }

        public final synchronized void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            lazyStorage.remove(string2);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull LinkedHashMap<String, Object> value2) {
            Intrinsics.checkNotNullParameter(value2, (String)"value");
            return IncrementalJvmCacheKt.dumpMap((Map)value2, dumpValue.1.INSTANCE);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u000e\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$PackagePartMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "addPackagePart", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "", "value", "isPackagePart", "remove", "kotlin-build-common"})
    private final class PackagePartMap
    extends BasicStringMap<Boolean> {
        public PackagePartMap(File storageFile) {
            Intrinsics.checkNotNullParameter((Object)IncrementalJvmCache.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
            BooleanDataDescriptor booleanDataDescriptor = BooleanDataDescriptor.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)booleanDataDescriptor, (String)"INSTANCE");
            super(storageFile, booleanDataDescriptor);
        }

        public final void addPackagePart(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage<String, Boolean> lazyStorage = this.getStorage();
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            lazyStorage.set(string2, true);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            lazyStorage.remove(string2);
        }

        public final boolean isPackagePart(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            return lazyStorage.contains(string2);
        }

        @Override
        @NotNull
        protected String dumpValue(boolean value2) {
            return "";
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0086\u0002J\u0016\u0010\u000b\u001a\u00020\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0014J\u0019\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\nH\u0086\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nJ\u001f\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0086\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$MultifileClassFacadeMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "contains", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "value", "get", "remove", "", "set", "partNames", "kotlin-build-common"})
    private final class MultifileClassFacadeMap
    extends BasicStringMap<Collection<? extends String>> {
        public MultifileClassFacadeMap(File storageFile) {
            Intrinsics.checkNotNullParameter((Object)IncrementalJvmCache.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
            super(storageFile, StringCollectionExternalizer.INSTANCE);
        }

        public final synchronized void set(@NotNull JvmClassName className2, @NotNull Collection<String> partNames) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            Intrinsics.checkNotNullParameter(partNames, (String)"partNames");
            LazyStorage<String, Collection<String>> lazyStorage = this.getStorage();
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            lazyStorage.set(string2, partNames);
        }

        @Nullable
        public final Collection<String> get(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            return (Collection)lazyStorage.get(string2);
        }

        public final boolean contains(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            return lazyStorage.contains(string2);
        }

        public final synchronized void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            lazyStorage.remove(string2);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Collection<String> value2) {
            Intrinsics.checkNotNullParameter(value2, (String)"value");
            return IncrementalJvmCacheKt.dumpCollection(value2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0014J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\u0016\u0010\u000e\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$MultifileClassPartMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "dumpValue", "value", "get", "partName", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "remove", "", "className", "set", "facadeName", "kotlin-build-common"})
    private final class MultifileClassPartMap
    extends BasicStringMap<String> {
        public MultifileClassPartMap(File storageFile) {
            Intrinsics.checkNotNullParameter((Object)IncrementalJvmCache.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
            EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)enumeratorStringDescriptor, (String)"INSTANCE");
            super(storageFile, enumeratorStringDescriptor);
        }

        public final synchronized void set(@NotNull String partName, @NotNull String facadeName) {
            Intrinsics.checkNotNullParameter((Object)partName, (String)"partName");
            Intrinsics.checkNotNullParameter((Object)facadeName, (String)"facadeName");
            this.getStorage().set(partName, facadeName);
        }

        @Nullable
        public final String get(@NotNull JvmClassName partName) {
            Intrinsics.checkNotNullParameter((Object)partName, (String)"partName");
            LazyStorage lazyStorage = this.getStorage();
            String string2 = partName.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"partName.internalName");
            return (String)lazyStorage.get(string2);
        }

        public final synchronized void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            lazyStorage.remove(string2);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            return value2;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0014J\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00022\u0006\u0010\f\u001a\u00020\u0003H\u0086\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0003J\u001f\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0002H\u0086\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$InternalNameToSourcesMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "pathConverter", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;)V", "dumpValue", "value", "get", "internalName", "remove", "", "set", "sourceFiles", "kotlin-build-common"})
    public final class InternalNameToSourcesMap
    extends BasicStringMap<Collection<? extends String>> {
        @NotNull
        private final FileToPathConverter pathConverter;

        public InternalNameToSourcesMap(@NotNull File storageFile, FileToPathConverter pathConverter) {
            Intrinsics.checkNotNullParameter((Object)IncrementalJvmCache.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
            Intrinsics.checkNotNullParameter((Object)pathConverter, (String)"pathConverter");
            super(storageFile, new EnumeratorStringDescriptor(), (DataExternalizer)PathCollectionExternalizer.INSTANCE);
            this.pathConverter = pathConverter;
        }

        public final void set(@NotNull String internalName2, @NotNull Collection<? extends File> sourceFiles2) {
            Intrinsics.checkNotNullParameter((Object)internalName2, (String)"internalName");
            Intrinsics.checkNotNullParameter(sourceFiles2, (String)"sourceFiles");
            this.getStorage().set(internalName2, FileToPathConverterKt.toPaths(this.pathConverter, sourceFiles2));
        }

        @NotNull
        public final Collection<File> get(@NotNull String internalName2) {
            Intrinsics.checkNotNullParameter((Object)internalName2, (String)"internalName");
            Collection collection = (Collection)this.getStorage().get(internalName2);
            return FileToPathConverterKt.toFiles(this.pathConverter, collection == null ? (Collection)CollectionsKt.emptyList() : collection);
        }

        public final void remove(@NotNull String internalName2) {
            Intrinsics.checkNotNullParameter((Object)internalName2, (String)"internalName");
            this.getStorage().remove(internalName2);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Collection<String> value2) {
            Intrinsics.checkNotNullParameter(value2, (String)"value");
            return IncrementalJvmCacheKt.dumpCollection(value2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002$\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004`\u00050\u0001B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ,\u0010\t\u001a\u00020\u00032\"\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004`\u0005H\u0014J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$InlineFunctionsMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "Ljava/util/LinkedHashMap;", "", "", "Lkotlin/collections/LinkedHashMap;", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "dumpValue", "value", "functionNameBySignature", "signature", "process", "", "kotlinClassInfo", "Lorg/jetbrains/kotlin/incremental/KotlinClassInfo;", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "remove", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "kotlin-build-common"})
    private final class InlineFunctionsMap
    extends BasicStringMap<LinkedHashMap<String, Long>> {
        public InlineFunctionsMap(File storageFile) {
            Intrinsics.checkNotNullParameter((Object)IncrementalJvmCache.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
            super(storageFile, new LinkedHashMapExternalizer(StringExternalizer.INSTANCE, LongExternalizer.INSTANCE));
        }

        public final synchronized void process(@NotNull KotlinClassInfo kotlinClassInfo, @NotNull ChangesCollector changesCollector) {
            Intrinsics.checkNotNullParameter((Object)kotlinClassInfo, (String)"kotlinClassInfo");
            Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
            String string2 = kotlinClassInfo.getClassName().getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"kotlinClassInfo.className.internalName");
            String key = string2;
            LinkedHashMap linkedHashMap = (LinkedHashMap)this.getStorage().get(key);
            Map oldMap2 = linkedHashMap == null ? MapsKt.emptyMap() : (Map)linkedHashMap;
            LinkedHashMap<String, Long> newMap2 = kotlinClassInfo.getInlineFunctionsMap();
            if (!((Map)newMap2).isEmpty()) {
                this.getStorage().set(key, newMap2);
            } else {
                this.getStorage().remove(key);
            }
            Set set = oldMap2.keySet();
            Set<String> set2 = newMap2.keySet();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"newMap.keys");
            for (String fn : SetsKt.plus(set, (Iterable)set2)) {
                changesCollector.collectMemberIfValueWasChanged(KotlinClassInfo.scopeFqName$default(kotlinClassInfo, false, 1, null), this.functionNameBySignature(fn), oldMap2.get(fn), newMap2.get(fn));
            }
        }

        private final String functionNameBySignature(String signature2) {
            return StringsKt.substringBefore$default((String)signature2, (String)"(", null, (int)2, null);
        }

        public final synchronized void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string2 = className2.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.internalName");
            lazyStorage.remove(string2);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull LinkedHashMap<String, Long> value2) {
            Intrinsics.checkNotNullParameter(value2, (String)"value");
            return IncrementalJvmCacheKt.dumpMap((Map)value2, dumpValue.1.INSTANCE);
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KotlinClassHeader.Kind.values().length];
            nArray[KotlinClassHeader.Kind.FILE_FACADE.ordinal()] = 1;
            nArray[KotlinClassHeader.Kind.MULTIFILE_CLASS.ordinal()] = 2;
            nArray[KotlinClassHeader.Kind.MULTIFILE_CLASS_PART.ordinal()] = 3;
            nArray[KotlinClassHeader.Kind.CLASS.ordinal()] = 4;
            nArray[KotlinClassHeader.Kind.UNKNOWN.ordinal()] = 5;
            nArray[KotlinClassHeader.Kind.SYNTHETIC_CLASS.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

