/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Deprecation;
import org.jetbrains.kotlin.descriptors.DeprecationLevelValue;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirRealSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKind;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory2;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0002J;\u0010\u0015\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u001aJ=\u0010\u001b\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00142\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u001cR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirDeprecationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "()V", "allowedSourceKinds", "", "Lorg/jetbrains/kotlin/fir/FirSourceElementKind;", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "getWorstDeprecation", "Lorg/jetbrains/kotlin/descriptors/Deprecation;", "callSite", "Lorg/jetbrains/kotlin/fir/FirElement;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "reportDeprecation", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "referencedSymbol", "deprecation", "reportDeprecation$checkers", "reportDeprecationIfNeeded", "reportDeprecationIfNeeded$checkers", "checkers"})
public final class FirDeprecationChecker
extends FirExpressionChecker<FirStatement> {
    @NotNull
    public static final FirDeprecationChecker INSTANCE = new FirDeprecationChecker();
    @NotNull
    private static final Set<FirSourceElementKind> allowedSourceKinds;

    private FirDeprecationChecker() {
    }

    @Override
    public void check(@NotNull FirStatement expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirResolvedNamedReference firResolvedNamedReference;
        FirResolvable firResolvable;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirSourceElement firSourceElement = expression2.getSource();
        if (!CollectionsKt.contains((Iterable)allowedSourceKinds, (Object)(firSourceElement == null ? null : firSourceElement.getKind()))) {
            return;
        }
        if (expression2 instanceof FirAnnotationCall || expression2 instanceof FirDelegatedConstructorCall) {
            return;
        }
        FirResolvable firResolvable2 = firResolvable = expression2 instanceof FirResolvable ? (FirResolvable)((Object)expression2) : null;
        if (firResolvable == null) {
            return;
        }
        FirResolvable resolvable = firResolvable;
        FirReference firReference = resolvable.getCalleeReference();
        FirResolvedNamedReference firResolvedNamedReference2 = firResolvedNamedReference = firReference instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)firReference : null;
        if (firResolvedNamedReference == null) {
            return;
        }
        FirResolvedNamedReference reference = firResolvedNamedReference;
        FirBasedSymbol<?> referencedSymbol2 = reference.getResolvedSymbol();
        this.reportDeprecationIfNeeded$checkers(expression2.getSource(), referencedSymbol2, expression2, context2, reporter);
    }

    public final void reportDeprecationIfNeeded$checkers(@Nullable FirSourceElement source, @NotNull FirBasedSymbol<?> referencedSymbol2, @Nullable FirElement callSite, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(referencedSymbol2, (String)"referencedSymbol");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Deprecation deprecation2 = this.getWorstDeprecation(callSite, referencedSymbol2, context2);
        if (deprecation2 == null) {
            return;
        }
        Deprecation deprecation3 = deprecation2;
        this.reportDeprecation$checkers(source, referencedSymbol2, deprecation3, reporter, context2);
    }

    public final void reportDeprecation$checkers(@Nullable FirSourceElement source, @NotNull FirBasedSymbol<?> referencedSymbol2, @NotNull Deprecation deprecation2, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2) {
        FirDiagnosticFactory2<FirBasedSymbol<?>, String> firDiagnosticFactory2;
        Intrinsics.checkNotNullParameter(referencedSymbol2, (String)"referencedSymbol");
        Intrinsics.checkNotNullParameter((Object)deprecation2, (String)"deprecation");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object object = deprecation2.getLevel();
        int n = WhenMappings.$EnumSwitchMapping$0[object.ordinal()];
        switch (n) {
            case 1: 
            case 2: {
                firDiagnosticFactory2 = FirErrors.INSTANCE.getDEPRECATION_ERROR();
                break;
            }
            case 3: {
                firDiagnosticFactory2 = FirErrors.INSTANCE.getDEPRECATION();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        FirDiagnosticFactory2<FirBasedSymbol<?>, String> diagnostic = firDiagnosticFactory2;
        object = deprecation2.getMessage();
        DiagnosticReporterKt.reportOn$default(reporter, source, diagnostic, referencedSymbol2, object == null ? "" : object, context2, null, 32, null);
    }

    private final Deprecation getWorstDeprecation(FirElement callSite, FirBasedSymbol<?> symbol2, CheckerContext context2) {
        FirResolvedTypeRef firResolvedTypeRef;
        FirRegularClassSymbol firRegularClassSymbol;
        FirConstructorSymbol firConstructorSymbol;
        Object[] objectArray = new Deprecation[2];
        objectArray[0] = DeprecationUtilsKt.getDeprecation(symbol2, callSite);
        FirBasedSymbol<?> $this$safeAs$iv = symbol2;
        boolean $i$f$safeAs = false;
        FirBasedSymbol<?> firBasedSymbol = $this$safeAs$iv;
        if (!(firBasedSymbol instanceof FirConstructorSymbol)) {
            firBasedSymbol = null;
        }
        objectArray[1] = (firConstructorSymbol = (FirConstructorSymbol)firBasedSymbol) == null ? null : ((firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol(firResolvedTypeRef = firConstructorSymbol.getResolvedReturnTypeRef(), context2.getSession())) == null ? null : DeprecationUtilsKt.getDeprecation(firRegularClassSymbol, callSite));
        List deprecationInfos = CollectionsKt.listOfNotNull((Object[])objectArray);
        return (Deprecation)CollectionsKt.maxOrNull((Iterable)deprecationInfos);
    }

    static {
        Object[] objectArray = new FirSourceElementKind[]{FirRealSourceElementKind.INSTANCE, FirFakeSourceElementKind.DesugaredIncrementOrDecrement.INSTANCE};
        allowedSourceKinds = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DeprecationLevelValue.values().length];
            nArray[DeprecationLevelValue.ERROR.ordinal()] = 1;
            nArray[DeprecationLevelValue.HIDDEN.ordinal()] = 2;
            nArray[DeprecationLevelValue.WARNING.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

