/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface EventWatcher {
    @NotNull
    public static final InstanceHolder HOLDER = new InstanceHolder();

    public static boolean isEnabled() {
        return HOLDER.myIsEnabled;
    }

    @Nullable
    public static EventWatcher getInstance() {
        if (!EventWatcher.isEnabled()) {
            return null;
        }
        EventWatcher result2 = HOLDER.myInstance;
        if (result2 != null) {
            return result2;
        }
        Application application = ApplicationManager.getApplication();
        if (application == null || application.isDisposed()) {
            return null;
        }
        result2 = application.getService(EventWatcher.class);
        HOLDER.myInstance = result2;
        return result2;
    }

    public void runnableStarted(@NotNull Runnable var1, long var2);

    public void runnableFinished(@NotNull Runnable var1, long var2);

    public static final class InstanceHolder {
        @Nullable
        private EventWatcher myInstance = null;
        private final boolean myIsEnabled = Boolean.getBoolean("idea.event.queue.dispatch.listen");

        private InstanceHolder() {
        }
    }
}

