/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.overrides;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrOverridableMember;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.overrides.DeepCopyIrTreeWithSymbolsForFakeOverrides;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContextKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a8\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\n0\b\u001a2\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\n0\bH\u0002\u001a\n\u0010\u0010\u001a\u00020\f*\u00020\u0011\u001a\n\u0010\u0012\u001a\u00020\f*\u00020\u0013\u001a\n\u0010\u0014\u001a\u00020\f*\u00020\u0015\u001a6\u0010\u0016\u001a\u00020\f*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\n0\bH\u0002\u00a8\u0006\u0019"}, d2={"buildFakeOverrideMember", "Lorg/jetbrains/kotlin/ir/declarations/IrOverridableMember;", "superType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "member", "clazz", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "friendModules", "", "", "", "isInFriendModules", "", "fromModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "toModule", "isOverridableFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "isOverridableMemberOrAccessor", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "isOverridableProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "isPrivateToThisModule", "thisClass", "memberClass", "ir.tree"})
public final class IrOverridingUtilKt {
    private static final boolean isPrivateToThisModule(IrOverridableMember $this$isPrivateToThisModule, IrClass thisClass, IrClass memberClass, Map<String, ? extends Collection<String>> friendModules) {
        IrModuleFragment memberModule;
        if (!Intrinsics.areEqual((Object)$this$isPrivateToThisModule.getVisibility(), (Object)DescriptorVisibilities.INTERNAL)) {
            return false;
        }
        IrFile irFile = IrUtilsKt.getFileOrNull(thisClass);
        IrModuleFragment thisModule = irFile != null ? irFile.getModule() : null;
        IrFile irFile2 = IrUtilsKt.getFileOrNull(memberClass);
        IrModuleFragment irModuleFragment = memberModule = irFile2 != null ? irFile2.getModule() : null;
        if (Intrinsics.areEqual((Object)thisModule, (Object)memberModule)) {
            return false;
        }
        if (thisModule == null || memberModule == null) {
            return false;
        }
        return !IrOverridingUtilKt.isInFriendModules(thisModule, memberModule, friendModules);
    }

    private static final boolean isInFriendModules(IrModuleFragment fromModule, IrModuleFragment toModule, Map<String, ? extends Collection<String>> friendModules) {
        if (friendModules.isEmpty()) {
            return false;
        }
        String string2 = fromModule.getName().asStringStripSpecialMarkers();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fromModule.name.asStringStripSpecialMarkers()");
        String fromModuleName = string2;
        Collection<String> collection = friendModules.get(fromModuleName);
        if (collection == null) {
            return false;
        }
        Collection<String> fromFriends = collection;
        String string3 = toModule.getName().asStringStripSpecialMarkers();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toModule.name.asStringStripSpecialMarkers()");
        String toModuleName = string3;
        return fromFriends.contains(toModuleName);
    }

    @NotNull
    public static final IrOverridableMember buildFakeOverrideMember(@NotNull IrType superType2, @NotNull IrOverridableMember member2, @NotNull IrClass clazz) {
        Intrinsics.checkNotNullParameter((Object)superType2, (String)"superType");
        Intrinsics.checkNotNullParameter((Object)member2, (String)"member");
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        return IrOverridingUtilKt.buildFakeOverrideMember(superType2, member2, clazz, MapsKt.emptyMap());
    }

    @NotNull
    public static final IrOverridableMember buildFakeOverrideMember(@NotNull IrType superType2, @NotNull IrOverridableMember member2, @NotNull IrClass clazz, @NotNull Map<String, ? extends Collection<String>> friendModules) {
        Intrinsics.checkNotNullParameter((Object)superType2, (String)"superType");
        Intrinsics.checkNotNullParameter((Object)member2, (String)"member");
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(friendModules, (String)"friendModules");
        if (!(superType2 instanceof IrSimpleType)) {
            boolean $i$a$-require-IrOverridingUtilKt$buildFakeOverrideMember$62 = false;
            String $i$a$-require-IrOverridingUtilKt$buildFakeOverrideMember$62 = "superType is " + superType2 + ", expected IrSimpleType";
            throw new IllegalArgumentException($i$a$-require-IrOverridingUtilKt$buildFakeOverrideMember$62.toString());
        }
        IrClassifierSymbol classifier2 = ((IrSimpleType)superType2).getClassifier();
        if (!(classifier2 instanceof IrClassSymbol)) {
            boolean $i$a$-require-IrOverridingUtilKt$buildFakeOverrideMember$72 = false;
            String $i$a$-require-IrOverridingUtilKt$buildFakeOverrideMember$72 = "superType classifier is not IrClassSymbol: " + classifier2;
            throw new IllegalArgumentException($i$a$-require-IrOverridingUtilKt$buildFakeOverrideMember$72.toString());
        }
        List<IrTypeParameter> typeParameters2 = IrTypeSystemContextKt.extractTypeParameters((IrDeclarationParent)((IrClassSymbol)classifier2).getOwner());
        List<IrTypeArgument> superArguments = ((IrSimpleType)superType2).getArguments();
        if (!(typeParameters2.size() == superArguments.size())) {
            boolean $i$a$-require-IrOverridingUtilKt$buildFakeOverrideMember$82 = false;
            String $i$a$-require-IrOverridingUtilKt$buildFakeOverrideMember$82 = "typeParameters = " + typeParameters2 + " size != typeArguments = " + superArguments + " size ";
            throw new IllegalArgumentException($i$a$-require-IrOverridingUtilKt$buildFakeOverrideMember$82.toString());
        }
        Map substitutionMap = new LinkedHashMap();
        int n = typeParameters2.size();
        for (int i = 0; i < n; ++i) {
            IrTypeParameter tp = typeParameters2.get(i);
            IrTypeArgument ta = superArguments.get(i);
            if (!(ta instanceof IrTypeProjection)) {
                boolean $i$a$-require-IrOverridingUtilKt$buildFakeOverrideMember$92 = false;
                String $i$a$-require-IrOverridingUtilKt$buildFakeOverrideMember$92 = "Unexpected super type argument: " + RenderIrElementKt.render(ta) + " @ " + i;
                throw new IllegalArgumentException($i$a$-require-IrOverridingUtilKt$buildFakeOverrideMember$92.toString());
            }
            if (!(((IrTypeProjection)ta).getVariance() == Variance.INVARIANT)) {
                boolean bl = false;
                String string2 = "Unexpected variance in super type argument: " + (Object)((Object)((IrTypeProjection)ta).getVariance()) + " @" + i;
                throw new IllegalArgumentException(string2.toString());
            }
            substitutionMap.put(tp.getSymbol(), ((IrTypeProjection)ta).getType());
        }
        DeepCopyIrTreeWithSymbolsForFakeOverrides copier2 = new DeepCopyIrTreeWithSymbolsForFakeOverrides(substitutionMap);
        IrElement irElement = copier2.copy(member2, clazz);
        Intrinsics.checkNotNull((Object)irElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrOverridableMember");
        IrOverridableMember deepCopyFakeOverride = (IrOverridableMember)irElement;
        deepCopyFakeOverride.setParent(clazz);
        if (IrOverridingUtilKt.isPrivateToThisModule(deepCopyFakeOverride, clazz, (IrClass)((IrClassSymbol)classifier2).getOwner(), friendModules)) {
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.INVISIBLE_FAKE;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"INVISIBLE_FAKE");
            deepCopyFakeOverride.setVisibility(descriptorVisibility);
        }
        return deepCopyFakeOverride;
    }

    public static final boolean isOverridableFunction(@NotNull IrSimpleFunction $this$isOverridableFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isOverridableFunction, (String)"<this>");
        return !Intrinsics.areEqual((Object)$this$isOverridableFunction.getVisibility(), (Object)DescriptorVisibilities.PRIVATE) && $this$isOverridableFunction.getDispatchReceiverParameter() != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isOverridableProperty(@NotNull IrProperty $this$isOverridableProperty) {
        Intrinsics.checkNotNullParameter((Object)$this$isOverridableProperty, (String)"<this>");
        if (Intrinsics.areEqual((Object)$this$isOverridableProperty.getVisibility(), (Object)DescriptorVisibilities.PRIVATE)) return false;
        IrSimpleFunction irSimpleFunction = $this$isOverridableProperty.getGetter();
        if ((irSimpleFunction != null ? irSimpleFunction.getDispatchReceiverParameter() : null) != null) return true;
        IrSimpleFunction irSimpleFunction2 = $this$isOverridableProperty.getSetter();
        if (irSimpleFunction2 == null) return false;
        IrValueParameter irValueParameter = irSimpleFunction2.getDispatchReceiverParameter();
        if (irValueParameter == null) return false;
        return true;
    }

    public static final boolean isOverridableMemberOrAccessor(@NotNull IrDeclaration $this$isOverridableMemberOrAccessor) {
        Intrinsics.checkNotNullParameter((Object)$this$isOverridableMemberOrAccessor, (String)"<this>");
        IrDeclaration irDeclaration2 = $this$isOverridableMemberOrAccessor;
        return irDeclaration2 instanceof IrSimpleFunction ? IrOverridingUtilKt.isOverridableFunction((IrSimpleFunction)$this$isOverridableMemberOrAccessor) : (irDeclaration2 instanceof IrProperty ? IrOverridingUtilKt.isOverridableProperty((IrProperty)$this$isOverridableMemberOrAccessor) : false);
    }
}

