/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnsupportedDefaultValueInFunctionType;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirUnsupportedDefaultValueInFunctionTypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirValueParameterChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirUnsupportedDefaultValueInFunctionTypeChecker
extends FirDeclarationChecker<FirValueParameter> {
    @NotNull
    public static final FirUnsupportedDefaultValueInFunctionTypeChecker INSTANCE = new FirUnsupportedDefaultValueInFunctionTypeChecker();

    private FirUnsupportedDefaultValueInFunctionTypeChecker() {
    }

    @Override
    public void check(@NotNull FirValueParameter declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        ConeUnsupportedDefaultValueInFunctionType diagnostic;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirExpression firExpression2 = declaration.getDefaultValue();
        FirTypeRef firTypeRef = firExpression2 != null ? firExpression2.getTypeRef() : null;
        FirErrorTypeRef firErrorTypeRef = firTypeRef instanceof FirErrorTypeRef ? (FirErrorTypeRef)firTypeRef : null;
        ConeDiagnostic coneDiagnostic = firErrorTypeRef != null ? firErrorTypeRef.getDiagnostic() : null;
        ConeUnsupportedDefaultValueInFunctionType coneUnsupportedDefaultValueInFunctionType = diagnostic = coneDiagnostic instanceof ConeUnsupportedDefaultValueInFunctionType ? (ConeUnsupportedDefaultValueInFunctionType)coneDiagnostic : null;
        if (diagnostic != null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)diagnostic.getSource(), FirErrors.INSTANCE.getUNSUPPORTED(), (Object)diagnostic.getReason(), (DiagnosticContext)context, null, 16, null);
        }
    }
}

