/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.$Gson$Types;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.Excluder;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.Primitives;
import com.google.gson.internal.bind.JsonAdapterAnnotationTypeAdapterFactory;
import com.google.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import com.google.gson.internal.reflect.ReflectionAccessor;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ReflectiveTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;
    private final FieldNamingStrategy fieldNamingPolicy;
    private final Excluder excluder;
    private final JsonAdapterAnnotationTypeAdapterFactory jsonAdapterFactory;
    private final ReflectionAccessor accessor = ReflectionAccessor.getInstance();

    public ReflectiveTypeAdapterFactory(ConstructorConstructor constructorConstructor, FieldNamingStrategy fieldNamingPolicy, Excluder excluder, JsonAdapterAnnotationTypeAdapterFactory jsonAdapterFactory) {
        this.constructorConstructor = constructorConstructor;
        this.fieldNamingPolicy = fieldNamingPolicy;
        this.excluder = excluder;
        this.jsonAdapterFactory = jsonAdapterFactory;
    }

    public boolean excludeField(Field f, boolean serialize2) {
        return ReflectiveTypeAdapterFactory.excludeField(f, serialize2, this.excluder);
    }

    static boolean excludeField(Field f, boolean serialize2, Excluder excluder) {
        return !excluder.excludeClass(f.getType(), serialize2) && !excluder.excludeField(f, serialize2);
    }

    private List<String> getFieldNames(Field f) {
        SerializedName annotation2 = f.getAnnotation(SerializedName.class);
        if (annotation2 == null) {
            String name2 = this.fieldNamingPolicy.translateName(f);
            return Collections.singletonList(name2);
        }
        String serializedName = annotation2.value();
        String[] alternates = annotation2.alternate();
        if (alternates.length == 0) {
            return Collections.singletonList(serializedName);
        }
        ArrayList<String> fieldNames = new ArrayList<String>(alternates.length + 1);
        fieldNames.add(serializedName);
        for (String alternate : alternates) {
            fieldNames.add(alternate);
        }
        return fieldNames;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type2) {
        Class<T> raw = type2.getRawType();
        if (!Object.class.isAssignableFrom(raw)) {
            return null;
        }
        ObjectConstructor<T> constructor2 = this.constructorConstructor.get(type2);
        return new Adapter<T>(constructor2, this.getBoundFields(gson, type2, raw));
    }

    private BoundField createBoundField(final Gson context, final Field field2, String name2, final TypeToken<?> fieldType, boolean serialize2, boolean deserialize2) {
        boolean jsonAdapterPresent;
        final boolean isPrimitive = Primitives.isPrimitive(fieldType.getRawType());
        JsonAdapter annotation2 = field2.getAnnotation(JsonAdapter.class);
        TypeAdapter<?> mapped = null;
        if (annotation2 != null) {
            mapped = this.jsonAdapterFactory.getTypeAdapter(this.constructorConstructor, context, fieldType, annotation2);
        }
        boolean bl = jsonAdapterPresent = mapped != null;
        if (mapped == null) {
            mapped = context.getAdapter(fieldType);
        }
        final TypeAdapter<?> typeAdapter = mapped;
        return new BoundField(name2, serialize2, deserialize2){

            @Override
            void write(JsonWriter writer, Object value2) throws IOException, IllegalAccessException {
                Object fieldValue = field2.get(value2);
                TypeAdapter t = jsonAdapterPresent ? typeAdapter : new TypeAdapterRuntimeTypeWrapper(context, typeAdapter, fieldType.getType());
                t.write(writer, fieldValue);
            }

            @Override
            public boolean writeField(Object value2) throws IOException, IllegalAccessException {
                if (!this.serialized) {
                    return false;
                }
                Object fieldValue = field2.get(value2);
                return fieldValue != value2;
            }
        };
    }

    private Map<String, BoundField> getBoundFields(Gson context, TypeToken<?> type2, Class<?> raw) {
        LinkedHashMap<String, BoundField> result2 = new LinkedHashMap<String, BoundField>();
        if (raw.isInterface()) {
            return result2;
        }
        Type declaredType = type2.getType();
        while (raw != Object.class) {
            Field[] fields2;
            for (Field field2 : fields2 = raw.getDeclaredFields()) {
                boolean serialize2 = this.excludeField(field2, true);
                boolean deserialize2 = this.excludeField(field2, false);
                if (!serialize2 && !deserialize2) continue;
                this.accessor.makeAccessible(field2);
                Type fieldType = $Gson$Types.resolve(type2.getType(), raw, field2.getGenericType());
                List<String> fieldNames = this.getFieldNames(field2);
                BoundField previous = null;
                int size = fieldNames.size();
                for (int i = 0; i < size; ++i) {
                    String name2 = fieldNames.get(i);
                    if (i != 0) {
                        serialize2 = false;
                    }
                    BoundField boundField = this.createBoundField(context, field2, name2, TypeToken.get(fieldType), serialize2, deserialize2);
                    BoundField replaced = result2.put(name2, boundField);
                    if (previous != null) continue;
                    previous = replaced;
                }
                if (previous == null) continue;
                throw new IllegalArgumentException(declaredType + " declares multiple JSON fields named " + previous.name);
            }
            type2 = TypeToken.get($Gson$Types.resolve(type2.getType(), raw, raw.getGenericSuperclass()));
            raw = type2.getRawType();
        }
        return result2;
    }

    public static final class Adapter<T>
    extends TypeAdapter<T> {
        private final ObjectConstructor<T> constructor;
        private final Map<String, BoundField> boundFields;

        Adapter(ObjectConstructor<T> constructor2, Map<String, BoundField> boundFields) {
            this.constructor = constructor2;
            this.boundFields = boundFields;
        }

        @Override
        public void write(JsonWriter out, T value2) throws IOException {
            if (value2 == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            try {
                for (BoundField boundField : this.boundFields.values()) {
                    if (!boundField.writeField(value2)) continue;
                    out.name(boundField.name);
                    boundField.write(out, value2);
                }
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            out.endObject();
        }
    }

    static abstract class BoundField {
        final String name;
        final boolean serialized;
        final boolean deserialized;

        protected BoundField(String name2, boolean serialized, boolean deserialized) {
            this.name = name2;
            this.serialized = serialized;
            this.deserialized = deserialized;
        }

        abstract boolean writeField(Object var1) throws IOException, IllegalAccessException;

        abstract void write(JsonWriter var1, Object var2) throws IOException, IllegalAccessException;
    }
}

