/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiled.light.classes;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0002\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0005R/\u0010\u0003\u001a#\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u00070\u0004\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiled/light/classes/ClsJavaStubByVirtualFileCache;", "", "()V", "cache", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/analysis/decompiled/light/classes/ClsJavaStubByVirtualFileCache$CachedJavaStub;", "Lorg/jetbrains/annotations/NotNull;", "createStub", "Lcom/intellij/psi/impl/java/stubs/PsiJavaFileStub;", "file", "get", "Lcom/intellij/psi/impl/java/stubs/impl/PsiJavaFileStubImpl;", "classFile", "CachedJavaStub", "Companion", "light-classes-for-decompiled"})
public final class ClsJavaStubByVirtualFileCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMap<VirtualFile, CachedJavaStub> cache;
    @NotNull
    private static final Logger LOG;

    public ClsJavaStubByVirtualFileCache() {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakKeySoftValueMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, (String)"createConcurrentWeakKeySoftValueMap(...)");
        this.cache = concurrentMap;
    }

    @Nullable
    public final PsiJavaFileStubImpl get(@NotNull VirtualFile classFile) {
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        CachedJavaStub cached2 = (CachedJavaStub)this.cache.get(classFile);
        long fileModificationStamp = classFile.getModificationStamp();
        if (cached2 != null && cached2.getModificationStamp() == fileModificationStamp) {
            return cached2.getJavaFileStub();
        }
        PsiJavaFileStubImpl psiJavaFileStubImpl = (PsiJavaFileStubImpl)this.createStub(classFile);
        if (psiJavaFileStubImpl == null) {
            return null;
        }
        PsiJavaFileStubImpl stub = psiJavaFileStubImpl;
        ((Map)this.cache).put(classFile, new CachedJavaStub(fileModificationStamp, stub));
        return stub;
    }

    private final PsiJavaFileStub createStub(VirtualFile file2) {
        if (!Intrinsics.areEqual((Object)file2.getExtension(), (Object)JavaClassFileType.INSTANCE.getDefaultExtension()) && file2.getFileType() != JavaClassFileType.INSTANCE) {
            return null;
        }
        try {
            return ClsFileImpl.buildFileStub(file2, file2.contentsToByteArray(false));
        }
        catch (ClsFormatException e) {
            StringBuilder stringBuilder2 = new StringBuilder().append("Failed to build java cls class for ");
            String string2 = file2.getCanonicalPath();
            Intrinsics.checkNotNull((Object)string2);
            LOG.warn(stringBuilder2.append(string2).toString(), e);
        }
        catch (IOException e) {
            StringBuilder stringBuilder3 = new StringBuilder().append("Failed to build java cls class for ");
            String string3 = file2.getCanonicalPath();
            Intrinsics.checkNotNull((Object)string3);
            LOG.warn(stringBuilder3.append(string3).toString(), e);
        }
        return null;
    }

    static {
        Logger logger = Logger.getInstance(ClsJavaStubByVirtualFileCache.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiled/light/classes/ClsJavaStubByVirtualFileCache$CachedJavaStub;", "", "modificationStamp", "", "javaFileStub", "Lcom/intellij/psi/impl/java/stubs/impl/PsiJavaFileStubImpl;", "(JLcom/intellij/psi/impl/java/stubs/impl/PsiJavaFileStubImpl;)V", "getJavaFileStub", "()Lcom/intellij/psi/impl/java/stubs/impl/PsiJavaFileStubImpl;", "getModificationStamp", "()J", "light-classes-for-decompiled"})
    private static final class CachedJavaStub {
        private final long modificationStamp;
        @NotNull
        private final PsiJavaFileStubImpl javaFileStub;

        public CachedJavaStub(long modificationStamp, @NotNull PsiJavaFileStubImpl javaFileStub) {
            Intrinsics.checkNotNullParameter((Object)javaFileStub, (String)"javaFileStub");
            this.modificationStamp = modificationStamp;
            this.javaFileStub = javaFileStub;
        }

        public final long getModificationStamp() {
            return this.modificationStamp;
        }

        @NotNull
        public final PsiJavaFileStubImpl getJavaFileStub() {
            return this.javaFileStub;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiled/light/classes/ClsJavaStubByVirtualFileCache$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lorg/jetbrains/kotlin/analysis/decompiled/light/classes/ClsJavaStubByVirtualFileCache;", "project", "Lcom/intellij/openapi/project/Project;", "light-classes-for-decompiled"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClsJavaStubByVirtualFileCache getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ClsJavaStubByVirtualFileCache clsJavaStubByVirtualFileCache = project.getService(ClsJavaStubByVirtualFileCache.class);
            Intrinsics.checkNotNullExpressionValue((Object)clsJavaStubByVirtualFileCache, (String)"getService(...)");
            return clsJavaStubByVirtualFileCache;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

