/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.lexer;

import com.intellij.lang.java.lexer._JavaLexer;
import com.intellij.lexer.LexerBase;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.text.CharArrayUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaLexer
extends LexerBase {
    private static final Set<String> KEYWORDS = new HashSet<String>(Arrays.asList("abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null", "non-sealed"));
    private static final Set<CharSequence> JAVA9_KEYWORDS = CollectionFactory.createCharSequenceSet(Arrays.asList("open", "module", "requires", "exports", "opens", "uses", "provides", "transitive", "to", "with"));
    private final _JavaLexer myFlexLexer;
    private CharSequence myBuffer;
    private char @Nullable [] myBufferArray;
    private int myBufferIndex;
    private int myBufferEndOffset;
    private int myTokenEndOffset;
    private IElementType myTokenType;

    public static boolean isKeyword(String id, @NotNull LanguageLevel level) {
        if (level == null) {
            JavaLexer.$$$reportNull$$$0(0);
        }
        return KEYWORDS.contains(id) || level.isAtLeast(LanguageLevel.JDK_1_4) && "assert".equals(id) || level.isAtLeast(LanguageLevel.JDK_1_5) && "enum".equals(id);
    }

    public static boolean isSoftKeyword(CharSequence id, @NotNull LanguageLevel level) {
        if (level == null) {
            JavaLexer.$$$reportNull$$$0(1);
        }
        return id != null && (level.isAtLeast(LanguageLevel.JDK_1_9) && JAVA9_KEYWORDS.contains(id) || level.isAtLeast(LanguageLevel.JDK_10) && "var".contentEquals(id) || level.isAtLeast(LanguageLevel.JDK_16) && "record".contentEquals(id) || level.isAtLeast(LanguageLevel.JDK_14) && "yield".contentEquals(id) || JavaLexer.isSealedAvailable(level) && ("sealed".contentEquals(id) || "permits".contentEquals(id)));
    }

    public static boolean isSealedAvailable(@NotNull LanguageLevel level) {
        if (level == null) {
            JavaLexer.$$$reportNull$$$0(2);
        }
        return level.isAtLeast(LanguageLevel.JDK_16_PREVIEW);
    }

    public JavaLexer(@NotNull LanguageLevel level) {
        if (level == null) {
            JavaLexer.$$$reportNull$$$0(3);
        }
        this.myFlexLexer = new _JavaLexer(level);
    }

    @Override
    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            JavaLexer.$$$reportNull$$$0(4);
        }
        this.myBuffer = buffer;
        this.myBufferArray = CharArrayUtil.fromSequenceWithoutCopying(buffer);
        this.myBufferIndex = startOffset;
        this.myBufferEndOffset = endOffset;
        this.myTokenType = null;
        this.myTokenEndOffset = startOffset;
        this.myFlexLexer.reset(this.myBuffer, startOffset, endOffset, 0);
    }

    @Override
    public int getState() {
        return 0;
    }

    @Override
    public IElementType getTokenType() {
        this.locateToken();
        return this.myTokenType;
    }

    @Override
    public int getTokenStart() {
        return this.myBufferIndex;
    }

    @Override
    public int getTokenEnd() {
        this.locateToken();
        return this.myTokenEndOffset;
    }

    @Override
    public void advance() {
        this.locateToken();
        this.myTokenType = null;
    }

    private void locateToken() {
        if (this.myTokenType != null) {
            return;
        }
        if (this.myTokenEndOffset == this.myBufferEndOffset) {
            this.myBufferIndex = this.myBufferEndOffset;
            return;
        }
        this.myBufferIndex = this.myTokenEndOffset;
        char c = this.charAt(this.myBufferIndex);
        switch (c) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': {
                this.myTokenType = TokenType.WHITE_SPACE;
                this.myTokenEndOffset = this.getWhitespaces(this.myBufferIndex + 1);
                break;
            }
            case '/': {
                if (this.myBufferIndex + 1 >= this.myBufferEndOffset) {
                    this.myTokenType = JavaTokenType.DIV;
                    this.myTokenEndOffset = this.myBufferEndOffset;
                    break;
                }
                char nextChar = this.charAt(this.myBufferIndex + 1);
                if (nextChar == '/') {
                    this.myTokenType = JavaTokenType.END_OF_LINE_COMMENT;
                    this.myTokenEndOffset = this.getLineTerminator(this.myBufferIndex + 2);
                    break;
                }
                if (nextChar == '*') {
                    if (this.myBufferIndex + 2 >= this.myBufferEndOffset || this.charAt(this.myBufferIndex + 2) != '*' || this.myBufferIndex + 3 < this.myBufferEndOffset && this.charAt(this.myBufferIndex + 3) == '/') {
                        this.myTokenType = JavaTokenType.C_STYLE_COMMENT;
                        this.myTokenEndOffset = this.getClosingComment(this.myBufferIndex + 2);
                        break;
                    }
                    this.myTokenType = JavaDocElementType.DOC_COMMENT;
                    this.myTokenEndOffset = this.getClosingComment(this.myBufferIndex + 3);
                    break;
                }
                this.flexLocateToken();
                break;
            }
            case '#': {
                if (this.myBufferIndex == 0 && this.myBufferIndex + 1 < this.myBufferEndOffset && this.charAt(this.myBufferIndex + 1) == '!') {
                    this.myTokenType = JavaTokenType.END_OF_LINE_COMMENT;
                    this.myTokenEndOffset = this.getLineTerminator(this.myBufferIndex + 2);
                    break;
                }
                this.flexLocateToken();
                break;
            }
            case '\'': {
                this.myTokenType = JavaTokenType.CHARACTER_LITERAL;
                this.myTokenEndOffset = this.getClosingQuote(this.myBufferIndex + 1, c);
                break;
            }
            case '\"': {
                if (this.myBufferIndex + 2 < this.myBufferEndOffset && this.charAt(this.myBufferIndex + 2) == '\"' && this.charAt(this.myBufferIndex + 1) == '\"') {
                    this.myTokenType = JavaTokenType.TEXT_BLOCK_LITERAL;
                    this.myTokenEndOffset = this.getTextBlockEnd(this.myBufferIndex + 2);
                    break;
                }
                this.myTokenType = JavaTokenType.STRING_LITERAL;
                this.myTokenEndOffset = this.getClosingQuote(this.myBufferIndex + 1, c);
                break;
            }
            default: {
                this.flexLocateToken();
            }
        }
        if (this.myTokenEndOffset > this.myBufferEndOffset) {
            this.myTokenEndOffset = this.myBufferEndOffset;
        }
    }

    private int getWhitespaces(int offset2) {
        if (offset2 >= this.myBufferEndOffset) {
            return this.myBufferEndOffset;
        }
        int pos = offset2;
        char c = this.charAt(pos);
        while (c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f') {
            if (++pos == this.myBufferEndOffset) {
                return pos;
            }
            c = this.charAt(pos);
        }
        return pos;
    }

    private void flexLocateToken() {
        try {
            this.myFlexLexer.goTo(this.myBufferIndex);
            this.myTokenType = this.myFlexLexer.advance();
            this.myTokenEndOffset = this.myFlexLexer.getTokenEnd();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int getClosingQuote(int offset2, char quoteChar) {
        int pos;
        block10: {
            if (offset2 >= this.myBufferEndOffset) {
                return this.myBufferEndOffset;
            }
            pos = offset2;
            char c = this.charAt(pos);
            while (true) {
                if (c != quoteChar && c != '\n' && c != '\r' && c != '\\') {
                    if (++pos >= this.myBufferEndOffset) {
                        return this.myBufferEndOffset;
                    }
                    c = this.charAt(pos);
                    continue;
                }
                if (c != '\\') break;
                if (++pos >= this.myBufferEndOffset) {
                    return this.myBufferEndOffset;
                }
                c = this.charAt(pos);
                if (c == '\n' || c == '\r') continue;
                if (c == 'u') {
                    while (++pos < this.myBufferEndOffset && this.charAt(pos) == 'u') {
                    }
                    if (pos + 3 >= this.myBufferEndOffset) {
                        return this.myBufferEndOffset;
                    }
                    boolean isBackSlash = this.charAt(pos) == '0' && this.charAt(pos + 1) == '0' && this.charAt(pos + 2) == '5' && this.charAt(pos + 3) == 'c';
                    pos += isBackSlash ? 5 : 4;
                } else {
                    ++pos;
                }
                if (pos >= this.myBufferEndOffset) {
                    return this.myBufferEndOffset;
                }
                c = this.charAt(pos);
            }
            if (c == quoteChar) break block10;
            --pos;
        }
        return pos + 1;
    }

    private int getClosingComment(int offset2) {
        char c;
        int pos;
        for (pos = offset2; pos < this.myBufferEndOffset - 1 && ((c = this.charAt(pos)) != '*' || this.charAt(pos + 1) != '/'); ++pos) {
        }
        return pos + 2;
    }

    private int getLineTerminator(int offset2) {
        char c;
        int pos;
        for (pos = offset2; pos < this.myBufferEndOffset && (c = this.charAt(pos)) != '\r' && c != '\n'; ++pos) {
        }
        return pos;
    }

    private int getTextBlockEnd(int offset2) {
        int pos = offset2;
        while ((pos = this.getClosingQuote(pos + 1, '\"')) < this.myBufferEndOffset) {
            char current = this.charAt(pos);
            if (current == '\\') {
                ++pos;
                continue;
            }
            if (current != '\"' || pos + 1 >= this.myBufferEndOffset || this.charAt(pos + 1) != '\"') continue;
            pos += 2;
            break;
        }
        return pos;
    }

    private char charAt(int position) {
        return this.myBufferArray != null ? this.myBufferArray[position] : this.myBuffer.charAt(position);
    }

    @Override
    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            JavaLexer.$$$reportNull$$$0(5);
        }
        return charSequence;
    }

    @Override
    public int getBufferEnd() {
        return this.myBufferEndOffset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/java/lexer/JavaLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/java/lexer/JavaLexer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isKeyword";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSoftKeyword";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSealedAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 5: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

