/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.UtilBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.TObjectHashingStrategy;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.NonExtendable
public class FileUtil
extends FileUtilRt {
    public static final String ASYNC_DELETE_EXTENSION = ".__del__";
    public static final int REGEX_PATTERN_FLAGS = SystemInfoRt.isFileSystemCaseSensitive ? 0 : 2;
    @Deprecated
    public static final TObjectHashingStrategy<String> PATH_HASHING_STRATEGY = SystemInfoRt.isFileSystemCaseSensitive ? TObjectHashingStrategy.CANONICAL : CaseInsensitiveStringHashingStrategy.INSTANCE;
    @Deprecated
    public static final TObjectHashingStrategy<File> FILE_HASHING_STRATEGY = new TObjectHashingStrategy<File>(){

        public int computeHashCode(File object) {
            return FileUtil.fileHashCode(object);
        }

        public boolean equals(File o1, File o2) {
            return FileUtil.filesEqual(o1, o2);
        }
    };
    private static final Logger LOG = Logger.getInstance(FileUtil.class);
    private static final FileUtilRt.SymlinkResolver SYMLINK_RESOLVER = new FileUtilRt.SymlinkResolver(){

        @Override
        @NotNull
        public String resolveSymlinksAndCanonicalize(@NotNull String path, char separatorChar, boolean removeLastSlash) {
            String string2;
            if (path == null) {
                2.$$$reportNull$$$0(0);
            }
            try {
                string2 = new File(path).getCanonicalPath().replace(separatorChar, '/');
            }
            catch (IOException ignore) {
                String string3 = FileUtil.toCanonicalPath(path, separatorChar, removeLastSlash, false);
                if (string3 == null) {
                    2.$$$reportNull$$$0(2);
                }
                return string3;
            }
            if (string2 == null) {
                2.$$$reportNull$$$0(1);
            }
            return string2;
        }

        @Override
        public boolean isSymlink(@NotNull CharSequence path) {
            if (path == null) {
                2.$$$reportNull$$$0(3);
            }
            return FileSystemUtil.isSymLink(new File(path.toString()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/io/FileUtil$2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/io/FileUtil$2";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolveSymlinksAndCanonicalize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolveSymlinksAndCanonicalize";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isSymlink";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    @NotNull
    public static String join(String ... parts) {
        if (parts == null) {
            FileUtil.$$$reportNull$$$0(0);
        }
        String string2 = String.join((CharSequence)File.separator, parts);
        if (string2 == null) {
            FileUtil.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @Nullable
    public static String getRelativePath(File base, File file2) {
        return FileUtilRt.getRelativePath(base, file2);
    }

    @Nullable
    public static String getRelativePath(@NotNull String basePath, @NotNull String filePath, char separator) {
        if (basePath == null) {
            FileUtil.$$$reportNull$$$0(2);
        }
        if (filePath == null) {
            FileUtil.$$$reportNull$$$0(3);
        }
        return FileUtilRt.getRelativePath(basePath, filePath, separator);
    }

    @Nullable
    public static String getRelativePath(@NotNull String basePath, @NotNull String filePath, char separator, boolean caseSensitive) {
        if (basePath == null) {
            FileUtil.$$$reportNull$$$0(4);
        }
        if (filePath == null) {
            FileUtil.$$$reportNull$$$0(5);
        }
        return FileUtilRt.getRelativePath(basePath, filePath, separator, caseSensitive);
    }

    public static boolean isAbsolute(@NotNull String path) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(6);
        }
        return !path.isEmpty() && new File(path).isAbsolute();
    }

    public static boolean exists(@Nullable String path) {
        return path != null && new File(path).exists();
    }

    public static boolean isAncestor(@NotNull File ancestor, @NotNull File file2, boolean strict) {
        if (ancestor == null) {
            FileUtil.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(8);
        }
        return FileUtil.isAncestor(ancestor.getPath(), file2.getPath(), strict);
    }

    public static boolean isAncestor(@NotNull String ancestor, @NotNull String file2, boolean strict) {
        if (ancestor == null) {
            FileUtil.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(10);
        }
        return !ThreeState.NO.equals((Object)FileUtil.isAncestorThreeState(ancestor, file2, strict));
    }

    @NotNull
    public static ThreeState isAncestorThreeState(@NotNull String ancestor, @NotNull String file2, boolean strict) {
        if (ancestor == null) {
            FileUtil.$$$reportNull$$$0(11);
        }
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(12);
        }
        String ancestorPath = FileUtil.toCanonicalPath(ancestor);
        String filePath = FileUtil.toCanonicalPath(file2);
        return FileUtil.startsWith(filePath, ancestorPath, strict, SystemInfoRt.isFileSystemCaseSensitive, true);
    }

    public static boolean startsWith(@NotNull String path, @NotNull String prefix) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(13);
        }
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(14);
        }
        return FileUtil.startsWith(path, prefix, SystemInfoRt.isFileSystemCaseSensitive);
    }

    public static boolean startsWith(@NotNull String path, @NotNull String prefix, boolean isCaseSensitive) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(15);
        }
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(16);
        }
        return FileUtil.startsWith(path, prefix, isCaseSensitive, false);
    }

    public static boolean startsWith(@NotNull String path, @NotNull String prefix, boolean isCaseSensitive, boolean strict) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(17);
        }
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(18);
        }
        return !ThreeState.NO.equals((Object)FileUtil.startsWith(path, prefix, strict, isCaseSensitive, false));
    }

    @NotNull
    private static ThreeState startsWith(@NotNull String path, @NotNull String prefix, boolean strict, boolean isCaseSensitive, boolean checkImmediateParent) {
        char next;
        if (path == null) {
            FileUtil.$$$reportNull$$$0(19);
        }
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(20);
        }
        int pathLength = path.length();
        int prefixLength = prefix.length();
        if (prefixLength == 0) {
            ThreeState threeState = pathLength == 0 ? ThreeState.YES : ThreeState.UNSURE;
            if (threeState == null) {
                FileUtil.$$$reportNull$$$0(21);
            }
            return threeState;
        }
        if (prefixLength > pathLength) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                FileUtil.$$$reportNull$$$0(22);
            }
            return threeState;
        }
        if (!path.regionMatches(!isCaseSensitive, 0, prefix, 0, prefixLength)) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                FileUtil.$$$reportNull$$$0(23);
            }
            return threeState;
        }
        if (pathLength == prefixLength) {
            ThreeState threeState = strict ? ThreeState.NO : ThreeState.YES;
            if (threeState == null) {
                FileUtil.$$$reportNull$$$0(24);
            }
            return threeState;
        }
        char lastPrefixChar = prefix.charAt(prefixLength - 1);
        int slashOrSeparatorIdx = prefixLength;
        if (lastPrefixChar == '/' || lastPrefixChar == File.separatorChar) {
            slashOrSeparatorIdx = prefixLength - 1;
        }
        if ((next = path.charAt(slashOrSeparatorIdx)) == '/' || next == File.separatorChar) {
            if (!checkImmediateParent) {
                ThreeState threeState = ThreeState.YES;
                if (threeState == null) {
                    FileUtil.$$$reportNull$$$0(25);
                }
                return threeState;
            }
            if (slashOrSeparatorIdx == pathLength - 1) {
                ThreeState threeState = ThreeState.YES;
                if (threeState == null) {
                    FileUtil.$$$reportNull$$$0(26);
                }
                return threeState;
            }
            int idxNext = path.indexOf(next, slashOrSeparatorIdx + 1);
            idxNext = idxNext == -1 ? path.indexOf(next == '/' ? 92 : 47, slashOrSeparatorIdx + 1) : idxNext;
            ThreeState threeState = idxNext == -1 ? ThreeState.YES : ThreeState.UNSURE;
            if (threeState == null) {
                FileUtil.$$$reportNull$$$0(27);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.NO;
        if (threeState == null) {
            FileUtil.$$$reportNull$$$0(28);
        }
        return threeState;
    }

    @Nullable
    public static File findAncestor(@NotNull File f1, @NotNull File f2) {
        File ancestor;
        if (f1 == null) {
            FileUtil.$$$reportNull$$$0(29);
        }
        if (f2 == null) {
            FileUtil.$$$reportNull$$$0(30);
        }
        for (ancestor = f1; ancestor != null && !FileUtil.isAncestor(ancestor, f2, false); ancestor = ancestor.getParentFile()) {
        }
        return ancestor;
    }

    @Nullable
    public static File getParentFile(@NotNull File file2) {
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(31);
        }
        return FileUtilRt.getParentFile(file2);
    }

    public static byte @NotNull [] loadFileBytes(@NotNull File file2) throws IOException {
        byte[] bytes;
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(32);
        }
        try (FileInputStream stream = new FileInputStream(file2);){
            long len = file2.length();
            if (len < 0L) {
                throw new IOException("File length reported negative, probably doesn't exist");
            }
            if (FileUtil.isTooLarge(len)) {
                throw new FileTooBigException("Attempt to load '" + file2 + "' in memory buffer, file length is " + len + " bytes.");
            }
            bytes = FileUtil.loadBytes(stream, (int)len);
        }
        if (bytes == null) {
            FileUtil.$$$reportNull$$$0(33);
        }
        return bytes;
    }

    public static byte @NotNull [] loadFirstAndClose(@NotNull InputStream stream, int maxLength) throws IOException {
        if (stream == null) {
            FileUtil.$$$reportNull$$$0(34);
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            FileUtil.copy(stream, maxLength, (OutputStream)buffer);
        }
        finally {
            stream.close();
        }
        byte[] byArray = buffer.toByteArray();
        if (byArray == null) {
            FileUtil.$$$reportNull$$$0(35);
        }
        return byArray;
    }

    @NotNull
    public static String loadTextAndClose(@NotNull InputStream stream) throws IOException {
        if (stream == null) {
            FileUtil.$$$reportNull$$$0(36);
        }
        return FileUtil.loadTextAndClose(new InputStreamReader(stream, StandardCharsets.UTF_8));
    }

    @NotNull
    public static String loadTextAndClose(@NotNull Reader reader) throws IOException {
        if (reader == null) {
            FileUtil.$$$reportNull$$$0(37);
        }
        String string2 = new String(FileUtil.adaptiveLoadText(reader));
        String string3 = string2;
        if (string3 == null) {
            FileUtil.$$$reportNull$$$0(38);
        }
        return string3;
        finally {
            reader.close();
        }
    }

    public static char @NotNull [] adaptiveLoadText(@NotNull Reader reader) throws IOException {
        int n;
        if (reader == null) {
            FileUtil.$$$reportNull$$$0(39);
        }
        char[] chars = new char[4096];
        ArrayList<char[]> buffers = null;
        int count = 0;
        int total = 0;
        while ((n = reader.read(chars, count, chars.length - count)) > 0) {
            count += n;
            if (total > 0xA00000) {
                throw new FileTooBigException("File too big " + reader);
            }
            total += n;
            if (count != chars.length) continue;
            if (buffers == null) {
                buffers = new ArrayList<char[]>();
            }
            buffers.add(chars);
            int newLength = Math.min(0x100000, chars.length * 2);
            chars = new char[newLength];
            count = 0;
        }
        char[] result2 = new char[total];
        if (buffers != null) {
            for (char[] buffer : buffers) {
                System.arraycopy(buffer, 0, result2, result2.length - total, buffer.length);
                total -= buffer.length;
            }
        }
        System.arraycopy(chars, 0, result2, result2.length - total, total);
        if (result2 == null) {
            FileUtil.$$$reportNull$$$0(40);
        }
        return result2;
    }

    public static byte @NotNull [] adaptiveLoadBytes(@NotNull InputStream stream) throws IOException {
        int n;
        if (stream == null) {
            FileUtil.$$$reportNull$$$0(41);
        }
        byte[] bytes = new byte[8192];
        ArrayList<byte[]> buffers = null;
        int count = 0;
        int total = 0;
        while ((n = stream.read(bytes, count, bytes.length - count)) > 0) {
            count += n;
            if (total > 0xA00000) {
                throw new FileTooBigException("File too big " + stream);
            }
            total += n;
            if (count != bytes.length) continue;
            if (buffers == null) {
                buffers = new ArrayList<byte[]>();
            }
            buffers.add(bytes);
            int newLength = Math.min(0x100000, bytes.length * 2);
            bytes = new byte[newLength];
            count = 0;
        }
        byte[] result2 = ArrayUtil.newByteArray(total);
        if (buffers != null) {
            for (byte[] buffer : buffers) {
                System.arraycopy(buffer, 0, result2, result2.length - total, buffer.length);
                total -= buffer.length;
            }
        }
        System.arraycopy(bytes, 0, result2, result2.length - total, total);
        if (result2 == null) {
            FileUtil.$$$reportNull$$$0(42);
        }
        return result2;
    }

    @NotNull
    public static Future<Void> asyncDelete(@NotNull File file2) {
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(43);
        }
        return FileUtil.asyncDelete(Collections.singleton(file2));
    }

    @NotNull
    public static Future<Void> asyncDelete(@NotNull Collection<? extends File> files2) {
        if (files2 == null) {
            FileUtil.$$$reportNull$$$0(44);
        }
        ArrayList<File> tempFiles = new ArrayList<File>();
        for (File file2 : files2) {
            File tempFile = FileUtil.renameToTempFileOrDelete(file2);
            if (tempFile == null) continue;
            tempFiles.add(tempFile);
        }
        Future<Object> future = tempFiles.isEmpty() ? CompletableFuture.completedFuture(null) : AppExecutorUtil.getAppExecutorService().submit(() -> {
            Thread currentThread = Thread.currentThread();
            int priority = currentThread.getPriority();
            currentThread.setPriority(1);
            try {
                for (File tempFile : tempFiles) {
                    FileUtil.delete(tempFile);
                }
            }
            finally {
                currentThread.setPriority(priority);
            }
            return null;
        });
        if (future == null) {
            FileUtil.$$$reportNull$$$0(45);
        }
        return future;
    }

    @Nullable
    private static File renameToTempFileOrDelete(@NotNull File file2) {
        String originalFileName;
        File tempFile;
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(46);
        }
        String tempDir = FileUtil.getTempDirectory();
        boolean isSameDrive = true;
        if (SystemInfoRt.isWindows) {
            String tempDirDrive = tempDir.substring(0, 2);
            String fileDrive = file2.getAbsolutePath().substring(0, 2);
            isSameDrive = tempDirDrive.equalsIgnoreCase(fileDrive);
        }
        if (isSameDrive && file2.renameTo(tempFile = FileUtil.getTempFile(originalFileName = file2.getName(), tempDir))) {
            return tempFile;
        }
        FileUtil.delete(file2);
        return null;
    }

    @NotNull
    private static File getTempFile(@NotNull String originalFileName, @NotNull String parent2) {
        int randomSuffix;
        if (originalFileName == null) {
            FileUtil.$$$reportNull$$$0(47);
        }
        if (parent2 == null) {
            FileUtil.$$$reportNull$$$0(48);
        }
        int i = randomSuffix = (int)(System.currentTimeMillis() % 1000L);
        while (true) {
            String name2;
            File tempFile;
            if (!(tempFile = new File(parent2, name2 = "___" + originalFileName + i + ASYNC_DELETE_EXTENSION)).exists()) {
                File file2 = tempFile;
                if (file2 == null) {
                    FileUtil.$$$reportNull$$$0(49);
                }
                return file2;
            }
            ++i;
        }
    }

    public static boolean delete(@NotNull File file2) {
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(50);
        }
        return FileUtilRt.delete(file2);
    }

    public static void delete(@NotNull Path path) throws IOException {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(51);
        }
        FileUtilRt.deleteRecursivelyNIO(path, null);
    }

    public static boolean createParentDirs(@NotNull File file2) {
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(52);
        }
        return FileUtilRt.createParentDirs(file2);
    }

    public static boolean createDirectory(@NotNull File path) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(53);
        }
        return FileUtilRt.createDirectory(path);
    }

    public static boolean createIfDoesntExist(@NotNull File file2) {
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(54);
        }
        return FileUtilRt.createIfNotExists(file2);
    }

    public static boolean ensureCanCreateFile(@NotNull File file2) {
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(55);
        }
        return FileUtilRt.ensureCanCreateFile(file2);
    }

    public static void copy(@NotNull File fromFile, @NotNull File toFile) throws IOException {
        if (fromFile == null) {
            FileUtil.$$$reportNull$$$0(56);
        }
        if (toFile == null) {
            FileUtil.$$$reportNull$$$0(57);
        }
        FileUtil.performCopy(fromFile, toFile, true);
    }

    public static void copyContent(@NotNull File fromFile, @NotNull File toFile) throws IOException {
        if (fromFile == null) {
            FileUtil.$$$reportNull$$$0(58);
        }
        if (toFile == null) {
            FileUtil.$$$reportNull$$$0(59);
        }
        FileUtil.performCopy(fromFile, toFile, false);
    }

    private static void performCopy(@NotNull File fromFile, @NotNull File toFile, boolean syncTimestamp) throws IOException {
        if (fromFile == null) {
            FileUtil.$$$reportNull$$$0(60);
        }
        if (toFile == null) {
            FileUtil.$$$reportNull$$$0(61);
        }
        if (FileUtil.filesEqual(fromFile, toFile)) {
            return;
        }
        try (FileOutputStream fos = FileUtil.openOutputStream(toFile);
             FileInputStream fis = new FileInputStream(fromFile);){
            FileUtil.copy(fis, fos);
        }
        catch (IOException e) {
            throw new IOException(String.format("Couldn't copy [%s] to [%s]", fromFile, toFile), e);
        }
        if (syncTimestamp) {
            long timeStamp = fromFile.lastModified();
            if (timeStamp < 0L) {
                LOG.warn("Invalid timestamp " + timeStamp + " of '" + fromFile + "'");
            } else if (!toFile.setLastModified(timeStamp)) {
                LOG.warn("Unable to set timestamp " + timeStamp + " to '" + toFile + "'");
            }
        }
        if (SystemInfoRt.isUnix && fromFile.canExecute()) {
            FileSystemUtil.clonePermissionsToExecute(fromFile.getPath(), toFile.getPath());
        }
    }

    @NotNull
    private static FileOutputStream openOutputStream(@NotNull File file2) throws IOException {
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(62);
        }
        try {
            return new FileOutputStream(file2);
        }
        catch (FileNotFoundException e) {
            File parentFile = file2.getParentFile();
            if (parentFile == null) {
                throw new IOException("Parent file is null for " + file2.getPath(), e);
            }
            FileUtil.createParentDirs(file2);
            return new FileOutputStream(file2);
        }
    }

    public static void copy(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) throws IOException {
        if (inputStream == null) {
            FileUtil.$$$reportNull$$$0(63);
        }
        if (outputStream == null) {
            FileUtil.$$$reportNull$$$0(64);
        }
        FileUtilRt.copy(inputStream, outputStream);
    }

    public static void copy(@NotNull InputStream inputStream, int maxSize, @NotNull OutputStream outputStream) throws IOException {
        if (inputStream == null) {
            FileUtil.$$$reportNull$$$0(65);
        }
        if (outputStream == null) {
            FileUtil.$$$reportNull$$$0(66);
        }
        FileUtil.copy(inputStream, (long)maxSize, outputStream);
    }

    /*
     * WARNING - void declaration
     */
    public static void copy(@NotNull InputStream inputStream, long maxSize, @NotNull OutputStream outputStream) throws IOException {
        int read2;
        if (inputStream == null) {
            FileUtil.$$$reportNull$$$0(67);
        }
        if (outputStream == null) {
            FileUtil.$$$reportNull$$$0(68);
        }
        byte[] buffer = new byte[8192];
        for (long toRead = maxSize; toRead > 0L && (read2 = inputStream.read(buffer, 0, (int)Math.min((long)buffer.length, toRead))) >= 0; toRead -= (long)read2) {
            void outputStream2;
            outputStream2.write(buffer, 0, read2);
        }
    }

    public static void copyFileOrDir(@NotNull File from2, @NotNull File to) throws IOException {
        if (from2 == null) {
            FileUtil.$$$reportNull$$$0(69);
        }
        if (to == null) {
            FileUtil.$$$reportNull$$$0(70);
        }
        FileUtil.copyFileOrDir(from2, to, from2.isDirectory());
    }

    public static void copyFileOrDir(@NotNull File from2, @NotNull File to, boolean isDir) throws IOException {
        if (from2 == null) {
            FileUtil.$$$reportNull$$$0(71);
        }
        if (to == null) {
            FileUtil.$$$reportNull$$$0(72);
        }
        if (isDir) {
            FileUtil.copyDir(from2, to);
        } else {
            FileUtil.copy(from2, to);
        }
    }

    public static void copyDir(@NotNull File fromDir, @NotNull File toDir) throws IOException {
        if (fromDir == null) {
            FileUtil.$$$reportNull$$$0(73);
        }
        if (toDir == null) {
            FileUtil.$$$reportNull$$$0(74);
        }
        FileUtil.copyDir(fromDir, toDir, true);
    }

    public static void copyDirContent(@NotNull File fromDir, @NotNull File toDir) throws IOException {
        File[] children;
        if (fromDir == null) {
            FileUtil.$$$reportNull$$$0(75);
        }
        if (toDir == null) {
            FileUtil.$$$reportNull$$$0(76);
        }
        for (File child : children = ObjectUtils.notNull(fromDir.listFiles(), ArrayUtilRt.EMPTY_FILE_ARRAY)) {
            FileUtil.copyFileOrDir(child, new File(toDir, child.getName()));
        }
    }

    public static void copyDir(@NotNull File fromDir, @NotNull File toDir, boolean copySystemFiles) throws IOException {
        if (fromDir == null) {
            FileUtil.$$$reportNull$$$0(77);
        }
        if (toDir == null) {
            FileUtil.$$$reportNull$$$0(78);
        }
        FileUtil.copyDir(fromDir, toDir, copySystemFiles ? null : file2 -> !StringUtil.startsWithChar(file2.getName(), '.'));
    }

    public static void copyDir(@NotNull File fromDir, @NotNull File toDir, @Nullable FileFilter filter) throws IOException {
        if (fromDir == null) {
            FileUtil.$$$reportNull$$$0(79);
        }
        if (toDir == null) {
            FileUtil.$$$reportNull$$$0(80);
        }
        FileUtil.ensureExists(toDir);
        if (FileUtil.isAncestor(fromDir, toDir, true)) {
            LOG.error(fromDir.getAbsolutePath() + " is ancestor of " + toDir + ". Can't copy to itself.");
            return;
        }
        File[] files2 = fromDir.listFiles();
        if (files2 == null) {
            throw new IOException(UtilBundle.message("exception.directory.is.invalid", fromDir.getPath()));
        }
        if (!fromDir.canRead()) {
            throw new IOException(UtilBundle.message("exception.directory.is.not.readable", fromDir.getPath()));
        }
        for (File file2 : files2) {
            if (filter != null && !filter.accept(file2)) continue;
            if (file2.isDirectory()) {
                FileUtil.copyDir(file2, new File(toDir, file2.getName()), filter);
                continue;
            }
            FileUtil.copy(file2, new File(toDir, file2.getName()));
        }
    }

    public static void ensureExists(@NotNull File dir2) throws IOException {
        if (dir2 == null) {
            FileUtil.$$$reportNull$$$0(81);
        }
        if (!dir2.exists() && !dir2.mkdirs()) {
            throw new IOException(UtilBundle.message("exception.directory.can.not.create", dir2.getPath()));
        }
    }

    @NotNull
    public static String getNameWithoutExtension(@NotNull File file2) {
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(82);
        }
        String string2 = FileUtilRt.getNameWithoutExtension(file2.getName());
        if (string2 == null) {
            FileUtil.$$$reportNull$$$0(83);
        }
        return string2;
    }

    @NotNull
    public static String getNameWithoutExtension(@NotNull String name2) {
        if (name2 == null) {
            FileUtil.$$$reportNull$$$0(84);
        }
        String string2 = FileUtilRt.getNameWithoutExtension(name2);
        if (string2 == null) {
            FileUtil.$$$reportNull$$$0(85);
        }
        return string2;
    }

    @NotNull
    public static String createSequentFileName(@NotNull File aParentFolder, @NotNull String aFilePrefix, @NotNull String aExtension) {
        if (aParentFolder == null) {
            FileUtil.$$$reportNull$$$0(86);
        }
        if (aFilePrefix == null) {
            FileUtil.$$$reportNull$$$0(87);
        }
        if (aExtension == null) {
            FileUtil.$$$reportNull$$$0(88);
        }
        String string2 = FileUtil.findSequentNonexistentFile(aParentFolder, aFilePrefix, aExtension).getName();
        if (string2 == null) {
            FileUtil.$$$reportNull$$$0(89);
        }
        return string2;
    }

    @NotNull
    public static String createSequentFileName(@NotNull File aParentFolder, @NotNull String aFilePrefix, @NotNull String aExtension, @NotNull Predicate<? super File> condition) {
        if (aParentFolder == null) {
            FileUtil.$$$reportNull$$$0(90);
        }
        if (aFilePrefix == null) {
            FileUtil.$$$reportNull$$$0(91);
        }
        if (aExtension == null) {
            FileUtil.$$$reportNull$$$0(92);
        }
        if (condition == null) {
            FileUtil.$$$reportNull$$$0(93);
        }
        String string2 = FileUtil.findSequentFile(aParentFolder, aFilePrefix, aExtension, condition).getName();
        if (string2 == null) {
            FileUtil.$$$reportNull$$$0(94);
        }
        return string2;
    }

    @NotNull
    public static File findSequentNonexistentFile(@NotNull File parentFolder, @NotNull @NonNls String filePrefix, @NotNull String extension) {
        if (parentFolder == null) {
            FileUtil.$$$reportNull$$$0(95);
        }
        if (filePrefix == null) {
            FileUtil.$$$reportNull$$$0(96);
        }
        if (extension == null) {
            FileUtil.$$$reportNull$$$0(97);
        }
        return FileUtil.findSequentFile(parentFolder, filePrefix, extension, file2 -> !file2.exists());
    }

    @NotNull
    public static File findSequentFile(@NotNull File parentFolder, @NotNull String filePrefix, @NotNull String extension, @NotNull Predicate<? super File> condition) {
        if (parentFolder == null) {
            FileUtil.$$$reportNull$$$0(98);
        }
        if (filePrefix == null) {
            FileUtil.$$$reportNull$$$0(99);
        }
        if (extension == null) {
            FileUtil.$$$reportNull$$$0(100);
        }
        if (condition == null) {
            FileUtil.$$$reportNull$$$0(101);
        }
        int postfix = 0;
        String ext = extension.isEmpty() ? "" : '.' + extension;
        File candidate2 = new File(parentFolder, filePrefix + ext);
        while (!condition.test(candidate2)) {
            candidate2 = new File(parentFolder, filePrefix + ++postfix + ext);
        }
        File file2 = candidate2;
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(102);
        }
        return file2;
    }

    @NotNull
    public static String toSystemDependentName(@NotNull String filePath) {
        if (filePath == null) {
            FileUtil.$$$reportNull$$$0(103);
        }
        String string2 = FileUtilRt.toSystemDependentName(filePath);
        if (string2 == null) {
            FileUtil.$$$reportNull$$$0(104);
        }
        return string2;
    }

    @NotNull
    @NonNls
    public static String toSystemIndependentName(@NotNull String filePath) {
        if (filePath == null) {
            FileUtil.$$$reportNull$$$0(105);
        }
        String string2 = FileUtilRt.toSystemIndependentName(filePath);
        if (string2 == null) {
            FileUtil.$$$reportNull$$$0(106);
        }
        return string2;
    }

    @Contract(value="null -> null; !null->!null")
    public static String toCanonicalPath(@Nullable String path) {
        return FileUtil.toCanonicalPath(path, File.separatorChar, true);
    }

    @Contract(value="null, _ -> null; !null,_->!null")
    public static String toCanonicalPath(@Nullable String path, boolean resolveSymlinksIfNecessary) {
        return FileUtil.toCanonicalPath(path, File.separatorChar, true, resolveSymlinksIfNecessary);
    }

    @Contract(value="null, _ -> null; !null,_->!null")
    public static String toCanonicalPath(@Nullable String path, char separatorChar) {
        return FileUtil.toCanonicalPath(path, separatorChar, true);
    }

    @Contract(value="null -> null; !null->!null")
    public static String toCanonicalUriPath(@Nullable String path) {
        return FileUtil.toCanonicalPath(path, '/', false);
    }

    @Contract(value="null, _, _, _ -> null; !null,_,_,_->!null")
    private static String toCanonicalPath(@Nullable String path, char separatorChar, boolean removeLastSlash, boolean resolveSymlinks) {
        FileUtilRt.SymlinkResolver symlinkResolver = resolveSymlinks ? SYMLINK_RESOLVER : null;
        return FileUtil.toCanonicalPath(path, separatorChar, removeLastSlash, symlinkResolver);
    }

    @NotNull
    public static String normalize(@NotNull String path) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(107);
        }
        int start = 0;
        boolean separator = false;
        if (SystemInfoRt.isWindows) {
            if (path.startsWith("//")) {
                start = 2;
                separator = true;
            } else if (path.startsWith("\\\\")) {
                return FileUtil.normalizeTail(0, path, false);
            }
        }
        for (int i = start; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '/') {
                if (separator) {
                    return FileUtil.normalizeTail(i, path, true);
                }
                separator = true;
                continue;
            }
            if (c == '\\') {
                return FileUtil.normalizeTail(i, path, separator);
            }
            separator = false;
        }
        String string2 = path;
        if (string2 == null) {
            FileUtil.$$$reportNull$$$0(108);
        }
        return string2;
    }

    @NotNull
    private static String normalizeTail(int prefixEnd, @NotNull String path, boolean separator) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(109);
        }
        StringBuilder result2 = new StringBuilder(path.length());
        result2.append(path, 0, prefixEnd);
        int start = prefixEnd;
        if (start == 0 && SystemInfoRt.isWindows && (path.startsWith("//") || path.startsWith("\\\\"))) {
            start = 2;
            result2.append("//");
            separator = true;
        }
        for (int i = start; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '/' || c == '\\') {
                if (!separator) {
                    result2.append('/');
                }
                separator = true;
                continue;
            }
            result2.append(c);
            separator = false;
        }
        String string2 = result2.toString();
        if (string2 == null) {
            FileUtil.$$$reportNull$$$0(110);
        }
        return string2;
    }

    @NotNull
    public static String unquote(@NotNull String urlString) {
        if (urlString == null) {
            FileUtil.$$$reportNull$$$0(111);
        }
        urlString = urlString.replace('/', File.separatorChar);
        String string2 = URLUtil.unescapePercentSequences(urlString);
        if (string2 == null) {
            FileUtil.$$$reportNull$$$0(112);
        }
        return string2;
    }

    public static boolean rename(@NotNull File source, @NotNull String newName) throws IOException {
        if (source == null) {
            FileUtil.$$$reportNull$$$0(113);
        }
        if (newName == null) {
            FileUtil.$$$reportNull$$$0(114);
        }
        File target = new File(source.getParent(), newName);
        if (!SystemInfoRt.isFileSystemCaseSensitive && newName.equalsIgnoreCase(source.getName())) {
            File intermediate = FileUtil.createTempFile(source.getParentFile(), source.getName(), ".tmp", false, false);
            return source.renameTo(intermediate) && intermediate.renameTo(target);
        }
        return source.renameTo(target);
    }

    public static void rename(@NotNull File source, @NotNull File target) throws IOException {
        if (source == null) {
            FileUtil.$$$reportNull$$$0(115);
        }
        if (target == null) {
            FileUtil.$$$reportNull$$$0(116);
        }
        if (source.renameTo(target)) {
            return;
        }
        if (!source.exists()) {
            return;
        }
        FileUtil.copy(source, target);
        FileUtil.delete(source);
    }

    public static boolean filesEqual(@Nullable File file1, @Nullable File file2) {
        return FileUtil.pathsEqual(file1 == null ? null : file1.getPath(), file2 == null ? null : file2.getPath());
    }

    public static boolean pathsEqual(@Nullable String path1, @Nullable String path2) {
        if (path1 == path2) {
            return true;
        }
        if (path1 == null || path2 == null) {
            return false;
        }
        path1 = FileUtil.toCanonicalPath(path1);
        path2 = FileUtil.toCanonicalPath(path2);
        return SystemInfoRt.isFileSystemCaseSensitive ? path1.equals(path2) : path1.equalsIgnoreCase(path2);
    }

    public static boolean namesEqual(@Nullable String name1, @Nullable String name2) {
        if (name1 == name2) {
            return true;
        }
        if (name1 == null || name2 == null) {
            return false;
        }
        return SystemInfoRt.isFileSystemCaseSensitive ? name1.equals(name2) : name1.equalsIgnoreCase(name2);
    }

    public static int compareFiles(@Nullable File file1, @Nullable File file2) {
        return FileUtil.comparePaths(file1 == null ? null : file1.getPath(), file2 == null ? null : file2.getPath());
    }

    public static int comparePaths(@Nullable String path1, @Nullable String path2) {
        return OSAgnosticPathUtil.COMPARATOR.compare(path1, path2);
    }

    public static int fileHashCode(@Nullable File file2) {
        return FileUtilRt.pathHashCode(file2 == null ? null : file2.getPath());
    }

    public static int pathHashCode(@Nullable String path) {
        return FileUtilRt.pathHashCode(path);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static String getExtension(@NotNull String fileName) {
        if (fileName == null) {
            FileUtil.$$$reportNull$$$0(117);
        }
        String string2 = Strings.toLowerCase(FileUtilRt.getExtension(fileName));
        if (string2 == null) {
            FileUtil.$$$reportNull$$$0(118);
        }
        return string2;
    }

    @NotNull
    public static String resolveShortWindowsName(@NotNull String path) throws IOException {
        String string2;
        if (path == null) {
            FileUtil.$$$reportNull$$$0(119);
        }
        try {
            string2 = SystemInfoRt.isWindows && FileUtil.containsWindowsShortName(path) ? Paths.get(path, new String[0]).toRealPath(LinkOption.NOFOLLOW_LINKS).toString() : path;
        }
        catch (InvalidPathException e) {
            throw new IOException(e);
        }
        if (string2 == null) {
            FileUtil.$$$reportNull$$$0(120);
        }
        return string2;
    }

    public static boolean containsWindowsShortName(@NotNull String path) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(121);
        }
        if (path.indexOf(126) < 0) {
            return false;
        }
        path = FileUtil.toSystemIndependentName(path);
        int start = 0;
        while (start < path.length()) {
            int dot;
            int end = path.indexOf(47, start);
            if (end < 0) {
                end = path.length();
            }
            if ((dot = path.lastIndexOf(46, end)) < start) {
                dot = end;
            }
            if (dot - start > 2 && dot - start <= 8 && end - dot - 1 <= 3 && path.charAt(dot - 2) == '~' && Character.isDigit(path.charAt(dot - 1))) {
                return true;
            }
            start = end + 1;
        }
        return false;
    }

    @Nullable
    public static String extractRootPath(@NotNull String normalizedPath) {
        int sc;
        if (normalizedPath == null) {
            FileUtil.$$$reportNull$$$0(122);
        }
        if (SystemInfoRt.isWindows) {
            int p1;
            if (normalizedPath.length() >= 2 && normalizedPath.charAt(1) == ':') {
                return StringUtil.toUpperCase(normalizedPath.substring(0, 2));
            }
            if (normalizedPath.startsWith("//") && (p1 = normalizedPath.indexOf(47, 2)) > 2) {
                int p2 = normalizedPath.indexOf(47, p1 + 1);
                if (p2 > p1 + 1) {
                    return normalizedPath.substring(0, p2);
                }
                if (p2 < 0) {
                    return normalizedPath;
                }
            }
        } else if (StringUtil.startsWithChar(normalizedPath, '/')) {
            return "/";
        }
        if ((sc = normalizedPath.indexOf("://")) != -1) {
            return normalizedPath.substring(0, sc + "://".length());
        }
        return null;
    }

    public static void collectMatchedFiles(@NotNull File root, @NotNull Pattern pattern, @NotNull List<? super File> outFiles) {
        if (root == null) {
            FileUtil.$$$reportNull$$$0(123);
        }
        if (pattern == null) {
            FileUtil.$$$reportNull$$$0(124);
        }
        if (outFiles == null) {
            FileUtil.$$$reportNull$$$0(125);
        }
        FileUtil.collectMatchedFiles(root, root, pattern, outFiles);
    }

    private static void collectMatchedFiles(@NotNull File absoluteRoot, @NotNull File root, @NotNull Pattern pattern, @NotNull List<? super File> files2) {
        File[] dirs;
        if (absoluteRoot == null) {
            FileUtil.$$$reportNull$$$0(126);
        }
        if (root == null) {
            FileUtil.$$$reportNull$$$0(127);
        }
        if (pattern == null) {
            FileUtil.$$$reportNull$$$0(128);
        }
        if (files2 == null) {
            FileUtil.$$$reportNull$$$0(129);
        }
        if ((dirs = root.listFiles()) == null) {
            return;
        }
        for (File dir2 : dirs) {
            if (dir2.isFile()) {
                String path;
                String relativePath = FileUtil.getRelativePath(absoluteRoot, dir2);
                if (relativePath == null || !pattern.matcher(path = FileUtil.toSystemIndependentName(relativePath)).matches()) continue;
                files2.add(dir2);
                continue;
            }
            FileUtil.collectMatchedFiles(absoluteRoot, dir2, pattern, files2);
        }
    }

    @RegExp
    @NotNull
    public static String convertAntToRegexp(@NotNull String antPattern) {
        if (antPattern == null) {
            FileUtil.$$$reportNull$$$0(130);
        }
        return FileUtil.convertAntToRegexp(antPattern, true);
    }

    @RegExp
    @NotNull
    public static String convertAntToRegexp(@NotNull String antPattern, boolean ignoreStartingSlash) {
        boolean isTrailingSlash;
        int start;
        if (antPattern == null) {
            FileUtil.$$$reportNull$$$0(131);
        }
        StringBuilder builder = new StringBuilder();
        int asteriskCount = 0;
        boolean recursive = true;
        for (int idx = start = ignoreStartingSlash && (StringUtil.startsWithChar(antPattern, '/') || StringUtil.startsWithChar(antPattern, '\\')) ? 1 : 0; idx < antPattern.length(); ++idx) {
            char ch = antPattern.charAt(idx);
            if (ch == '*') {
                ++asteriskCount;
                continue;
            }
            boolean foundRecursivePattern = recursive && asteriskCount == 2 && (ch == '/' || ch == '\\');
            boolean asterisksFound = asteriskCount > 0;
            asteriskCount = 0;
            boolean bl = recursive = ch == '/' || ch == '\\';
            if (foundRecursivePattern) {
                builder.append("(?:[^/]+/)*?");
                continue;
            }
            if (asterisksFound) {
                builder.append("[^/]*?");
            }
            if (ch == '(' || ch == ')' || ch == '[' || ch == ']' || ch == '^' || ch == '$' || ch == '.' || ch == '{' || ch == '}' || ch == '+' || ch == '|') {
                builder.append('\\').append(ch);
                continue;
            }
            if (ch == '?') {
                builder.append("[^/]{1}");
                continue;
            }
            if (ch == '\\') {
                builder.append('/');
                continue;
            }
            builder.append(ch);
        }
        boolean bl = isTrailingSlash = builder.length() > 0 && builder.charAt(builder.length() - 1) == '/';
        if (asteriskCount == 0 && isTrailingSlash || recursive && asteriskCount == 2) {
            if (isTrailingSlash) {
                builder.setLength(builder.length() - 1);
            }
            if (builder.length() == 0) {
                builder.append(".*");
            } else {
                builder.append("(?:$|/.+)");
            }
        } else if (asteriskCount > 0) {
            builder.append("[^/]*?");
        }
        String string2 = builder.toString();
        if (string2 == null) {
            FileUtil.$$$reportNull$$$0(132);
        }
        return string2;
    }

    public static boolean moveDirWithContent(@NotNull File fromDir, @NotNull File toDir) {
        if (fromDir == null) {
            FileUtil.$$$reportNull$$$0(133);
        }
        if (toDir == null) {
            FileUtil.$$$reportNull$$$0(134);
        }
        if (!toDir.exists()) {
            return fromDir.renameTo(toDir);
        }
        File[] files2 = fromDir.listFiles();
        if (files2 == null) {
            return false;
        }
        boolean success = true;
        for (File fromFile : files2) {
            File toFile = new File(toDir, fromFile.getName());
            success = success && fromFile.renameTo(toFile);
        }
        fromDir.delete();
        return success;
    }

    @NotNull
    public static String sanitizeFileName(@NotNull String name2) {
        if (name2 == null) {
            FileUtil.$$$reportNull$$$0(135);
        }
        return FileUtil.sanitizeFileName(name2, true);
    }

    @NotNull
    public static String sanitizeFileName(@NotNull String name2, boolean strict) {
        if (name2 == null) {
            FileUtil.$$$reportNull$$$0(136);
        }
        return FileUtil.sanitizeFileName(name2, strict, "_");
    }

    @NotNull
    public static String sanitizeFileName(@NotNull String name2, boolean strict, @NotNull String replacement) {
        if (name2 == null) {
            FileUtil.$$$reportNull$$$0(137);
        }
        if (replacement == null) {
            FileUtil.$$$reportNull$$$0(138);
        }
        StringBuilder result2 = null;
        int last = 0;
        int length = name2.length();
        for (int i = 0; i < length; ++i) {
            char c = name2.charAt(i);
            boolean appendReplacement = true;
            if (c > '\u0000' && c < '\u00ff') {
                if (strict ? Character.isLetterOrDigit(c) || c == '_' : Character.isJavaIdentifierPart(c) || c == ' ' || c == '@' || c == '-') {
                    continue;
                }
            } else {
                appendReplacement = false;
            }
            if (result2 == null) {
                result2 = new StringBuilder();
            }
            if (last < i) {
                result2.append(name2, last, i);
            }
            if (appendReplacement) {
                result2.append(replacement);
            }
            last = i + 1;
        }
        if (result2 == null) {
            String string2 = name2;
            if (string2 == null) {
                FileUtil.$$$reportNull$$$0(139);
            }
            return string2;
        }
        if (last < length) {
            result2.append(name2, last, length);
        }
        String string3 = result2.toString();
        if (string3 == null) {
            FileUtil.$$$reportNull$$$0(140);
        }
        return string3;
    }

    public static boolean canExecute(@NotNull File file2) {
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(141);
        }
        return file2.canExecute();
    }

    public static boolean canWrite(@NotNull String path) {
        FileAttributes attributes;
        if (path == null) {
            FileUtil.$$$reportNull$$$0(142);
        }
        return (attributes = FileSystemUtil.getAttributes(path)) != null && attributes.isWritable();
    }

    public static void setReadOnlyAttribute(@NotNull String path, boolean readOnlyFlag) {
        boolean writableFlag;
        if (path == null) {
            FileUtil.$$$reportNull$$$0(143);
        }
        boolean bl = writableFlag = !readOnlyFlag;
        if (!new File(path).setWritable(writableFlag, false) && FileUtil.canWrite(path) != writableFlag) {
            LOG.warn("Can't set writable attribute of '" + path + "' to '" + readOnlyFlag + "'");
        }
    }

    public static void appendToFile(@NotNull File file2, @NotNull String text) throws IOException {
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(144);
        }
        if (text == null) {
            FileUtil.$$$reportNull$$$0(145);
        }
        FileUtil.writeToFile(file2, text.getBytes(StandardCharsets.UTF_8), true);
    }

    public static void writeToFile(@NotNull File file2, byte @NotNull [] text) throws IOException {
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(146);
        }
        if (text == null) {
            FileUtil.$$$reportNull$$$0(147);
        }
        FileUtil.writeToFile(file2, text, false);
    }

    public static void writeToFile(@NotNull File file2, @NotNull String text) throws IOException {
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(148);
        }
        if (text == null) {
            FileUtil.$$$reportNull$$$0(149);
        }
        FileUtil.writeToFile(file2, text, false);
    }

    public static void writeToFile(@NotNull File file2, @NotNull String text, @NotNull Charset charset) throws IOException {
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(150);
        }
        if (text == null) {
            FileUtil.$$$reportNull$$$0(151);
        }
        if (charset == null) {
            FileUtil.$$$reportNull$$$0(152);
        }
        FileUtil.writeToFile(file2, text.getBytes(charset));
    }

    public static void writeToFile(@NotNull File file2, @NotNull String text, boolean append) throws IOException {
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(153);
        }
        if (text == null) {
            FileUtil.$$$reportNull$$$0(154);
        }
        FileUtil.writeToFile(file2, text.getBytes(StandardCharsets.UTF_8), append);
    }

    public static void writeToFile(@NotNull File file2, byte @NotNull [] text, int off, int len) throws IOException {
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(155);
        }
        if (text == null) {
            FileUtil.$$$reportNull$$$0(156);
        }
        FileUtil.writeToFile(file2, text, off, len, false);
    }

    public static void writeToFile(@NotNull File file2, byte @NotNull [] text, boolean append) throws IOException {
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(157);
        }
        if (text == null) {
            FileUtil.$$$reportNull$$$0(158);
        }
        FileUtil.writeToFile(file2, text, 0, text.length, append);
    }

    private static void writeToFile(@NotNull File file2, byte @NotNull [] text, int off, int len, boolean append) throws IOException {
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(159);
        }
        if (text == null) {
            FileUtil.$$$reportNull$$$0(160);
        }
        FileUtil.createParentDirs(file2);
        try (FileOutputStream stream = new FileOutputStream(file2, append);){
            ((OutputStream)stream).write(text, off, len);
        }
    }

    @NotNull
    public static JBTreeTraverser<File> fileTraverser(@Nullable File root) {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)Lazy.FILE_TRAVERSER.withRoot(root);
        if (jBTreeTraverser == null) {
            FileUtil.$$$reportNull$$$0(161);
        }
        return jBTreeTraverser;
    }

    public static boolean processFilesRecursively(@NotNull File root, @NotNull Processor<? super File> processor) {
        if (root == null) {
            FileUtil.$$$reportNull$$$0(162);
        }
        if (processor == null) {
            FileUtil.$$$reportNull$$$0(163);
        }
        return FileUtil.fileTraverser(root).bfsTraversal().processEach(processor);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static boolean processFilesRecursively(@NotNull File root, @NotNull Processor<? super File> processor, @Nullable Processor<? super File> directoryFilter) {
        if (root == null) {
            FileUtil.$$$reportNull$$$0(164);
        }
        if (processor == null) {
            FileUtil.$$$reportNull$$$0(165);
        }
        LinkedList<File> queue = new LinkedList<File>();
        queue.add(root);
        while (!queue.isEmpty()) {
            File[] children;
            File file2 = (File)queue.removeFirst();
            if (!processor.process(file2)) {
                return false;
            }
            if (directoryFilter != null && (!file2.isDirectory() || !directoryFilter.process(file2)) || (children = file2.listFiles()) == null) continue;
            ContainerUtil.addAll(queue, children);
        }
        return true;
    }

    @Nullable
    public static File findFirstThatExist(String ... paths) {
        if (paths == null) {
            FileUtil.$$$reportNull$$$0(166);
        }
        for (String path : paths) {
            File file2;
            if (Strings.isEmptyOrSpaces(path) || !(file2 = new File(FileUtil.toSystemDependentName(path))).exists()) continue;
            return file2;
        }
        return null;
    }

    @NotNull
    public static List<File> findFilesByMask(@NotNull Pattern pattern, @NotNull File dir2) {
        if (pattern == null) {
            FileUtil.$$$reportNull$$$0(167);
        }
        if (dir2 == null) {
            FileUtil.$$$reportNull$$$0(168);
        }
        ArrayList<File> found = new ArrayList<File>();
        File[] files2 = dir2.listFiles();
        if (files2 != null) {
            for (File file2 : files2) {
                if (file2.isDirectory()) {
                    found.addAll(FileUtil.findFilesByMask(pattern, file2));
                    continue;
                }
                if (!pattern.matcher(file2.getName()).matches()) continue;
                found.add(file2);
            }
        }
        ArrayList<File> arrayList = found;
        if (arrayList == null) {
            FileUtil.$$$reportNull$$$0(169);
        }
        return arrayList;
    }

    @NotNull
    public static List<File> findFilesOrDirsByMask(@NotNull Pattern pattern, @NotNull File dir2) {
        if (pattern == null) {
            FileUtil.$$$reportNull$$$0(170);
        }
        if (dir2 == null) {
            FileUtil.$$$reportNull$$$0(171);
        }
        ArrayList<File> found = new ArrayList<File>();
        File[] files2 = dir2.listFiles();
        if (files2 != null) {
            for (File file2 : files2) {
                if (pattern.matcher(file2.getName()).matches()) {
                    found.add(file2);
                }
                if (!file2.isDirectory()) continue;
                found.addAll(FileUtil.findFilesOrDirsByMask(pattern, file2));
            }
        }
        ArrayList<File> arrayList = found;
        if (arrayList == null) {
            FileUtil.$$$reportNull$$$0(172);
        }
        return arrayList;
    }

    @Nullable
    public static String findFileInProvidedPath(String providedPath, String ... fileNames) {
        File file2;
        if (Strings.isEmpty(providedPath)) {
            return "";
        }
        File providedFile = new File(providedPath);
        if (providedFile.exists() && ArrayUtil.indexOf(fileNames, providedFile.getName()) >= 0) {
            return FileUtil.toSystemDependentName(providedFile.getPath());
        }
        if (providedFile.isDirectory()) {
            for (String fileName : fileNames) {
                file2 = new File(providedFile, fileName);
                if (!fileName.equals(file2.getName()) || !file2.exists()) continue;
                return FileUtil.toSystemDependentName(file2.getPath());
            }
        }
        if ((providedFile = providedFile.getParentFile()) != null && providedFile.exists()) {
            for (String fileName : fileNames) {
                file2 = new File(providedFile, fileName);
                if (!fileName.equals(file2.getName()) || !file2.exists()) continue;
                return FileUtil.toSystemDependentName(file2.getPath());
            }
        }
        return null;
    }

    @Deprecated
    public static boolean isAbsolutePlatformIndependent(@NotNull String path) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(173);
        }
        return FileUtil.isUnixAbsolutePath(path) || FileUtil.isWindowsAbsolutePath(path);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static boolean isUnixAbsolutePath(@NotNull String path) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(174);
        }
        return path.startsWith("/");
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static boolean isWindowsAbsolutePath(@NotNull String path) {
        boolean ok;
        if (path == null) {
            FileUtil.$$$reportNull$$$0(175);
        }
        boolean bl = ok = path.length() >= 2 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':';
        if (ok && path.length() > 2) {
            char separatorChar = path.charAt(2);
            ok = separatorChar == '/' || separatorChar == '\\';
        }
        return ok;
    }

    @Contract(value="null -> null; !null -> !null")
    public static String getLocationRelativeToUserHome(@Nullable String path) {
        return FileUtil.getLocationRelativeToUserHome(path, true);
    }

    @Contract(value="null,_ -> null; !null,_ -> !null")
    public static String getLocationRelativeToUserHome(@Nullable String path, boolean unixOnly) {
        if (path == null) {
            return null;
        }
        if (SystemInfoRt.isUnix || !unixOnly) {
            File projectDir = new File(path);
            File userHomeDir = new File(SystemProperties.getUserHome());
            if (FileUtil.isAncestor(userHomeDir, projectDir, true)) {
                return '~' + File.separator + FileUtil.getRelativePath(userHomeDir, projectDir);
            }
        }
        return path;
    }

    @Contract(pure=true)
    @NotNull
    public static String expandUserHome(@NotNull String path) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(176);
        }
        if (path.startsWith("~/") || path.startsWith("~\\")) {
            path = SystemProperties.getUserHome() + path.substring(1);
        }
        String string2 = path;
        if (string2 == null) {
            FileUtil.$$$reportNull$$$0(177);
        }
        return string2;
    }

    public static File @NotNull [] notNullize(File @Nullable [] files2) {
        return FileUtil.notNullize(files2, ArrayUtilRt.EMPTY_FILE_ARRAY);
    }

    public static File @NotNull [] notNullize(File @Nullable [] files2, File @NotNull [] defaultFiles) {
        if (defaultFiles == null) {
            FileUtil.$$$reportNull$$$0(178);
        }
        File[] fileArray = files2 == null ? defaultFiles : files2;
        if (fileArray == null) {
            FileUtil.$$$reportNull$$$0(179);
        }
        return fileArray;
    }

    public static boolean isHashBangLine(@Nullable CharSequence firstCharsIfText, @NotNull String marker) {
        if (marker == null) {
            FileUtil.$$$reportNull$$$0(180);
        }
        if (firstCharsIfText == null) {
            return false;
        }
        if (!StringUtil.startsWith(firstCharsIfText, "#!")) {
            return false;
        }
        int lineBreak = Strings.indexOf(firstCharsIfText, '\n', 2);
        return lineBreak >= 0 && Strings.indexOf(firstCharsIfText, marker, 2, lineBreak) != -1;
    }

    @NotNull
    public static File createTempDirectory(@NotNull @NonNls String prefix, @Nullable @NonNls String suffix) throws IOException {
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(181);
        }
        File file2 = FileUtilRt.createTempDirectory(prefix, suffix);
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(182);
        }
        return file2;
    }

    @NotNull
    public static File createTempDirectory(@NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean deleteOnExit) throws IOException {
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(183);
        }
        File file2 = FileUtilRt.createTempDirectory(prefix, suffix, deleteOnExit);
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(184);
        }
        return file2;
    }

    @NotNull
    public static File createTempDirectory(@NotNull File dir2, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix) throws IOException {
        if (dir2 == null) {
            FileUtil.$$$reportNull$$$0(185);
        }
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(186);
        }
        File file2 = FileUtilRt.createTempDirectory(dir2, prefix, suffix);
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(187);
        }
        return file2;
    }

    @NotNull
    public static File createTempDirectory(@NotNull File dir2, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean deleteOnExit) throws IOException {
        if (dir2 == null) {
            FileUtil.$$$reportNull$$$0(188);
        }
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(189);
        }
        File file2 = FileUtilRt.createTempDirectory(dir2, prefix, suffix, deleteOnExit);
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(190);
        }
        return file2;
    }

    @NotNull
    public static File createTempFile(@NotNull @NonNls String prefix, @Nullable @NonNls String suffix) throws IOException {
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(191);
        }
        File file2 = FileUtilRt.createTempFile(prefix, suffix);
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(192);
        }
        return file2;
    }

    @NotNull
    public static File createTempFile(@NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean deleteOnExit) throws IOException {
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(193);
        }
        File file2 = FileUtilRt.createTempFile(prefix, suffix, deleteOnExit);
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(194);
        }
        return file2;
    }

    @NotNull
    public static File createTempFile(@NotNull File dir2, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix) throws IOException {
        if (dir2 == null) {
            FileUtil.$$$reportNull$$$0(195);
        }
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(196);
        }
        File file2 = FileUtilRt.createTempFile(dir2, prefix, suffix);
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(197);
        }
        return file2;
    }

    @NotNull
    public static File createTempFile(@NotNull File dir2, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean create2) throws IOException {
        if (dir2 == null) {
            FileUtil.$$$reportNull$$$0(198);
        }
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(199);
        }
        File file2 = FileUtilRt.createTempFile(dir2, prefix, suffix, create2);
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(200);
        }
        return file2;
    }

    @NotNull
    public static File createTempFile(@NotNull File dir2, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean create2, boolean deleteOnExit) throws IOException {
        if (dir2 == null) {
            FileUtil.$$$reportNull$$$0(201);
        }
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(202);
        }
        File file2 = FileUtilRt.createTempFile(dir2, prefix, suffix, create2, deleteOnExit);
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(203);
        }
        return file2;
    }

    @NotNull
    public static String getTempDirectory() {
        String string2 = FileUtilRt.getTempDirectory();
        if (string2 == null) {
            FileUtil.$$$reportNull$$$0(204);
        }
        return string2;
    }

    @TestOnly
    public static void resetCanonicalTempPathCache(@NotNull String tempPath) {
        if (tempPath == null) {
            FileUtil.$$$reportNull$$$0(205);
        }
        FileUtilRt.resetCanonicalTempPathCache(tempPath);
    }

    @NotNull
    public static File generateRandomTemporaryPath() throws IOException {
        File file2 = FileUtilRt.generateRandomTemporaryPath();
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(206);
        }
        return file2;
    }

    public static void setExecutable(@NotNull File file2) throws IOException {
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(207);
        }
        NioFiles.setExecutable(file2.toPath());
    }

    @Nullable
    public static String loadFileOrNull(@NotNull String path) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(208);
        }
        return FileUtil.loadFileOrNull(new File(path));
    }

    @Nullable
    public static String loadFileOrNull(@NotNull File file2) {
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(209);
        }
        try {
            return FileUtil.loadFile(file2);
        }
        catch (IOException e) {
            return null;
        }
    }

    @NotNull
    public static String loadFile(@NotNull File file2) throws IOException {
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(210);
        }
        String string2 = FileUtilRt.loadFile(file2);
        if (string2 == null) {
            FileUtil.$$$reportNull$$$0(211);
        }
        return string2;
    }

    @NotNull
    public static String loadFile(@NotNull File file2, boolean convertLineSeparators) throws IOException {
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(212);
        }
        String string2 = FileUtilRt.loadFile(file2, convertLineSeparators);
        if (string2 == null) {
            FileUtil.$$$reportNull$$$0(213);
        }
        return string2;
    }

    @NotNull
    public static String loadFile(@NotNull File file2, @Nullable String encoding) throws IOException {
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(214);
        }
        String string2 = FileUtilRt.loadFile(file2, encoding);
        if (string2 == null) {
            FileUtil.$$$reportNull$$$0(215);
        }
        return string2;
    }

    @NotNull
    public static String loadFile(@NotNull File file2, @NotNull Charset encoding) throws IOException {
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(216);
        }
        if (encoding == null) {
            FileUtil.$$$reportNull$$$0(217);
        }
        String string2 = String.valueOf(FileUtilRt.loadFileText(file2, encoding));
        if (string2 == null) {
            FileUtil.$$$reportNull$$$0(218);
        }
        return string2;
    }

    @NotNull
    public static String loadFile(@NotNull File file2, @Nullable String encoding, boolean convertLineSeparators) throws IOException {
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(219);
        }
        String string2 = FileUtilRt.loadFile(file2, encoding, convertLineSeparators);
        if (string2 == null) {
            FileUtil.$$$reportNull$$$0(220);
        }
        return string2;
    }

    public static char @NotNull [] loadFileText(@NotNull File file2) throws IOException {
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(221);
        }
        char[] cArray = FileUtilRt.loadFileText(file2);
        if (cArray == null) {
            FileUtil.$$$reportNull$$$0(222);
        }
        return cArray;
    }

    public static char @NotNull [] loadFileText(@NotNull File file2, @Nullable String encoding) throws IOException {
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(223);
        }
        char[] cArray = FileUtilRt.loadFileText(file2, encoding);
        if (cArray == null) {
            FileUtil.$$$reportNull$$$0(224);
        }
        return cArray;
    }

    public static char @NotNull [] loadText(@NotNull Reader reader, int length) throws IOException {
        if (reader == null) {
            FileUtil.$$$reportNull$$$0(225);
        }
        char[] cArray = FileUtilRt.loadText(reader, length);
        if (cArray == null) {
            FileUtil.$$$reportNull$$$0(226);
        }
        return cArray;
    }

    @NotNull
    public static List<String> loadLines(@NotNull File file2) throws IOException {
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(227);
        }
        List<String> list = FileUtilRt.loadLines(file2);
        if (list == null) {
            FileUtil.$$$reportNull$$$0(228);
        }
        return list;
    }

    @NotNull
    public static List<String> loadLines(@NotNull File file2, @Nullable String encoding) throws IOException {
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(229);
        }
        List<String> list = FileUtilRt.loadLines(file2, encoding);
        if (list == null) {
            FileUtil.$$$reportNull$$$0(230);
        }
        return list;
    }

    @NotNull
    public static List<String> loadLines(@NotNull String path) throws IOException {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(231);
        }
        List<String> list = FileUtilRt.loadLines(path);
        if (list == null) {
            FileUtil.$$$reportNull$$$0(232);
        }
        return list;
    }

    @NotNull
    public static List<String> loadLines(@NotNull String path, @Nullable String encoding) throws IOException {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(233);
        }
        List<String> list = FileUtilRt.loadLines(path, encoding);
        if (list == null) {
            FileUtil.$$$reportNull$$$0(234);
        }
        return list;
    }

    @NotNull
    public static List<String> loadLines(@NotNull BufferedReader reader) throws IOException {
        if (reader == null) {
            FileUtil.$$$reportNull$$$0(235);
        }
        List<String> list = FileUtilRt.loadLines(reader);
        if (list == null) {
            FileUtil.$$$reportNull$$$0(236);
        }
        return list;
    }

    public static byte @NotNull [] loadBytes(@NotNull InputStream stream) throws IOException {
        if (stream == null) {
            FileUtil.$$$reportNull$$$0(237);
        }
        byte[] byArray = FileUtilRt.loadBytes(stream);
        if (byArray == null) {
            FileUtil.$$$reportNull$$$0(238);
        }
        return byArray;
    }

    public static byte @NotNull [] loadBytes(@NotNull InputStream stream, int length) throws IOException {
        if (stream == null) {
            FileUtil.$$$reportNull$$$0(239);
        }
        byte[] byArray = FileUtilRt.loadBytes(stream, length);
        if (byArray == null) {
            FileUtil.$$$reportNull$$$0(240);
        }
        return byArray;
    }

    @NotNull
    public static List<String> splitPath(@NotNull String path) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(241);
        }
        List<String> list = FileUtil.splitPath(path, File.separatorChar);
        if (list == null) {
            FileUtil.$$$reportNull$$$0(242);
        }
        return list;
    }

    public static boolean visitFiles(@NotNull File root, @NotNull Processor<? super File> processor) {
        if (root == null) {
            FileUtil.$$$reportNull$$$0(243);
        }
        if (processor == null) {
            FileUtil.$$$reportNull$$$0(244);
        }
        if (!processor.process(root)) {
            return false;
        }
        File[] children = root.listFiles();
        if (children != null) {
            for (File child : children) {
                if (FileUtil.visitFiles(child, processor)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean deleteWithRenaming(@NotNull Path file2) {
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(245);
        }
        return FileUtil.deleteWithRenaming(file2.toFile());
    }

    public static boolean deleteWithRenaming(@NotNull File file2) {
        File tempFileNameForDeletion;
        boolean success;
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(246);
        }
        return FileUtil.delete((success = file2.renameTo(tempFileNameForDeletion = FileUtil.findSequentNonexistentFile(file2.getParentFile(), file2.getName(), ""))) ? tempFileNameForDeletion : file2);
    }

    public static boolean isFileSystemCaseSensitive(@NotNull String path) throws FileNotFoundException {
        FileAttributes attributes;
        if (path == null) {
            FileUtil.$$$reportNull$$$0(247);
        }
        if ((attributes = FileSystemUtil.getAttributes(path)) == null) {
            throw new FileNotFoundException(path);
        }
        FileAttributes upper = FileSystemUtil.getAttributes(Strings.toUpperCase(path));
        FileAttributes lower2 = FileSystemUtil.getAttributes(Strings.toLowerCase(path));
        return !attributes.equals(upper) || !attributes.equals(lower2);
    }

    @NotNull
    public static String getUrl(@NotNull File file2) {
        String string2;
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(248);
        }
        try {
            string2 = file2.toURI().toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            String string3 = "file://" + file2.getAbsolutePath();
            if (string3 == null) {
                FileUtil.$$$reportNull$$$0(250);
            }
            return string3;
        }
        if (string2 == null) {
            FileUtil.$$$reportNull$$$0(249);
        }
        return string2;
    }

    @NotNull
    public static URI fileToUri(@NotNull File file2) {
        if (file2 == null) {
            FileUtil.$$$reportNull$$$0(251);
        }
        URI uRI = FileUtilRt.fileToUri(file2);
        if (uRI == null) {
            FileUtil.$$$reportNull$$$0(252);
        }
        return uRI;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 33: 
            case 35: 
            case 38: 
            case 40: 
            case 42: 
            case 45: 
            case 49: 
            case 83: 
            case 85: 
            case 89: 
            case 94: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 110: 
            case 112: 
            case 118: 
            case 120: 
            case 132: 
            case 139: 
            case 140: 
            case 161: 
            case 169: 
            case 172: 
            case 177: 
            case 179: 
            case 182: 
            case 184: 
            case 187: 
            case 190: 
            case 192: 
            case 194: 
            case 197: 
            case 200: 
            case 203: 
            case 204: 
            case 206: 
            case 211: 
            case 213: 
            case 215: 
            case 218: 
            case 220: 
            case 222: 
            case 224: 
            case 226: 
            case 228: 
            case 230: 
            case 232: 
            case 234: 
            case 236: 
            case 238: 
            case 240: 
            case 242: 
            case 249: 
            case 250: 
            case 252: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 33: 
            case 35: 
            case 38: 
            case 40: 
            case 42: 
            case 45: 
            case 49: 
            case 83: 
            case 85: 
            case 89: 
            case 94: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 110: 
            case 112: 
            case 118: 
            case 120: 
            case 132: 
            case 139: 
            case 140: 
            case 161: 
            case 169: 
            case 172: 
            case 177: 
            case 179: 
            case 182: 
            case 184: 
            case 187: 
            case 190: 
            case 192: 
            case 194: 
            case 197: 
            case 200: 
            case 203: 
            case 204: 
            case 206: 
            case 211: 
            case 213: 
            case 215: 
            case 218: 
            case 220: 
            case 222: 
            case 224: 
            case 226: 
            case 228: 
            case 230: 
            case 232: 
            case 234: 
            case 236: 
            case 238: 
            case 240: 
            case 242: 
            case 249: 
            case 250: 
            case 252: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 1: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 33: 
            case 35: 
            case 38: 
            case 40: 
            case 42: 
            case 45: 
            case 49: 
            case 83: 
            case 85: 
            case 89: 
            case 94: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 110: 
            case 112: 
            case 118: 
            case 120: 
            case 132: 
            case 139: 
            case 140: 
            case 161: 
            case 169: 
            case 172: 
            case 177: 
            case 179: 
            case 182: 
            case 184: 
            case 187: 
            case 190: 
            case 192: 
            case 194: 
            case 197: 
            case 200: 
            case 203: 
            case 204: 
            case 206: 
            case 211: 
            case 213: 
            case 215: 
            case 218: 
            case 220: 
            case 222: 
            case 224: 
            case 226: 
            case 228: 
            case 230: 
            case 232: 
            case 234: 
            case 236: 
            case 238: 
            case 240: 
            case 242: 
            case 249: 
            case 250: 
            case 252: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/io/FileUtil";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 3: 
            case 5: 
            case 103: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 6: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 51: 
            case 53: 
            case 107: 
            case 109: 
            case 119: 
            case 121: 
            case 142: 
            case 143: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 208: 
            case 231: 
            case 233: 
            case 241: 
            case 247: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 31: 
            case 32: 
            case 43: 
            case 46: 
            case 50: 
            case 52: 
            case 54: 
            case 55: 
            case 62: 
            case 82: 
            case 141: 
            case 144: 
            case 146: 
            case 148: 
            case 150: 
            case 153: 
            case 155: 
            case 157: 
            case 159: 
            case 207: 
            case 209: 
            case 210: 
            case 212: 
            case 214: 
            case 216: 
            case 219: 
            case 221: 
            case 223: 
            case 227: 
            case 229: 
            case 245: 
            case 246: 
            case 248: 
            case 251: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 181: 
            case 183: 
            case 186: 
            case 189: 
            case 191: 
            case 193: 
            case 196: 
            case 199: 
            case 202: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f1";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f2";
                break;
            }
            case 34: 
            case 36: 
            case 41: 
            case 237: 
            case 239: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 37: 
            case 39: 
            case 225: 
            case 235: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 44: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFileName";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 56: 
            case 58: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromFile";
                break;
            }
            case 57: 
            case 59: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toFile";
                break;
            }
            case 63: 
            case 65: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 64: 
            case 66: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 69: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 70: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 73: 
            case 75: 
            case 77: 
            case 79: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromDir";
                break;
            }
            case 74: 
            case 76: 
            case 78: 
            case 80: 
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDir";
                break;
            }
            case 81: 
            case 168: 
            case 171: 
            case 185: 
            case 188: 
            case 195: 
            case 198: 
            case 201: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 84: 
            case 135: 
            case 136: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 86: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aParentFolder";
                break;
            }
            case 87: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aFilePrefix";
                break;
            }
            case 88: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aExtension";
                break;
            }
            case 93: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 95: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentFolder";
                break;
            }
            case 96: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePrefix";
                break;
            }
            case 97: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlString";
                break;
            }
            case 113: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "normalizedPath";
                break;
            }
            case 123: 
            case 127: 
            case 162: 
            case 164: 
            case 243: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 124: 
            case 128: 
            case 167: 
            case 170: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outFiles";
                break;
            }
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absoluteRoot";
                break;
            }
            case 130: 
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "antPattern";
                break;
            }
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 145: 
            case 147: 
            case 149: 
            case 151: 
            case 154: 
            case 156: 
            case 158: 
            case 160: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 163: 
            case 165: 
            case 244: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 166: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 178: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultFiles";
                break;
            }
            case 180: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 205: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempPath";
                break;
            }
            case 217: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/io/FileUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "startsWith";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFileBytes";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFirstAndClose";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "loadTextAndClose";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "adaptiveLoadText";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "adaptiveLoadBytes";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "asyncDelete";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempFile";
                break;
            }
            case 83: 
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameWithoutExtension";
                break;
            }
            case 89: 
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "createSequentFileName";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "findSequentFile";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "toSystemDependentName";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "toSystemIndependentName";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "normalize";
                break;
            }
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeTail";
                break;
            }
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "unquote";
                break;
            }
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveShortWindowsName";
                break;
            }
            case 132: {
                objectArray = objectArray2;
                objectArray2[1] = "convertAntToRegexp";
                break;
            }
            case 139: 
            case 140: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeFileName";
                break;
            }
            case 161: {
                objectArray = objectArray2;
                objectArray2[1] = "fileTraverser";
                break;
            }
            case 169: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesByMask";
                break;
            }
            case 172: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesOrDirsByMask";
                break;
            }
            case 177: {
                objectArray = objectArray2;
                objectArray2[1] = "expandUserHome";
                break;
            }
            case 179: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 182: 
            case 184: 
            case 187: 
            case 190: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDirectory";
                break;
            }
            case 192: 
            case 194: 
            case 197: 
            case 200: 
            case 203: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempFile";
                break;
            }
            case 204: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDirectory";
                break;
            }
            case 206: {
                objectArray = objectArray2;
                objectArray2[1] = "generateRandomTemporaryPath";
                break;
            }
            case 211: 
            case 213: 
            case 215: 
            case 218: 
            case 220: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFile";
                break;
            }
            case 222: 
            case 224: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFileText";
                break;
            }
            case 226: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
            case 228: 
            case 230: 
            case 232: 
            case 234: 
            case 236: {
                objectArray = objectArray2;
                objectArray2[1] = "loadLines";
                break;
            }
            case 238: 
            case 240: {
                objectArray = objectArray2;
                objectArray2[1] = "loadBytes";
                break;
            }
            case 242: {
                objectArray = objectArray2;
                objectArray2[1] = "splitPath";
                break;
            }
            case 249: 
            case 250: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 252: {
                objectArray = objectArray2;
                objectArray2[1] = "fileToUri";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 1: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 33: 
            case 35: 
            case 38: 
            case 40: 
            case 42: 
            case 45: 
            case 49: 
            case 83: 
            case 85: 
            case 89: 
            case 94: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 110: 
            case 112: 
            case 118: 
            case 120: 
            case 132: 
            case 139: 
            case 140: 
            case 161: 
            case 169: 
            case 172: 
            case 177: 
            case 179: 
            case 182: 
            case 184: 
            case 187: 
            case 190: 
            case 192: 
            case 194: 
            case 197: 
            case 200: 
            case 203: 
            case 204: 
            case 206: 
            case 211: 
            case 213: 
            case 215: 
            case 218: 
            case 220: 
            case 222: 
            case 224: 
            case 226: 
            case 228: 
            case 230: 
            case 232: 
            case 234: 
            case 236: 
            case 238: 
            case 240: 
            case 242: 
            case 249: 
            case 250: 
            case 252: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAbsolute";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAncestorThreeState";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findAncestor";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getParentFile";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "loadFileBytes";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "loadFirstAndClose";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "loadTextAndClose";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "adaptiveLoadText";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "adaptiveLoadBytes";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "asyncDelete";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "renameToTempFileOrDelete";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getTempFile";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createParentDirs";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "createDirectory";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "createIfDoesntExist";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "ensureCanCreateFile";
                break;
            }
            case 56: 
            case 57: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "copyContent";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "performCopy";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "openOutputStream";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "copyFileOrDir";
                break;
            }
            case 73: 
            case 74: 
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "copyDir";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "copyDirContent";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "ensureExists";
                break;
            }
            case 82: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getNameWithoutExtension";
                break;
            }
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 91: 
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "createSequentFileName";
                break;
            }
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "findSequentNonexistentFile";
                break;
            }
            case 98: 
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "findSequentFile";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "toSystemDependentName";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "toSystemIndependentName";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "normalizeTail";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "unquote";
                break;
            }
            case 113: 
            case 114: 
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "resolveShortWindowsName";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "containsWindowsShortName";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "extractRootPath";
                break;
            }
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "collectMatchedFiles";
                break;
            }
            case 130: 
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "convertAntToRegexp";
                break;
            }
            case 133: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "moveDirWithContent";
                break;
            }
            case 135: 
            case 136: 
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeFileName";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "canExecute";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "canWrite";
                break;
            }
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "setReadOnlyAttribute";
                break;
            }
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "appendToFile";
                break;
            }
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "writeToFile";
                break;
            }
            case 162: 
            case 163: 
            case 164: 
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "processFilesRecursively";
                break;
            }
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "findFirstThatExist";
                break;
            }
            case 167: 
            case 168: {
                objectArray = objectArray;
                objectArray[2] = "findFilesByMask";
                break;
            }
            case 170: 
            case 171: {
                objectArray = objectArray;
                objectArray[2] = "findFilesOrDirsByMask";
                break;
            }
            case 173: {
                objectArray = objectArray;
                objectArray[2] = "isAbsolutePlatformIndependent";
                break;
            }
            case 174: {
                objectArray = objectArray;
                objectArray[2] = "isUnixAbsolutePath";
                break;
            }
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "isWindowsAbsolutePath";
                break;
            }
            case 176: {
                objectArray = objectArray;
                objectArray[2] = "expandUserHome";
                break;
            }
            case 178: {
                objectArray = objectArray;
                objectArray[2] = "notNullize";
                break;
            }
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "isHashBangLine";
                break;
            }
            case 181: 
            case 183: 
            case 185: 
            case 186: 
            case 188: 
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "createTempDirectory";
                break;
            }
            case 191: 
            case 193: 
            case 195: 
            case 196: 
            case 198: 
            case 199: 
            case 201: 
            case 202: {
                objectArray = objectArray;
                objectArray[2] = "createTempFile";
                break;
            }
            case 205: {
                objectArray = objectArray;
                objectArray[2] = "resetCanonicalTempPathCache";
                break;
            }
            case 207: {
                objectArray = objectArray;
                objectArray[2] = "setExecutable";
                break;
            }
            case 208: 
            case 209: {
                objectArray = objectArray;
                objectArray[2] = "loadFileOrNull";
                break;
            }
            case 210: 
            case 212: 
            case 214: 
            case 216: 
            case 217: 
            case 219: {
                objectArray = objectArray;
                objectArray[2] = "loadFile";
                break;
            }
            case 221: 
            case 223: {
                objectArray = objectArray;
                objectArray[2] = "loadFileText";
                break;
            }
            case 225: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 227: 
            case 229: 
            case 231: 
            case 233: 
            case 235: {
                objectArray = objectArray;
                objectArray[2] = "loadLines";
                break;
            }
            case 237: 
            case 239: {
                objectArray = objectArray;
                objectArray[2] = "loadBytes";
                break;
            }
            case 241: {
                objectArray = objectArray;
                objectArray[2] = "splitPath";
                break;
            }
            case 243: 
            case 244: {
                objectArray = objectArray;
                objectArray[2] = "visitFiles";
                break;
            }
            case 245: 
            case 246: {
                objectArray = objectArray;
                objectArray[2] = "deleteWithRenaming";
                break;
            }
            case 247: {
                objectArray = objectArray;
                objectArray[2] = "isFileSystemCaseSensitive";
                break;
            }
            case 248: {
                objectArray = objectArray;
                objectArray[2] = "getUrl";
                break;
            }
            case 251: {
                objectArray = objectArray;
                objectArray[2] = "fileToUri";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 33: 
            case 35: 
            case 38: 
            case 40: 
            case 42: 
            case 45: 
            case 49: 
            case 83: 
            case 85: 
            case 89: 
            case 94: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 110: 
            case 112: 
            case 118: 
            case 120: 
            case 132: 
            case 139: 
            case 140: 
            case 161: 
            case 169: 
            case 172: 
            case 177: 
            case 179: 
            case 182: 
            case 184: 
            case 187: 
            case 190: 
            case 192: 
            case 194: 
            case 197: 
            case 200: 
            case 203: 
            case 204: 
            case 206: 
            case 211: 
            case 213: 
            case 215: 
            case 218: 
            case 220: 
            case 222: 
            case 224: 
            case 226: 
            case 228: 
            case 230: 
            case 232: 
            case 234: 
            case 236: 
            case 238: 
            case 240: 
            case 242: 
            case 249: 
            case 250: 
            case 252: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Lazy {
        private static final JBTreeTraverser<File> FILE_TRAVERSER = JBTreeTraverser.from(file2 -> file2 == null ? Collections.emptySet() : JBIterable.of(file2.listFiles()));
    }
}

