/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ContributedReferenceHost;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.impl.PsiLiteralStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.injected.StringLiteralEscaper;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.util.text.LiteralFormatUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiLiteralExpressionImpl
extends JavaStubPsiElement<PsiLiteralStub>
implements ContributedReferenceHost,
PsiLanguageInjectionHost,
PsiLiteralExpression {
    private static final TokenSet NUMERIC_LITERALS = TokenSet.orSet(ElementType.INTEGER_LITERALS, ElementType.REAL_LITERALS);

    public PsiLiteralExpressionImpl(@NotNull PsiLiteralStub stub) {
        if (stub == null) {
            PsiLiteralExpressionImpl.$$$reportNull$$$0(0);
        }
        super(stub, (IStubElementType)JavaStubElementTypes.LITERAL_EXPRESSION);
    }

    public PsiLiteralExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            PsiLiteralExpressionImpl.$$$reportNull$$$0(1);
        }
        super(node);
    }

    @Override
    public PsiElement @NotNull [] getChildren() {
        PsiElement[] psiElementArray = ((CompositeElement)this.getNode()).getChildrenAsPsiElements(null, PsiElement.ARRAY_FACTORY);
        if (psiElementArray == null) {
            PsiLiteralExpressionImpl.$$$reportNull$$$0(2);
        }
        return psiElementArray;
    }

    @Override
    public PsiType getType() {
        IElementType type2 = this.getLiteralElementType();
        if (type2 == JavaTokenType.INTEGER_LITERAL) {
            return PsiType.INT;
        }
        if (type2 == JavaTokenType.LONG_LITERAL) {
            return PsiType.LONG;
        }
        if (type2 == JavaTokenType.FLOAT_LITERAL) {
            return PsiType.FLOAT;
        }
        if (type2 == JavaTokenType.DOUBLE_LITERAL) {
            return PsiType.DOUBLE;
        }
        if (type2 == JavaTokenType.CHARACTER_LITERAL) {
            return PsiType.CHAR;
        }
        if (ElementType.STRING_LITERALS.contains(type2)) {
            PsiFile file2 = this.getContainingFile();
            return PsiType.getJavaLangString(file2.getManager(), ResolveScopeManager.getElementResolveScope(file2));
        }
        if (type2 == JavaTokenType.TRUE_KEYWORD || type2 == JavaTokenType.FALSE_KEYWORD) {
            return PsiType.BOOLEAN;
        }
        if (type2 == JavaTokenType.NULL_KEYWORD) {
            return PsiType.NULL;
        }
        return null;
    }

    @Override
    public boolean isTextBlock() {
        return this.getLiteralElementType() == JavaTokenType.TEXT_BLOCK_LITERAL;
    }

    public IElementType getLiteralElementType() {
        PsiLiteralStub stub = (PsiLiteralStub)this.getGreenStub();
        if (stub != null) {
            return stub.getLiteralType();
        }
        return this.getNode().getFirstChildNode().getElementType();
    }

    public String getCanonicalText() {
        IElementType type2 = this.getLiteralElementType();
        return NUMERIC_LITERALS.contains(type2) ? LiteralFormatUtil.removeUnderscores(this.getText()) : this.getText();
    }

    @Override
    public String getText() {
        PsiLiteralStub stub = (PsiLiteralStub)this.getGreenStub();
        if (stub != null) {
            return stub.getLiteralText();
        }
        return super.getText();
    }

    @Override
    public Object getValue() {
        IElementType type2 = this.getLiteralElementType();
        if (type2 == JavaTokenType.TRUE_KEYWORD) {
            return Boolean.TRUE;
        }
        if (type2 == JavaTokenType.FALSE_KEYWORD) {
            return Boolean.FALSE;
        }
        if (type2 == JavaTokenType.STRING_LITERAL) {
            return PsiLiteralExpressionImpl.internedParseStringCharacters(PsiLiteralUtil.getStringLiteralContent(this));
        }
        if (type2 == JavaTokenType.TEXT_BLOCK_LITERAL) {
            return PsiLiteralExpressionImpl.internedParseStringCharacters(PsiLiteralUtil.getTextBlockText(this));
        }
        String text = NUMERIC_LITERALS.contains(type2) ? StringUtil.toLowerCase(this.getCanonicalText()) : this.getCanonicalText();
        int textLength = text.length();
        if (type2 == JavaTokenType.INTEGER_LITERAL) {
            return PsiLiteralUtil.parseInteger(text);
        }
        if (type2 == JavaTokenType.LONG_LITERAL) {
            return PsiLiteralUtil.parseLong(text);
        }
        if (type2 == JavaTokenType.FLOAT_LITERAL) {
            return PsiLiteralUtil.parseFloat(text);
        }
        if (type2 == JavaTokenType.DOUBLE_LITERAL) {
            return PsiLiteralUtil.parseDouble(text);
        }
        if (type2 == JavaTokenType.CHARACTER_LITERAL) {
            StringBuilder chars;
            if (textLength == 1 || !StringUtil.endsWithChar(text, '\'')) {
                return null;
            }
            boolean success = PsiLiteralExpressionImpl.parseStringCharacters(text = text.substring(1, textLength - 1), chars = new StringBuilder(), null);
            if (!success) {
                return null;
            }
            if (chars.length() != 1) {
                return null;
            }
            return Character.valueOf(chars.charAt(0));
        }
        return null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.2")
    @Nullable
    public String getInnerText() {
        return PsiLiteralUtil.getStringLiteralContent(this);
    }

    @Nullable
    private static String internedParseStringCharacters(String chars) {
        if (chars == null) {
            return null;
        }
        StringBuilder outChars = new StringBuilder(chars.length());
        boolean success = PsiLiteralExpressionImpl.parseStringCharacters(chars, outChars, null);
        return success ? outChars.toString() : null;
    }

    public static boolean parseStringCharacters(@NotNull String chars, @NotNull StringBuilder outChars, int @Nullable [] sourceOffsets) {
        if (chars == null) {
            PsiLiteralExpressionImpl.$$$reportNull$$$0(3);
        }
        if (outChars == null) {
            PsiLiteralExpressionImpl.$$$reportNull$$$0(4);
        }
        return CodeInsightUtilCore.parseStringCharacters(chars, outChars, sourceOffsets);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiLiteralExpressionImpl.$$$reportNull$$$0(5);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitLiteralExpression(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiLiteralExpression:" + this.getText();
    }

    @Override
    public boolean isValidHost() {
        return ElementType.TEXT_LITERALS.contains(this.getLiteralElementType());
    }

    @Override
    public PsiReference @NotNull [] getReferences() {
        IElementType type2 = this.getLiteralElementType();
        PsiReference[] psiReferenceArray = ElementType.STRING_LITERALS.contains(type2) || type2 == JavaTokenType.INTEGER_LITERAL ? PsiReferenceService.getService().getContributedReferences(this) : PsiReference.EMPTY_ARRAY;
        if (psiReferenceArray == null) {
            PsiLiteralExpressionImpl.$$$reportNull$$$0(6);
        }
        return psiReferenceArray;
    }

    @Override
    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            PsiLiteralExpressionImpl.$$$reportNull$$$0(7);
        }
        ASTNode valueNode = this.getNode().getFirstChildNode();
        assert (valueNode instanceof LeafElement);
        ((LeafElement)valueNode).replaceWithText(text);
        return this;
    }

    @NotNull
    public LiteralTextEscaper<PsiLiteralExpressionImpl> createLiteralTextEscaper() {
        return new StringLiteralEscaper<PsiLiteralExpressionImpl>(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/java/PsiLiteralExpressionImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outChars";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiLiteralExpressionImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseStringCharacters";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

