/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Parent;
import org.jdom.output.XMLOutputter2;

public class ProcessingInstruction
extends Content {
    private static final long serialVersionUID = 200L;
    protected String target;
    protected String rawData;
    protected transient Map<String, String> mapData = null;

    protected ProcessingInstruction() {
        super(Content.CType.ProcessingInstruction);
    }

    public String getTarget() {
        return this.target;
    }

    public String getData() {
        return this.rawData;
    }

    private Map<String, String> parseData(String prawData) {
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        String inputData = prawData.trim();
        while (!inputData.trim().equals("")) {
            int pos;
            String name2 = "";
            String value2 = "";
            int startName = 0;
            char previousChar = inputData.charAt(startName);
            for (pos = 1; pos < inputData.length(); ++pos) {
                char currentChar = inputData.charAt(pos);
                if (currentChar == '=') {
                    name2 = inputData.substring(startName, pos).trim();
                    int[] bounds = ProcessingInstruction.extractQuotedString(inputData.substring(pos + 1));
                    if (bounds == null) {
                        return Collections.emptyMap();
                    }
                    value2 = inputData.substring(bounds[0] + pos + 1, bounds[1] + pos + 1);
                    pos += bounds[1] + 1;
                    break;
                }
                if (Character.isWhitespace(previousChar) && !Character.isWhitespace(currentChar)) {
                    startName = pos;
                }
                previousChar = currentChar;
            }
            inputData = inputData.substring(pos);
            if (name2.length() <= 0) continue;
            data.put(name2, value2);
        }
        return data;
    }

    private static int[] extractQuotedString(String rawData) {
        boolean inQuotes = false;
        char quoteChar = '\"';
        int start = 0;
        for (int pos = 0; pos < rawData.length(); ++pos) {
            char currentChar = rawData.charAt(pos);
            if (currentChar != '\"' && currentChar != '\'') continue;
            if (!inQuotes) {
                quoteChar = currentChar;
                inQuotes = true;
                start = pos + 1;
                continue;
            }
            if (quoteChar != currentChar) continue;
            inQuotes = false;
            return new int[]{start, pos};
        }
        return null;
    }

    public String toString() {
        return "[ProcessingInstruction: " + new XMLOutputter2().outputString(this) + "]";
    }

    @Override
    public ProcessingInstruction clone() {
        ProcessingInstruction pi = (ProcessingInstruction)super.clone();
        pi.mapData = this.parseData(this.rawData);
        return pi;
    }

    @Override
    protected ProcessingInstruction setParent(Parent parent2) {
        return (ProcessingInstruction)super.setParent(parent2);
    }
}

