/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.psi.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.DecompiledText;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuildingKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.contracts.description.AbstractContractProvider;
import org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererModifier;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u001a\f\u0010\b\u001a\u00020\t*\u00020\nH\u0000\u001a\f\u0010\u000b\u001a\u00020\t*\u00020\nH\u0002\u001a$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"DECOMPILED_CODE_COMMENT", "", "DECOMPILED_COMMENT_FOR_PARAMETER", "FLEXIBLE_TYPE_COMMENT", "DECOMPILED_CONTRACT_STUB", "defaultDecompilerRendererOptions", "", "Lorg/jetbrains/kotlin/renderer/DescriptorRendererOptions;", "mustNotBeWrittenToDecompiledText", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "syntheticMemberMustNotBeWrittenToDecompiledText", "buildDecompiledText", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/text/DecompiledText;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "descriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptorRenderer", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "decompiler-to-psi"})
@SourceDebugExtension(value={"SMAP\nbuildDecompiledText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 buildDecompiledText.kt\norg/jetbrains/kotlin/analysis/decompiler/psi/text/BuildDecompiledTextKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,213:1\n3193#2,10:214\n*S KotlinDebug\n*F\n+ 1 buildDecompiledText.kt\norg/jetbrains/kotlin/analysis/decompiler/psi/text/BuildDecompiledTextKt\n*L\n169#1:214,10\n*E\n"})
public final class BuildDecompiledTextKt {
    public static final void defaultDecompilerRendererOptions(@NotNull DescriptorRendererOptions $this$defaultDecompilerRendererOptions) {
        Intrinsics.checkNotNullParameter((Object)$this$defaultDecompilerRendererOptions, (String)"<this>");
        $this$defaultDecompilerRendererOptions.setWithDefinedIn(false);
        $this$defaultDecompilerRendererOptions.setClassWithPrimaryConstructor(true);
        $this$defaultDecompilerRendererOptions.setSecondaryConstructorsAsPrimary(false);
        $this$defaultDecompilerRendererOptions.setModifiers(DescriptorRendererModifier.ALL);
        $this$defaultDecompilerRendererOptions.setExcludedTypeAnnotationClasses(SetsKt.emptySet());
        $this$defaultDecompilerRendererOptions.setAlwaysRenderModifiers(true);
        $this$defaultDecompilerRendererOptions.setParameterNamesInFunctionalTypes(false);
        $this$defaultDecompilerRendererOptions.setDefaultParameterValueRenderer((Function1<? super ValueParameterDescriptor, String>)((Function1)BuildDecompiledTextKt::defaultDecompilerRendererOptions$lambda$0));
        $this$defaultDecompilerRendererOptions.setIncludePropertyConstant(true);
        $this$defaultDecompilerRendererOptions.setPropertyConstantRenderer(BuildDecompiledTextKt::defaultDecompilerRendererOptions$lambda$1);
    }

    public static final boolean mustNotBeWrittenToDecompiledText(@NotNull CallableMemberDescriptor $this$mustNotBeWrittenToDecompiledText) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$mustNotBeWrittenToDecompiledText, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$mustNotBeWrittenToDecompiledText.getKind().ordinal()]) {
            case 1: 
            case 2: {
                bl = false;
                break;
            }
            case 3: {
                bl = true;
                break;
            }
            case 4: {
                bl = BuildDecompiledTextKt.syntheticMemberMustNotBeWrittenToDecompiledText($this$mustNotBeWrittenToDecompiledText);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private static final boolean syntheticMemberMustNotBeWrittenToDecompiledText(CallableMemberDescriptor $this$syntheticMemberMustNotBeWrittenToDecompiledText) {
        boolean bl;
        DeclarationDescriptor declarationDescriptor = $this$syntheticMemberMustNotBeWrittenToDecompiledText.getContainingDeclaration();
        ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor containingClass = classDescriptor;
        if (containingClass.isData() && containingClass.getKind() != ClassKind.OBJECT) {
            bl = Intrinsics.areEqual((Object)$this$syntheticMemberMustNotBeWrittenToDecompiledText.getName(), (Object)StandardNames.DATA_CLASS_COPY);
        } else if (containingClass.getKind() == ClassKind.ENUM_CLASS) {
            Object[] objectArray = new Name[]{StandardNames.ENUM_VALUES, StandardNames.ENUM_ENTRIES, StandardNames.ENUM_VALUE_OF};
            bl = ArraysKt.contains((Object[])objectArray, (Object)$this$syntheticMemberMustNotBeWrittenToDecompiledText.getName());
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final DecompiledText buildDecompiledText(@NotNull FqName packageFqName, @NotNull List<? extends DeclarationDescriptor> descriptors, @NotNull DescriptorRenderer descriptorRenderer) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        Intrinsics.checkNotNullParameter((Object)descriptorRenderer, (String)"descriptorRenderer");
        StringBuilder builder = new StringBuilder();
        BuildDecompiledTextKt.buildDecompiledText$appendDecompiledTextAndPackageName(builder, packageFqName);
        for (DeclarationDescriptor declarationDescriptor : descriptors) {
            BuildDecompiledTextKt.buildDecompiledText$appendDescriptor$default(builder, descriptorRenderer, declarationDescriptor, "", null, 16, null);
            builder.append("\n");
        }
        String string2 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return new DecompiledText(string2);
    }

    private static final String defaultDecompilerRendererOptions$lambda$0(ValueParameterDescriptor valueParameterDescriptor) {
        Intrinsics.checkNotNullParameter((Object)valueParameterDescriptor, (String)"<unused var>");
        return "COMPILED_CODE";
    }

    private static final String defaultDecompilerRendererOptions$lambda$1(ConstantValue constantValue) {
        Intrinsics.checkNotNullParameter((Object)constantValue, (String)"<unused var>");
        return "COMPILED_CODE";
    }

    private static final void buildDecompiledText$appendDecompiledTextAndPackageName(StringBuilder builder, FqName $packageFqName) {
        builder.append("// IntelliJ API Decompiler stub source generated from a class file\n// Implementation of methods is not available");
        builder.append("\n\n");
        if (!$packageFqName.isRoot()) {
            builder.append("package ").append(RenderingUtilsKt.render($packageFqName)).append("\n\n");
        }
    }

    private static final void buildDecompiledText$appendDescriptor$newlineExceptFirst(Ref.BooleanRef firstPassed, StringBuilder builder) {
        if (firstPassed.element) {
            builder.append("\n");
        } else {
            firstPassed.element = true;
        }
    }

    private static final void buildDecompiledText$appendDescriptor(StringBuilder builder, DescriptorRenderer $descriptorRenderer, DeclarationDescriptor descriptor, String indent, Boolean lastEnumEntry) {
        StringBuilder stringBuilder;
        if (DescriptorUtils.isEnumEntry(descriptor)) {
            for (AnnotationDescriptor annotation : descriptor.getAnnotations()) {
                builder.append(DescriptorRenderer.renderAnnotation$default($descriptorRenderer, annotation, null, 2, null));
                builder.append(" ");
            }
            String string2 = descriptor.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            builder.append(KtPsiUtilKt.quoteIfNeeded(string2));
            Boolean bl = lastEnumEntry;
            Intrinsics.checkNotNull((Object)bl);
            stringBuilder = builder.append(bl != false ? ";" : ",");
        } else {
            stringBuilder = builder.append(StringsKt.replace$default((String)$descriptorRenderer.render(descriptor), (String)"= ...", (String)"/* = compiled code */", (boolean)false, (int)4, null));
        }
        if (descriptor instanceof CallableDescriptor) {
            KotlinType kotlinType = ((CallableDescriptor)descriptor).getReturnType();
            Intrinsics.checkNotNull((Object)kotlinType);
            if (FlexibleTypesKt.isFlexible(kotlinType)) {
                builder.append(" ").append("/* platform type */");
            }
        }
        if (descriptor instanceof FunctionDescriptor || descriptor instanceof PropertyDescriptor) {
            if (((MemberDescriptor)descriptor).getModality() != Modality.ABSTRACT) {
                StringBuilder stringBuilder2;
                if (descriptor instanceof FunctionDescriptor) {
                    StringBuilder $this$buildDecompiledText_u24appendDescriptor_u24lambda_u242 = builder;
                    boolean bl = false;
                    $this$buildDecompiledText_u24appendDescriptor_u24lambda_u242.append(" { ");
                    AbstractContractProvider abstractContractProvider = (AbstractContractProvider)((FunctionDescriptor)descriptor).getUserData(ContractProviderKey.INSTANCE);
                    if ((abstractContractProvider != null ? abstractContractProvider.getContractDescription() : null) != null) {
                        $this$buildDecompiledText_u24appendDescriptor_u24lambda_u242.append("contract { /* compiled contract */ }").append("; ");
                    }
                    stringBuilder2 = $this$buildDecompiledText_u24appendDescriptor_u24lambda_u242.append("/* compiled code */").append(" }");
                } else {
                    stringBuilder2 = builder.append(" ").append("/* compiled code */");
                }
            }
            if (descriptor instanceof PropertyDescriptor) {
                for (PropertyAccessorDescriptor accessor : ((PropertyDescriptor)descriptor).getAccessors()) {
                    Object annotation2;
                    if (accessor.isDefault()) continue;
                    builder.append('\n' + indent + "    ");
                    builder.append(accessor.getVisibility().getInternalDisplayName()).append(" ");
                    builder.append(CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly(accessor.getModality().name())).append(" ");
                    if (accessor.isExternal()) {
                        builder.append("external ");
                    }
                    for (Object annotation2 : accessor.getAnnotations()) {
                        builder.append(DescriptorRenderer.renderAnnotation$default($descriptorRenderer, (AnnotationDescriptor)annotation2, null, 2, null));
                        builder.append(" ");
                    }
                    if (accessor instanceof PropertyGetterDescriptor) {
                        builder.append("get");
                        continue;
                    }
                    if (!(accessor instanceof PropertySetterDescriptor)) continue;
                    builder.append("set(");
                    ValueParameterDescriptor parameterDescriptor = ((PropertySetterDescriptor)accessor).getValueParameters().get(0);
                    annotation2 = parameterDescriptor.getAnnotations().iterator();
                    while (annotation2.hasNext()) {
                        AnnotationDescriptor annotation3 = (AnnotationDescriptor)annotation2.next();
                        builder.append(DescriptorRenderer.renderAnnotation$default($descriptorRenderer, annotation3, null, 2, null));
                        builder.append(" ");
                    }
                    Name name2 = parameterDescriptor.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
                    Name parameterName = ClsStubBuildingKt.computeParameterName(name2);
                    StringBuilder stringBuilder3 = builder.append(parameterName.asString()).append(": ");
                    KotlinType kotlinType = parameterDescriptor.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                    stringBuilder3.append($descriptorRenderer.renderType(kotlinType));
                    builder.append(")");
                    builder.append(" {").append("/* compiled code */").append(" }");
                }
            }
        } else if (descriptor instanceof ClassDescriptor && !DescriptorUtils.isEnumEntry(descriptor)) {
            builder.append(" {\n");
            String subindent = indent + "    ";
            Ref.BooleanRef firstPassed = new Ref.BooleanRef();
            List allDescriptors = CollectionsKt.plus((Collection)DescriptorUtilsKt.getSecondaryConstructors((ClassDescriptor)descriptor), (Iterable)ResolutionScope.DefaultImpls.getContributedDescriptors$default(((ClassDescriptor)descriptor).getDefaultType().getMemberScope(), null, null, 3, null));
            Iterable $this$partition$iv = allDescriptors;
            boolean $i$f$partition = false;
            Object first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                DeclarationDescriptor p0 = (DeclarationDescriptor)element$iv;
                boolean bl = false;
                if (DescriptorUtils.isEnumEntry(p0)) {
                    ((ArrayList)first$iv).add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List enumEntries = (List)pair.component1();
            List members = (List)pair.component2();
            first$iv = ((Iterable)enumEntries).iterator();
            int n = 0;
            while (first$iv.hasNext()) {
                int index = n++;
                DeclarationDescriptor enumEntry = (DeclarationDescriptor)first$iv.next();
                BuildDecompiledTextKt.buildDecompiledText$appendDescriptor$newlineExceptFirst(firstPassed, builder);
                builder.append(subindent);
                BuildDecompiledTextKt.buildDecompiledText$appendDescriptor(builder, $descriptorRenderer, enumEntry, subindent, index == CollectionsKt.getLastIndex((List)enumEntries));
            }
            ClassDescriptor companionObject = ((ClassDescriptor)descriptor).getCompanionObjectDescriptor();
            if (companionObject != null) {
                BuildDecompiledTextKt.buildDecompiledText$appendDescriptor$newlineExceptFirst(firstPassed, builder);
                builder.append(subindent);
                BuildDecompiledTextKt.buildDecompiledText$appendDescriptor$default(builder, $descriptorRenderer, companionObject, subindent, null, 16, null);
            }
            for (DeclarationDescriptor member : members) {
                if (!Intrinsics.areEqual((Object)member.getContainingDeclaration(), (Object)descriptor) || Intrinsics.areEqual((Object)member, (Object)companionObject) || member instanceof CallableMemberDescriptor && BuildDecompiledTextKt.mustNotBeWrittenToDecompiledText((CallableMemberDescriptor)member)) continue;
                BuildDecompiledTextKt.buildDecompiledText$appendDescriptor$newlineExceptFirst(firstPassed, builder);
                builder.append(subindent);
                BuildDecompiledTextKt.buildDecompiledText$appendDescriptor$default(builder, $descriptorRenderer, member, subindent, null, 16, null);
            }
            builder.append(indent).append("}");
        }
        builder.append("\n");
    }

    static /* synthetic */ void buildDecompiledText$appendDescriptor$default(StringBuilder stringBuilder, DescriptorRenderer descriptorRenderer, DeclarationDescriptor declarationDescriptor, String string2, Boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = null;
        }
        BuildDecompiledTextKt.buildDecompiledText$appendDescriptor(stringBuilder, descriptorRenderer, declarationDescriptor, string2, bl);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CallableMemberDescriptor.Kind.values().length];
            try {
                nArray[CallableMemberDescriptor.Kind.DECLARATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CallableMemberDescriptor.Kind.DELEGATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CallableMemberDescriptor.Kind.FAKE_OVERRIDE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CallableMemberDescriptor.Kind.SYNTHESIZED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

