/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.ir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineReferenceLocator;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrInlineUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0016J\u001a\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\fH\u0016J\u001a\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0018\u001a\u0004\u0018\u00010\fH\u0016J\u001a\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001d2\b\u0010\u0018\u001a\u0004\u0018\u00010\fH\u0016J\f\u0010!\u001a\u00020\u001f*\u00020\bH\u0002J\u0010\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0014\u001a\u00020$J\u001d\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010\u0014\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u001fH\u0082\u0010R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u001e\u001a\u00020\u001f*\u00020\u00178\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010 \u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver;", "Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineReferenceLocator;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "inlineCallSites", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver$CallSite;", "privateInlineFunctionCallSites", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "visitInlineLambda", "", "argument", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "callee", "parameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "scope", "visitSimpleFunction", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "data", "visitCall", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "isPrivateInline", "", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Z", "isCoroutineIntrinsic", "findContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationContainer;", "Lorg/jetbrains/kotlin/ir/IrElement;", "approximateToPackage", "CallSite", "backend.jvm"})
@SourceDebugExtension(value={"SMAP\nIrInlineReferenceLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrInlineReferenceLocator.kt\norg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,251:1\n124#1:252\n124#1:253\n124#1:261\n381#2,7:254\n381#2,7:262\n1557#3:269\n1628#3,3:270\n1734#3,3:274\n1#4:273\n*S KotlinDebug\n*F\n+ 1 IrInlineReferenceLocator.kt\norg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver\n*L\n98#1:252\n106#1:253\n115#1:261\n107#1:254,7\n116#1:262,7\n191#1:269\n191#1:270,3\n194#1:274,3\n*E\n"})
public final class IrInlineScopeResolver
extends IrInlineReferenceLocator {
    @NotNull
    private final Map<IrFunction, CallSite> inlineCallSites;
    @NotNull
    private final Map<IrFunction, Set<IrDeclaration>> privateInlineFunctionCallSites;

    public IrInlineScopeResolver(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2);
        this.inlineCallSites = new LinkedHashMap();
        this.privateInlineFunctionCallSites = new LinkedHashMap();
    }

    @Override
    public void visitInlineLambda(@NotNull IrFunctionReference argument, @NotNull IrFunction callee, @NotNull IrValueParameter parameter, @NotNull IrDeclaration scope2) {
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)callee, (String)"callee");
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        this.inlineCallSites.put(((IrFunctionSymbol)argument.getSymbol()).getOwner(), new CallSite(scope2, parameter.isCrossinline() && !this.isCoroutineIntrinsic(callee)));
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable IrDeclaration data) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrInlineScopeResolver irInlineScopeResolver = this;
        IrSimpleFunction $this$isPrivateInline$iv = declaration;
        boolean $i$f$isPrivateInline = false;
        if ($this$isPrivateInline$iv.isInline() && DescriptorVisibilities.isPrivate($this$isPrivateInline$iv.getVisibility())) {
            this.privateInlineFunctionCallSites.putIfAbsent(declaration, new LinkedHashSet());
        }
        super.visitSimpleFunction(declaration, data);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2, @Nullable IrDeclaration data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
        IrInlineScopeResolver irInlineScopeResolver = this;
        IrSimpleFunction $this$isPrivateInline$iv = callee;
        boolean $i$f$isPrivateInline = false;
        if ($this$isPrivateInline$iv.isInline() && DescriptorVisibilities.isPrivate($this$isPrivateInline$iv.getVisibility()) && data != null) {
            Set set;
            Map<IrFunction, Set<IrDeclaration>> $this$getOrPut$iv = this.privateInlineFunctionCallSites;
            boolean $i$f$getOrPut = false;
            Set value$iv = $this$getOrPut$iv.get(callee);
            if (value$iv == null) {
                boolean bl = false;
                Set answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(callee, answer$iv);
                set = answer$iv;
            } else {
                set = value$iv;
            }
            TypeIntrinsics.asMutableSet(set).add(data);
        }
        super.visitCall(expression2, data);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitBlock(@NotNull IrBlock expression2, @Nullable IrDeclaration data) {
        IrDeclaration callee;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (expression2 instanceof IrInlinedFunctionBlock && IrInlineUtilsKt.isFunctionInlining((IrInlinedFunctionBlock)expression2) && (callee = IrInlineUtilsKt.getInlineDeclaration((IrInlinedFunctionBlock)expression2)) instanceof IrSimpleFunction) {
            IrInlineScopeResolver irInlineScopeResolver = this;
            Object $this$isPrivateInline$iv = (IrSimpleFunction)callee;
            boolean $i$f$isPrivateInline = false;
            if (((IrFunction)$this$isPrivateInline$iv).isInline() && DescriptorVisibilities.isPrivate($this$isPrivateInline$iv.getVisibility()) && data != null) {
                Object object;
                void $this$getOrPut$iv;
                $this$isPrivateInline$iv = this.privateInlineFunctionCallSites;
                IrDeclaration key$iv = callee;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                TypeIntrinsics.asMutableSet(object).add(data);
            }
        }
        super.visitBlock(expression2, data);
    }

    private final boolean isCoroutineIntrinsic(IrFunction $this$isCoroutineIntrinsic) {
        return AdditionalIrUtilsKt.isBuiltInSuspendCoroutine($this$isCoroutineIntrinsic) || AdditionalIrUtilsKt.isBuiltInSuspendCoroutineUninterceptedOrReturn($this$isCoroutineIntrinsic);
    }

    @Nullable
    public final IrDeclarationContainer findContainer(@NotNull IrElement scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        return this.findContainer(scope2, false);
    }

    /*
     * WARNING - void declaration
     */
    private final IrDeclarationContainer findContainer(IrElement scope2, boolean approximateToPackage) {
        IrDeclarationContainer irDeclarationContainer;
        block15: {
            IrInlineScopeResolver irInlineScopeResolver = this;
            while (true) {
                boolean bl;
                IrElement irElement;
                IrInlineScopeResolver irInlineScopeResolver2;
                CallSite callSite = irInlineScopeResolver.inlineCallSites.get(scope2);
                if (callSite != null) {
                    irInlineScopeResolver2 = irInlineScopeResolver;
                    irElement = callSite.getScope();
                    bl = approximateToPackage || callSite.getApproximateToPackage();
                    irInlineScopeResolver = irInlineScopeResolver2;
                    scope2 = irElement;
                    approximateToPackage = bl;
                    continue;
                }
                if (scope2 instanceof IrFunction && ((IrFunction)scope2).isInline()) {
                    CallSite callSite2;
                    Set<IrDeclaration> callSites;
                    if (irInlineScopeResolver.privateInlineFunctionCallSites.get(scope2) == null) {
                        return null;
                    }
                    irInlineScopeResolver.inlineCallSites.put((IrFunction)scope2, new CallSite(null, false));
                    if (callSites.isEmpty()) {
                        callSite2 = new CallSite(((IrFunction)scope2).getParent(), false);
                    } else if (callSites.size() == 1) {
                        callSite2 = new CallSite((IrElement)CollectionsKt.single((Iterable)callSites), false);
                    } else {
                        IrDeclarationContainer single;
                        boolean bl2;
                        Object object;
                        block14: {
                            void $this$mapTo$iv$iv;
                            Iterable $this$map$iv = callSites;
                            boolean $i$f$map = false;
                            Iterable iterable = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                IrDeclaration irDeclaration2 = (IrDeclaration)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl3 = false;
                                IrDeclarationContainer irDeclarationContainer2 = irInlineScopeResolver.findContainer((IrElement)it, false);
                                if (irDeclarationContainer2 == null) {
                                    return null;
                                }
                                collection.add(irDeclarationContainer2);
                            }
                            List results = (List)destination$iv$iv;
                            object = CollectionsKt.first((List)results);
                            IrDeclarationContainer it = (IrDeclarationContainer)object;
                            boolean bl4 = false;
                            Iterable $this$all$iv = results;
                            boolean $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl2 = true;
                            } else {
                                for (Object element$iv : $this$all$iv) {
                                    IrDeclarationContainer other = (IrDeclarationContainer)element$iv;
                                    boolean bl5 = false;
                                    if (it == other) continue;
                                    bl2 = false;
                                    break block14;
                                }
                                bl2 = true;
                            }
                        }
                        IrDeclarationContainer irDeclarationContainer3 = single = (IrDeclarationContainer)(bl2 ? object : null);
                        callSite2 = new CallSite(irDeclarationContainer3 != null ? (IrDeclarationParent)irDeclarationContainer3 : ((IrFunction)scope2).getParent(), single == null);
                    }
                    CallSite commonCallSite = callSite2;
                    irInlineScopeResolver.inlineCallSites.put((IrFunction)scope2, commonCallSite);
                    IrInlineScopeResolver irInlineScopeResolver3 = irInlineScopeResolver;
                    IrElement irElement2 = commonCallSite.getScope();
                    boolean bl6 = approximateToPackage || commonCallSite.getApproximateToPackage();
                    irInlineScopeResolver = irInlineScopeResolver3;
                    scope2 = irElement2;
                    approximateToPackage = bl6;
                    continue;
                }
                if (scope2 instanceof IrClass && !approximateToPackage) {
                    irDeclarationContainer = (IrDeclarationContainer)scope2;
                    break block15;
                }
                if (!(scope2 instanceof IrDeclaration)) break;
                irInlineScopeResolver2 = irInlineScopeResolver;
                irElement = ((IrDeclaration)scope2).getParent();
                bl = approximateToPackage;
                irInlineScopeResolver = irInlineScopeResolver2;
                scope2 = irElement;
                approximateToPackage = bl;
            }
            irDeclarationContainer = scope2 instanceof IrPackageFragment ? (IrPackageFragment)scope2 : null;
        }
        return irDeclarationContainer;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver$CallSite;", "", "scope", "Lorg/jetbrains/kotlin/ir/IrElement;", "approximateToPackage", "", "<init>", "(Lorg/jetbrains/kotlin/ir/IrElement;Z)V", "getScope", "()Lorg/jetbrains/kotlin/ir/IrElement;", "getApproximateToPackage", "()Z", "backend.jvm"})
    private static final class CallSite {
        @Nullable
        private final IrElement scope;
        private final boolean approximateToPackage;

        public CallSite(@Nullable IrElement scope2, boolean approximateToPackage) {
            this.scope = scope2;
            this.approximateToPackage = approximateToPackage;
        }

        @Nullable
        public final IrElement getScope() {
            return this.scope;
        }

        public final boolean getApproximateToPackage() {
            return this.approximateToPackage;
        }
    }
}

