/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.LocationType;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.LineAndColumn;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocation;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\b\u001a\u00020\t*\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u000f\u001a\n\u0010\u0010\u001a\u00020\u000e*\u00020\u000f\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0005\u001a\u00020\u0001*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007\u00a8\u0006\u0011"}, d2={"hasSyntheticOrUndefinedLocation", "", "Lorg/jetbrains/kotlin/ir/IrElement;", "getHasSyntheticOrUndefinedLocation", "(Lorg/jetbrains/kotlin/ir/IrElement;)Z", "isIgnoredFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;)Z", "getSourceLocation", "Lorg/jetbrains/kotlin/wasm/ir/source/location/SourceLocation;", "file", "type", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/LocationType;", "buildUnreachableForVerifier", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "buildUnreachableAfterNothingType", "backend.wasm"})
public final class LocationUtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getHasSyntheticOrUndefinedLocation(IrElement $this$hasSyntheticOrUndefinedLocation) {
        boolean bl;
        int n = $this$hasSyntheticOrUndefinedLocation.getStartOffset();
        if (-2 <= n) {
            if (n < 0) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        n = $this$hasSyntheticOrUndefinedLocation.getEndOffset();
        if (-2 > n) return false;
        if (n >= 0) return false;
        return true;
    }

    private static final boolean isIgnoredFile(IrFile $this$isIgnoredFile) {
        return $this$isIgnoredFile.getPackageFqName().startsWith(StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE());
    }

    @NotNull
    public static final SourceLocation getSourceLocation(@NotNull IrElement $this$getSourceLocation, @Nullable IrFile file2, @NotNull LocationType type2) {
        IrFileEntry fileEntry;
        Intrinsics.checkNotNullParameter((Object)$this$getSourceLocation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        IrFile irFile = file2;
        IrFileEntry irFileEntry = fileEntry = irFile != null ? irFile.getFileEntry() : null;
        if (fileEntry == null) {
            return SourceLocation.Companion.NoLocation("fileEntry is null");
        }
        if (LocationUtilsKt.getHasSyntheticOrUndefinedLocation($this$getSourceLocation)) {
            return SourceLocation.Companion.NoLocation("Synthetic declaration");
        }
        String path = fileEntry.getName();
        LineAndColumn lineAndColumn = type2.getLineAndColumnNumberFor($this$getSourceLocation, fileEntry);
        int line = lineAndColumn.component1();
        int column = lineAndColumn.component2();
        if (line < 0 || column < 0) {
            return SourceLocation.Companion.NoLocation("startLine or startColumn < 0");
        }
        if (LocationUtilsKt.isIgnoredFile(file2)) {
            return new SourceLocation.IgnoredLocation(path, line, column);
        }
        return new SourceLocation.Location(path, line, column);
    }

    public static /* synthetic */ SourceLocation getSourceLocation$default(IrElement irElement, IrFile irFile, LocationType locationType, int n, Object object) {
        if ((n & 2) != 0) {
            locationType = LocationType.START;
        }
        return LocationUtilsKt.getSourceLocation(irElement, irFile, locationType);
    }

    public static final void buildUnreachableForVerifier(@NotNull WasmExpressionBuilder $this$buildUnreachableForVerifier) {
        Intrinsics.checkNotNullParameter((Object)$this$buildUnreachableForVerifier, (String)"<this>");
        $this$buildUnreachableForVerifier.buildUnreachable(SourceLocation.Companion.NoLocation("This instruction should never be reached, but required for wasm verifier"));
    }

    public static final void buildUnreachableAfterNothingType(@NotNull WasmExpressionBuilder $this$buildUnreachableAfterNothingType) {
        Intrinsics.checkNotNullParameter((Object)$this$buildUnreachableAfterNothingType, (String)"<this>");
        $this$buildUnreachableAfterNothingType.buildUnreachable(SourceLocation.Companion.NoLocation("The unreachable instruction after an expression with Nothing type to make sure that execution doesn't come here (or it fails fast if so). It also might be required for wasm verifier."));
    }
}

