/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirMissingDependencyClassProxy;
import org.jetbrains.kotlin.fir.diagnostics.FirDiagnosticHolder;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedErrorReference;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeDiagnosticWithSingleCandidate;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00012\u00020\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassProxy;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirMissingDependencyClassChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirMissingDependencyClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,164:1\n1863#2,2:165\n1755#2,3:167\n*S KotlinDebug\n*F\n+ 1 FirMissingDependencyClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassChecker\n*L\n66#1:165,2\n43#1:167,3\n*E\n"})
public final class FirMissingDependencyClassChecker
extends FirExpressionChecker<FirQualifiedAccessExpression>
implements FirMissingDependencyClassProxy {
    @NotNull
    public static final FirMissingDependencyClassChecker INSTANCE = new FirMissingDependencyClassChecker();

    private FirMissingDependencyClassChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirReference calleeReference = expression2.getCalleeReference();
        Set missingTypes = new LinkedHashSet();
        Set missingTypesFromExpression = new LinkedHashSet();
        List<FirElement> containingElements = context2.getContainingElements();
        if (!FirReferenceUtilsKt.isError(calleeReference)) {
            ConeTypeUtilsKt.forEachType(FirTypeUtilsKt.getResolvedType(expression2), (Function1<? super ConeKotlinType, Unit>)((Function1)arg_0 -> FirMissingDependencyClassChecker.check$lambda$1(containingElements, context2, missingTypes, missingTypesFromExpression, arg_0)));
        }
        if (FirReferenceUtilsKt.isError(calleeReference) && !(((FirDiagnosticHolder)((Object)calleeReference)).getDiagnostic() instanceof ConeDiagnosticWithSingleCandidate) && missingTypesFromExpression.isEmpty()) {
            return;
        }
        FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(calleeReference, false, 1, null);
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol symbol = firCallableSymbol;
        this.considerType(FirTypeUtilsKt.getConeType(symbol.getResolvedReturnTypeRef()), missingTypes, context2);
        Object object2 = symbol.getResolvedReceiverTypeRef();
        if (object2 != null && (object2 = FirTypeUtilsKt.getConeType((FirTypeRef)object2)) != null) {
            Object it = object2;
            boolean bl = false;
            INSTANCE.considerType((ConeKotlinType)it, missingTypes, context2);
        }
        if ((object = symbol instanceof FirFunctionSymbol ? (FirFunctionSymbol)symbol : null) != null && (object = ((FirFunctionSymbol)object).getValueParameterSymbols()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
                boolean bl = false;
                INSTANCE.considerType(FirTypeUtilsKt.getConeType(it.getResolvedReturnTypeRef()), missingTypes, context2);
            }
        }
        this.reportMissingTypes(expression2.getSource(), missingTypes, context2, reporter, FirMissingDependencyClassProxy.MissingTypeOrigin.Other.INSTANCE);
        if (missingTypes.isEmpty()) {
            this.reportMissingTypes(expression2.getSource(), missingTypesFromExpression, context2, reporter, FirMissingDependencyClassProxy.MissingTypeOrigin.Expression.INSTANCE);
        }
    }

    private static final Unit check$lambda$1(List $containingElements, CheckerContext $context, Set $missingTypes, Set $missingTypesFromExpression, ConeKotlinType it) {
        Intrinsics.checkNotNullParameter((Object)$containingElements, (String)"$containingElements");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$missingTypes, (String)"$missingTypes");
        Intrinsics.checkNotNullParameter((Object)$missingTypesFromExpression, (String)"$missingTypesFromExpression");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it instanceof ConeErrorType) {
            boolean bl;
            block4: {
                Iterable $this$any$iv = $containingElements;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirElement it2 = (FirElement)element$iv;
                        boolean bl2 = false;
                        if (!(it2 instanceof FirFunctionCall && ((FirFunctionCall)it2).getCalleeReference() instanceof FirResolvedErrorReference)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            boolean partOfErroneousOuterCall = bl && !FirLanguageSettingsComponentKt.getLanguageVersionSettings($context.getSession()).supportsFeature(LanguageFeature.ForbidUsingExpressionTypesWithInaccessibleContent);
            INSTANCE.considerType(it, partOfErroneousOuterCall ? $missingTypes : $missingTypesFromExpression, $context);
        }
        return Unit.INSTANCE;
    }
}

