/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.resolve.CallableIdUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.AnnotationTargetList;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmSerializableLambdaChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAnnotationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "<init>", "()V", "JVM_SERIALIZABLE_LAMBDA_ANNOTATION_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.jvm"})
public final class FirJvmSerializableLambdaChecker
extends FirExpressionChecker<FirAnnotation> {
    @NotNull
    public static final FirJvmSerializableLambdaChecker INSTANCE = new FirJvmSerializableLambdaChecker();
    @NotNull
    private static final FqName JVM_SERIALIZABLE_LAMBDA_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.JvmSerializableLambda");

    private FirJvmSerializableLambdaChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirAnnotation expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirDeclaration declaration;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (Intrinsics.areEqual((Object)CallableIdUtilsKt.fqName(expression2, context2.getSession()), (Object)JVM_SERIALIZABLE_LAMBDA_ANNOTATION_FQ_NAME) && !((declaration = (FirDeclaration)CollectionsKt.last(context2.getContainingDeclarations())) instanceof FirAnonymousFunction)) {
            AnnotationTargetList actualTargets = FirHelpersKt.getActualTargetList(declaration);
            Object object = (KotlinTarget)((Object)CollectionsKt.firstOrNull(actualTargets.getDefaultTargets()));
            if (object == null || (object = object.getDescription()) == null) {
                object = "unidentified target";
            }
            Object targetDescription = object;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET(), targetDescription, (DiagnosticContext)context2, null, 16, null);
        }
    }
}

