/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.MultiMap;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtPsiSourceFileLinesMapping;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.KtSourceFileLinesMapping;
import org.jetbrains.kotlin.KtSourceFileLinesMappingFromLineStartOffsets;
import org.jetbrains.kotlin.backend.common.CommonBackendErrors;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.backend.CodeFragmentConversionData;
import org.jetbrains.kotlin.fir.backend.CodeFragmentUtilsKt;
import org.jetbrains.kotlin.fir.backend.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrBuiltIns;
import org.jetbrains.kotlin.fir.backend.Fir2IrClassifierStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrCommonMemberStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponentsStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrConfiguration;
import org.jetbrains.kotlin.fir.backend.Fir2IrConversionScope;
import org.jetbrains.kotlin.fir.backend.Fir2IrDeclarationStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrExtensions;
import org.jetbrains.kotlin.fir.backend.Fir2IrFakeOverrideStrategy;
import org.jetbrains.kotlin.fir.backend.Fir2IrIrGeneratedDeclarationsRegistrar;
import org.jetbrains.kotlin.fir.backend.Fir2IrResult;
import org.jetbrains.kotlin.fir.backend.Fir2IrSpecialSymbolProvider;
import org.jetbrains.kotlin.fir.backend.Fir2IrSymbolsMappingForLazyClasses;
import org.jetbrains.kotlin.fir.backend.Fir2IrTypeConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrTypeConverterKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrVisibilityConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrVisitor;
import org.jetbrains.kotlin.fir.backend.FirProviderWithGeneratedFiles;
import org.jetbrains.kotlin.fir.backend.InjectedValue;
import org.jetbrains.kotlin.fir.backend.IrBuiltInsOverFir;
import org.jetbrains.kotlin.fir.backend.generators.AnnotationGenerator;
import org.jetbrains.kotlin.fir.backend.generators.CallAndReferenceGenerator;
import org.jetbrains.kotlin.fir.backend.generators.DataClassMembersGenerator;
import org.jetbrains.kotlin.fir.backend.generators.DelegatedMemberGenerator;
import org.jetbrains.kotlin.fir.backend.generators.FakeOverrideGenerator;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrCallableDeclarationsGenerator;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrCallableDeclarationsGeneratorKt;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrClassifiersGenerator;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrLazyDeclarationsGenerator;
import org.jetbrains.kotlin.fir.backend.generators.FirBasedFakeOverrideGenerator;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirCodeFragment;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.descriptors.FirModuleDescriptor;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.extensions.FirDeclarationGenerationExtension;
import org.jetbrains.kotlin.fir.extensions.FirDeclarationGenerationExtensionKt;
import org.jetbrains.kotlin.fir.extensions.FirExtensionServiceKt;
import org.jetbrains.kotlin.fir.extensions.GeneratedDeclarationsUtilsKt;
import org.jetbrains.kotlin.fir.java.FirJavaElementFinder;
import org.jetbrains.kotlin.fir.java.FirJavaElementFinderKt;
import org.jetbrains.kotlin.fir.lazy.Fir2IrLazyClass;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.signaturer.FirBasedSignatureComposer;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.ir.AbstractIrFileEntry;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrLock;
import org.jetbrains.kotlin.ir.KtDiagnosticReporterWithImplicitIrBasedContext;
import org.jetbrains.kotlin.ir.PsiIrFileEntry;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.impl.IrFileImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrFileImplKt;
import org.jetbrains.kotlin.ir.declarations.impl.IrModuleFragmentImpl;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreter;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterConfiguration;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.checker.EvaluationMode;
import org.jetbrains.kotlin.ir.interpreter.transformer.IrConstTransformerKt;
import org.jetbrains.kotlin.ir.linkage.IrProvider;
import org.jetbrains.kotlin.ir.overrides.IrFakeOverrideBuilder;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrBindableSymbolBase;
import org.jetbrains.kotlin.ir.symbols.impl.IrConstructorSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrSimpleFunctionSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.ir.util.NaiveSourceBasedFileEntryImpl;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u007f2\u00020\u0001:\u0001\u007fB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ&\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0016\u0010\u001b\u001a\u00020\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\nH\u0007J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u0016\u0010#\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u0018\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u0016H\u0002J\u0010\u0010)\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u0016H\u0002J\u0016\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u001eJ\u001d\u0010.\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010-\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b/J\u0018\u00100\u001a\u00020\u001e2\u0006\u00101\u001a\u0002022\u0006\u0010-\u001a\u00020\u001eH\u0002J\u0010\u00103\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u0016H\u0003J\u000e\u00104\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u001eJ\u0016\u00105\u001a\b\u0012\u0004\u0012\u0002060\n2\u0006\u0010-\u001a\u00020\u001eH\u0002J\u001c\u00107\u001a\b\u0012\u0004\u0012\u000206082\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020608H\u0002J\u0018\u00109\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010:\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010-\u001a\u00020\u001eH\u0002J\u0010\u0010;\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010<\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 H\u0002J8\u0010=\u001a\u00020\u00142\u0006\u0010>\u001a\u0002062\b\u0010?\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\u0014\u0010@\u001a\u0010\u0012\u0004\u0012\u00020B\u0012\u0004\u0012\u00020C\u0018\u00010AH\u0002J\u0016\u0010D\u001a\u0004\u0018\u00010B*\u00020C2\u0006\u0010E\u001a\u00020 H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\u00020\r8\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\t\u0010F\u001a\u00020GX\u0096\u0005R\t\u0010H\u001a\u00020IX\u0096\u0005R\t\u0010J\u001a\u00020KX\u0096\u0005R\t\u0010L\u001a\u00020MX\u0096\u0005R\t\u0010N\u001a\u00020OX\u0096\u0005R\t\u0010P\u001a\u00020QX\u0096\u0005R\t\u0010R\u001a\u00020SX\u0096\u0005R\t\u0010T\u001a\u00020UX\u0096\u0005R\t\u0010V\u001a\u00020\u0000X\u0096\u0005R\t\u0010W\u001a\u00020XX\u0096\u0005R\t\u0010Y\u001a\u00020ZX\u0096\u0005R\t\u0010[\u001a\u00020\\X\u0096\u0005R\t\u0010]\u001a\u00020^X\u0096\u0005R\u000b\u0010_\u001a\u00020`8\u0016X\u0097\u0005R\u0011\u0010a\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010bX\u0096\u0005R\t\u0010c\u001a\u00020dX\u0096\u0005R\t\u0010e\u001a\u00020fX\u0096\u0005R\t\u0010g\u001a\u00020hX\u0096\u0005R\u000f\u0010i\u001a\b\u0012\u0004\u0012\u00020j0\nX\u0096\u0005R\t\u0010k\u001a\u00020lX\u0096\u0005R\t\u0010m\u001a\u00020nX\u0096\u0005R\t\u0010o\u001a\u00020pX\u0096\u0005R\t\u0010q\u001a\u00020rX\u0096\u0005R\t\u0010s\u001a\u00020tX\u0096\u0005R\t\u0010u\u001a\u00020vX\u0096\u0005R\t\u0010w\u001a\u00020xX\u0096\u0005R\t\u0010y\u001a\u00020zX\u0096\u0005R\t\u0010{\u001a\u00020|X\u0096\u0005R\t\u0010}\u001a\u00020~X\u0096\u0005\u00a8\u0006\u0080\u0001"}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrConverter;", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "moduleDescriptor", "Lorg/jetbrains/kotlin/fir/descriptors/FirModuleDescriptor;", "c", "conversionScope", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;", "<init>", "(Lorg/jetbrains/kotlin/fir/descriptors/FirModuleDescriptor;Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;Lorg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;)V", "generatorExtensions", "", "Lorg/jetbrains/kotlin/fir/extensions/FirDeclarationGenerationExtension;", "wereSourcesFakeOverridesBound", "", "getWereSourcesFakeOverridesBound$annotations", "()V", "postponedDeclarationsForFakeOverridesBinding", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "runSourcesConversion", "", "allFirFiles", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "irModuleFragment", "Lorg/jetbrains/kotlin/ir/declarations/impl/IrModuleFragmentImpl;", "fir2irVisitor", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisitor;", "bindFakeOverridesOrPostpone", "declarations", "processLocalClassAndNestedClassesOnTheFly", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "parent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "processLocalClassAndNestedClasses", "registerFileAndClasses", "file", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "processClassHeaders", "processFileAndClassMembers", "processAnonymousObjectHeaders", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "irClass", "processClassMembers", "processClassMembers$fir2ir", "processCodeFragmentMembers", "codeFragment", "Lorg/jetbrains/kotlin/fir/declarations/FirCodeFragment;", "bindFakeOverridesInFile", "bindFakeOverridesInClass", "delegatedMembers", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "syntheticPropertiesLast", "", "registerClassAndNestedClasses", "registerNestedClasses", "processClassAndNestedClassHeaders", "processNestedClassHeaders", "processMemberDeclaration", "declaration", "containingClass", "delegateFieldToPropertyMap", "Lcom/intellij/util/containers/MultiMap;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "findCorrespondingDelegateProperty", "owner", "annotationGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/AnnotationGenerator;", "annotationsFromPluginRegistrar", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrIrGeneratedDeclarationsRegistrar;", "builtIns", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrBuiltIns;", "callGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator;", "callablesGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrCallableDeclarationsGenerator;", "classifierStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "classifiersGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrClassifiersGenerator;", "configuration", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConfiguration;", "converter", "declarationStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "delegatedMemberGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/DelegatedMemberGenerator;", "extensions", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "fakeOverrideBuilder", "Lorg/jetbrains/kotlin/ir/overrides/IrFakeOverrideBuilder;", "fakeOverrideGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/FakeOverrideGenerator;", "filesBeingCompiled", "", "firProvider", "Lorg/jetbrains/kotlin/fir/backend/FirProviderWithGeneratedFiles;", "irBuiltIns", "Lorg/jetbrains/kotlin/fir/backend/IrBuiltInsOverFir;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "irProviders", "Lorg/jetbrains/kotlin/ir/linkage/IrProvider;", "lazyDeclarationsGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrLazyDeclarationsGenerator;", "lock", "Lorg/jetbrains/kotlin/ir/IrLock;", "manglers", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents$Manglers;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "signatureComposer", "Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "symbolsMappingForLazyClasses", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrSymbolsMappingForLazyClasses;", "typeConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "visibilityConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "Companion", "fir2ir"})
@SourceDebugExtension(value={"SMAP\nFir2IrConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fir2IrConverter.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrConverter\n+ 2 Utils.kt\norg/jetbrains/kotlin/fir/UtilsKt\n+ 3 Fir2IrConversionScope.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 7 Fir2IrDeclarationStorage.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage\n+ 8 FirDeclarationUtil.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirDeclarationUtilKt\n*L\n1#1,779:1\n160#2,4:780\n70#3,7:784\n70#3,7:791\n1#4:798\n1#4:820\n1863#5,2:799\n1567#5:802\n1598#5,4:803\n774#5:807\n865#5,2:808\n1611#5,9:810\n1863#5:819\n1864#5:821\n1620#5:822\n1053#5:823\n1863#5,2:824\n1863#5,2:826\n1863#5,2:828\n1863#5,2:830\n808#5,11:835\n808#5,11:849\n54#6:801\n54#6:832\n1452#7,2:833\n1454#7,2:846\n39#8:848\n*S KotlinDebug\n*F\n+ 1 Fir2IrConverter.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrConverter\n*L\n118#1:780,4\n151#1:784,7\n159#1:791,7\n415#1:820\n203#1:799,2\n358#1:802\n358#1:803,4\n413#1:807\n413#1:808,2\n415#1:810,9\n415#1:819\n415#1:821\n415#1:822\n424#1:823\n447#1:824,2\n453#1:826,2\n478#1:828,2\n484#1:830,2\n533#1:835,11\n625#1:849,11\n263#1:801\n520#1:832\n531#1:833,2\n531#1:846,2\n579#1:848\n*E\n"})
public final class Fir2IrConverter
implements Fir2IrComponents {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirModuleDescriptor moduleDescriptor;
    @NotNull
    private final Fir2IrComponents c;
    @NotNull
    private final Fir2IrConversionScope conversionScope;
    @NotNull
    private final List<FirDeclarationGenerationExtension> generatorExtensions;
    private boolean wereSourcesFakeOverridesBound;
    @NotNull
    private final List<IrDeclaration> postponedDeclarationsForFakeOverridesBinding;

    public Fir2IrConverter(@NotNull FirModuleDescriptor moduleDescriptor, @NotNull Fir2IrComponents c, @NotNull Fir2IrConversionScope conversionScope) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)conversionScope, (String)"conversionScope");
        this.moduleDescriptor = moduleDescriptor;
        this.c = c;
        this.conversionScope = conversionScope;
        this.generatorExtensions = FirDeclarationGenerationExtensionKt.getDeclarationGenerators(FirExtensionServiceKt.getExtensionService(this.getSession()));
        this.postponedDeclarationsForFakeOverridesBinding = new ArrayList();
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.c.getSession();
    }

    @Override
    @NotNull
    public ScopeSession getScopeSession() {
        return this.c.getScopeSession();
    }

    @Override
    @NotNull
    public FirProviderWithGeneratedFiles getFirProvider() {
        return this.c.getFirProvider();
    }

    @Override
    @NotNull
    public Fir2IrConverter getConverter() {
        return this.c.getConverter();
    }

    @Override
    @NotNull
    public SymbolTable getSymbolTable() {
        return this.c.getSymbolTable();
    }

    @Override
    @NotNull
    public IrBuiltInsOverFir getIrBuiltIns() {
        return this.c.getIrBuiltIns();
    }

    @Override
    @NotNull
    public Fir2IrBuiltIns getBuiltIns() {
        return this.c.getBuiltIns();
    }

    @Override
    @NotNull
    public Fir2IrComponents.Manglers getManglers() {
        return this.c.getManglers();
    }

    @Override
    @NotNull
    public IrFactory getIrFactory() {
        return this.c.getIrFactory();
    }

    @Override
    @NotNull
    public List<IrProvider> getIrProviders() {
        return this.c.getIrProviders();
    }

    @Override
    @NotNull
    public IrLock getLock() {
        return this.c.getLock();
    }

    @Override
    @NotNull
    public Fir2IrClassifierStorage getClassifierStorage() {
        return this.c.getClassifierStorage();
    }

    @Override
    @NotNull
    public Fir2IrDeclarationStorage getDeclarationStorage() {
        return this.c.getDeclarationStorage();
    }

    @Override
    @NotNull
    public Fir2IrTypeConverter getTypeConverter() {
        return this.c.getTypeConverter();
    }

    @Override
    @NotNull
    public FirBasedSignatureComposer getSignatureComposer() {
        return this.c.getSignatureComposer();
    }

    @Override
    @NotNull
    public Fir2IrVisibilityConverter getVisibilityConverter() {
        return this.c.getVisibilityConverter();
    }

    @Override
    @NotNull
    public Fir2IrCallableDeclarationsGenerator getCallablesGenerator() {
        return this.c.getCallablesGenerator();
    }

    @Override
    @NotNull
    public Fir2IrClassifiersGenerator getClassifiersGenerator() {
        return this.c.getClassifiersGenerator();
    }

    @Override
    @NotNull
    public Fir2IrLazyDeclarationsGenerator getLazyDeclarationsGenerator() {
        return this.c.getLazyDeclarationsGenerator();
    }

    @Override
    @NotNull
    public AnnotationGenerator getAnnotationGenerator() {
        return this.c.getAnnotationGenerator();
    }

    @Override
    @NotNull
    public CallAndReferenceGenerator getCallGenerator() {
        return this.c.getCallGenerator();
    }

    @Override
    @NotNull
    public FakeOverrideGenerator getFakeOverrideGenerator() {
        return this.c.getFakeOverrideGenerator();
    }

    @Override
    @NotNull
    public DelegatedMemberGenerator getDelegatedMemberGenerator() {
        return this.c.getDelegatedMemberGenerator();
    }

    @Override
    @NotNull
    public IrFakeOverrideBuilder getFakeOverrideBuilder() {
        return this.c.getFakeOverrideBuilder();
    }

    @Override
    @NotNull
    public Fir2IrSymbolsMappingForLazyClasses getSymbolsMappingForLazyClasses() {
        return this.c.getSymbolsMappingForLazyClasses();
    }

    @Override
    @NotNull
    public Fir2IrExtensions getExtensions() {
        return this.c.getExtensions();
    }

    @Override
    @NotNull
    public Fir2IrConfiguration getConfiguration() {
        return this.c.getConfiguration();
    }

    @Override
    @NotNull
    public Fir2IrIrGeneratedDeclarationsRegistrar getAnnotationsFromPluginRegistrar() {
        return this.c.getAnnotationsFromPluginRegistrar();
    }

    @Override
    @Nullable
    public Set<FirFile> getFilesBeingCompiled() {
        return this.c.getFilesBeingCompiled();
    }

    private final void runSourcesConversion(List<? extends FirFile> allFirFiles, IrModuleFragmentImpl irModuleFragment, Fir2IrVisitor fir2irVisitor) {
        for (FirFile firFile : allFirFiles) {
            this.registerFileAndClasses(firFile, irModuleFragment);
        }
        for (FirFile firFile : allFirFiles) {
            this.processClassHeaders(firFile);
        }
        for (FirFile firFile : allFirFiles) {
            this.processFileAndClassMembers(firFile);
        }
        if (this.getConfiguration().getUseFirBasedFakeOverrideGenerator()) {
            for (FirFile firFile : allFirFiles) {
                this.bindFakeOverridesInFile(firFile);
            }
            this.wereSourcesFakeOverridesBound = true;
            this.getFakeOverrideGenerator().bindOverriddenSymbols(this.postponedDeclarationsForFakeOverridesBinding);
            this.postponedDeclarationsForFakeOverridesBinding.clear();
        } else if (!this.postponedDeclarationsForFakeOverridesBinding.isEmpty()) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.getClassifierStorage().processMembersOfClassesCreatedOnTheFly();
        this.getDelegatedMemberGenerator().generateBodies();
        for (FirFile firFile : allFirFiles) {
            boolean $i$f$withFileAnalysisExceptionWrapping = false;
            try {
                boolean bl = false;
                IrElement irElement = (IrElement)firFile.accept(fir2irVisitor, null);
            }
            catch (Throwable throwable$iv) {
                UtilsKt.getExceptionHandler(firFile.getModuleData().getSession()).handleExceptionOnFileAnalysis(firFile, throwable$iv);
                throw null;
            }
        }
        if (this.getConfiguration().getUseFirBasedFakeOverrideGenerator() && FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.c.getSession()).supportsFeature(LanguageFeature.MultiPlatformProjects)) {
            this.getDeclarationStorage().generateUnboundFakeOverrides$fir2ir();
        }
        if (this.getConfiguration().getAllowNonCachedDeclarations()) {
            this.getDeclarationStorage().fillUnboundSymbols$fir2ir();
        }
    }

    @FirBasedFakeOverrideGenerator
    public final void bindFakeOverridesOrPostpone(@NotNull List<? extends IrDeclaration> declarations2) {
        Intrinsics.checkNotNullParameter(declarations2, (String)"declarations");
        if (this.wereSourcesFakeOverridesBound) {
            this.getFakeOverrideGenerator().bindOverriddenSymbols(declarations2);
        } else {
            CollectionsKt.addAll((Collection)this.postponedDeclarationsForFakeOverridesBinding, (Iterable)declarations2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final IrClass processLocalClassAndNestedClassesOnTheFly(@NotNull FirClass klass, @NotNull IrDeclarationParent parent2) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        IrClass irClass = this.registerClassAndNestedClasses(klass, parent2);
        Fir2IrConversionScope this_$iv = this.conversionScope;
        boolean $i$f$withContainingFirClass = false;
        ((Collection)this_$iv.getContainingFirClassStack()).add(klass);
        try {
            boolean bl = false;
            this.processClassAndNestedClassHeaders(klass);
        }
        finally {
            this_$iv.getContainingFirClassStack().remove(this_$iv.getContainingFirClassStack().size() - 1);
        }
        return irClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final IrClass processLocalClassAndNestedClasses(@NotNull FirClass klass, @NotNull IrDeclarationParent parent2) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        IrClass irClass = this.registerClassAndNestedClasses(klass, parent2);
        Fir2IrConversionScope this_$iv = this.conversionScope;
        boolean $i$f$withContainingFirClass = false;
        ((Collection)this_$iv.getContainingFirClassStack()).add(klass);
        try {
            boolean bl = false;
            this.processClassAndNestedClassHeaders(klass);
            this.processClassMembers$fir2ir(klass, irClass);
            this.bindFakeOverridesInClass(irClass);
        }
        finally {
            this_$iv.getContainingFirClassStack().remove(this_$iv.getContainingFirClassStack().size() - 1);
        }
        return irClass;
    }

    private final void registerFileAndClasses(FirFile file2, IrModuleFragment moduleFragment) {
        AbstractIrFileEntry abstractIrFileEntry;
        FirDeclarationOrigin firDeclarationOrigin = file2.getOrigin();
        if (Intrinsics.areEqual((Object)firDeclarationOrigin, (Object)FirDeclarationOrigin.Source.INSTANCE)) {
            PsiElement psiElement = UtilsKt.getPsi(file2);
            if (psiElement != null) {
                PsiElement it = psiElement;
                boolean bl = false;
                abstractIrFileEntry = new PsiIrFileEntry((KtFile)it);
            } else {
                KtSourceFileLinesMapping linesMapping = file2.getSourceFileLinesMapping();
                if (linesMapping instanceof KtSourceFileLinesMappingFromLineStartOffsets) {
                    Object object = file2.getSourceFile();
                    if (object == null || (object = object.getPath()) == null) {
                        KtSourceFile ktSourceFile = file2.getSourceFile();
                        object = ktSourceFile != null ? ktSourceFile.getName() : file2.getName();
                    }
                    abstractIrFileEntry = new NaiveSourceBasedFileEntryImpl((String)object, ((KtSourceFileLinesMappingFromLineStartOffsets)linesMapping).getLineStartOffsets(), ((KtSourceFileLinesMappingFromLineStartOffsets)linesMapping).getLastOffset());
                } else if (linesMapping instanceof KtPsiSourceFileLinesMapping) {
                    abstractIrFileEntry = new PsiIrFileEntry(((KtPsiSourceFileLinesMapping)linesMapping).getPsiFile());
                } else {
                    Object object = file2.getSourceFile();
                    if (object == null || (object = object.getPath()) == null) {
                        KtSourceFile ktSourceFile = file2.getSourceFile();
                        object = ktSourceFile != null ? ktSourceFile.getName() : file2.getName();
                    }
                    abstractIrFileEntry = new NaiveSourceBasedFileEntryImpl((String)object, null, 0, 6, null);
                }
            }
        } else if (firDeclarationOrigin instanceof FirDeclarationOrigin.Synthetic) {
            abstractIrFileEntry = new NaiveSourceBasedFileEntryImpl(file2.getName(), null, 0, 6, null);
        } else {
            throw new IllegalStateException(("Unsupported file origin: " + file2.getOrigin()).toString());
        }
        AbstractIrFileEntry fileEntry = abstractIrFileEntry;
        IrFileImpl irFile = IrFileImplKt.IrFileImpl(fileEntry, (PackageFragmentDescriptor)CollectionsKt.first(this.moduleDescriptor.getPackage(UtilsKt.getPackageFqName(file2)).getFragments()), moduleFragment);
        this.getDeclarationStorage().registerFile(file2, irFile);
        for (FirDeclaration declaration : file2.getDeclarations()) {
            FirDeclaration firDeclaration = declaration;
            if (firDeclaration instanceof FirRegularClass) {
                this.registerClassAndNestedClasses((FirClass)declaration, irFile);
                continue;
            }
            if (!(firDeclaration instanceof FirCodeFragment)) continue;
            this.getClassifierStorage().createAndCacheCodeFragmentClass((FirCodeFragment)declaration, irFile);
        }
        ((Collection)moduleFragment.getFiles()).add(irFile);
    }

    private final void processClassHeaders(FirFile file2) {
        IrFile irFile = this.getDeclarationStorage().getIrFile(file2);
        Iterable $this$forEach$iv = file2.getDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirDeclaration it = (FirDeclaration)element$iv;
            boolean bl = false;
            FirDeclaration firDeclaration = it;
            if (firDeclaration instanceof FirRegularClass) {
                this.processClassAndNestedClassHeaders((FirClass)it);
                continue;
            }
            if (!(firDeclaration instanceof FirTypeAlias)) continue;
            this.getClassifierStorage().createAndCacheIrTypeAlias((FirTypeAlias)it, irFile);
        }
        irFile.getDeclarations().clear();
    }

    private final void processFileAndClassMembers(FirFile file2) {
        IrFile irFile = this.getDeclarationStorage().getIrFile(file2);
        for (FirDeclaration declaration : file2.getDeclarations()) {
            this.processMemberDeclaration(declaration, null, irFile, null);
        }
    }

    public final void processAnonymousObjectHeaders(@NotNull FirAnonymousObject anonymousObject, @NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)anonymousObject, (String)"anonymousObject");
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        this.registerNestedClasses(anonymousObject, irClass);
        this.processNestedClassHeaders(anonymousObject);
        irClass.getDeclarations().clear();
    }

    @NotNull
    public final IrClass processClassMembers$fir2ir(@NotNull FirClass klass, @NotNull IrClass irClass) {
        IrConstructor irConstructor;
        List list;
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        List $this$processClassMembers_u24lambda_u245 = list = (List)new ArrayList();
        boolean bl = false;
        $this$processClassMembers_u24lambda_u245.addAll((Collection)klass.getDeclarations());
        if (klass instanceof FirRegularClass && !((Collection)this.generatorExtensions).isEmpty()) {
            $this$processClassMembers_u24lambda_u245.addAll((Collection)GeneratedDeclarationsUtilsKt.generatedMembers((FirRegularClass)klass, this.getSession()));
            $this$processClassMembers_u24lambda_u245.addAll((Collection)GeneratedDeclarationsUtilsKt.generatedNestedClassifiers((FirRegularClass)klass, this.getSession()));
        }
        List allDeclarations = list;
        irClass.getDeclarations().addAll((Collection<IrDeclaration>)this.getClassifierStorage().getFieldsWithContextReceiversForClass(irClass, klass));
        FirConstructorSymbol firConstructorSymbol = DeclarationUtilsKt.primaryConstructorIfAny(klass, this.getSession());
        if (firConstructorSymbol != null) {
            FirConstructorSymbol it = firConstructorSymbol;
            boolean bl2 = false;
            FirClassLikeDeclaration $this$isLocal$iv = klass;
            boolean $i$f$isLocal = false;
            irConstructor = Fir2IrDeclarationStorage.createAndCacheIrConstructor$default(this.getDeclarationStorage(), (FirConstructor)it.getFir(), () -> Fir2IrConverter.processClassMembers$lambda$7$lambda$6(irClass), null, $this$isLocal$iv.getSymbol().getClassId().isLocal(), 4, null);
        } else {
            irConstructor = null;
        }
        IrConstructor irConstructor2 = irConstructor;
        MultiMap<FirProperty, FirField> delegateFieldToPropertyMap = new MultiMap<FirProperty, FirField>();
        for (FirDeclaration declaration : this.syntheticPropertiesLast(allDeclarations)) {
            this.processMemberDeclaration(declaration, klass, irClass, delegateFieldToPropertyMap);
        }
        CollectionsKt.addAll((Collection)allDeclarations, (Iterable)this.delegatedMembers(irClass));
        if (klass instanceof FirRegularClass && irConstructor2 != null && (irClass.isValue() || irClass.isData())) {
            this.getDeclarationStorage().enterScope(irConstructor2.getSymbol());
            DataClassMembersGenerator dataClassMembersGenerator = new DataClassMembersGenerator(this.c);
            if (IrDeclarationsKt.isSingleFieldValueClass(irClass)) {
                CollectionsKt.addAll((Collection)allDeclarations, (Iterable)dataClassMembersGenerator.generateSingleFieldValueClassMembers((FirRegularClass)klass, irClass));
            }
            if (IrDeclarationsKt.isMultiFieldValueClass(irClass)) {
                CollectionsKt.addAll((Collection)allDeclarations, (Iterable)dataClassMembersGenerator.generateMultiFieldValueClassMembers((FirRegularClass)klass, irClass));
            }
            if (irClass.isData()) {
                CollectionsKt.addAll((Collection)allDeclarations, (Iterable)dataClassMembersGenerator.generateDataClassMembers((FirRegularClass)klass, irClass));
            }
            this.getDeclarationStorage().leaveScope(irConstructor2.getSymbol());
        }
        if (this.getConfiguration().getUseFirBasedFakeOverrideGenerator()) {
            this.getFakeOverrideGenerator().computeFakeOverrides(klass, irClass, allDeclarations);
        }
        return irClass;
    }

    /*
     * WARNING - void declaration
     */
    private final IrClass processCodeFragmentMembers(FirCodeFragment codeFragment, IrClass irClass) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        IrSimpleFunction irSimpleFunction;
        void $this$processCodeFragmentMembers_u24lambda_u2410_u24lambda_u249_u24lambda_u248;
        CodeFragmentConversionData conversionData = CodeFragmentUtilsKt.getConversionData(codeFragment);
        this.getDeclarationStorage().enterScope(irClass.getSymbol());
        IrBindableSymbolBase irSymbol2 = new IrConstructorSymbolImpl(null, 1, null);
        boolean bl = false;
        Object object = this.getIrFactory();
        IrDeclarationOriginImpl irDeclarationOriginImpl = IrDeclarationOrigin.Companion.getDEFINED();
        Name name2 = Name.special("<init>");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(...)");
        Name name3 = name2;
        DescriptorVisibility descriptorVisibility = irClass.getVisibility();
        IrSimpleType irSimpleType = IrUtilsKt.getDefaultType(irClass);
        Object $this$processCodeFragmentMembers_u24lambda_u2410_u24lambda_u249 = object = IrFactory.DefaultImpls.createConstructor$default((IrFactory)object, -1, -1, irDeclarationOriginImpl, name3, descriptorVisibility, false, false, irSimpleType, irSymbol2, true, false, null, 2048, null);
        boolean bl2 = false;
        Fir2IrCallableDeclarationsGeneratorKt.setParent((IrDeclaration)$this$processCodeFragmentMembers_u24lambda_u2410_u24lambda_u249, irClass);
        Fir2IrCallableDeclarationsGeneratorKt.addDeclarationToParent((IrDeclaration)$this$processCodeFragmentMembers_u24lambda_u2410_u24lambda_u249, irClass);
        FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol(this.getSession().getBuiltinTypes().getAnyType(), this.getSession());
        Intrinsics.checkNotNull((Object)firRegularClassSymbol);
        FirConstructorSymbol firConstructorSymbol = DeclarationUtilsKt.primaryConstructorIfAny((FirClass)firRegularClassSymbol.getFir(), this.getSession());
        Intrinsics.checkNotNull((Object)firConstructorSymbol);
        FirConstructorSymbol firAnyConstructor = firConstructorSymbol;
        IrConstructorSymbol irAnyConstructor = Fir2IrDeclarationStorage.getIrConstructorSymbol$default(this.getDeclarationStorage(), firAnyConstructor, false, 2, null);
        Object object2 = this.getIrFactory().createBlockBody(-1, -1);
        IrElementBase irElementBase = object2;
        Object object3 = $this$processCodeFragmentMembers_u24lambda_u2410_u24lambda_u249;
        boolean $i$a$-apply-Fir2IrConverter$processCodeFragmentMembers$1$1$22 = false;
        ((Collection)$this$processCodeFragmentMembers_u24lambda_u2410_u24lambda_u249_u24lambda_u248.getStatements()).add(new IrDelegatingConstructorCallImpl(-1, -1, this.getIrBuiltIns().getUnitType(), irAnyConstructor, 0, 0));
        ((IrFunction)object3).setBody((IrBody)object2);
        irSymbol2 = new IrSimpleFunctionSymbolImpl(null, 1, null);
        boolean bl3 = false;
        FirStatement lastStatement = (FirStatement)CollectionsKt.lastOrNull(codeFragment.getBlock().getStatements());
        Object object4 = lastStatement instanceof FirExpression ? (FirExpression)lastStatement : null;
        if (object4 == null || (object4 = FirTypeUtilsKt.getResolvedType((FirExpression)object4)) == null || (object4 = Fir2IrTypeConverterKt.toIrType$default((ConeKotlinType)object4, this.c, null, 2, null)) == null) {
            object4 = this.getIrBuiltIns().getUnitType();
        }
        Object returnType = object4;
        IrFactory irFactory = this.getIrFactory();
        IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.Companion.getDEFINED();
        Name name4 = conversionData.getMethodName();
        DescriptorVisibility descriptorVisibility2 = DescriptorVisibilities.PUBLIC;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility2, (String)"PUBLIC");
        IrSimpleFunction $this$processCodeFragmentMembers_u24lambda_u2414_u24lambda_u2413 = irSimpleFunction = irFactory.createSimpleFunction(-1, -1, irDeclarationOrigin, name4, descriptorVisibility2, false, false, (IrType)returnType, Modality.FINAL, (IrSimpleFunctionSymbol)((Object)irSymbol2), false, false, false, false, false, null, false);
        boolean bl4 = false;
        Fir2IrCallableDeclarationsGeneratorKt.setParent($this$processCodeFragmentMembers_u24lambda_u2414_u24lambda_u2413, irClass);
        Fir2IrCallableDeclarationsGeneratorKt.addDeclarationToParent($this$processCodeFragmentMembers_u24lambda_u2414_u24lambda_u2413, irClass);
        object2 = conversionData.getInjectedValues();
        irElementBase = $this$processCodeFragmentMembers_u24lambda_u2414_u24lambda_u2413;
        boolean $i$f$mapIndexed = false;
        void $i$a$-apply-Fir2IrConverter$processCodeFragmentMembers$1$1$22 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            IrValueParameter irValueParameter;
            void index;
            void injectedValue;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            InjectedValue injectedValue2 = (InjectedValue)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            boolean isMutated = injectedValue.isMutated();
            IrFactory irFactory2 = this.getIrFactory();
            IrDeclarationOrigin irDeclarationOrigin2 = isMutated ? IrDeclarationOrigin.Companion.getSHARED_VARIABLE_IN_EVALUATOR_FRAGMENT() : IrDeclarationOrigin.Companion.getDEFINED();
            Name name5 = Name.identifier("" + 'p' + (int)index);
            Intrinsics.checkNotNullExpressionValue((Object)name5, (String)"identifier(...)");
            IrValueParameter $this$processCodeFragmentMembers_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411 = irValueParameter = irFactory2.createValueParameter(-1, -1, irDeclarationOrigin2, name5, Fir2IrTypeConverterKt.toIrType$default(injectedValue.getTypeRef(), this.getTypeConverter(), null, 2, null), isMutated, injectedValue.getIrParameterSymbol(), (int)index, null, false, false, false);
            boolean bl6 = false;
            $this$processCodeFragmentMembers_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411.setParent($this$processCodeFragmentMembers_u24lambda_u2414_u24lambda_u2413);
            collection.add(irValueParameter);
        }
        ((IrFunction)irElementBase).setValueParameters((List)destination$iv$iv);
        this.getDeclarationStorage().leaveScope(irClass.getSymbol());
        return irClass;
    }

    @FirBasedFakeOverrideGenerator
    private final void bindFakeOverridesInFile(FirFile file2) {
        IrFile irFile = this.getDeclarationStorage().getIrFile(file2);
        for (IrDeclaration irDeclaration2 : irFile.getDeclarations()) {
            if (!(irDeclaration2 instanceof IrClass)) continue;
            this.bindFakeOverridesInClass((IrClass)irDeclaration2);
        }
    }

    public final void bindFakeOverridesInClass(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        if (!this.getConfiguration().getUseFirBasedFakeOverrideGenerator()) {
            return;
        }
        if (!(!(klass instanceof Fir2IrLazyClass))) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.getFakeOverrideGenerator().bindOverriddenSymbols(klass.getDeclarations());
        this.getDelegatedMemberGenerator().bindDelegatedMembersOverriddenSymbols(klass);
        for (IrDeclaration irDeclaration2 : klass.getDeclarations()) {
            if (!(irDeclaration2 instanceof IrClass)) continue;
            this.bindFakeOverridesInClass((IrClass)irDeclaration2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirDeclaration> delegatedMembers(IrClass irClass) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = irClass.getDeclarations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrDeclaration it = (IrDeclaration)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getOrigin(), (Object)IrDeclarationOrigin.Companion.getDELEGATED_MEMBER())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirDeclaration it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrDeclaration it = (IrDeclaration)element$iv$iv;
            boolean bl2 = false;
            if (this.c.getDeclarationStorage().originalDeclarationForDelegated(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Iterable<FirDeclaration> syntheticPropertiesLast(Iterable<? extends FirDeclaration> declarations2) {
        Iterable<? extends FirDeclaration> $this$sortedBy$iv = declarations2;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith($this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl;
                boolean bl2;
                FirDeclaration it = (FirDeclaration)a;
                boolean bl3 = false;
                FirDeclaration $this$isSynthetic$iv = it;
                boolean $i$f$isSynthetic = false;
                if (!($this$isSynthetic$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic)) {
                    bl2 = false;
                } else {
                    KtSourceElement ktSourceElement = it.getSource();
                    bl2 = !((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.ClassDelegationField);
                }
                it = (FirDeclaration)b;
                Comparable comparable = Boolean.valueOf(bl2);
                bl3 = false;
                $this$isSynthetic$iv = it;
                $i$f$isSynthetic = false;
                if (!($this$isSynthetic$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic)) {
                    bl = false;
                } else {
                    KtSourceElement ktSourceElement = it.getSource();
                    bl = !((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.ClassDelegationField);
                }
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Boolean.valueOf(bl));
            }
        });
    }

    private final IrClass registerClassAndNestedClasses(FirClass klass, IrDeclarationParent parent2) {
        Object object;
        Object object2;
        IrClass irClass = this.getClassifierStorage().getCachedIrLocalClass(klass);
        if (irClass != null) {
            object2 = irClass;
            IrClass $this$registerClassAndNestedClasses_u24lambda_u2418 = object2;
            boolean bl = false;
            $this$registerClassAndNestedClasses_u24lambda_u2418.setParent(parent2);
            object = object2;
        } else {
            object2 = klass;
            if (object2 instanceof FirRegularClass) {
                object = Fir2IrClassifierStorage.createAndCacheIrClass$default(this.getClassifierStorage(), (FirRegularClass)klass, parent2, null, 4, null);
            } else if (object2 instanceof FirAnonymousObject) {
                object = Fir2IrClassifierStorage.createAndCacheAnonymousObject$default(this.getClassifierStorage(), (FirAnonymousObject)klass, null, null, parent2, 6, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        Object irClass2 = object;
        this.registerNestedClasses(klass, (IrClass)irClass2);
        return irClass2;
    }

    private final void registerNestedClasses(FirClass klass, IrClass irClass) {
        FirDeclaration it;
        Iterable $this$forEach$iv = klass.getDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (FirDeclaration)element$iv;
            boolean bl = false;
            if (!(it instanceof FirRegularClass)) continue;
            this.registerClassAndNestedClasses((FirClass)it, irClass);
        }
        if (klass instanceof FirRegularClass && !((Collection)this.generatorExtensions).isEmpty()) {
            $this$forEach$iv = GeneratedDeclarationsUtilsKt.generatedNestedClassifiers((FirRegularClass)klass, this.getSession());
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FirClassLikeDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof FirRegularClass)) continue;
                this.registerClassAndNestedClasses((FirClass)it, irClass);
            }
        }
    }

    private final void processClassAndNestedClassHeaders(FirClass klass) {
        Fir2IrClassifiersGenerator.processClassHeader$default(this.getClassifiersGenerator(), klass, null, 2, null);
        this.processNestedClassHeaders(klass);
        IrClass irClass = this.getClassifierStorage().getIrClass(klass);
        irClass.getDeclarations().clear();
    }

    private final void processNestedClassHeaders(FirClass klass) {
        FirDeclaration it;
        Iterable $this$forEach$iv = klass.getDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (FirDeclaration)element$iv;
            boolean bl = false;
            if (!(it instanceof FirRegularClass)) continue;
            this.processClassAndNestedClassHeaders((FirClass)it);
        }
        if (klass instanceof FirRegularClass && !((Collection)this.generatorExtensions).isEmpty()) {
            $this$forEach$iv = GeneratedDeclarationsUtilsKt.generatedNestedClassifiers((FirRegularClass)klass, this.getSession());
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FirClassLikeDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof FirRegularClass)) continue;
                this.processClassAndNestedClassHeaders((FirClass)it);
            }
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final void processMemberDeclaration(FirDeclaration declaration, FirClass containingClass, IrDeclarationParent parent, MultiMap<FirProperty, FirField> delegateFieldToPropertyMap) {
        if (containingClass == null) ** GOTO lbl-1000
        if (!(containingClass instanceof FirRegularClass)) ** GOTO lbl-1000
        $this$isLocal$iv = containingClass;
        $i$f$isLocal = false;
        if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        isInLocalClass = v0;
        var6_5 = declaration;
        if (var6_5 instanceof FirRegularClass) {
            irClass = this.getClassifierStorage().getIrClass((FirClass)declaration);
            Fir2IrConverter.processMemberDeclaration$addDeclarationToParentIfNeeded(parent, irClass);
            this.processClassMembers$fir2ir((FirClass)declaration, irClass);
        } else if (var6_5 instanceof FirScript) {
            if (!(parent instanceof IrFile)) {
                var8_13 = "Failed requirement.";
                throw new IllegalArgumentException(var8_13.toString());
            }
            irScript = this.getDeclarationStorage().createIrScript((FirScript)declaration);
            Fir2IrConverter.processMemberDeclaration$addDeclarationToParentIfNeeded(parent, irScript);
            var8_14 = this.getDeclarationStorage();
            symbol$iv = irScript.getSymbol();
            $i$f$withScope = false;
            this_$iv.enterScope(symbol$iv);
            $i$a$-withScope-Fir2IrConverter$processMemberDeclaration$1 = false;
            irScript.setParent(parent);
            $this$filterIsInstance$iv = ((FirScript)declaration).getDeclarations();
            $i$f$filterIsInstance = false;
            var14_30 = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterIsInstanceTo = false;
            for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof FirRegularClass)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (FirRegularClass scriptDeclaration : (List)destination$iv$iv) {
                Fir2IrConverter.access$registerClassAndNestedClasses(this, scriptDeclaration /* !! */ , irScript);
            }
            for (FirRegularClass scriptDeclaration : ((FirScript)declaration).getDeclarations()) {
                var13_28 /* !! */  = scriptDeclaration /* !! */ ;
                if (var13_28 /* !! */  instanceof FirRegularClass) {
                    Fir2IrConverter.access$processClassAndNestedClassHeaders(this, scriptDeclaration /* !! */ );
                    continue;
                }
                if (!(var13_28 /* !! */  instanceof FirTypeAlias)) continue;
                this.getClassifierStorage().createAndCacheIrTypeAlias((FirTypeAlias)scriptDeclaration /* !! */ , irScript);
            }
            for (FirRegularClass scriptDeclaration : ((FirScript)declaration).getDeclarations()) {
                if (scriptDeclaration /* !! */  instanceof FirAnonymousInitializer) continue;
                Fir2IrConverter.access$processMemberDeclaration(this, scriptDeclaration /* !! */ , null, irScript, null);
            }
            this_$iv.leaveScope(symbol$iv);
        } else if (var6_5 instanceof FirSimpleFunction) {
            Fir2IrDeclarationStorage.createAndCacheIrFunction$default(this.getDeclarationStorage(), (FirFunction)declaration, parent, null, isInLocalClass, null, false, 52, null);
        } else if (var6_5 instanceof FirProperty) {
            if (containingClass == null || !UtilsKt.isEnumEntries((FirVariable)declaration, containingClass) || FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.getSession()).supportsFeature(LanguageFeature.EnumEntries)) {
                irProperty = Fir2IrDeclarationStorage.createAndCacheIrProperty$default(this.getDeclarationStorage(), (FirProperty)declaration, parent, null, null, false, 28, null);
                v1 = delegateFieldToPropertyMap;
                if (v1 != null && (v1 = v1.remove((FirProperty)declaration)) != null) {
                    delegateFields = v1;
                    $i$a$-let-Fir2IrConverter$processMemberDeclaration$2 = false;
                    v2 = irProperty.getBackingField();
                    Intrinsics.checkNotNull((Object)v2);
                    backingField = v2;
                    var13_29 = delegateFields.iterator();
                    while (var13_29.hasNext()) {
                        delegateField = (FirField)var13_29.next();
                        v3 = this.getDeclarationStorage();
                        Intrinsics.checkNotNull((Object)delegateField);
                        v3.recordDelegateFieldMappedToBackingField(delegateField, backingField.getSymbol());
                        v4 = this.getDelegatedMemberGenerator();
                        v5 = containingClass;
                        Intrinsics.checkNotNull((Object)v5);
                        Intrinsics.checkNotNull((Object)parent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                        v4.generateWithBodiesIfNeeded(delegateField, backingField, v5, (IrClass)parent);
                    }
                }
            }
        } else if (var6_5 instanceof FirField) {
            $this$isSynthetic$iv = declaration;
            $i$f$isSynthetic = false;
            if (!($this$isSynthetic$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic)) {
                throw new IllegalStateException(("Unexpected non-synthetic field: " + Reflection.getOrCreateKotlinClass(declaration.getClass())).toString());
            }
            if (containingClass == null) {
                $this$isSynthetic$iv = "Required value was null.";
                throw new IllegalArgumentException($this$isSynthetic$iv.toString());
            }
            if (delegateFieldToPropertyMap == null) {
                $this$isSynthetic$iv = "Required value was null.";
                throw new IllegalArgumentException($this$isSynthetic$iv.toString());
            }
            if (!(parent instanceof IrClass)) {
                $i$f$isSynthetic = "Failed requirement.";
                throw new IllegalArgumentException($i$f$isSynthetic.toString());
            }
            correspondingClassProperty = this.findCorrespondingDelegateProperty((FirField)declaration, containingClass);
            if (correspondingClassProperty == null || correspondingClassProperty.isVar()) {
                irField = this.getDeclarationStorage().createDelegateIrField$fir2ir((FirField)declaration, (IrClass)parent);
                this.getDelegatedMemberGenerator().generateWithBodiesIfNeeded((FirField)declaration, irField, containingClass, (IrClass)parent);
            } else {
                delegateFieldToPropertyMap.putValue(correspondingClassProperty, (FirField)declaration);
            }
        } else if (var6_5 instanceof FirConstructor) {
            if (!((FirConstructor)declaration).isPrimary()) {
                Fir2IrDeclarationStorage.createAndCacheIrConstructor$default(this.getDeclarationStorage(), (FirConstructor)declaration, (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, processMemberDeclaration$lambda$25(org.jetbrains.kotlin.ir.declarations.IrDeclarationParent ), ()Lorg/jetbrains/kotlin/ir/declarations/IrClass;)((IrDeclarationParent)parent), null, isInLocalClass, 4, null);
            }
        } else if (var6_5 instanceof FirEnumEntry) {
            v6 = this.getClassifierStorage();
            v7 = (FirEnumEntry)declaration;
            Intrinsics.checkNotNull((Object)parent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            Fir2IrClassifierStorage.createAndCacheIrEnumEntry$default(v6, v7, (IrClass)parent, null, 4, null);
        } else if (var6_5 instanceof FirAnonymousInitializer) {
            v8 = this.getDeclarationStorage();
            v9 = (FirAnonymousInitializer)declaration;
            Intrinsics.checkNotNull((Object)parent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            v8.createIrAnonymousInitializer(v9, (IrClass)parent);
        } else if (var6_5 instanceof FirTypeAlias) {
            v10 = this.getClassifierStorage().getCachedTypeAlias$fir2ir((FirTypeAlias)declaration);
            if (v10 != null) {
                irTypeAlias = v10;
                $i$a$-let-Fir2IrConverter$processMemberDeclaration$4 = false;
                Fir2IrConverter.processMemberDeclaration$addDeclarationToParentIfNeeded(parent, irTypeAlias);
            }
        } else if (var6_5 instanceof FirCodeFragment) {
            v11 = this.getClassifierStorage().getCachedIrCodeFragment((FirCodeFragment)declaration);
            Intrinsics.checkNotNull((Object)v11);
            codeFragmentClass = v11;
            this.processCodeFragmentMembers((FirCodeFragment)declaration, codeFragmentClass);
            Fir2IrConverter.processMemberDeclaration$addDeclarationToParentIfNeeded(parent, codeFragmentClass);
        } else {
            throw new IllegalStateException(("Unexpected member: " + Reflection.getOrCreateKotlinClass(declaration.getClass())).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final FirProperty findCorrespondingDelegateProperty(FirField $this$findCorrespondingDelegateProperty, FirClass owner) {
        Object v1;
        block5: {
            void $this$filterIsInstanceTo$iv$iv;
            FirExpression initializer = $this$findCorrespondingDelegateProperty.getInitializer();
            if (!(initializer instanceof FirQualifiedAccessExpression)) {
                return null;
            }
            if (((FirQualifiedAccessExpression)initializer).getExplicitReceiver() != null) {
                return null;
            }
            FirValueParameterSymbol firValueParameterSymbol = FirReferenceUtilsKt.toResolvedValueParameterSymbol$default(((FirQualifiedAccessExpression)initializer).getCalleeReference(), false, 1, null);
            if (firValueParameterSymbol == null) {
                return null;
            }
            FirValueParameterSymbol resolvedSymbol = firValueParameterSymbol;
            Iterable $this$filterIsInstance$iv = owner.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof FirProperty)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            for (Object e : iterable2) {
                FirProperty it = (FirProperty)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)DeclarationAttributesKt.getCorrespondingValueParameterFromPrimaryConstructor(it), (Object)resolvedSymbol)) continue;
                v1 = e;
                break block5;
            }
            v1 = null;
        }
        return v1;
    }

    private static final IrClass processClassMembers$lambda$7$lambda$6(IrClass $irClass) {
        Intrinsics.checkNotNullParameter((Object)$irClass, (String)"$irClass");
        return $irClass;
    }

    private static final void processMemberDeclaration$addDeclarationToParentIfNeeded(IrDeclarationParent $parent, IrDeclaration irDeclaration2) {
        IrDeclarationParent irDeclarationParent = $parent;
        if (irDeclarationParent instanceof IrFile) {
            ((Collection)((IrFile)$parent).getDeclarations()).add(irDeclaration2);
        } else if (irDeclarationParent instanceof IrClass) {
            ((Collection)((IrClass)$parent).getDeclarations()).add(irDeclaration2);
        }
    }

    private static final IrClass processMemberDeclaration$lambda$25(IrDeclarationParent $parent) {
        Intrinsics.checkNotNullParameter((Object)$parent, (String)"$parent");
        return (IrClass)$parent;
    }

    public static final /* synthetic */ IrClass access$registerClassAndNestedClasses(Fir2IrConverter $this, FirClass klass, IrDeclarationParent parent2) {
        return $this.registerClassAndNestedClasses(klass, parent2);
    }

    public static final /* synthetic */ void access$processClassAndNestedClassHeaders(Fir2IrConverter $this, FirClass klass) {
        $this.processClassAndNestedClassHeaders(klass);
    }

    public static final /* synthetic */ void access$processMemberDeclaration(Fir2IrConverter $this, FirDeclaration declaration, FirClass containingClass, IrDeclarationParent parent2, MultiMap delegateFieldToPropertyMap) {
        $this.processMemberDeclaration(declaration, containingClass, parent2, delegateFieldToPropertyMap);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ&\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\"\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0082\u0001\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u0002010/\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrConverter$Companion;", "", "<init>", "()V", "evaluateConstants", "", "irModuleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "components", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "evaluate", "", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "interpreter", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "mode", "Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "friendModulesMap", "", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "createIrModuleFragment", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrResult;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "firFiles", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "fir2IrExtensions", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "fir2IrConfiguration", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConfiguration;", "irMangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "visibilityConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "specialSymbolProvider", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrSpecialSymbolProvider;", "kotlinBuiltIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "commonMemberStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrCommonMemberStorage;", "initializedIrBuiltIns", "Lorg/jetbrains/kotlin/fir/backend/IrBuiltInsOverFir;", "typeContextProvider", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;", "fir2ir"})
    @SourceDebugExtension(value={"SMAP\nFir2IrConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fir2IrConverter.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrConverter$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,779:1\n1863#2,2:780\n1557#2:783\n1628#2,3:784\n1187#2,2:787\n1261#2,4:789\n1863#2,2:794\n1#3:782\n226#4:793\n*S KotlinDebug\n*F\n+ 1 Fir2IrConverter.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrConverter$Companion\n*L\n652#1:780,2\n709#1:783\n709#1:784,3\n710#1:787,2\n710#1:789,4\n764#1:794,2\n737#1:793\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void evaluateConstants(@NotNull IrModuleFragment irModuleFragment, @NotNull Fir2IrComponents components) {
            FirModuleDescriptor firModuleDescriptor;
            Intrinsics.checkNotNullParameter((Object)irModuleFragment, (String)"irModuleFragment");
            Intrinsics.checkNotNullParameter((Object)components, (String)"components");
            Fir2IrConfiguration fir2IrConfiguration = components.getConfiguration();
            ModuleDescriptor moduleDescriptor = irModuleFragment.getDescriptor();
            FirModuleDescriptor firModuleDescriptor2 = firModuleDescriptor = moduleDescriptor instanceof FirModuleDescriptor ? (FirModuleDescriptor)moduleDescriptor : null;
            TargetPlatform targetPlatform = firModuleDescriptor2 != null ? firModuleDescriptor2.getPlatform() : null;
            Object object = firModuleDescriptor;
            if (object == null || (object = ((FirModuleDescriptor)object).getSession()) == null || (object = FirLanguageSettingsComponentKt.getLanguageVersionSettings((FirSession)object)) == null) {
                return;
            }
            Object languageVersionSettings = object;
            boolean intrinsicConstEvaluation = languageVersionSettings.supportsFeature(LanguageFeature.IntrinsicConstEvaluation);
            IrInterpreterConfiguration configuration2 = new IrInterpreterConfiguration(targetPlatform, 0, 0, false, true, false, 46, null);
            IrInterpreter interpreter2 = new IrInterpreter(new IrInterpreterEnvironment(irModuleFragment.getIrBuiltins(), configuration2), null, 2, null);
            EvaluationMode mode = intrinsicConstEvaluation ? (EvaluationMode)new EvaluationMode.OnlyIntrinsicConst(false, 1, null) : (EvaluationMode)EvaluationMode.OnlyBuiltins.INSTANCE;
            FirJavaElementFinder firJavaElementFinder = FirJavaElementFinderKt.getJavaElementFinder(components.getSession());
            if (firJavaElementFinder != null) {
                firJavaElementFinder.setPropertyEvaluator((Function1<? super FirProperty, String>)((Function1)arg_0 -> Companion.evaluateConstants$lambda$0(components, interpreter2, mode, arg_0)));
            }
            KtDiagnosticReporterWithImplicitIrBasedContext ktDiagnosticReporter = new KtDiagnosticReporterWithImplicitIrBasedContext(fir2IrConfiguration.getDiagnosticReporter(), (LanguageVersionSettings)languageVersionSettings);
            Iterable $this$forEach$iv = irModuleFragment.getFiles();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrFile it = (IrFile)element$iv;
                boolean bl = false;
                IrConstTransformerKt.transformConst$default(it, it, interpreter2, mode, fir2IrConfiguration.getEvaluatedConstTracker(), fir2IrConfiguration.getInlineConstTracker(), null, (arg_0, arg_1, arg_2) -> Companion.evaluateConstants$lambda$2$lambda$1(ktDiagnosticReporter, arg_0, arg_1, arg_2), false, 160, null);
            }
        }

        private final String evaluate(FirProperty $this$evaluate, Fir2IrComponents components, IrInterpreter interpreter2, EvaluationMode mode) {
            IrProperty irProperty;
            Object object = Fir2IrDeclarationStorage.getCachedIrPropertySymbol$default(components.getDeclarationStorage(), $this$evaluate, null, null, 4, null);
            if (object == null || (irProperty = (IrProperty)object.getOwner()) == null) {
                return null;
            }
            IrProperty irProperty2 = irProperty;
            object = org.jetbrains.kotlin.fir.backend.Fir2IrConverter$Companion.evaluate$tryToGetConst(irProperty2);
            if (object != null) {
                Object it = object;
                boolean bl = false;
                return org.jetbrains.kotlin.fir.backend.Fir2IrConverter$Companion.evaluate$asString(it);
            }
            IrFile irFile = IrUtilsKt.getFileOrNull(irProperty2);
            if (irFile == null) {
                return null;
            }
            IrFile irFile2 = irFile;
            IrElement evaluated = IrConstTransformerKt.transformConst$default(irProperty2, irFile2, interpreter2, mode, components.getConfiguration().getEvaluatedConstTracker(), components.getConfiguration().getInlineConstTracker(), null, null, false, 224, null);
            IrElementBase irElementBase = evaluated instanceof IrProperty ? (IrProperty)evaluated : null;
            return irElementBase != null && (irElementBase = org.jetbrains.kotlin.fir.backend.Fir2IrConverter$Companion.evaluate$tryToGetConst(irElementBase)) != null ? org.jetbrains.kotlin.fir.backend.Fir2IrConverter$Companion.evaluate$asString(irElementBase) : null;
        }

        /*
         * WARNING - void declaration
         */
        private final Map<String, List<String>> friendModulesMap(FirSession session2) {
            void $this$associateTo$iv$iv;
            void $this$mapTo$iv$iv;
            Set set;
            FirModuleData moduleData = FirModuleDataKt.getModuleData(session2);
            Set $this$friendModulesMap_u24lambda_u244 = set = SetsKt.createSetBuilder();
            boolean bl = false;
            org.jetbrains.kotlin.fir.backend.Fir2IrConverter$Companion.friendModulesMap$collectDependsOnRecursive(moduleData, $this$friendModulesMap_u24lambda_u244);
            Set dependsOnTransitive = SetsKt.build((Set)set);
            Iterable $this$map$iv = CollectionsKt.plus((Collection)moduleData.getFriendDependencies(), (Iterable)dependsOnTransitive);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirModuleData firModuleData = (FirModuleData)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(org.jetbrains.kotlin.fir.backend.Fir2IrConverter$Companion.friendModulesMap$friendsMapName((FirModuleData)it));
            }
            List friendNames = (List)destination$iv$iv;
            Iterable $this$associate$iv = dependsOnTransitive;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv2;
                FirModuleData it = (FirModuleData)element$iv$iv;
                boolean bl3 = false;
                Pair pair = TuplesKt.to((Object)org.jetbrains.kotlin.fir.backend.Fir2IrConverter$Companion.friendModulesMap$friendsMapName(it), (Object)friendNames);
                map.put(pair.getFirst(), pair.getSecond());
            }
            return destination$iv$iv2;
        }

        @NotNull
        public final Fir2IrResult createIrModuleFragment(@NotNull FirSession session2, @NotNull ScopeSession scopeSession, @NotNull List<? extends FirFile> firFiles2, @NotNull Fir2IrExtensions fir2IrExtensions, @NotNull Fir2IrConfiguration fir2IrConfiguration, @NotNull KotlinMangler.IrMangler irMangler, @NotNull IrFactory irFactory, @NotNull Fir2IrVisibilityConverter visibilityConverter, @NotNull Fir2IrSpecialSymbolProvider specialSymbolProvider, @NotNull KotlinBuiltIns kotlinBuiltIns, @NotNull Fir2IrCommonMemberStorage commonMemberStorage, @Nullable IrBuiltInsOverFir initializedIrBuiltIns, @NotNull Function1<? super IrBuiltIns, ? extends IrTypeSystemContext> typeContextProvider) {
            List list;
            Set set;
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
            Intrinsics.checkNotNullParameter(firFiles2, (String)"firFiles");
            Intrinsics.checkNotNullParameter((Object)fir2IrExtensions, (String)"fir2IrExtensions");
            Intrinsics.checkNotNullParameter((Object)fir2IrConfiguration, (String)"fir2IrConfiguration");
            Intrinsics.checkNotNullParameter((Object)irMangler, (String)"irMangler");
            Intrinsics.checkNotNullParameter((Object)irFactory, (String)"irFactory");
            Intrinsics.checkNotNullParameter((Object)visibilityConverter, (String)"visibilityConverter");
            Intrinsics.checkNotNullParameter((Object)specialSymbolProvider, (String)"specialSymbolProvider");
            Intrinsics.checkNotNullParameter((Object)kotlinBuiltIns, (String)"kotlinBuiltIns");
            Intrinsics.checkNotNullParameter((Object)commonMemberStorage, (String)"commonMemberStorage");
            Intrinsics.checkNotNullParameter(typeContextProvider, (String)"typeContextProvider");
            FirLazyDeclarationResolverKt.getLazyDeclarationResolver(session2).disableLazyResolveContractChecks();
            FirModuleDescriptor moduleDescriptor = FirModuleDescriptor.Companion.createSourceModuleDescriptor(session2, kotlinBuiltIns);
            FirSession firSession = session2;
            ScopeSession scopeSession2 = scopeSession;
            IrFactory irFactory2 = irFactory;
            Fir2IrExtensions fir2IrExtensions2 = fir2IrExtensions;
            Fir2IrConfiguration fir2IrConfiguration2 = fir2IrConfiguration;
            Fir2IrVisibilityConverter fir2IrVisibilityConverter = visibilityConverter;
            boolean condition$iv = fir2IrConfiguration.getAllowNonCachedDeclarations();
            boolean $i$f$runIf = false;
            if (condition$iv) {
                Fir2IrVisibilityConverter fir2IrVisibilityConverter2 = fir2IrVisibilityConverter;
                Fir2IrConfiguration fir2IrConfiguration3 = fir2IrConfiguration2;
                Fir2IrExtensions fir2IrExtensions3 = fir2IrExtensions2;
                IrFactory irFactory3 = irFactory2;
                ScopeSession scopeSession3 = scopeSession2;
                FirSession firSession2 = firSession;
                boolean bl = false;
                Set set2 = CollectionsKt.toSet((Iterable)firFiles2);
                firSession = firSession2;
                scopeSession2 = scopeSession3;
                irFactory2 = irFactory3;
                fir2IrExtensions2 = fir2IrExtensions3;
                fir2IrConfiguration2 = fir2IrConfiguration3;
                fir2IrVisibilityConverter = fir2IrVisibilityConverter2;
                set = set2;
            } else {
                set = null;
            }
            IrBuiltInsOverFir irBuiltInsOverFir = initializedIrBuiltIns;
            Fir2IrSpecialSymbolProvider fir2IrSpecialSymbolProvider = specialSymbolProvider;
            KotlinMangler.IrMangler irMangler2 = irMangler;
            Fir2IrCommonMemberStorage fir2IrCommonMemberStorage = commonMemberStorage;
            FirModuleDescriptor firModuleDescriptor = moduleDescriptor;
            Function1 function1 = arg_0 -> Companion.createIrModuleFragment$lambda$8(typeContextProvider, session2, fir2IrExtensions, arg_0);
            Set set3 = set;
            Fir2IrVisibilityConverter fir2IrVisibilityConverter3 = fir2IrVisibilityConverter;
            Fir2IrConfiguration fir2IrConfiguration4 = fir2IrConfiguration2;
            Fir2IrExtensions fir2IrExtensions4 = fir2IrExtensions2;
            IrFactory irFactory4 = irFactory2;
            ScopeSession scopeSession4 = scopeSession2;
            FirSession firSession3 = firSession;
            Fir2IrComponentsStorage components = new Fir2IrComponentsStorage(firSession3, scopeSession4, irFactory4, fir2IrExtensions4, fir2IrConfiguration4, fir2IrVisibilityConverter3, set3, (Function1<? super IrBuiltIns, IrFakeOverrideBuilder>)function1, firModuleDescriptor, fir2IrCommonMemberStorage, irMangler2, fir2IrSpecialSymbolProvider, irBuiltInsOverFir);
            fir2IrExtensions.registerDeclarations(commonMemberStorage.getSymbolTable());
            IrModuleFragmentImpl irModuleFragment = new IrModuleFragmentImpl(moduleDescriptor, components.getIrBuiltIns());
            List $this$createIrModuleFragment_u24lambda_u2410 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$createIrModuleFragment_u24lambda_u2410.addAll((Collection)firFiles2);
            List<FirFile> generatedFiles = ConversionUtilsKt.createFilesWithGeneratedDeclarations(session2);
            $this$createIrModuleFragment_u24lambda_u2410.addAll((Collection)generatedFiles);
            Iterable $this$forEach$iv = generatedFiles;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirFile it = (FirFile)element$iv;
                boolean bl2 = false;
                components.getFirProvider().recordFile(it);
            }
            List allFirFiles = CollectionsKt.build((List)list);
            components.getConverter().runSourcesConversion(allFirFiles, irModuleFragment, components.getFir2IrVisitor());
            commonMemberStorage.registerFirProvider(FirModuleDataKt.getModuleData(session2), components.getFirProvider());
            return new Fir2IrResult(irModuleFragment, components, moduleDescriptor);
        }

        private static final String evaluateConstants$lambda$0(Fir2IrComponents $components, IrInterpreter $interpreter, EvaluationMode $mode, FirProperty it) {
            Intrinsics.checkNotNullParameter((Object)$components, (String)"$components");
            Intrinsics.checkNotNullParameter((Object)$interpreter, (String)"$interpreter");
            Intrinsics.checkNotNullParameter((Object)$mode, (String)"$mode");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Companion.evaluate(it, $components, $interpreter, $mode);
        }

        private static final Unit evaluateConstants$lambda$2$lambda$1(KtDiagnosticReporterWithImplicitIrBasedContext $ktDiagnosticReporter, IrFile irFile, IrElement element, IrErrorExpression error) {
            Intrinsics.checkNotNullParameter((Object)$ktDiagnosticReporter, (String)"$ktDiagnosticReporter");
            Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            $ktDiagnosticReporter.at(IrUtilsKt.sourceElement(element), element, irFile).report(CommonBackendErrors.INSTANCE.getEVALUATION_ERROR(), error.getDescription());
            return Unit.INSTANCE;
        }

        private static final IrConst<?> evaluate$tryToGetConst(IrProperty $this$evaluate_u24tryToGetConst) {
            IrElementBase irElementBase = $this$evaluate_u24tryToGetConst.getBackingField();
            IrExpression irExpression = irElementBase != null && (irElementBase = ((IrField)irElementBase).getInitializer()) != null ? ((IrExpressionBody)irElementBase).getExpression() : null;
            return irExpression instanceof IrConst ? (IrConst)irExpression : null;
        }

        private static final String evaluate$asString(IrConst<?> $this$evaluate_u24asString) {
            Object constVal = $this$evaluate_u24asString.getValue();
            return constVal instanceof Character ? String.valueOf((int)((Character)constVal).charValue()) : (constVal instanceof String ? '\"' + (String)constVal + '\"' : String.valueOf(constVal));
        }

        private static final String friendModulesMap$friendsMapName(FirModuleData $this$friendModulesMap_u24friendsMapName) {
            String string2 = $this$friendModulesMap_u24friendsMapName.getName().asStringStripSpecialMarkers();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asStringStripSpecialMarkers(...)");
            return string2;
        }

        private static final void friendModulesMap$collectDependsOnRecursive(FirModuleData $this$friendModulesMap_u24collectDependsOnRecursive, Set<FirModuleData> set) {
            if (!set.add($this$friendModulesMap_u24collectDependsOnRecursive)) {
                return;
            }
            for (FirModuleData dep : $this$friendModulesMap_u24collectDependsOnRecursive.getDependsOnDependencies()) {
                org.jetbrains.kotlin.fir.backend.Fir2IrConverter$Companion.friendModulesMap$collectDependsOnRecursive(dep, set);
            }
        }

        private static final IrFakeOverrideBuilder createIrModuleFragment$lambda$8(Function1 $typeContextProvider, FirSession $session, Fir2IrExtensions $fir2IrExtensions, IrBuiltIns irBuiltins) {
            Intrinsics.checkNotNullParameter((Object)$typeContextProvider, (String)"$typeContextProvider");
            Intrinsics.checkNotNullParameter((Object)$session, (String)"$session");
            Intrinsics.checkNotNullParameter((Object)$fir2IrExtensions, (String)"$fir2IrExtensions");
            Intrinsics.checkNotNullParameter((Object)irBuiltins, (String)"irBuiltins");
            return new IrFakeOverrideBuilder((IrTypeSystemContext)$typeContextProvider.invoke((Object)irBuiltins), new Fir2IrFakeOverrideStrategy(Companion.friendModulesMap($session), JvmPlatformKt.isJvm(FirModuleDataKt.getModuleData($session).getPlatform()), JvmPlatformKt.isJvm(FirModuleDataKt.getModuleData($session).getPlatform())), $fir2IrExtensions.getExternalOverridabilityConditions());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

