/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.Check;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001:\u0002\u001a\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\tJ(\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f0\tR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\u0015\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/Checks;", "", "<init>", "()V", "simple", "Lorg/jetbrains/kotlin/fir/declarations/Check;", "message", "", "predicate", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "Lorg/jetbrains/kotlin/fir/FirSession;", "", "full", "memberOrExtension", "getMemberOrExtension", "()Lorg/jetbrains/kotlin/fir/declarations/Check;", "member", "getMember", "nonSuspend", "getNonSuspend", "noDefaultAndVarargs", "getNoDefaultAndVarargs", "kPropertyType", "Lorg/jetbrains/kotlin/fir/types/impl/ConeClassLikeTypeImpl;", "isKProperty", "ValueParametersCount", "Returns", "providers"})
@SourceDebugExtension(value={"SMAP\nOperatorFunctionChecks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OperatorFunctionChecks.kt\norg/jetbrains/kotlin/fir/declarations/Checks\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,236:1\n46#2:237\n1734#3,3:238\n*S KotlinDebug\n*F\n+ 1 OperatorFunctionChecks.kt\norg/jetbrains/kotlin/fir/declarations/Checks\n*L\n184#1:237\n220#1:238,3\n*E\n"})
final class Checks {
    @NotNull
    public static final Checks INSTANCE = new Checks();
    @NotNull
    private static final Check memberOrExtension = INSTANCE.simple("must be a member or an extension function", (Function2<? super FirSimpleFunction, ? super FirSession, Boolean>)((Function2)Checks::memberOrExtension$lambda$0));
    @NotNull
    private static final Check member = INSTANCE.simple("must be a member function", (Function2<? super FirSimpleFunction, ? super FirSession, Boolean>)((Function2)Checks::member$lambda$1));
    @NotNull
    private static final Check nonSuspend = INSTANCE.simple("must not be suspend", (Function2<? super FirSimpleFunction, ? super FirSession, Boolean>)((Function2)Checks::nonSuspend$lambda$2));
    @NotNull
    private static final Check noDefaultAndVarargs = INSTANCE.simple("should not have varargs or parameters with default values", (Function2<? super FirSimpleFunction, ? super FirSession, Boolean>)((Function2)Checks::noDefaultAndVarargs$lambda$4));
    @NotNull
    private static final ConeClassLikeTypeImpl kPropertyType;
    @NotNull
    private static final Check isKProperty;

    private Checks() {
    }

    @NotNull
    public final Check simple(@NotNull String message, @NotNull Function2<? super FirSimpleFunction, ? super FirSession, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        return new Check(message, predicate){
            final /* synthetic */ String $message;
            final /* synthetic */ Function2<FirSimpleFunction, FirSession, Boolean> $predicate;
            {
                this.$message = $message;
                this.$predicate = $predicate;
            }

            public String check(FirSimpleFunction function2, FirSession session2, ScopeSession scopeSession) {
                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
                String string2 = this.$message;
                Function2<FirSimpleFunction, FirSession, Boolean> function22 = this.$predicate;
                String it = string2;
                boolean bl = false;
                return (Boolean)function22.invoke((Object)function2, (Object)session2) == false ? string2 : null;
            }
        };
    }

    @NotNull
    public final Check full(@NotNull String message, @NotNull Function2<? super FirSession, ? super FirSimpleFunction, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        return new Check(message, predicate){
            final /* synthetic */ String $message;
            final /* synthetic */ Function2<FirSession, FirSimpleFunction, Boolean> $predicate;
            {
                this.$message = $message;
                this.$predicate = $predicate;
            }

            public String check(FirSimpleFunction function2, FirSession session2, ScopeSession scopeSession) {
                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
                String string2 = this.$message;
                Function2<FirSession, FirSimpleFunction, Boolean> function22 = this.$predicate;
                String it = string2;
                boolean bl = false;
                return (Boolean)function22.invoke((Object)session2, (Object)function2) == false ? string2 : null;
            }
        };
    }

    @NotNull
    public final Check getMemberOrExtension() {
        return memberOrExtension;
    }

    @NotNull
    public final Check getMember() {
        return member;
    }

    @NotNull
    public final Check getNonSuspend() {
        return nonSuspend;
    }

    @NotNull
    public final Check getNoDefaultAndVarargs() {
        return noDefaultAndVarargs;
    }

    @NotNull
    public final Check isKProperty() {
        return isKProperty;
    }

    private static final boolean memberOrExtension$lambda$0(FirSimpleFunction it, FirSession firSession) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Intrinsics.checkNotNullParameter((Object)firSession, (String)"<unused var>");
        return it.getDispatchReceiverType() != null || it.getReceiverParameter() != null;
    }

    private static final boolean member$lambda$1(FirSimpleFunction it, FirSession firSession) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Intrinsics.checkNotNullParameter((Object)firSession, (String)"<unused var>");
        return it.getDispatchReceiverType() != null;
    }

    private static final boolean nonSuspend$lambda$2(FirSimpleFunction it, FirSession firSession) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Intrinsics.checkNotNullParameter((Object)firSession, (String)"<unused var>");
        FirMemberDeclaration $this$isSuspend$iv = it;
        boolean $i$f$isSuspend = false;
        return !$this$isSuspend$iv.getStatus().isSuspend();
    }

    private static final boolean noDefaultAndVarargs$lambda$4(FirSimpleFunction it, FirSession firSession) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Intrinsics.checkNotNullParameter((Object)firSession, (String)"<unused var>");
            Iterable $this$all$iv = it.getValueParameters();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    FirValueParameter param = (FirValueParameter)element$iv;
                    boolean bl2 = false;
                    if (param.getDefaultValue() == null && !param.isVararg()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean isKProperty$lambda$5(FirSession session2, FirSimpleFunction function2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Object object = (FirValueParameter)CollectionsKt.getOrNull(function2.getValueParameters(), (int)1);
        if (object == null || (object = ((FirValueParameter)object).getReturnTypeRef()) == null || (object = FirTypeUtilsKt.getConeType((FirTypeRef)object)) == null) {
            return false;
        }
        Object paramType = object;
        return TypeUtilsKt.isSubtypeOf(kPropertyType, (ConeKotlinType)paramType, session2, true);
    }

    static {
        ConeStarProjection[] coneStarProjectionArray = new ConeStarProjection[]{ConeStarProjection.INSTANCE};
        kPropertyType = new ConeClassLikeTypeImpl(TypeConstructionUtilsKt.toLookupTag(StandardClassIds.INSTANCE.getKProperty()), coneStarProjectionArray, false, null, 8, null);
        isKProperty = INSTANCE.full("second parameter must be of type KProperty<*> or its supertype", (Function2<? super FirSession, ? super FirSimpleFunction, Boolean>)((Function2)Checks::isKProperty$lambda$5));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/Checks$Returns;", "", "<init>", "()V", "boolean", "Lorg/jetbrains/kotlin/fir/declarations/Check;", "getBoolean", "()Lorg/jetbrains/kotlin/fir/declarations/Check;", "int", "getInt", "unit", "getUnit", "providers"})
    public static final class Returns {
        @NotNull
        public static final Returns INSTANCE = new Returns();
        @NotNull
        private static final Check boolean = INSTANCE.simple("must return 'Boolean'", (Function2<? super FirSimpleFunction, ? super FirSession, Boolean>)((Function2)Returns::boolean$lambda$0));
        @NotNull
        private static final Check int = INSTANCE.simple("must return 'Int'", (Function2<? super FirSimpleFunction, ? super FirSession, Boolean>)((Function2)Returns::int$lambda$1));
        @NotNull
        private static final Check unit = INSTANCE.simple("must return 'Unit'", (Function2<? super FirSimpleFunction, ? super FirSession, Boolean>)((Function2)Returns::unit$lambda$2));

        private Returns() {
        }

        @NotNull
        public final Check getBoolean() {
            return boolean;
        }

        @NotNull
        public final Check getInt() {
            return int;
        }

        @NotNull
        public final Check getUnit() {
            return unit;
        }

        private static final boolean boolean$lambda$0(FirSimpleFunction it, FirSession session2) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            return ConeBuiltinTypeUtilsKt.isBoolean(TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getConeType(it.getReturnTypeRef()), session2));
        }

        private static final boolean int$lambda$1(FirSimpleFunction it, FirSession session2) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            return ConeBuiltinTypeUtilsKt.isInt(TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getConeType(it.getReturnTypeRef()), session2));
        }

        private static final boolean unit$lambda$2(FirSimpleFunction it, FirSession session2) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            return ConeBuiltinTypeUtilsKt.isUnit(TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getConeType(it.getReturnTypeRef()), session2));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/Checks$ValueParametersCount;", "", "<init>", "()V", "atLeast", "Lorg/jetbrains/kotlin/fir/declarations/Check;", "n", "", "exactly", "single", "getSingle", "()Lorg/jetbrains/kotlin/fir/declarations/Check;", "none", "getNone", "providers"})
    public static final class ValueParametersCount {
        @NotNull
        public static final ValueParametersCount INSTANCE = new ValueParametersCount();
        @NotNull
        private static final Check single = INSTANCE.simple("must have a single value parameter", (Function2<? super FirSimpleFunction, ? super FirSession, Boolean>)((Function2)ValueParametersCount::single$lambda$2));
        @NotNull
        private static final Check none = INSTANCE.simple("must have no value parameters", (Function2<? super FirSimpleFunction, ? super FirSession, Boolean>)((Function2)ValueParametersCount::none$lambda$3));

        private ValueParametersCount() {
        }

        @NotNull
        public final Check atLeast(int n) {
            return INSTANCE.simple("must have at least " + n + " value parameter" + (n > 1 ? "s" : ""), (Function2<? super FirSimpleFunction, ? super FirSession, Boolean>)((Function2)(arg_0, arg_1) -> ValueParametersCount.atLeast$lambda$0(n, arg_0, arg_1)));
        }

        @NotNull
        public final Check exactly(int n) {
            return INSTANCE.simple("must have exactly " + n + " value parameters", (Function2<? super FirSimpleFunction, ? super FirSession, Boolean>)((Function2)(arg_0, arg_1) -> ValueParametersCount.exactly$lambda$1(n, arg_0, arg_1)));
        }

        @NotNull
        public final Check getSingle() {
            return single;
        }

        @NotNull
        public final Check getNone() {
            return none;
        }

        private static final boolean atLeast$lambda$0(int $n, FirSimpleFunction it, FirSession firSession) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Intrinsics.checkNotNullParameter((Object)firSession, (String)"<unused var>");
            return it.getValueParameters().size() >= $n;
        }

        private static final boolean exactly$lambda$1(int $n, FirSimpleFunction it, FirSession firSession) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Intrinsics.checkNotNullParameter((Object)firSession, (String)"<unused var>");
            return it.getValueParameters().size() == $n;
        }

        private static final boolean single$lambda$2(FirSimpleFunction it, FirSession firSession) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Intrinsics.checkNotNullParameter((Object)firSession, (String)"<unused var>");
            return it.getValueParameters().size() == 1;
        }

        private static final boolean none$lambda$3(FirSimpleFunction it, FirSession firSession) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Intrinsics.checkNotNullParameter((Object)firSession, (String)"<unused var>");
            return it.getValueParameters().isEmpty();
        }
    }
}

